/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.Invoker;
import org.testng.internal.Utils;

class TestNgMethodUtils {
    private TestNgMethodUtils() {
    }

    static boolean isConfigurationMethod(ITestNGMethod iTestNGMethod) {
        return TestNgMethodUtils.isConfigurationMethod(iTestNGMethod, false);
    }

    private static boolean isConfigurationMethod(ITestNGMethod iTestNGMethod, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = iTestNGMethod.isBeforeMethodConfiguration() || iTestNGMethod.isAfterMethodConfiguration() || iTestNGMethod.isBeforeTestConfiguration() || iTestNGMethod.isAfterTestConfiguration() || iTestNGMethod.isBeforeClassConfiguration() || iTestNGMethod.isAfterClassConfiguration() || iTestNGMethod.isBeforeSuiteConfiguration() || iTestNGMethod.isAfterSuiteConfiguration();
        if (bl) {
            bl2 = bl2 || iTestNGMethod.isBeforeGroupsConfiguration() || iTestNGMethod.isAfterGroupsConfiguration();
        }
        return bl2;
    }

    private static boolean containsConfigurationMethod(ITestNGMethod iTestNGMethod, List<ITestNGMethod> list) {
        return TestNgMethodUtils.isConfigurationMethod(iTestNGMethod, true) && list.contains(iTestNGMethod);
    }

    static ITestNGMethod[] filterBeforeTestMethods(ITestClass iTestClass, Invoker.Predicate<ITestNGMethod, IClass> predicate) {
        return TestNgMethodUtils.filterMethods(iTestClass, iTestClass.getBeforeTestMethods(), predicate);
    }

    static ITestNGMethod[] filterAfterTestMethods(ITestClass iTestClass, Invoker.Predicate<ITestNGMethod, IClass> predicate) {
        return TestNgMethodUtils.filterMethods(iTestClass, iTestClass.getAfterTestMethods(), predicate);
    }

    static ITestNGMethod[] filterMethods(IClass iClass, ITestNGMethod[] iTestNGMethodArray, Invoker.Predicate<ITestNGMethod, IClass> predicate) {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            String string;
            if (predicate.isTrue(iTestNGMethod, iClass) && !TestNgMethodUtils.containsConfigurationMethod(iTestNGMethod, list)) {
                string = "Keeping method " + iTestNGMethod + " for class " + iClass;
                list.add(iTestNGMethod);
            } else {
                string = "Filtering out method " + iTestNGMethod + " for class " + iClass;
            }
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 10, string);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    static ITestNGMethod[] filterFirstTimeRunnableSetupConfigurationMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod2;
            if (!TestNgMethodUtils.isConfigMethodRunningFirstTime(configurationMethod, iTestNGMethod)) continue;
            list.add(iTestNGMethod2);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    static ITestNGMethod[] filterLastTimeRunnableTeardownConfigurationMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod2;
            if (!TestNgMethodUtils.isConfigMethodRunningLastTime(configurationMethod, iTestNGMethod)) continue;
            list.add(iTestNGMethod2);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    static boolean cannotRunMethodIndependently(ITestNGMethod iTestNGMethod) {
        String[] stringArray = iTestNGMethod.getMethodsDependedUpon();
        return null != stringArray && stringArray.length > 0;
    }

    static Object getMethodInvocationToken(ITestNGMethod iTestNGMethod, Object object) {
        return String.format("%s+%d+%d", object.toString(), iTestNGMethod.getCurrentInvocationCount(), iTestNGMethod.getParameterInvocationCount());
    }

    private static boolean isConfigMethodRunningFirstTime(ConfigurationMethod configurationMethod, ITestNGMethod iTestNGMethod) {
        return !configurationMethod.isFirstTimeOnly() || configurationMethod.isFirstTimeOnly() && iTestNGMethod.getCurrentInvocationCount() == 0;
    }

    private static boolean isConfigMethodRunningLastTime(ConfigurationMethod configurationMethod, ITestNGMethod iTestNGMethod) {
        return !configurationMethod.isLastTimeOnly() || configurationMethod.isLastTimeOnly() && !iTestNGMethod.hasMoreInvocation();
    }
}

