/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Point;
import java.awt.Rectangle;
import java.text.BreakIterator;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;

public class AtkText {
    AccessibleContext ac;
    AccessibleText acc_text;

    public AtkText(AccessibleContext accessibleContext) {
        this.ac = accessibleContext;
        this.acc_text = accessibleContext.getAccessibleText();
    }

    public String get_text(int n, int n2) {
        int n3 = this.acc_text.getCharCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 > n3 || n2 == -1) {
            n2 = n3;
        }
        if (n2 < -1) {
            n2 = 0;
        }
        if (this.acc_text instanceof AccessibleExtendedText) {
            AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)this.acc_text);
            return accessibleExtendedText.getTextRange(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2 - 1; ++i) {
            String string = this.acc_text.getAtIndex(1, i);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public char get_character_at_offset(int n) {
        String string = this.acc_text.getAtIndex(1, n);
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public StringSequence get_text_at_offset(int n, int n2) {
        if (this.acc_text instanceof AccessibleExtendedText) {
            AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)this.acc_text);
            int n3 = this.getPartTypeFromBoundary(n2);
            if (n3 == -1) {
                return null;
            }
            AccessibleTextSequence accessibleTextSequence = accessibleExtendedText.getTextSequenceAt(n3, n);
            return new StringSequence(accessibleTextSequence.text, accessibleTextSequence.startIndex, accessibleTextSequence.endIndex + 1);
        }
        return this.private_get_text_at_offset(n, n2);
    }

    public int get_caret_offset() {
        return this.acc_text.getCaretPosition();
    }

    public Rectangle get_character_extents(int n, int n2) {
        Rectangle rectangle = this.acc_text.getCharacterBounds(n);
        if (rectangle == null) {
            return null;
        }
        if (n2 == 0) {
            AccessibleComponent accessibleComponent = this.ac.getAccessibleComponent();
            if (accessibleComponent == null) {
                return null;
            }
            Point point = accessibleComponent.getLocationOnScreen();
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        return rectangle;
    }

    public int get_character_count() {
        return this.acc_text.getCharCount();
    }

    public int get_offset_at_point(int n, int n2, int n3) {
        if (n3 == 0) {
            AccessibleComponent accessibleComponent = this.ac.getAccessibleComponent();
            if (accessibleComponent == null) {
                return -1;
            }
            Point point = accessibleComponent.getLocationOnScreen();
            n -= point.x;
            n2 -= point.y;
        }
        return this.acc_text.getIndexAtPoint(new Point(n, n2));
    }

    public Rectangle get_range_extents(int n, int n2, int n3) {
        if (this.acc_text instanceof AccessibleExtendedText) {
            AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)this.acc_text);
            Rectangle rectangle = accessibleExtendedText.getTextBounds(n, n2 - 1);
            if (rectangle == null) {
                return null;
            }
            if (n3 == 0) {
                AccessibleComponent accessibleComponent = this.ac.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return null;
                }
                Point point = accessibleComponent.getLocationOnScreen();
                rectangle.x += point.x;
                rectangle.y += point.y;
            }
            return rectangle;
        }
        return null;
    }

    public int get_n_selections() {
        String string = this.acc_text.getSelectedText();
        if (string != null && string.length() > 0) {
            return 1;
        }
        return 0;
    }

    public StringSequence get_selection() {
        int n = this.acc_text.getSelectionStart();
        int n2 = this.acc_text.getSelectionEnd() + 1;
        String string = this.acc_text.getSelectedText();
        if (string == null) {
            return null;
        }
        return new StringSequence(string, n, n2);
    }

    public boolean add_selection(int n, int n2) {
        AccessibleEditableText accessibleEditableText = this.ac.getAccessibleEditableText();
        if (accessibleEditableText == null || this.get_n_selections() > 0) {
            return false;
        }
        return this.set_selection(0, n, n2);
    }

    public boolean remove_selection(int n) {
        AccessibleEditableText accessibleEditableText = this.ac.getAccessibleEditableText();
        if (accessibleEditableText == null || n > 0) {
            return false;
        }
        accessibleEditableText.selectText(0, 0);
        return true;
    }

    public boolean set_selection(int n, int n2, int n3) {
        AccessibleEditableText accessibleEditableText = this.ac.getAccessibleEditableText();
        if (accessibleEditableText == null || n > 0) {
            return false;
        }
        accessibleEditableText.selectText(n2, n3 - 1);
        return true;
    }

    public boolean set_caret_offset(int n) {
        AccessibleEditableText accessibleEditableText = this.ac.getAccessibleEditableText();
        if (accessibleEditableText != null) {
            accessibleEditableText.selectText(n, n);
            return true;
        }
        return false;
    }

    private int getPartTypeFromBoundary(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 3;
            }
            case 5: 
            case 6: {
                return 4;
            }
        }
        return -1;
    }

    private int getNextWordStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        int n3 = breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i < n3; ++i) {
                if (!Character.isLetter(string.codePointAt(i))) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return -1;
    }

    private int getNextWordEnd(int n, String string) {
        int n2 = this.getNextWordStart(n, string);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n3 = breakIterator.following(n);
        if (n2 == n3) {
            return breakIterator.following(n2);
        }
        return n3;
    }

    private int getPreviousWordStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        int n3 = breakIterator.next();
        while (n2 != -1) {
            for (int i = n2; i < n3; ++i) {
                if (!Character.isLetter(string.codePointAt(i))) continue;
                return n2;
            }
            n3 = n2;
            n2 = breakIterator.preceding(n3);
        }
        return -1;
    }

    private int getPreviousWordEnd(int n, String string) {
        int n2 = this.getPreviousWordStart(n, string);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n3 = breakIterator.preceding(n);
        if (n2 == n3) {
            return breakIterator.preceding(n2);
        }
        return n3;
    }

    private int getNextSentenceStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        return n2;
    }

    private int getNextSentenceEnd(int n, String string) {
        int n2 = this.getNextSentenceStart(n, string);
        if (n2 == -1) {
            return string.length();
        }
        int n3 = n2;
        while (--n3 >= 0 && Character.isWhitespace(string.charAt(n3))) {
        }
        if (++n3 < n) {
            if ((n2 = this.getNextSentenceStart(n2, string)) == -1) {
                return string.length();
            }
            n3 = n2;
            while (--n3 >= 0 && Character.isWhitespace(string.charAt(n3))) {
            }
            ++n3;
        }
        return n3;
    }

    private int getPreviousSentenceStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        return n2;
    }

    private int getPreviousSentenceEnd(int n, String string) {
        int n2 = this.getPreviousSentenceStart(n, string);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.getNextSentenceEnd(n2, string);
        if (n < n3) {
            if ((n2 = this.getPreviousSentenceStart(n2, string)) == -1) {
                return 0;
            }
            n3 = this.getNextSentenceEnd(n2, string);
        }
        return n3;
    }

    private StringSequence private_get_text_at_offset(int n, int n2) {
        int n3 = this.get_character_count();
        if (n < 0 || n >= n3) {
            return null;
        }
        switch (n2) {
            case 0: {
                String string = this.get_text(n, n + 1);
                return new StringSequence(string, n, n + 1);
            }
            case 1: {
                int n4;
                String string = this.get_text(0, this.get_character_count());
                int n5 = this.getPreviousWordStart(n, string);
                if (n5 == -1) {
                    n5 = 0;
                }
                if ((n4 = this.getNextWordStart(n, string)) == -1) {
                    n4 = string.length();
                }
                String string2 = this.get_text(n5, n4);
                return new StringSequence(string2, n5, n4);
            }
            case 2: {
                int n6;
                String string = this.get_text(0, this.get_character_count());
                int n7 = this.getPreviousWordEnd(n, string);
                if (n7 == -1) {
                    n7 = 0;
                }
                if ((n6 = this.getNextWordEnd(n, string)) == -1) {
                    n6 = string.length();
                }
                String string3 = this.get_text(n7, n6);
                return new StringSequence(string3, n7, n6);
            }
            case 3: {
                int n8;
                String string = this.get_text(0, this.get_character_count());
                int n9 = this.getPreviousSentenceStart(n, string);
                if (n9 == -1) {
                    n9 = 0;
                }
                if ((n8 = this.getNextSentenceStart(n, string)) == -1) {
                    n8 = string.length();
                }
                String string4 = this.get_text(n9, n8);
                return new StringSequence(string4, n9, n8);
            }
            case 4: {
                int n10;
                String string = this.get_text(0, this.get_character_count());
                int n11 = this.getPreviousSentenceEnd(n, string);
                if (n11 == -1) {
                    n11 = 0;
                }
                if ((n10 = this.getNextSentenceEnd(n, string)) == -1) {
                    n10 = string.length();
                }
                String string5 = this.get_text(n11, n10);
                return new StringSequence(string5, n11, n10);
            }
            case 5: 
            case 6: {
                int n12;
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                String string = this.get_text(0, this.get_character_count());
                breakIterator.setText(string);
                int n13 = breakIterator.preceding(n);
                if (n13 == -1) {
                    n13 = 0;
                }
                if ((n12 = breakIterator.following(n)) == -1) {
                    n12 = string.length();
                }
                String string6 = this.get_text(n13, n12);
                return new StringSequence(string6, n13, n12);
            }
        }
        return null;
    }

    public class StringSequence {
        public String str;
        public int start_offset;
        public int end_offset;

        public StringSequence(String string, int n, int n2) {
            this.str = string;
            this.start_offset = n;
            this.end_offset = n2;
        }
    }
}

