/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.P3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;

public final class Bspf {
    int dimMax;
    public Bspt[] bspts;
    public boolean isValid = false;
    boolean[] bsptsValid;
    CubeIterator[] cubeIterators;

    public void validateModel(int i, boolean isValid) {
        this.bsptsValid[i] = isValid;
    }

    public boolean isInitializedIndex(int bsptIndex) {
        return this.bspts.length > bsptIndex && this.bspts[bsptIndex] != null && this.bsptsValid[bsptIndex];
    }

    public Bspf(int dimMax) {
        this.dimMax = dimMax;
        this.bspts = new Bspt[1];
        this.bsptsValid = new boolean[1];
        this.cubeIterators = new CubeIterator[0];
    }

    public void addTuple(int bsptIndex, P3 tuple) {
        Bspt bspt;
        if (bsptIndex >= this.bspts.length) {
            this.bspts = (Bspt[])AU.arrayCopyObject(this.bspts, bsptIndex + 1);
            this.bsptsValid = AU.arrayCopyBool(this.bsptsValid, bsptIndex + 1);
        }
        if ((bspt = this.bspts[bsptIndex]) == null) {
            bspt = this.bspts[bsptIndex] = new Bspt(this.dimMax, bsptIndex);
        }
        bspt.addTuple(tuple);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            if (this.bspts[i] == null) continue;
            this.bspts[i].stats();
        }
    }

    public CubeIterator getCubeIterator(int bsptIndex) {
        if (bsptIndex < 0) {
            return this.getNewCubeIterator(-1 - bsptIndex);
        }
        if (bsptIndex >= this.cubeIterators.length) {
            this.cubeIterators = (CubeIterator[])AU.arrayCopyObject(this.cubeIterators, bsptIndex + 1);
        }
        if (this.cubeIterators[bsptIndex] == null && this.bspts[bsptIndex] != null) {
            this.cubeIterators[bsptIndex] = this.getNewCubeIterator(bsptIndex);
        }
        this.cubeIterators[bsptIndex].set(this.bspts[bsptIndex]);
        return this.cubeIterators[bsptIndex];
    }

    public CubeIterator getNewCubeIterator(int bsptIndex) {
        return this.bspts[bsptIndex].allocateCubeIterator();
    }

    public synchronized void initialize(int modelIndex, P3[] atoms, BS modelAtomBitSet) {
        if (this.bspts[modelIndex] != null) {
            this.bspts[modelIndex].reset();
        }
        int i = modelAtomBitSet.nextSetBit(0);
        while (i >= 0) {
            this.addTuple(modelIndex, atoms[i]);
            i = modelAtomBitSet.nextSetBit(i + 1);
        }
        this.bsptsValid[modelIndex] = true;
    }
}

