/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.tlsServerContext = new TlsServerContextImpl(tlsServer.getCrypto());
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handleHandshakeMessage(short s, ByteArrayInputStream byteArrayInputStream) throws IOException {
        block0 : switch (s) {
            case 1: {
                switch (this.connection_state) {
                    case 16: {
                        if (!this.handleRenegotiation()) break block0;
                    }
                    case 0: {
                        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
                        this.receiveClientHelloMessage(byteArrayInputStream);
                        this.connection_state = 1;
                        this.invalidateSession();
                        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.sessionParameters = null;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = TlsUtils.initKeyExchangeServer(this.tlsServerContext, this.tlsServer);
                        this.serverCredentials = TlsServerProtocol.validateCredentials(this.tlsServer.getCredentials());
                        Object object = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (null == this.serverCredentials) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            object = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage((Certificate)object, byteArrayOutputStream);
                        }
                        securityParameters.tlsServerEndPoint = byteArrayOutputStream.toByteArray();
                        this.connection_state = (short)4;
                        if (null == object || ((Certificate)object).isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                        }
                        this.connection_state = (short)5;
                        object = this.keyExchange.generateServerKeyExchange();
                        if (object != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                if (TlsUtils.isTLSv12(this.getContext()) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        boolean bl = false;
                        TlsUtils.sealHandshakeHash(this.getContext(), this.recordStream.getHandshakeHash(), bl);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(byteArrayInputStream));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(byteArrayInputStream);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.getContext())) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 10: {
                        this.receiveClientKeyExchangeMessage(byteArrayInputStream);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(byteArrayInputStream);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(byteArrayInputStream);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleAlertWarningMessage(short s) throws IOException {
        super.handleAlertWarningMessage(s);
        switch (s) {
            case 41: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        TlsUtils.processClientCertificate(this.tlsServerContext, certificate, this.certificateRequest, this.keyExchange, this.tlsServer);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(this.getContext(), byteArrayInputStream, null);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsServerContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerify(this.tlsServerContext, this.certificateRequest, digitallySigned, this.prepareFinishHash);
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 0, 32);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (s < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = TlsUtils.readUint8Array(s, byteArrayInputStream);
        this.clientExtensions = TlsServerProtocol.readExtensions(byteArrayInputStream);
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        this.tlsServerContext.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(this.clientExtensions));
        if (null == this.tlsServerContext.getClientSupportedVersions()) {
            if (protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12)) {
                protocolVersion = ProtocolVersion.TLSv12;
            }
            this.tlsServerContext.setClientSupportedVersions(protocolVersion.downTo(ProtocolVersion.TLSv10));
        } else {
            protocolVersion = ProtocolVersion.getLatestTLS(this.tlsServerContext.getClientSupportedVersions());
        }
        if (null == protocolVersion || !ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion.equals(this.tlsServerContext.getClientVersion()) && !protocolVersion.equals(this.tlsServerContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            this.tlsServerContext.setClientVersion(protocolVersion);
        }
        this.tlsServer.notifyClientVersion(this.tlsServerContext.getClientVersion());
        securityParameters.clientRandom = byArray;
        this.tlsServer.notifyFallback(Arrays.contains((int[])this.offeredCipherSuites, (int)22016));
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        if (!securityParameters.isExtendedMasterSecret() && this.tlsServer.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(40);
        }
        byte[] byArray3 = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                throw new TlsFatalAlert(40);
            }
            if (null == byArray3) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters securityParameters2 = this.tlsServerContext.getSecurityParametersConnection();
            byte[] byArray4 = securityParameters2.getPeerVerifyData();
            if (!Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])TlsServerProtocol.createRenegotiationInfo(byArray4))) {
                throw new TlsFatalAlert(40);
            }
        } else {
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                securityParameters.secureRenegotiation = true;
            }
            if (byArray3 != null) {
                securityParameters.secureRenegotiation = true;
                if (!Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
        }
        this.tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
                securityParameters.clientSigAlgs = TlsExtensionsUtils.getSignatureAlgorithmsExtension(this.clientExtensions);
                securityParameters.clientSigAlgsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(this.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.prepareFinishHash = this.recordStream.prepareToFinish();
        this.tlsServerContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.prepareFinishHash);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(13);
        certificateRequest.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(22);
        certificateStatus.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendHelloRequestMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)0, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.writeHandshakeMessage(byArray, 0, byArray.length);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(4);
        newSessionTicket.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendServerHelloMessage() throws IOException {
        Object object;
        int n;
        ProtocolVersion protocolVersion;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.tlsServerContext.getServerVersion();
        } else {
            protocolVersion = this.tlsServer.getServerVersion();
            if (null == protocolVersion || !ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion) || !ProtocolVersion.contains(this.tlsServerContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            ProtocolVersion protocolVersion2 = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
            this.recordStream.setWriteVersion(protocolVersion2);
            securityParameters.negotiatedVersion = protocolVersion;
        }
        securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(this.tlsServer.shouldUseGMTUnixTime(), this.tlsServerContext);
        if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getSupportedVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)(n = this.tlsServer.getSelectedCipherSuite())) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, this.tlsServerContext.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.cipherSuite = n;
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        ProtocolVersion protocolVersion3 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12)) {
            protocolVersion3 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionServer(this.serverExtensions, protocolVersion);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            object = this.tlsServerContext.getSecurityParametersConnection();
            byte[] byArray = TlsUtils.concat(((SecurityParameters)object).getPeerVerifyData(), ((SecurityParameters)object).getLocalVerifyData());
            this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(byArray));
        } else if (securityParameters.isSecureRenegotiation()) {
            boolean bl;
            object = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl2 = bl = null == object;
            if (bl) {
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        if (!this.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.tlsServerContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        object = new TlsProtocol.HandshakeMessage(2);
        TlsUtils.writeVersion(protocolVersion3, (OutputStream)object);
        ((OutputStream)object).write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8(this.tlsSession.getSessionID(), (OutputStream)object);
        TlsUtils.writeUint16(securityParameters.getCipherSuite(), (OutputStream)object);
        TlsUtils.writeUint8((short)0, (OutputStream)object);
        TlsServerProtocol.writeExtensions((OutputStream)object, this.serverExtensions);
        ((TlsProtocol.HandshakeMessage)object).writeToRecordStream();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)14, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.writeHandshakeMessage(byArray, 0, byArray.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(12, byArray.length);
        handshakeMessage.write(byArray);
        handshakeMessage.writeToRecordStream();
    }

    protected boolean expectCertificateVerifyMessage() {
        Certificate certificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && this.keyExchange.requiresCertificateVerify();
    }
}

