/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.securerandom;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ConvertBytes;

@JRubyModule(name={"SecureRandom"})
public class RubySecureRandom {
    private static final int BI_ADD_BITS = 96;

    @JRubyMethod(meta=true, name={"random_bytes"})
    public static IRubyObject random_bytes(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, RubySecureRandom.nextBytes(context, 16));
    }

    @JRubyMethod(meta=true, name={"random_bytes"}, alias={"gen_random"})
    public static IRubyObject random_bytes(ThreadContext context, IRubyObject self2, IRubyObject n) {
        return RubyString.newStringNoCopy(context.runtime, RubySecureRandom.nextBytes(context, n));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject hex(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.twosComplementToHexBytes(RubySecureRandom.nextBytes(context, 16), false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject hex(ThreadContext context, IRubyObject self2, IRubyObject n) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.twosComplementToHexBytes(RubySecureRandom.nextBytes(context, n), false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject uuid(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.bytesToUUIDBytes(RubySecureRandom.nextBytes(context, 16), false));
    }

    private static byte[] nextBytes(ThreadContext context, IRubyObject n) {
        return RubySecureRandom.nextBytes(context, n.isNil() ? 16 : n.convertToInteger().getIntValue());
    }

    private static byte[] nextBytes(ThreadContext context, int size2) {
        if (size2 < 0) {
            throw context.runtime.newArgumentError("negative argument: " + size2);
        }
        byte[] bytes2 = new byte[size2];
        RubySecureRandom.getSecureRandom(context).nextBytes(bytes2);
        return bytes2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_number(ThreadContext context, IRubyObject self2) {
        return RubySecureRandom.randomDouble(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_number(ThreadContext context, IRubyObject self2, IRubyObject n) {
        if (n instanceof RubyFixnum) {
            long bound = ((RubyFixnum)n).getLongValue();
            return bound < 0L ? RubySecureRandom.randomDouble(context) : RubySecureRandom.randomFixnum(context, 0L, bound - 1L);
        }
        if (n instanceof RubyFloat) {
            double bound = ((RubyFloat)n).getDoubleValue();
            return bound < 0.0 ? RubySecureRandom.randomDouble(context) : RubySecureRandom.randomDouble(context, 0.0, bound - Double.MIN_VALUE);
        }
        if (n instanceof RubyBignum) {
            BigInteger bound = ((RubyBignum)n).getBigIntegerValue();
            return bound.signum() < 0 ? RubySecureRandom.randomDouble(context) : RubySecureRandom.randomBignum(context, 0, bound);
        }
        if (n instanceof RubyRange) {
            IRubyObject beg = ((RubyRange)n).begin(context);
            IRubyObject end2 = ((RubyRange)n).end(context);
            boolean exclude = ((RubyRange)n).isExcludeEnd();
            if (beg instanceof RubyFixnum && end2 instanceof RubyFixnum) {
                long upper;
                long lower = ((RubyFixnum)beg).getLongValue();
                if (lower > (upper = ((RubyFixnum)end2).getLongValue())) {
                    return RubySecureRandom.randomDouble(context);
                }
                if (exclude) {
                    --upper;
                }
                return RubySecureRandom.randomFixnum(context, lower, upper);
            }
            if (beg instanceof RubyInteger && end2 instanceof RubyInteger) {
                BigInteger upper;
                BigInteger lower = ((RubyInteger)beg).getBigIntegerValue();
                if (lower.compareTo(upper = ((RubyInteger)end2).getBigIntegerValue()) > 0) {
                    return RubySecureRandom.randomDouble(context);
                }
                if (!exclude) {
                    upper = upper.add(BigInteger.ONE);
                }
                return RubySecureRandom.randomBignum(context, lower, upper);
            }
            if (beg instanceof RubyFloat && end2 instanceof RubyFloat) {
                double upper;
                double lower = ((RubyFloat)beg).getDoubleValue();
                if (lower > (upper = ((RubyFloat)end2).getDoubleValue())) {
                    return RubySecureRandom.randomDouble(context);
                }
                if (exclude) {
                    upper -= Double.MIN_VALUE;
                }
                return RubySecureRandom.randomDouble(context, lower, upper);
            }
        }
        throw context.runtime.newArgumentError("invalid argument - " + n.anyToString());
    }

    private static RubyFixnum randomFixnum(ThreadContext context, long lower, long upper) {
        double rnd = RubySecureRandom.getSecureRandom(context).nextDouble();
        rnd = rnd * (double)upper + (1.0 - rnd) * (double)lower + rnd;
        return context.runtime.newFixnum((long)Math.floor(rnd));
    }

    private static RubyBignum randomBignum(ThreadContext context, Number lower, BigInteger upperExc) {
        BigInteger lowerBig = lower instanceof BigInteger ? (BigInteger)lower : BigInteger.valueOf(lower.longValue());
        BigInteger bound = upperExc.subtract(lowerBig);
        BigInteger rnd = RubySecureRandom.nextBigInteger(RubySecureRandom.getSecureRandom(context), bound, bound.bitLength());
        return RubyBignum.newBignum(context.runtime, rnd.add(lowerBig));
    }

    private static BigInteger nextBigInteger(SecureRandom random, BigInteger bound, int bits) {
        BigInteger val = new BigInteger(bits + 96, random);
        BigInteger rnd = val.mod(bound);
        if (val.add(bound).subtract(rnd).subtract(BigInteger.ONE).bitLength() >= bits + 96) {
            return RubySecureRandom.nextBigInteger(random, bound, bits);
        }
        return rnd;
    }

    private static RubyFloat randomDouble(ThreadContext context, double lower, double upper) {
        double rnd = RubySecureRandom.getSecureRandom(context).nextDouble();
        return context.runtime.newFloat(rnd * upper + (1.0 - rnd) * lower);
    }

    private static RubyFloat randomDouble(ThreadContext context) {
        return context.runtime.newFloat(RubySecureRandom.getSecureRandom(context).nextDouble());
    }

    private static SecureRandom getSecureRandom(ThreadContext context) {
        return context.getSecureRandom();
    }
}

