/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSourceStream;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class BufferControlImpl
implements BufferControl {
    private long currBuffer = Integer.MAX_VALUE;
    private long currThreshold = Integer.MAX_VALUE;
    private long defBuffer = Integer.MAX_VALUE;
    private long defThreshold = Integer.MAX_VALUE;
    private long maxBuffer = Integer.MAX_VALUE;
    private long maxThreshold = Integer.MAX_VALUE;
    BufferControlPanel controlComp = null;
    boolean threshold_enabled = true;
    private static final int AUDIO_DEFAULT_BUFFER = 250;
    private static final int AUDIO_DEFAULT_THRESHOLD = 125;
    private static final int AUDIO_MAX_BUFFER = 4000;
    private static final int AUDIO_MAX_THRESHOLD = 2000;
    private static final int VIDEO_DEFAULT_BUFFER = 135;
    private static final int VIDEO_DEFAULT_THRESHOLD = 0;
    private static final int VIDEO_MAX_BUFFER = 4000;
    private static final int VIDEO_MAX_THRESHOLD = 0;
    private static final int NOT_SPECIFIED = Integer.MAX_VALUE;
    private int bufValue = Integer.MAX_VALUE;
    private int threshValue = Integer.MAX_VALUE;
    private boolean inited = false;
    private Vector sourcestreamlist = new Vector(1);

    protected void addSourceStream(RTPSourceStream s) {
        this.sourcestreamlist.addElement(s);
        s.setBufferControl(this);
    }

    protected void removeSourceStream(RTPSourceStream s) {
        this.sourcestreamlist.removeElement(s);
    }

    protected void initBufferControl(Format f) {
        if (f instanceof AudioFormat) {
            this.defBuffer = this.defBuffer == Integer.MAX_VALUE ? 250L : this.currBuffer;
            this.defThreshold = this.defThreshold == Integer.MAX_VALUE ? 125L : this.currThreshold;
            this.maxBuffer = this.maxBuffer == Integer.MAX_VALUE ? 4000L : this.maxBuffer;
            this.maxThreshold = this.maxThreshold == Integer.MAX_VALUE ? 2000L : this.maxThreshold;
            this.currBuffer = this.currBuffer == Integer.MAX_VALUE ? this.defBuffer : this.currBuffer;
            long l = this.currThreshold = this.currThreshold == Integer.MAX_VALUE ? this.defThreshold : this.currThreshold;
        }
        if (f instanceof VideoFormat) {
            this.defBuffer = this.defBuffer == Integer.MAX_VALUE ? 135L : this.currBuffer;
            this.defThreshold = this.defThreshold == Integer.MAX_VALUE ? 0L : this.currThreshold;
            this.maxBuffer = this.maxBuffer == Integer.MAX_VALUE ? 4000L : this.maxBuffer;
            this.maxThreshold = this.maxThreshold == Integer.MAX_VALUE ? 0L : this.maxThreshold;
            this.currBuffer = this.currBuffer == Integer.MAX_VALUE ? this.defBuffer : this.currBuffer;
            long l = this.currThreshold = this.currThreshold == Integer.MAX_VALUE ? this.defThreshold : this.currThreshold;
        }
        if (this.currBuffer == -2L) {
            this.currBuffer = this.maxBuffer;
        }
        if (this.currBuffer == -1L) {
            this.currBuffer = this.defBuffer;
        }
        if (this.currThreshold == -2L) {
            this.currThreshold = this.maxThreshold;
        }
        if (this.currThreshold == -1L) {
            this.currThreshold = this.defThreshold;
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
            this.controlComp.updateThreshold(this.currThreshold);
        }
        this.inited = true;
    }

    public long getBufferLength() {
        return this.currBuffer;
    }

    public long setBufferLength(long time) {
        if (!this.inited) {
            this.currBuffer = time;
            return time;
        }
        if (time == -1L) {
            time = this.defBuffer;
        }
        if (time == -2L) {
            time = this.maxBuffer;
        }
        if (time < this.currThreshold) {
            return this.currBuffer;
        }
        this.currBuffer = time >= this.maxBuffer ? this.maxBuffer : (time <= 0L || time == this.defBuffer ? this.defBuffer : time);
        int i = 0;
        while (i < this.sourcestreamlist.size()) {
            ((RTPSourceStream)this.sourcestreamlist.elementAt(i)).updateBuffer(this.currBuffer);
            ++i;
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
        }
        return this.currBuffer;
    }

    public long getMinimumThreshold() {
        return this.currThreshold;
    }

    public long setMinimumThreshold(long t) {
        if (!this.inited) {
            this.currThreshold = t;
            return t;
        }
        if (t == -1L) {
            t = this.defThreshold;
        }
        if (t == -2L) {
            t = this.maxThreshold;
        }
        if (t > this.currBuffer) {
            return this.currThreshold;
        }
        this.currThreshold = t >= this.maxThreshold ? this.maxThreshold : (t == this.defThreshold ? this.defThreshold : t);
        if (t < 0L) {
            this.currThreshold = 0L;
        }
        int i = 0;
        while (i < this.sourcestreamlist.size()) {
            ((RTPSourceStream)this.sourcestreamlist.elementAt(i)).updateThreshold(this.currThreshold);
            ++i;
        }
        if (this.controlComp != null) {
            this.controlComp.updateThreshold(this.currThreshold);
        }
        return this.currThreshold;
    }

    public void setEnabledThreshold(boolean b) {
        this.threshold_enabled = b;
    }

    public boolean getEnabledThreshold() {
        return this.threshold_enabled;
    }

    public Component getControlComponent() {
        if (this.controlComp == null) {
            this.controlComp = new BufferControlPanel();
        }
        return this.controlComp;
    }

    class BufferControlPanel
    extends Panel {
        Panel buffersize = new Panel(new FlowLayout());
        Panel threshold = null;
        TextField bsize;
        TextField btext = null;
        Choice bchoice = null;
        Choice tchoice = null;
        TextField tsize;
        TextField ttext = null;
        Button bb;
        Button tb = null;

        public BufferControlPanel() {
            super(new BorderLayout());
            this.buffersize.add(new Label("BufferSize"));
            this.bsize = new TextField(15);
            this.updateBuffer(BufferControlImpl.this.getBufferLength());
            this.bsize.setEnabled(false);
            this.buffersize.add(this.bsize);
            this.buffersize.add(new Label("Update"));
            this.bchoice = new Choice();
            this.buffersize.add(this.bchoice);
            this.bchoice.add("DEFAULT");
            this.bchoice.add("MAX");
            this.bchoice.add("User Defined");
            this.bchoice.addItemListener(new ItemListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals("User Defined")) {
                        this.this$1.btext.setEnabled(true);
                    } else {
                        this.this$1.btext.setEnabled(false);
                    }
                }
            });
            this.buffersize.add(new Label("If User Defined, Enter here:"));
            this.btext = new TextField(10);
            this.buffersize.add(this.btext);
            this.btext.setEnabled(false);
            this.bb = new Button("Commit");
            this.buffersize.add(this.bb);
            this.bb.addActionListener(new ActionListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    BufferControlPanel.access$000(this.this$1);
                }
            });
            this.threshold = new Panel(new FlowLayout());
            this.threshold.add(new Label("Threshold"));
            this.tsize = new TextField(15);
            this.updateThreshold(BufferControlImpl.this.getMinimumThreshold());
            this.tsize.setEnabled(false);
            this.threshold.add(this.tsize);
            this.threshold.add(new Label("Update"));
            this.tchoice = new Choice();
            this.threshold.add(this.tchoice);
            this.tchoice.add("DEFAULT");
            this.tchoice.add("MAX");
            this.tchoice.add("User Defined");
            this.tchoice.addItemListener(new ItemListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals("User Defined")) {
                        this.this$1.ttext.setEnabled(true);
                    } else {
                        this.this$1.ttext.setEnabled(false);
                    }
                }
            });
            this.threshold.add(new Label("If User Defined, Enter here:"));
            this.ttext = new TextField(10);
            this.threshold.add(this.ttext);
            this.ttext.setEnabled(false);
            this.tb = new Button("Commit");
            this.threshold.add(this.tb);
            this.tb.addActionListener(new ActionListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    BufferControlPanel.access$100(this.this$1);
                }
            });
            this.add((Component)this.buffersize, "North");
            this.add((Component)new Label("Actual buffer & threshold sizes (in millisec) not displayed until media type is determined"), "Center");
            this.add((Component)this.threshold, "South");
            this.setVisible(true);
        }

        private void buffersizeUpdate() {
            String s = this.bchoice.getSelectedItem();
            long b = -1L;
            if (s.equals("MAX")) {
                b = -2L;
            } else if (s.equals("DEFAULT")) {
                b = -1L;
            } else {
                s = this.btext.getText();
                b = new Long(s);
            }
            b = BufferControlImpl.this.setBufferLength(b);
            this.updateBuffer(b);
        }

        private void thresholdUpdate() {
            String s = this.tchoice.getSelectedItem();
            long t = -1L;
            if (s.equals("DEFAULT")) {
                t = -1L;
            } else if (s.equals("MAX")) {
                t = -2L;
            } else {
                s = this.ttext.getText();
                t = new Long(s);
            }
            t = BufferControlImpl.this.setMinimumThreshold(t);
            this.updateThreshold(t);
        }

        public void updateBuffer(long b) {
            if (b != Integer.MAX_VALUE && b != -2L && b != -1L) {
                this.bsize.setText(new Long(b).toString());
            }
        }

        public void updateThreshold(long d) {
            if (d != Integer.MAX_VALUE && d != -2L && d != -1L) {
                this.tsize.setText(new Long(d).toString());
            }
        }

        static /* synthetic */ void access$000(BufferControlPanel x0) {
            x0.buffersizeUpdate();
        }

        static /* synthetic */ void access$100(BufferControlPanel x0) {
            x0.thresholdUpdate();
        }
    }
}

