/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestedReplacement {
    private String replacement;
    private String shortDescription;
    private SortedMap<String, Float> features = Collections.emptySortedMap();
    private Float confidence = null;

    public SuggestedReplacement(String replacement) {
        this.replacement = Objects.requireNonNull(replacement);
    }

    public SuggestedReplacement(SuggestedReplacement clone) {
        this.replacement = clone.replacement;
        this.setShortDescription(clone.getShortDescription());
        this.setConfidence(clone.getConfidence());
        this.setFeatures(clone.getFeatures());
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = Objects.requireNonNull(replacement);
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String desc) {
        this.shortDescription = desc;
    }

    public String toString() {
        return this.replacement + '(' + this.shortDescription + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestedReplacement that = (SuggestedReplacement)o;
        return this.replacement.equals(that.replacement) && Objects.equals(this.shortDescription, that.shortDescription);
    }

    public int hashCode() {
        return Objects.hash(this.replacement, this.shortDescription);
    }

    @Nullable
    public Float getConfidence() {
        return this.confidence;
    }

    public void setConfidence(@Nullable Float confidence) {
        this.confidence = confidence;
    }

    @NotNull
    public SortedMap<String, Float> getFeatures() {
        return Collections.unmodifiableSortedMap(this.features);
    }

    public void setFeatures(@NotNull SortedMap<String, Float> features) {
        this.features = features;
    }
}

