/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CompoundTextSupport {
    static int MAX_CONTROL_SEQUENCE_LEN;
    private static final Map<ControlSequence, String> sequenceToEncodingMap;
    private static final Map<ControlSequence, Boolean> highBitsMap;
    private static final Map<String, ControlSequence> encodingToSequenceMap;
    private static final List<String> encodings;

    private static boolean isEncodingSupported(String encoding) {
        try {
            if (Charset.isSupported(encoding)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return CompoundTextSupport.getDecoder(encoding) != null && CompoundTextSupport.getEncoder(encoding) != null;
    }

    static CharsetDecoder getStandardDecoder(byte[] escSequence) {
        return CompoundTextSupport.getNonStandardDecoder(escSequence, null);
    }

    static boolean getHighBit(byte[] escSequence) {
        Boolean bool = highBitsMap.get(new ControlSequence(escSequence));
        return bool == Boolean.TRUE;
    }

    static CharsetDecoder getNonStandardDecoder(byte[] escSequence, byte[] encoding) {
        return CompoundTextSupport.getDecoder(sequenceToEncodingMap.get(new ControlSequence(escSequence, encoding)));
    }

    static CharsetDecoder getDecoder(String enc) {
        if (enc == null) {
            return null;
        }
        Charset cs = null;
        try {
            cs = Charset.forName(enc);
        }
        catch (IllegalArgumentException e) {
            Class<?> cls;
            try {
                cls = Class.forName("sun.awt.motif." + enc);
            }
            catch (ClassNotFoundException ee) {
                return null;
            }
            try {
                cs = (Charset)cls.newInstance();
            }
            catch (InstantiationException ee) {
                return null;
            }
            catch (IllegalAccessException ee) {
                return null;
            }
        }
        try {
            return cs.newDecoder();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    static byte[] getEscapeSequence(String encoding) {
        ControlSequence seq = encodingToSequenceMap.get(encoding);
        if (seq != null) {
            return seq.escSequence;
        }
        return null;
    }

    static byte[] getEncoding(String encoding) {
        ControlSequence seq = encodingToSequenceMap.get(encoding);
        if (seq != null) {
            return seq.encoding;
        }
        return null;
    }

    static List<String> getEncodings() {
        return encodings;
    }

    static CharsetEncoder getEncoder(String enc) {
        if (enc == null) {
            return null;
        }
        Charset cs = null;
        try {
            cs = Charset.forName(enc);
        }
        catch (IllegalArgumentException e) {
            Class<?> cls;
            try {
                cls = Class.forName("sun.awt.motif." + enc);
            }
            catch (ClassNotFoundException ee) {
                return null;
            }
            try {
                cs = (Charset)cls.newInstance();
            }
            catch (InstantiationException ee) {
                return null;
            }
            catch (IllegalAccessException ee) {
                return null;
            }
        }
        try {
            return cs.newEncoder();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private CompoundTextSupport() {
    }

    static {
        ControlSequence rightHalf;
        ControlSequence leftHalf;
        HashMap<ControlSequence, String> tSequenceToEncodingMap = new HashMap<ControlSequence, String>(33, 1.0f);
        HashMap<ControlSequence, Boolean> tHighBitsMap = new HashMap<ControlSequence, Boolean>(31, 1.0f);
        HashMap<String, ControlSequence> tEncodingToSequenceMap = new HashMap<String, ControlSequence>(21, 1.0f);
        ArrayList<String> tEncodings = new ArrayList<String>(21);
        if (!CompoundTextSupport.isEncodingSupported("US-ASCII") || !CompoundTextSupport.isEncodingSupported("ISO-8859-1")) {
            throw new ExceptionInInitializerError("US-ASCII and ISO-8859-1 unsupported");
        }
        ControlSequence leftAscii = new ControlSequence(new byte[]{27, 40, 66});
        tSequenceToEncodingMap.put(leftAscii, "US-ASCII");
        tHighBitsMap.put(leftAscii, Boolean.FALSE);
        ControlSequence rightAscii = new ControlSequence(new byte[]{27, 41, 66});
        tSequenceToEncodingMap.put(rightAscii, "US-ASCII");
        tHighBitsMap.put(rightAscii, Boolean.FALSE);
        ControlSequence rightHalf2 = new ControlSequence(new byte[]{27, 45, 65});
        tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-1");
        tHighBitsMap.put(rightHalf2, Boolean.TRUE);
        ControlSequence fullSet = leftAscii.concatenate(rightHalf2);
        tEncodingToSequenceMap.put("ISO-8859-1", fullSet);
        tEncodings.add("ISO-8859-1");
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-2")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 66});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-2");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-2", fullSet);
            tEncodings.add("ISO-8859-2");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-3")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 67});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-3");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-3", fullSet);
            tEncodings.add("ISO-8859-3");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-4")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 68});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-4");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-4", fullSet);
            tEncodings.add("ISO-8859-4");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-5")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 76});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-5");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-5", fullSet);
            tEncodings.add("ISO-8859-5");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-6")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 71});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-6");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-6", fullSet);
            tEncodings.add("ISO-8859-6");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-7")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 70});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-7");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-7", fullSet);
            tEncodings.add("ISO-8859-7");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-8")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 72});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-8");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-8", fullSet);
            tEncodings.add("ISO-8859-8");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-9")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 77});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-9");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-9", fullSet);
            tEncodings.add("ISO-8859-9");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS_X0201")) {
            ControlSequence glLeft = new ControlSequence(new byte[]{27, 40, 74});
            ControlSequence glRight = new ControlSequence(new byte[]{27, 40, 73});
            ControlSequence grLeft = new ControlSequence(new byte[]{27, 41, 74});
            ControlSequence grRight = new ControlSequence(new byte[]{27, 41, 73});
            tSequenceToEncodingMap.put(glLeft, "JIS_X0201");
            tSequenceToEncodingMap.put(glRight, "JIS_X0201");
            tSequenceToEncodingMap.put(grLeft, "JIS_X0201");
            tSequenceToEncodingMap.put(grRight, "JIS_X0201");
            tHighBitsMap.put(glLeft, Boolean.FALSE);
            tHighBitsMap.put(glRight, Boolean.TRUE);
            tHighBitsMap.put(grLeft, Boolean.FALSE);
            tHighBitsMap.put(grRight, Boolean.TRUE);
            ControlSequence fullSet2 = glLeft.concatenate(grRight);
            tEncodingToSequenceMap.put("JIS_X0201", fullSet2);
            tEncodings.add("JIS_X0201");
        }
        if (CompoundTextSupport.isEncodingSupported("X11GB2312")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 65});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 65});
            tSequenceToEncodingMap.put(leftHalf, "X11GB2312");
            tSequenceToEncodingMap.put(rightHalf, "X11GB2312");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("X11GB2312", leftHalf);
            tEncodings.add("X11GB2312");
        }
        if (CompoundTextSupport.isEncodingSupported("x-JIS0208")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 66});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 66});
            tSequenceToEncodingMap.put(leftHalf, "x-JIS0208");
            tSequenceToEncodingMap.put(rightHalf, "x-JIS0208");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("x-JIS0208", leftHalf);
            tEncodings.add("x-JIS0208");
        }
        if (CompoundTextSupport.isEncodingSupported("X11KSC5601")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 67});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 67});
            tSequenceToEncodingMap.put(leftHalf, "X11KSC5601");
            tSequenceToEncodingMap.put(rightHalf, "X11KSC5601");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("X11KSC5601", leftHalf);
            tEncodings.add("X11KSC5601");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-15")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 98});
            tSequenceToEncodingMap.put(rightHalf2, "ISO-8859-15");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("ISO-8859-15", fullSet);
            tEncodings.add("ISO-8859-15");
        }
        if (CompoundTextSupport.isEncodingSupported("TIS-620")) {
            rightHalf2 = new ControlSequence(new byte[]{27, 45, 84});
            tSequenceToEncodingMap.put(rightHalf2, "TIS-620");
            tHighBitsMap.put(rightHalf2, Boolean.TRUE);
            fullSet = leftAscii.concatenate(rightHalf2);
            tEncodingToSequenceMap.put("TIS-620", fullSet);
            tEncodings.add("TIS-620");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS_X0212-1990")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 68});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 68});
            tSequenceToEncodingMap.put(leftHalf, "JIS_X0212-1990");
            tSequenceToEncodingMap.put(rightHalf, "JIS_X0212-1990");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("JIS_X0212-1990", leftHalf);
            tEncodings.add("JIS_X0212-1990");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P1")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 71});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 71});
            tSequenceToEncodingMap.put(leftHalf, "X11CNS11643P1");
            tSequenceToEncodingMap.put(rightHalf, "X11CNS11643P1");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("X11CNS11643P1", leftHalf);
            tEncodings.add("X11CNS11643P1");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P2")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 72});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 72});
            tSequenceToEncodingMap.put(leftHalf, "X11CNS11643P2");
            tSequenceToEncodingMap.put(rightHalf, "X11CNS11643P2");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("X11CNS11643P2", leftHalf);
            tEncodings.add("X11CNS11643P2");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P3")) {
            leftHalf = new ControlSequence(new byte[]{27, 36, 40, 73});
            rightHalf = new ControlSequence(new byte[]{27, 36, 41, 73});
            tSequenceToEncodingMap.put(leftHalf, "X11CNS11643P3");
            tSequenceToEncodingMap.put(rightHalf, "X11CNS11643P3");
            tHighBitsMap.put(leftHalf, Boolean.FALSE);
            tHighBitsMap.put(rightHalf, Boolean.FALSE);
            tEncodingToSequenceMap.put("X11CNS11643P3", leftHalf);
            tEncodings.add("X11CNS11643P3");
        }
        if (CompoundTextSupport.isEncodingSupported("x-Johab")) {
            ControlSequence johab = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 75, 83, 67, 53, 54, 48, 49, 46, 49, 57, 57, 50, 45, 51});
            tSequenceToEncodingMap.put(johab, "x-Johab");
            tEncodingToSequenceMap.put("x-Johab", johab);
            tEncodings.add("x-Johab");
        }
        if (CompoundTextSupport.isEncodingSupported("Big5")) {
            ControlSequence big5 = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 66, 73, 71, 53, 45, 49});
            tSequenceToEncodingMap.put(big5, "Big5");
            tEncodingToSequenceMap.put("Big5", big5);
            tEncodings.add("Big5");
        }
        sequenceToEncodingMap = Collections.unmodifiableMap(tSequenceToEncodingMap);
        highBitsMap = Collections.unmodifiableMap(tHighBitsMap);
        encodingToSequenceMap = Collections.unmodifiableMap(tEncodingToSequenceMap);
        encodings = Collections.unmodifiableList(tEncodings);
    }

    private static final class ControlSequence {
        final int hash;
        final byte[] escSequence;
        final byte[] encoding;

        ControlSequence(byte[] escSequence) {
            this(escSequence, null);
        }

        ControlSequence(byte[] escSequence, byte[] encoding) {
            int i;
            if (escSequence == null) {
                throw new NullPointerException();
            }
            this.escSequence = escSequence;
            this.encoding = encoding;
            int hash = 0;
            int length = escSequence.length;
            for (i = 0; i < escSequence.length; ++i) {
                hash += (escSequence[i] & 0xFF) << i % 4;
            }
            if (encoding != null) {
                for (i = 0; i < encoding.length; ++i) {
                    hash += (encoding[i] & 0xFF) << i % 4;
                }
                length += 2 + encoding.length + 1;
            }
            this.hash = hash;
            if (MAX_CONTROL_SEQUENCE_LEN < length) {
                MAX_CONTROL_SEQUENCE_LEN = length;
            }
        }

        public boolean equals(Object obj) {
            int i;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ControlSequence)) {
                return false;
            }
            ControlSequence rhs = (ControlSequence)obj;
            if (this.escSequence != rhs.escSequence) {
                if (this.escSequence.length != rhs.escSequence.length) {
                    return false;
                }
                for (i = 0; i < this.escSequence.length; ++i) {
                    if (this.escSequence[i] == rhs.escSequence[i]) continue;
                    return false;
                }
            }
            if (this.encoding != rhs.encoding) {
                if (this.encoding == null || rhs.encoding == null || this.encoding.length != rhs.encoding.length) {
                    return false;
                }
                for (i = 0; i < this.encoding.length; ++i) {
                    if (this.encoding[i] == rhs.encoding[i]) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }

        ControlSequence concatenate(ControlSequence rhs) {
            if (this.encoding != null) {
                throw new IllegalArgumentException("cannot concatenate to a non-standard charset escape sequence");
            }
            int len = this.escSequence.length + rhs.escSequence.length;
            byte[] newEscSequence = new byte[len];
            System.arraycopy(this.escSequence, 0, newEscSequence, 0, this.escSequence.length);
            System.arraycopy(rhs.escSequence, 0, newEscSequence, this.escSequence.length, rhs.escSequence.length);
            return new ControlSequence(newEscSequence, rhs.encoding);
        }
    }
}

