/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.exceptions;

import com.sun.org.apache.xml.internal.security.utils.I18n;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class XMLSecurityException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String msgID;

    public XMLSecurityException() {
        super("Missing message string");
        this.msgID = null;
    }

    public XMLSecurityException(String msgID) {
        super(I18n.getExceptionMessage(msgID));
        this.msgID = msgID;
    }

    public XMLSecurityException(String msgID, Object[] exArgs) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs));
        this.msgID = msgID;
    }

    public XMLSecurityException(Exception originalException) {
        super("Missing message ID to locate message string in resource bundle \"com/sun/org/apache/xml/internal/security/resource/xmlsecurity\". Original Exception was a " + originalException.getClass().getName() + " and message " + originalException.getMessage(), originalException);
    }

    public XMLSecurityException(String msgID, Exception originalException) {
        super(I18n.getExceptionMessage(msgID, originalException), originalException);
        this.msgID = msgID;
    }

    public XMLSecurityException(String msgID, Object[] exArgs, Exception originalException) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs), originalException);
        this.msgID = msgID;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = super.getLocalizedMessage();
        message = message != null ? s + ": " + message : s;
        if (super.getCause() != null) {
            message = message + "\nOriginal Exception was " + super.getCause().toString();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printwriter) {
        super.printStackTrace(printwriter);
    }

    @Override
    public void printStackTrace(PrintStream printstream) {
        super.printStackTrace(printstream);
    }

    public Exception getOriginalException() {
        if (this.getCause() instanceof Exception) {
            return (Exception)this.getCause();
        }
        return null;
    }
}

