/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import sun.security.util.ResourcesMgr;

public class UnixNumericUserPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -4329764253802397821L;
    private String name;

    public UnixNumericUserPrincipal(String name) {
        if (name == null) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("invalid.null.input.value", "sun.security.util.AuthResources"));
            Object[] source = new Object[]{"name"};
            throw new NullPointerException(form.format(source));
        }
        this.name = name;
    }

    public UnixNumericUserPrincipal(long name) {
        this.name = new Long(name).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long longValue() {
        return new Long(this.name);
    }

    @Override
    public String toString() {
        MessageFormat form = new MessageFormat(ResourcesMgr.getString("UnixNumericUserPrincipal.name", "sun.security.util.AuthResources"));
        Object[] source = new Object[]{this.name};
        return form.format(source);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnixNumericUserPrincipal)) {
            return false;
        }
        UnixNumericUserPrincipal that = (UnixNumericUserPrincipal)o;
        return this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

