/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime;

import com.sun.xml.internal.bind.util.ValidationEventLocatorExImpl;
import com.sun.xml.internal.bind.v2.runtime.Messages;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.helpers.PrintConversionEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

public class RuntimeUtil {
    public static final Map<Class, Class> boxToPrimitive;
    public static final Map<Class, Class> primitiveToBox;

    public static void handlePrintConversionException(Object caller, Exception e, XMLSerializer serializer) throws SAXException {
        if (e instanceof SAXException) {
            throw (SAXException)e;
        }
        PrintConversionEventImpl ve = new PrintConversionEventImpl(1, e.getMessage(), new ValidationEventLocatorImpl(caller), e);
        serializer.reportError(ve);
    }

    public static void handleTypeMismatchError(XMLSerializer serializer, Object parentObject, String fieldName, Object childObject) throws SAXException {
        ValidationEventImpl ve = new ValidationEventImpl(1, Messages.TYPE_MISMATCH.format(RuntimeUtil.getTypeName(parentObject), fieldName, RuntimeUtil.getTypeName(childObject)), new ValidationEventLocatorExImpl(parentObject, fieldName));
        serializer.reportError(ve);
    }

    private static String getTypeName(Object o) {
        return o.getClass().getName();
    }

    static {
        HashMap<Class<Object>, Class<Void>> b = new HashMap<Class<Object>, Class<Void>>();
        b.put(Byte.TYPE, Byte.class);
        b.put(Short.TYPE, Short.class);
        b.put(Integer.TYPE, Integer.class);
        b.put(Long.TYPE, Long.class);
        b.put(Character.TYPE, Character.class);
        b.put(Boolean.TYPE, Boolean.class);
        b.put(Float.TYPE, Float.class);
        b.put(Double.TYPE, Double.class);
        b.put(Void.TYPE, Void.class);
        primitiveToBox = Collections.unmodifiableMap(b);
        HashMap p = new HashMap();
        for (Map.Entry e : b.entrySet()) {
            p.put(e.getValue(), e.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(p);
    }

    public static final class ToStringAdapter
    extends XmlAdapter<String, Object> {
        @Override
        public Object unmarshal(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String marshal(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString();
        }
    }
}

