/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jdk.net.ExtendedSocketOptions;
import sun.net.ExtendedOptionsImpl;

public class Sockets {
    private static final HashMap<Class<?>, Set<SocketOption<?>>> options = new HashMap();
    private static Method siSetOption;
    private static Method siGetOption;
    private static Method dsiSetOption;
    private static Method dsiGetOption;

    private static void initMethods() {
        try {
            Class<?> clazz = Class.forName("java.net.SocketSecrets");
            siSetOption = clazz.getDeclaredMethod("setOption", Object.class, SocketOption.class, Object.class);
            siSetOption.setAccessible(true);
            siGetOption = clazz.getDeclaredMethod("getOption", Object.class, SocketOption.class);
            siGetOption.setAccessible(true);
            dsiSetOption = clazz.getDeclaredMethod("setOption", DatagramSocket.class, SocketOption.class, Object.class);
            dsiSetOption.setAccessible(true);
            dsiGetOption = clazz.getDeclaredMethod("getOption", DatagramSocket.class, SocketOption.class);
            dsiGetOption.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private static <T> void invokeSet(Method method, Object socket, SocketOption<T> option, T value) throws IOException {
        try {
            method.invoke(null, socket, option, value);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    private static <T> T invokeGet(Method method, Object socket, SocketOption<T> option) throws IOException {
        try {
            return (T)method.invoke(null, socket, option);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    private Sockets() {
    }

    public static <T> void setOption(Socket s, SocketOption<T> name, T value) throws IOException {
        if (!Sockets.isSupported(Socket.class, name)) {
            throw new UnsupportedOperationException(name.name());
        }
        Sockets.invokeSet(siSetOption, s, name, value);
    }

    public static <T> T getOption(Socket s, SocketOption<T> name) throws IOException {
        if (!Sockets.isSupported(Socket.class, name)) {
            throw new UnsupportedOperationException(name.name());
        }
        return Sockets.invokeGet(siGetOption, s, name);
    }

    public static <T> void setOption(ServerSocket s, SocketOption<T> name, T value) throws IOException {
        if (!Sockets.isSupported(ServerSocket.class, name)) {
            throw new UnsupportedOperationException(name.name());
        }
        Sockets.invokeSet(siSetOption, s, name, value);
    }

    public static <T> T getOption(ServerSocket s, SocketOption<T> name) throws IOException {
        if (!Sockets.isSupported(ServerSocket.class, name)) {
            throw new UnsupportedOperationException(name.name());
        }
        return Sockets.invokeGet(siGetOption, s, name);
    }

    public static <T> void setOption(DatagramSocket s, SocketOption<T> name, T value) throws IOException {
        if (!Sockets.isSupported(s.getClass(), name)) {
            throw new UnsupportedOperationException(name.name());
        }
        Sockets.invokeSet(dsiSetOption, s, name, value);
    }

    public static <T> T getOption(DatagramSocket s, SocketOption<T> name) throws IOException {
        if (!Sockets.isSupported(s.getClass(), name)) {
            throw new UnsupportedOperationException(name.name());
        }
        return Sockets.invokeGet(dsiGetOption, s, name);
    }

    public static Set<SocketOption<?>> supportedOptions(Class<?> socketType) {
        Set<SocketOption<?>> set = options.get(socketType);
        if (set == null) {
            throw new IllegalArgumentException("unknown socket type");
        }
        return set;
    }

    private static boolean isSupported(Class<?> type, SocketOption<?> option) {
        Set<SocketOption<?>> options = Sockets.supportedOptions(type);
        return options.contains(option);
    }

    private static void initOptionSets() {
        boolean flowsupported = ExtendedOptionsImpl.flowSupported();
        Set<SocketOption<Boolean>> set = new HashSet<SocketOption<Object>>();
        set.add(StandardSocketOptions.SO_KEEPALIVE);
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.SO_LINGER);
        set.add(StandardSocketOptions.IP_TOS);
        set.add(StandardSocketOptions.TCP_NODELAY);
        if (flowsupported) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set = Collections.unmodifiableSet(set);
        options.put(Socket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        set = Collections.unmodifiableSet(set);
        options.put(ServerSocket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        if (flowsupported) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set = Collections.unmodifiableSet(set);
        options.put(DatagramSocket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        set.add(StandardSocketOptions.IP_MULTICAST_IF);
        set.add(StandardSocketOptions.IP_MULTICAST_TTL);
        set.add(StandardSocketOptions.IP_MULTICAST_LOOP);
        if (flowsupported) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set = Collections.unmodifiableSet(set);
        options.put(MulticastSocket.class, set);
    }

    static {
        Sockets.initOptionSets();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Sockets.initMethods();
                return null;
            }
        });
    }
}

