/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Iterator;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEvent;
import sun.awt.X11.XPropertyEvent;

final class XDropTargetEventProcessor {
    private static final XDropTargetEventProcessor theInstance = new XDropTargetEventProcessor();
    private static boolean active = false;
    private XDropTargetProtocol protocol = null;

    private XDropTargetEventProcessor() {
    }

    private boolean doProcessEvent(XEvent ev) {
        XPropertyEvent xproperty;
        if (ev.get_type() == 17 && this.protocol != null && ev.get_xany().get_window() == this.protocol.getSourceWindow()) {
            this.protocol.cleanup();
            this.protocol = null;
            return false;
        }
        if (ev.get_type() == 28 && (xproperty = ev.get_xproperty()).get_atom() == MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom()) {
            XDropTargetRegistry.getRegistry().updateEmbedderDropSite(xproperty.get_window());
        }
        if (ev.get_type() != 33) {
            return false;
        }
        boolean processed = false;
        XClientMessageEvent xclient = ev.get_xclient();
        XDropTargetProtocol curProtocol = this.protocol;
        if (this.protocol != null) {
            if (this.protocol.getMessageType(xclient) != 0) {
                processed = this.protocol.processClientMessage(xclient);
            } else {
                this.protocol = null;
            }
        }
        if (this.protocol == null) {
            Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                if (dropTargetProtocol == curProtocol || dropTargetProtocol.getMessageType(xclient) == 0) continue;
                this.protocol = dropTargetProtocol;
                processed = this.protocol.processClientMessage(xclient);
                break;
            }
        }
        return processed;
    }

    static void reset() {
        XDropTargetEventProcessor.theInstance.protocol = null;
    }

    static void activate() {
        active = true;
    }

    static boolean processEvent(XEvent ev) {
        return active ? theInstance.doProcessEvent(ev) : false;
    }
}

