/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CompositeFont;
import sun.font.CompositeGlyphMapper;
import sun.font.PhysicalFont;

public final class FontRunIterator {
    CompositeFont font;
    char[] text;
    int start;
    int limit;
    CompositeGlyphMapper mapper;
    int slot = -1;
    int pos;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;

    public void init(CompositeFont font, char[] text, int start, int limit) {
        if (font == null || text == null || start < 0 || limit < start || limit > text.length) {
            throw new IllegalArgumentException();
        }
        this.font = font;
        this.text = text;
        this.start = start;
        this.limit = limit;
        this.mapper = (CompositeGlyphMapper)font.getMapper();
        this.slot = -1;
        this.pos = start;
    }

    public PhysicalFont getFont() {
        return this.slot == -1 ? null : this.font.getSlotFont(this.slot);
    }

    public int getGlyphMask() {
        return this.slot << 24;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean next(int script, int lim) {
        if (this.pos == lim) {
            return false;
        }
        int ch = this.nextCodePoint(lim);
        int sl = this.mapper.charToGlyph(ch) & 0xFF000000;
        this.slot = sl >>> 24;
        while ((ch = this.nextCodePoint(lim)) != -1 && (this.mapper.charToGlyph(ch) & 0xFF000000) == sl) {
        }
        this.pushback(ch);
        return true;
    }

    public boolean next() {
        return this.next(0, this.limit);
    }

    final int nextCodePoint() {
        return this.nextCodePoint(this.limit);
    }

    final int nextCodePoint(int lim) {
        char nch;
        int ch;
        if (this.pos >= lim) {
            return -1;
        }
        if ((ch = this.text[this.pos++]) >= 55296 && ch < 56320 && this.pos < lim && (nch = this.text[this.pos]) >= '\udc00' && nch < '\ue000') {
            ++this.pos;
            ch = (ch << 10) + nch + -56613888;
        }
        return ch;
    }

    final void pushback(int ch) {
        if (ch >= 0) {
            this.pos = ch >= 65536 ? (this.pos -= 2) : --this.pos;
        }
    }
}

