/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.ExtendedTextLabel;
import sun.font.ExtendedTextSourceLabel;
import sun.font.StandardTextSource;
import sun.font.TextLabel;
import sun.font.TextSourceLabel;

public class TextLabelFactory {
    private FontRenderContext frc;
    private char[] text;
    private Bidi bidi;
    private Bidi lineBidi;
    private int flags;
    private int lineStart;
    private int lineLimit;

    public TextLabelFactory(FontRenderContext frc, char[] text, Bidi bidi, int flags) {
        this.frc = frc;
        this.text = text;
        this.bidi = bidi;
        this.flags = flags;
        this.lineBidi = bidi;
        this.lineStart = 0;
        this.lineLimit = text.length;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public char[] getText() {
        return this.text;
    }

    public Bidi getParagraphBidi() {
        return this.bidi;
    }

    public Bidi getLineBidi() {
        return this.lineBidi;
    }

    public int getLayoutFlags() {
        return this.flags;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public void setLineContext(int lineStart, int lineLimit) {
        this.lineStart = lineStart;
        this.lineLimit = lineLimit;
        if (this.bidi != null) {
            this.lineBidi = this.bidi.createLineBidi(lineStart, lineLimit);
        }
    }

    public ExtendedTextLabel createExtended(Font font, CoreMetrics lm, Decoration decorator, int start, int limit) {
        if (start >= limit || start < this.lineStart || limit > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + start + " or limit: " + limit);
        }
        int level = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(start - this.lineStart);
        boolean linedir = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int layoutFlags = this.flags & 0xFFFFFFF6;
        if ((level & 1) != 0) {
            layoutFlags |= 1;
        }
        if (linedir & true) {
            layoutFlags |= 8;
        }
        StandardTextSource source = new StandardTextSource(this.text, start, limit - start, this.lineStart, this.lineLimit - this.lineStart, level, layoutFlags, font, this.frc, lm);
        return new ExtendedTextSourceLabel(source, decorator);
    }

    public TextLabel createSimple(Font font, CoreMetrics lm, int start, int limit) {
        if (start >= limit || start < this.lineStart || limit > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + start + " or limit: " + limit);
        }
        int level = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(start - this.lineStart);
        boolean linedir = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int layoutFlags = this.flags & 0xFFFFFFF6;
        if ((level & 1) != 0) {
            layoutFlags |= 1;
        }
        if (linedir & true) {
            layoutFlags |= 8;
        }
        StandardTextSource source = new StandardTextSource(this.text, start, limit - start, this.lineStart, this.lineLimit - this.lineStart, level, layoutFlags, font, this.frc, lm);
        return new TextSourceLabel(source);
    }
}

