/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableByteArray;
import sun.java2d.xr.GrowablePointArray;

public class JulesPathBuf {
    static final double[] emptyDash = new double[0];
    private static final byte CAIRO_PATH_OP_MOVE_TO = 0;
    private static final byte CAIRO_PATH_OP_LINE_TO = 1;
    private static final byte CAIRO_PATH_OP_CURVE_TO = 2;
    private static final byte CAIRO_PATH_OP_CLOSE_PATH = 3;
    private static final int CAIRO_FILL_RULE_WINDING = 0;
    private static final int CAIRO_FILL_RULE_EVEN_ODD = 1;
    GrowablePointArray points = new GrowablePointArray(128);
    GrowableByteArray ops = new GrowableByteArray(1, 128);
    int[] xTrapArray = new int[512];
    private static final boolean isCairoAvailable = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            boolean loadSuccess;
            block4: {
                loadSuccess = false;
                if (X11GraphicsEnvironment.isXRenderAvailable()) {
                    try {
                        System.loadLibrary("jules");
                        loadSuccess = true;
                        if (X11GraphicsEnvironment.isXRenderVerbose()) {
                            System.out.println("Xrender: INFO: Jules library loaded");
                        }
                    }
                    catch (UnsatisfiedLinkError ex) {
                        loadSuccess = false;
                        if (!X11GraphicsEnvironment.isXRenderVerbose()) break block4;
                        System.out.println("Xrender: INFO: Jules library not installed.");
                    }
                }
            }
            return loadSuccess;
        }
    });

    public static boolean isCairoAvailable() {
        return isCairoAvailable;
    }

    public TrapezoidList tesselateFill(Shape s, AffineTransform at, Region clip) {
        int windingRule = this.convertPathData(s, at);
        this.xTrapArray[0] = 0;
        this.xTrapArray = JulesPathBuf.tesselateFillNative(this.points.getArray(), this.ops.getArray(), this.points.getSize(), this.ops.getSize(), this.xTrapArray, this.xTrapArray.length, JulesPathBuf.getCairoWindingRule(windingRule), clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY());
        return new TrapezoidList(this.xTrapArray);
    }

    public TrapezoidList tesselateStroke(Shape s, BasicStroke bs, boolean thin, boolean adjust, boolean antialias, AffineTransform at, Region clip) {
        float lw = thin ? (antialias ? 0.5f : 1.0f) : bs.getLineWidth();
        this.convertPathData(s, at);
        double[] dashArray = this.floatToDoubleArray(bs.getDashArray());
        this.xTrapArray[0] = 0;
        this.xTrapArray = JulesPathBuf.tesselateStrokeNative(this.points.getArray(), this.ops.getArray(), this.points.getSize(), this.ops.getSize(), this.xTrapArray, this.xTrapArray.length, lw, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), dashArray, dashArray.length, bs.getDashPhase(), 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY());
        return new TrapezoidList(this.xTrapArray);
    }

    protected double[] floatToDoubleArray(float[] dashArrayFloat) {
        double[] dashArrayDouble = emptyDash;
        if (dashArrayFloat != null) {
            dashArrayDouble = new double[dashArrayFloat.length];
            for (int i = 0; i < dashArrayFloat.length; ++i) {
                dashArrayDouble[i] = dashArrayFloat[i];
            }
        }
        return dashArrayDouble;
    }

    protected int convertPathData(Shape s, AffineTransform at) {
        PathIterator pi = s.getPathIterator(at);
        double[] coords = new double[6];
        double currX = 0.0;
        double currY = 0.0;
        while (!pi.isDone()) {
            int curOp = pi.currentSegment(coords);
            switch (curOp) {
                case 0: {
                    this.ops.addByte((byte)0);
                    int pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[0]));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[1]));
                    currX = coords[0];
                    currY = coords[1];
                    break;
                }
                case 1: {
                    this.ops.addByte((byte)1);
                    int pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[0]));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[1]));
                    currX = coords[0];
                    currY = coords[1];
                    break;
                }
                case 2: {
                    double x1 = coords[0];
                    double y1 = coords[1];
                    double x3 = coords[2];
                    double y3 = coords[3];
                    double x2 = x1 + (x3 - x1) / 3.0;
                    double y2 = y1 + (y3 - y1) / 3.0;
                    x1 = currX + 2.0 * (x1 - currX) / 3.0;
                    y1 = currY + 2.0 * (y1 - currY) / 3.0;
                    this.ops.addByte((byte)2);
                    int pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(x1));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(y1));
                    pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(x2));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(y2));
                    pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(x3));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(y3));
                    currX = x3;
                    currY = y3;
                    break;
                }
                case 3: {
                    this.ops.addByte((byte)2);
                    int pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[0]));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[1]));
                    pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[2]));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[3]));
                    pointIndex = this.points.getNextIndex();
                    this.points.setX(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[4]));
                    this.points.setY(pointIndex, JulesPathBuf.DoubleToCairoFixed(coords[5]));
                    currX = coords[4];
                    currY = coords[5];
                    break;
                }
                case 4: {
                    this.ops.addByte((byte)3);
                }
            }
            pi.next();
        }
        return pi.getWindingRule();
    }

    private static native int[] tesselateStrokeNative(int[] var0, byte[] var1, int var2, int var3, int[] var4, int var5, double var6, int var8, int var9, double var10, double[] var12, int var13, double var14, double var16, double var18, double var20, double var22, double var24, double var26, int var28, int var29, int var30, int var31);

    private static native int[] tesselateFillNative(int[] var0, byte[] var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void clear() {
        this.points.clear();
        this.ops.clear();
        this.xTrapArray[0] = 0;
    }

    private static int DoubleToCairoFixed(double dbl) {
        return (int)(dbl * 256.0);
    }

    private static int getCairoWindingRule(int j2dWindingRule) {
        switch (j2dWindingRule) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal Java2D winding rule specified");
    }
}

