/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAppMessage;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.KRBSafe;
import sun.security.krb5.internal.KRBSafeBody;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.SeqNumber;

class KrbSafe
extends KrbAppMessage {
    private byte[] obuf;
    private byte[] userData;

    public KrbSafe(byte[] userData, Credentials creds, EncryptionKey subKey, KerberosTime timestamp, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr) throws KrbException, IOException {
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.obuf = this.mk_safe(userData, reqKey, timestamp, seqNumber, saddr, raddr);
    }

    public KrbSafe(byte[] msg, Credentials creds, EncryptionKey subKey, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr, boolean timestampRequired, boolean seqNumberRequired) throws KrbException, IOException {
        KRBSafe krb_safe = new KRBSafe(msg);
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.userData = this.rd_safe(krb_safe, reqKey, seqNumber, saddr, raddr, timestampRequired, seqNumberRequired, creds.client);
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public byte[] getData() {
        return this.userData;
    }

    private byte[] mk_safe(byte[] userData, EncryptionKey key, KerberosTime timestamp, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, KrbCryptoException {
        Integer usec = null;
        Integer seqno = null;
        if (timestamp != null) {
            usec = new Integer(timestamp.getMicroSeconds());
        }
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
            seqNumber.step();
        }
        KRBSafeBody krb_safeBody = new KRBSafeBody(userData, timestamp, usec, seqno, sAddress, rAddress);
        byte[] temp = krb_safeBody.asn1Encode();
        Checksum cksum = new Checksum(Checksum.SAFECKSUMTYPE_DEFAULT, temp, key, 15);
        KRBSafe krb_safe = new KRBSafe(krb_safeBody, cksum);
        temp = krb_safe.asn1Encode();
        return krb_safe.asn1Encode();
    }

    private byte[] rd_safe(KRBSafe krb_safe, EncryptionKey key, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress, boolean timestampRequired, boolean seqNumberRequired, PrincipalName cname) throws Asn1Exception, KdcErrException, KrbApErrException, IOException, KrbCryptoException {
        byte[] temp = krb_safe.safeBody.asn1Encode();
        if (!krb_safe.cksum.verifyKeyedChecksum(temp, key, 15)) {
            throw new KrbApErrException(41);
        }
        this.check(krb_safe.safeBody.timestamp, krb_safe.safeBody.usec, krb_safe.safeBody.seqNumber, krb_safe.safeBody.sAddress, krb_safe.safeBody.rAddress, seqNumber, sAddress, rAddress, timestampRequired, seqNumberRequired, cname);
        return krb_safe.safeBody.userData;
    }
}

