/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.ShapeType;

public final class Polygon
implements Geometry {
    public static final Polygon EMPTY = new Polygon();
    private final LinearRing polygon;
    private final List<LinearRing> holes;
    private final boolean hasAlt;

    private Polygon() {
        this.polygon = LinearRing.EMPTY;
        this.holes = Collections.emptyList();
        this.hasAlt = false;
    }

    public Polygon(LinearRing polygon, List<LinearRing> holes) {
        this.polygon = polygon;
        this.holes = holes;
        if (holes == null) {
            throw new IllegalArgumentException("holes must not be null");
        }
        boolean hasAlt = polygon.hasAlt();
        this.checkRing(polygon);
        for (LinearRing hole : holes) {
            if (hole.hasAlt() != hasAlt) {
                throw new IllegalArgumentException("holes must have the same number of dimensions as the polygon");
            }
            this.checkRing(hole);
        }
        this.hasAlt = hasAlt;
    }

    public Polygon(LinearRing polygon) {
        this(polygon, Collections.emptyList());
    }

    @Override
    public ShapeType type() {
        return ShapeType.POLYGON;
    }

    private void checkRing(LinearRing ring) {
        if (ring.length() < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
    }

    public int getNumberOfHoles() {
        return this.holes.size();
    }

    public LinearRing getPolygon() {
        return this.polygon;
    }

    public LinearRing getHole(int i) {
        if (i >= this.holes.size()) {
            throw new IllegalArgumentException("Index " + i + " is outside the bounds of the " + this.holes.size() + " polygon holes");
        }
        return this.holes.get(i);
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.polygon.isEmpty();
    }

    @Override
    public boolean hasAlt() {
        return this.hasAlt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("polygon=").append(this.polygon);
        if (this.holes.size() > 0) {
            sb.append(", holes=");
            sb.append(this.holes);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon1 = (Polygon)o;
        return Objects.equals(this.polygon, polygon1.polygon) && Objects.equals(this.holes, polygon1.holes);
    }

    public int hashCode() {
        return Objects.hash(this.polygon, this.holes);
    }
}

