/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.URIPattern;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class URLRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(URLRepository.class);
    public static final String TYPE = "url";
    public static final Setting<List<String>> SUPPORTED_PROTOCOLS_SETTING = Setting.listSetting((String)"repositories.url.supported_protocols", Arrays.asList("http", "https", "ftp", "file", "jar"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<URIPattern>> ALLOWED_URLS_SETTING = Setting.listSetting((String)"repositories.url.allowed_urls", Collections.emptyList(), URIPattern::new, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> URL_SETTING = new Setting("url", "http:", URLRepository::parseURL, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<URL> REPOSITORIES_URL_SETTING = new Setting("repositories.url.url", s -> s.get("repositories.uri.url", "http:"), URLRepository::parseURL, new Setting.Property[]{Setting.Property.NodeScope});
    private final List<String> supportedProtocols;
    private final URIPattern[] urlWhiteList;
    private final Environment environment;
    private final BlobPath basePath;
    private final URL url;

    public URLRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
        super(metadata, environment.settings(), false, namedXContentRegistry, threadPool);
        if (!URL_SETTING.exists(metadata.settings()) && !REPOSITORIES_URL_SETTING.exists(environment.settings())) {
            throw new RepositoryException(metadata.name(), "missing url");
        }
        this.environment = environment;
        this.supportedProtocols = (List)SUPPORTED_PROTOCOLS_SETTING.get(environment.settings());
        this.urlWhiteList = ((List)ALLOWED_URLS_SETTING.get(environment.settings())).toArray(new URIPattern[0]);
        this.basePath = BlobPath.cleanPath();
        this.url = URL_SETTING.exists(metadata.settings()) ? (URL)URL_SETTING.get(metadata.settings()) : (URL)REPOSITORIES_URL_SETTING.get(environment.settings());
    }

    protected BlobStore createBlobStore() {
        URL normalizedURL = this.checkURL(this.url);
        return new URLBlobStore(this.environment.settings(), normalizedURL);
    }

    protected BlobContainer blobContainer() {
        return super.blobContainer();
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    private URL checkURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            throw new RepositoryException(this.getMetadata().name(), "unknown url protocol from URL [" + url + "]");
        }
        for (String supportedProtocol : this.supportedProtocols) {
            if (!supportedProtocol.equals(protocol)) continue;
            try {
                if (URIPattern.match((URIPattern[])this.urlWhiteList, (URI)url.toURI())) {
                    return url;
                }
            }
            catch (URISyntaxException ex) {
                logger.warn("cannot parse the specified url [{}]", (Object)url);
                throw new RepositoryException(this.getMetadata().name(), "cannot parse the specified url [" + url + "]");
            }
            URL normalizedUrl = this.environment.resolveRepoURL(url);
            if (normalizedUrl == null) {
                String logMessage = "The specified url [{}] doesn't start with any repository paths specified by the path.repo setting or by {} setting: [{}] ";
                logger.warn(logMessage, (Object)url, (Object)ALLOWED_URLS_SETTING.getKey(), (Object)this.environment.repoFiles());
                String exceptionMessage = "file url [" + url + "] doesn't match any of the locations specified by path.repo or " + ALLOWED_URLS_SETTING.getKey();
                throw new RepositoryException(this.getMetadata().name(), exceptionMessage);
            }
            return normalizedUrl;
        }
        throw new RepositoryException(this.getMetadata().name(), "unsupported url protocol [" + protocol + "] from URL [" + url + "]");
    }

    public boolean isReadOnly() {
        return true;
    }

    private static URL parseURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to parse URL repository setting", e);
        }
    }
}

