#ifndef _EFL_CANVAS_ANIMATION_ROTATE_EO_H_
#define _EFL_CANVAS_ANIMATION_ROTATE_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_ROTATE_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_ROTATE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Rotate;

#endif

#ifndef _EFL_CANVAS_ANIMATION_ROTATE_EO_TYPES
#define _EFL_CANVAS_ANIMATION_ROTATE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl rotate animation class
 *
 * @ingroup Efl_Canvas_Animation_Rotate
 */
#define EFL_CANVAS_ANIMATION_ROTATE_CLASS efl_canvas_animation_rotate_class_get()

EWAPI const Efl_Class *efl_canvas_animation_rotate_class_get(void);

/**
 * @brief Rotate property
 *
 * @param[in] obj The object.
 * @param[in] from_degree Rotation degree when animation starts
 * @param[in] to_degree Rotation degree when animation ends
 * @param[in] pivot Pivot object for the center point. If the pivot object is
 * NULL, then the object is rotated on itself.
 * @param[in] cx X relative coordinate of the center point. The left end is 0.0
 * and the right end is 1.0 (the center is 0.5).
 * @param[in] cy Y relative coordinate of the center point. The top end is 0.0
 * and the bottom end is 1.0 (the center is 0.5).
 *
 * @ingroup Efl_Canvas_Animation_Rotate
 */
EOAPI void efl_animation_rotate_set(Eo *obj, double from_degree, double to_degree, Efl_Canvas_Object *pivot, double cx, double cy);

/**
 * @brief Rotate property
 *
 * @param[in] obj The object.
 * @param[out] from_degree Rotation degree when animation starts
 * @param[out] to_degree Rotation degree when animation ends
 * @param[out] pivot Pivot object for the center point. If the pivot object is
 * NULL, then the object is rotated on itself.
 * @param[out] cx X relative coordinate of the center point. The left end is
 * 0.0 and the right end is 1.0 (the center is 0.5).
 * @param[out] cy Y relative coordinate of the center point. The top end is 0.0
 * and the bottom end is 1.0 (the center is 0.5).
 *
 * @ingroup Efl_Canvas_Animation_Rotate
 */
EOAPI void efl_animation_rotate_get(const Eo *obj, double *from_degree, double *to_degree, Efl_Canvas_Object **pivot, double *cx, double *cy);

/**
 * @brief Rotate absolute property
 *
 * @param[in] obj The object.
 * @param[in] from_degree Rotation degree when animation starts
 * @param[in] to_degree Rotation degree when animation ends
 * @param[in] cx X absolute coordinate of the center point.
 * @param[in] cy Y absolute coordinate of the center point.
 *
 * @ingroup Efl_Canvas_Animation_Rotate
 */
EOAPI void efl_animation_rotate_absolute_set(Eo *obj, double from_degree, double to_degree, int cx, int cy);

/**
 * @brief Rotate absolute property
 *
 * @param[in] obj The object.
 * @param[out] from_degree Rotation degree when animation starts
 * @param[out] to_degree Rotation degree when animation ends
 * @param[out] cx X absolute coordinate of the center point.
 * @param[out] cy Y absolute coordinate of the center point.
 *
 * @ingroup Efl_Canvas_Animation_Rotate
 */
EOAPI void efl_animation_rotate_absolute_get(const Eo *obj, double *from_degree, double *to_degree, int *cx, int *cy);
#endif /* EFL_BETA_API_SUPPORT */

#endif
