/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.jmlr;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXCls;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.StoreDataCs;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrAddr;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrEmail;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrKeywords;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrName;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrProceedings;
import com.dickimawbooks.texparserlib.latex.jmlr.ObsoleteFontCs;
import java.io.IOException;
import java.util.Vector;

public class JmlrCls
extends LaTeXCls {
    private Vector<Group> authors = null;

    public JmlrCls(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(keyValList, "jmlr", laTeXParserListener, bl);
    }

    public JmlrCls(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        this.registerControlSequence(new StoreDataCs("jmlrworkshop"));
        this.registerControlSequence(new StoreDataCs("jmlryear"));
        this.registerControlSequence(new StoreDataCs("jmlrvolume"));
        this.registerControlSequence(new StoreDataCs("jmlrissue"));
        this.registerControlSequence(new StoreDataCs("jmlrpages"));
        this.registerControlSequence(new StoreDataCs("jmlrsubmitted"));
        this.registerControlSequence(new StoreDataCs("jmlrpublished"));
        this.registerControlSequence(new StoreDataCs("jmlrauthors", "@jmlr@authors"));
        this.registerControlSequence(new StoreDataCs("editor"));
        this.registerControlSequence(new StoreDataCs("editors"));
        this.registerControlSequence(new StoreDataCs("title", "@shorttitle", "@title"));
        this.registerControlSequence(new StoreDataCs("author", "@shortauthor", "@author"));
        this.registerControlSequence(new GenericCommand("editorname", null, laTeXParserListener.createString("Editor")));
        this.registerControlSequence(new GenericCommand("editorsname", null, laTeXParserListener.createString("Editors")));
        this.registerControlSequence(new JmlrKeywords());
        this.registerControlSequence(new JmlrName(this));
        this.registerControlSequence(new JmlrEmail());
        this.registerControlSequence(new JmlrAddr());
    }

    protected void loadPreHyperrefPackages() throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        laTeXParserListener.requirepackage("xkeyval");
        laTeXParserListener.requirepackage("calc");
        laTeXParserListener.requirepackage("jmlrutils");
        laTeXParserListener.requirepackage("amssymb");
        LaTeXSty laTeXSty = laTeXParserListener.requirepackage("natbib");
        if (laTeXSty == null) {
            laTeXSty = laTeXParserListener.getLoadedPackage("natbib");
        }
        if (laTeXSty != null) {
            laTeXSty.processOption("round", null);
        }
        laTeXParserListener.requirepackage("graphicx");
        laTeXParserListener.requirepackage("url");
        KeyValList keyValList = new KeyValList();
        keyValList.put("x11names", new GenericCommand("empty"));
        laTeXParserListener.requirepackage(keyValList, "xcolor", false);
        keyValList = new KeyValList();
        keyValList.put("algo2e", new GenericCommand("empty"));
        keyValList.put("ruled", new GenericCommand("empty"));
        laTeXParserListener.requirepackage(keyValList, "algorithm2e", false);
    }

    @Override
    protected void preOptions() throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        TeXParser teXParser = laTeXParserListener.getParser();
        this.loadPreHyperrefPackages();
        ControlSequence controlSequence = teXParser.getControlSequence("jmlrprehyperref");
        if (controlSequence == null) {
            this.registerControlSequence(new GenericCommand("jmlrprehyperref"));
        } else {
            controlSequence.process(teXParser);
        }
        laTeXParserListener.requirepackage(null, "hyperref", false);
        laTeXParserListener.requirepackage(null, "nameref", false);
        this.registerControlSequence(new GenericCommand("@jmlrproceedings", null, laTeXParserListener.createString("Journal of Machine Learning Research")));
        this.registerControlSequence(new GenericCommand("@jmlrabbrvproceedings", null, laTeXParserListener.createString("JMLR")));
        this.registerControlSequence(new JmlrProceedings());
        this.registerControlSequence(new ObsoleteFontCs());
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("jmlrproceedings"));
        teXObjectList.add(laTeXParserListener.createGroup("JMLR"));
        teXObjectList.add(laTeXParserListener.createGroup("Journal of Machine Learning Research"));
        this.registerControlSequence(new GenericCommand("jmlrnowcp", null, teXObjectList));
        teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("jmlrproceedings"));
        Group group = laTeXParserListener.createGroup("JMLR ");
        group.add(new TeXCsRef("&"));
        group.add(laTeXParserListener.getLetter(67));
        group.add(laTeXParserListener.getLetter(80));
        teXObjectList.add(group);
        teXObjectList.add(laTeXParserListener.createGroup("JMLR: Workshop and Conference Proceedings"));
        this.registerControlSequence(new GenericCommand("jmlrwcp", null, teXObjectList));
        this.registerControlSequence(new AtSecondOfTwo("ifprint"));
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        if (string.equals("nowcp")) {
            laTeXParserListener.getControlSequence("jmlrnowcp").process(laTeXParserListener.getParser());
        } else if (string.equals("wcp")) {
            laTeXParserListener.getControlSequence("jmlrwcp").process(laTeXParserListener.getParser());
        } else if (string.equals("color")) {
            this.registerControlSequence(new AtSecondOfTwo("ifprint"));
        } else if (string.equals("gray")) {
            this.registerControlSequence(new AtFirstOfTwo("ifprint"));
        }
    }

    public void addAuthor(Group group) {
        if (this.authors == null) {
            this.authors = new Vector();
        }
        this.authors.add(group);
    }

    public Vector<Group> getAuthors() {
        return this.authors;
    }
}

