/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.fibs.geotag.gui.ArrowIcon;

public class ArrowButton
extends JLabel {
    ArrowIcon downArrow = new ArrowIcon(7, ArrowIcon.Orientation.DOWN);
    ArrowIcon rightArrow = new ArrowIcon(7, ArrowIcon.Orientation.RIGHT);
    boolean selected = false;
    int clickCounter = 0;
    List<ActionListener> listeners = new ArrayList<ActionListener>();

    public ArrowButton(String text) {
        super(text);
        this.setIcon(this.rightArrow);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                ++ArrowButton.this.clickCounter;
                ArrowButton.this.setSelected(!ArrowButton.this.selected);
                System.out.println(ArrowButton.this.selected);
                for (ActionListener listener : ArrowButton.this.listeners) {
                    listener.actionPerformed(new ActionEvent(ArrowButton.this, ArrowButton.this.clickCounter, "click"));
                }
            }
        });
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setIcon(selected ? this.downArrow : this.rightArrow);
    }
}

