/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.IntIntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    @NotNull
    public static Object sentinel(@NotNull String name) {
        if (name == null) {
            ObjectUtils.$$$reportNull$$$0(0);
        }
        Sentinel sentinel = new Sentinel(name);
        if (sentinel == null) {
            ObjectUtils.$$$reportNull$$$0(1);
        }
        return sentinel;
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils.notNull(t);
        if (t2 == null) {
            ObjectUtils.$$$reportNull$$$0(5);
        }
        return t2;
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        if (array == null) {
            ObjectUtils.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @NotNull
    public static <T> T notNull(@Nullable T value) {
        T t = ObjectUtils.notNull(value, value);
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(7);
        }
        return t;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            ObjectUtils.$$$reportNull$$$0(8);
        }
        T t = value == null ? defaultValue : value;
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(9);
        }
        return t;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz2) {
        if (clazz2 == null) {
            ObjectUtils.$$$reportNull$$$0(12);
        }
        if (clazz2.isInstance(obj)) {
            return clazz2.cast(obj);
        }
        return null;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntIntFunction indexComparator) {
        if (indexComparator == null) {
            ObjectUtils.$$$reportNull$$$0(17);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.fun(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ofInterface";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ObjectUtils";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sentinel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sentinel";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertAllElementsNotNull";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doIfCast";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doIfNotNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfCast";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "nullizeByCondition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sentinel {
        private final String myName;

        Sentinel(@NotNull String name) {
            if (name == null) {
                Sentinel.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ObjectUtils$Sentinel", "<init>"));
        }
    }
}

