/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J$\u0010\u001b\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u001c2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002052\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002072\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002092\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020;2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "binaryOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "operator", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "data", "isNativeInvoke", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "postfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "prefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "toDoubleConst", "", "f", "", "visitCall", "context", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "backend.js"})
public final class IrElementToJsExpressionTransformer
implements BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context) {
        Collection<JsExpression> collection;
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean $i$f$none;
        block5: {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Iterable $this$none$iv = expression2.getElements();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv22 : $this$none$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv22;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean $this$none$iv = bl;
        $i$f$none = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !$this$none$iv) {
            boolean element$iv22 = false;
            String element$iv22 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)element$iv22));
        }
        Iterable $this$map$iv = expression2.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            JsExpression jsExpression = (JsExpression)it.accept(this, context);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsArrayLiteral(list2);
    }

    @Override
    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return (JsExpression)body.getExpression().accept(this, context);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        IrFunction irFunction = expression2.getSymbol().getOwner();
        Object r = irFunction.accept(new IrFunctionToJsTransformer(), context);
        boolean bl = false;
        boolean bl2 = false;
        JsFunction $this$apply = (JsFunction)r;
        boolean bl3 = false;
        $this$apply.setName(null);
        return (JsExpression)r;
    }

    @Override
    @NotNull
    public <T> JsExpression visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext context) {
        JsLiteral.JsValueLiteral jsValueLiteral;
        IrConstKind<T> kind;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        IrConstKind<T> irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            jsValueLiteral = new JsStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsValueLiteral = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            jsValueLiteral = new JsBooleanLiteral((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Byte) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else {
            if (irConstKind instanceof IrConstKind.Long) {
                throw (Throwable)new IllegalStateException("Long const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Char) {
                throw (Throwable)new IllegalStateException("Char const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Float) {
                jsValueLiteral = new JsDoubleLiteral(this.toDoubleConst(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                jsValueLiteral = new JsDoubleLiteral(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsValueLiteral;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final double toDoubleConst(float f) {
        double d;
        float f2 = f;
        boolean bl = false;
        if (!Float.isInfinite(f2)) {
            f2 = f;
            bl = false;
            if (!Float.isNaN(f2)) {
                String string = String.valueOf(f);
                bl = false;
                d = Double.parseDouble(string);
                return d;
            }
        }
        d = f;
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context) {
        void $this$fold$iv;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable iterable = expression2.getArguments();
        JsStringLiteral initial$iv = new JsStringLiteral("");
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void irExpr;
            IrExpression irExpression = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept(this, context));
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        IrFieldSymbol symbol2 = expression2.getSymbol();
        IrField field2 = (IrField)symbol2.getOwner();
        IrDeclarationParent fieldParent = field2.getParent();
        if (fieldParent instanceof IrClass && IrUtilsKt.isEffectivelyExternal(field2)) {
            boolean bl = IrUtilsKt.isEnumClass((IrClass)fieldParent);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return new JsNameRef(AnnotationUtilsKt.getJsNameOrKotlinName(field2).getIdentifier(), (JsExpression)context.getNameForClass((IrClass)fieldParent).makeRef());
        }
        if (fieldParent instanceof IrClass && ((IrClass)fieldParent).isInline()) {
            IrExpression irExpression = expression2.getReceiver();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            return (JsExpression)irExpression.accept(this, context);
        }
        JsName fieldName = context.getNameForField(field2);
        IrExpression irExpression = expression2.getReceiver();
        return new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null);
    }

    @Override
    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsNameRef jsNameRef = context.getNameForValueDeclaration(expression2.getSymbol().getOwner()).makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getNameForValueD\u2026n.symbol.owner).makeRef()");
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$0[((IrClass)expression2.getSymbol().getOwner()).getKind().ordinal()]) {
            case 1: {
                IrClass obj = (IrClass)expression2.getSymbol().getOwner();
                if (IrUtilsKt.isEffectivelyExternal(obj)) {
                    jsExpression = context.getRefForExternalClass(obj);
                    break;
                }
                JsName className2 = context.getNameForClass((IrClass)expression2.getSymbol().getOwner());
                String getInstanceName = className2.getIdent() + "_getInstance";
                jsExpression = new JsInvocation((JsExpression)new JsNameRef(getInstanceName), new JsExpression[0]);
                break;
            }
            default: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName fieldName = context.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrExpression irExpression = expression2.getReceiver();
        JsNameRef dest = new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept(this, context);
        return JsAstUtilsKt.jsAssignment(dest, source);
    }

    @Override
    @NotNull
    public JsExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsNameRef ref = new JsNameRef(context.getNameForValueDeclaration((IrValueDeclaration)expression2.getSymbol().getOwner()));
        JsExpression value = (JsExpression)expression2.getValue().accept(this, context);
        return new JsBinaryOperation(JsBinaryOperator.ASG, ref, value);
    }

    @Override
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsNameRef jsNameRef = context.getNameForConstructor((IrConstructor)expression2.getSymbol().getOwner()).makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getNameForConstr\u2026n.symbol.owner).makeRef()");
        JsNameRef classNameRef = jsNameRef;
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)classNameRef);
        boolean fromPrimary = context.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction = context.getCurrentFunction();
            if (irFunction == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsNameRef2 = context.getNameForValueDeclaration(CollectionsKt.last(irFunction.getValueParameters())).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef2, "context.getNameForValueD\u2026ameters.last()).makeRef()");
            jsExpression = jsNameRef2;
        }
        JsExpression thisRef = jsExpression;
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context);
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.getParentAsClass(constructor2).isInline()) {
            boolean bl = constructor2.isPrimary();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Delegation to secondary inline constructors must be lowered into simple function calls";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return new JsBinaryOperation(JsBinaryOperator.ASG, thisRef, CollectionsKt.single(arguments2));
        }
        return new JsInvocation((JsExpression)callFuncRef, CollectionsKt.plus((Collection)CollectionsKt.listOf(thisRef), (Iterable)arguments2));
    }

    @Override
    @NotNull
    public JsExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
        IrConstructorSymbol symbol2 = expression2.getSymbol();
        Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> function22 = context.getStaticContext().getIntrinsics().get(symbol2);
        if (function22 != null) {
            Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> function23 = function22;
            boolean bl = false;
            boolean bl2 = false;
            Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> it = function23;
            boolean bl3 = false;
            return it.invoke(expression2, context);
        }
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context);
        IrClass klass2 = IrUtilsKt.getParentAsClass(function2);
        if (klass2.isInline()) {
            boolean bl = function2.isPrimary();
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Inline class secondary constructors must be lowered into static methods";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            jsExpression = CollectionsKt.single(arguments2);
        } else {
            JsNameRef jsNameRef;
            if (IrUtilsKt.isEffectivelyExternal(klass2)) {
                jsNameRef = context.getRefForExternalClass(klass2);
            } else {
                JsNameRef jsNameRef2 = context.getNameForClass(klass2).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef2, "context.getNameForClass(klass).makeRef()");
            }
            JsNameRef ref = jsNameRef;
            jsExpression = new JsNew(ref, arguments2);
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context) {
        JsInvocation jsInvocation;
        boolean isExternalVararg;
        int n;
        int index$iv;
        List<JsExpression> arguments2;
        JsExpression jsExtensionReceiver;
        JsExpression jsDispatchReceiver;
        IrFunction function2;
        block32: {
            block33: {
                List list2;
                JsExpression jsExpression;
                block35: {
                    block34: {
                        void target;
                        Pair<IrSimpleFunction, IrClass> pair;
                        Object property2;
                        Intrinsics.checkParameterIsNotNull(expression2, "expression");
                        Intrinsics.checkParameterIsNotNull(context, "context");
                        function2 = IrResolveUtilsKt.getRealOverrideTarget(expression2.getSymbol().getOwner());
                        IrFunctionSymbol symbol2 = function2.getSymbol();
                        Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> function22 = context.getStaticContext().getIntrinsics().get(symbol2);
                        if (function22 != null) {
                            Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> function23 = function22;
                            boolean bl = false;
                            boolean bl2 = false;
                            Function2<IrFunctionAccessExpression, JsGenerationContext, JsExpression> it = function23;
                            boolean bl3 = false;
                            return it.invoke(expression2, context);
                        }
                        IrExpression irExpression = expression2.getDispatchReceiver();
                        jsDispatchReceiver = irExpression != null ? (JsExpression)irExpression.accept(this, context) : null;
                        IrExpression irExpression2 = expression2.getExtensionReceiver();
                        jsExtensionReceiver = irExpression2 != null ? (JsExpression)irExpression2.accept(this, context) : null;
                        arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context);
                        if (function2 instanceof IrSimpleFunction && AnnotationUtilsKt.getJsName(function2) == null) {
                            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
                            Object object = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                            if (property2 != null && IrUtilsKt.isEffectivelyExternal((IrDeclaration)property2)) {
                                JsExpression jsExpression2;
                                JsNameRef nameRef = new JsNameRef(context.getNameForProperty((IrProperty)property2), jsDispatchReceiver);
                                IrFunction irFunction = function2;
                                if (Intrinsics.areEqual(irFunction, property2.getGetter())) {
                                    jsExpression2 = nameRef;
                                } else if (Intrinsics.areEqual(irFunction, property2.getSetter())) {
                                    jsExpression2 = JsAstUtilsKt.jsAssignment(nameRef, CollectionsKt.single(arguments2));
                                } else {
                                    String string = "Function must be an accessor of corresponding property";
                                    boolean bl = false;
                                    throw (Throwable)new IllegalStateException(string.toString());
                                }
                                return jsExpression2;
                            }
                        }
                        if (this.isNativeInvoke(expression2)) {
                            JsExpression jsExpression3 = jsDispatchReceiver;
                            if (jsExpression3 == null) {
                                Intrinsics.throwNpe();
                            }
                            return new JsInvocation(jsExpression3, arguments2);
                        }
                        IrClassSymbol irClassSymbol = expression2.getSuperQualifierSymbol();
                        if (irClassSymbol == null) break block33;
                        property2 = irClassSymbol;
                        boolean nameRef = false;
                        boolean bl = false;
                        Object superQualifier = property2;
                        boolean $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = false;
                        boolean bl4 = function2 instanceof IrSimpleFunction;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        bl6 = false;
                        boolean bl7 = false;
                        if (!bl4) {
                            boolean bl8 = false;
                            String string = "Failed requirement.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        if (IrUtilsKt.isInterface((IrClass)superQualifier.getOwner())) {
                            IrSimpleFunction irSimpleFunction = IrUtilsKt.resolveFakeOverride((IrSimpleFunction)function2);
                            if (irSimpleFunction == null) {
                                Intrinsics.throwNpe();
                            }
                            IrSimpleFunction impl = irSimpleFunction;
                            pair = new Pair<IrSimpleFunction, IrClass>(impl, IrUtilsKt.getParentAsClass(impl));
                        } else {
                            pair = new Pair<IrSimpleFunction, IrClass>((IrSimpleFunction)function2, (IrClass)superQualifier.getOwner());
                        }
                        Pair<IrSimpleFunction, IrClass> pair2 = pair;
                        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)pair2.component1();
                        IrClass klass2 = pair2.component2();
                        JsNameRef jsNameRef = context.getNameForClass(klass2).makeRef();
                        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getNameForClass(klass).makeRef()");
                        JsNameRef qualifierName = jsNameRef;
                        JsName targetName = context.getNameForMemberFunction((IrSimpleFunction)target);
                        JsNameRef qPrototype = new JsNameRef(targetName, (JsExpression)JsAstUtilsKt.prototypeOf(qualifierName));
                        JsNameRef callRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)qPrototype);
                        jsExpression = callRef;
                        list2 = jsDispatchReceiver;
                        if (list2 == null) break block34;
                        JsExpression jsExpression4 = list2;
                        JsExpression jsExpression5 = jsExpression;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        JsExpression receiver2 = jsExpression4;
                        boolean bl11 = false;
                        List list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf(receiver2), (Iterable)arguments2);
                        jsExpression = jsExpression5;
                        list2 = list3;
                        if (list2 != null) break block35;
                    }
                    list2 = arguments2;
                }
                List list4 = list2;
                JsExpression jsExpression6 = jsExpression;
                return new JsInvocation(jsExpression6, list4);
            }
            List<IrValueParameter> $this$indexOfFirst$iv = function2.getValueParameters();
            boolean $i$f$indexOfFirst = false;
            index$iv = 0;
            Iterator<IrValueParameter> $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = $this$indexOfFirst$iv.iterator();
            while ($i$a$-let-IrElementToJsExpressionTransformer$visitCall$32.hasNext()) {
                IrValueParameter item$iv;
                IrValueParameter it = item$iv = $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32.next();
                boolean bl12 = false;
                if (it.getVarargElementType() != null) {
                    n = index$iv;
                    break block32;
                }
                ++index$iv;
            }
            n = -1;
        }
        int varargParameterIndex = n;
        boolean bl = isExternalVararg = IrUtilsKt.isEffectivelyExternal(function2) && varargParameterIndex != -1;
        if (function2 instanceof IrConstructor) {
            JsExpression jsExpression;
            IrClass klass3 = IrUtilsKt.getParentAsClass(function2);
            if (klass3.isInline()) {
                index$iv = ((IrConstructor)function2).isPrimary() ? 1 : 0;
                boolean $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = false;
                if (_Assertions.ENABLED && index$iv == 0) {
                    boolean $i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422 = false;
                    String $i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422 = "Inline class secondary constructors must be lowered into static methods";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422));
                }
                jsExpression = CollectionsKt.single(arguments2);
            } else {
                JsNameRef jsNameRef;
                if (IrUtilsKt.isEffectivelyExternal(klass3)) {
                    jsNameRef = context.getRefForExternalClass(klass3);
                } else {
                    JsNameRef jsNameRef2 = context.getNameForClass(klass3).makeRef();
                    jsNameRef = jsNameRef2;
                    Intrinsics.checkExpressionValueIsNotNull(jsNameRef2, "context.getNameForClass(klass).makeRef()");
                }
                JsNameRef ref22 = jsNameRef;
                jsExpression = new JsNew(ref22, arguments2);
            }
            return jsExpression;
        }
        boolean klass3 = function2 instanceof IrSimpleFunction;
        boolean ref22 = false;
        boolean $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = false;
        $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = false;
        boolean $i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422 = false;
        if (!klass3) {
            boolean it = false;
            String $i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException($i$a$-assert-IrElementToJsExpressionTransformer$visitCall$422.toString());
        }
        JsExpression ref22 = jsDispatchReceiver;
        JsName symbolName = ref22 == null ? context.getNameForStaticFunction((IrSimpleFunction)function2) : context.getNameForMemberFunction((IrSimpleFunction)function2);
        JsExpression $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 = jsDispatchReceiver;
        JsExpression jsExpression = ref22 = $i$a$-let-IrElementToJsExpressionTransformer$visitCall$32 == null ? new JsNameRef(symbolName) : new JsNameRef(symbolName, jsDispatchReceiver);
        if (isExternalVararg) {
            Collection<JsExpression> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            JsNameRef arrayConcat = new JsNameRef("concat", (JsExpression)new JsArrayLiteral());
            JsNameRef arraySliceCall = new JsNameRef("call", (JsExpression)new JsNameRef("slice", (JsExpression)new JsArrayLiteral()));
            Iterable bl12 = arguments2;
            Collection collection2 = CollectionsKt.listOfNotNull(jsExtensionReceiver);
            JsExpression jsExpression7 = arrayConcat;
            boolean $i$f$mapIndexed = false;
            void qPrototype = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void argument;
                void index2;
                int n2 = index$iv$iv++;
                Collection collection3 = destination$iv$iv;
                boolean bl13 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = n2;
                JsExpression jsExpression8 = (JsExpression)item$iv$iv;
                int n4 = n3;
                collection = collection3;
                boolean bl14 = false;
                void var30_84 = index2;
                JsExpression jsExpression9 = var30_84 == varargParameterIndex ? (JsExpression)new JsInvocation((JsExpression)arraySliceCall, new JsExpression[]{argument}) : (JsExpression)new JsArrayLiteral(CollectionsKt.listOf(argument));
                collection.add(jsExpression9);
            }
            collection = (List)destination$iv$iv;
            List list5 = CollectionsKt.plus(collection2, (Iterable)collection);
            JsExpression jsExpression10 = jsExpression7;
            JsInvocation argumentsAsSingleArray = new JsInvocation(jsExpression10, list5);
            if (jsDispatchReceiver != null) {
                JsName jsName = context.getCurrentScope().declareFreshName("$externalVarargReceiverTmp");
                Intrinsics.checkExpressionValueIsNotNull(jsName, "context.currentScope.dec\u2026ternalVarargReceiverTmp\")");
                JsName receiverName = jsName;
                JsNameRef jsNameRef = receiverName.makeRef();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "receiverName.makeRef()");
                JsNameRef receiverRef = jsNameRef;
                jsInvocation = new JsInvocation((JsExpression)new JsFunction(context.getCurrentScope(), new JsBlock(new JsVars(new JsVars.JsVar(receiverName, jsDispatchReceiver)), new JsReturn(new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef(symbolName, (JsExpression)receiverRef)), CollectionsKt.listOf(receiverRef, argumentsAsSingleArray)))), "VarargIIFE"), new JsExpression[0]);
            } else {
                jsInvocation = new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef(symbolName)), CollectionsKt.listOf(new JsNullLiteral(), argumentsAsSingleArray));
            }
        } else {
            jsInvocation = new JsInvocation(ref22, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(jsExtensionReceiver), (Iterable)arguments2));
        }
        return jsInvocation;
    }

    @Override
    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object t = JsAstUtilsKt.toJsNode(expression2, this, context, visitWhen.1.INSTANCE);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return (JsExpression)t;
    }

    @Override
    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("All type operator calls except IMPLICIT_CAST should be lowered at this point");
            }
        }
        return (JsExpression)expression2.getArgument().accept(this, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return new JsNameRef(expression2.getMemberName(), (JsExpression)expression2.getReceiver().accept(this, data));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$2[expression2.getOperator().ordinal()]) {
            case 1: {
                jsExpression = this.prefixOperation(JsUnaryOperator.POS, expression2, data);
                break;
            }
            case 2: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NEG, expression2, data);
                break;
            }
            case 3: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NOT, expression2, data);
                break;
            }
            case 4: {
                jsExpression = this.prefixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 5: {
                jsExpression = this.prefixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 6: {
                jsExpression = this.postfixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 7: {
                jsExpression = this.postfixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 8: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ADD, expression2, data);
                break;
            }
            case 9: {
                jsExpression = this.binaryOperation(JsBinaryOperator.SUB, expression2, data);
                break;
            }
            case 10: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MUL, expression2, data);
                break;
            }
            case 11: {
                jsExpression = this.binaryOperation(JsBinaryOperator.DIV, expression2, data);
                break;
            }
            case 12: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MOD, expression2, data);
                break;
            }
            case 13: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GT, expression2, data);
                break;
            }
            case 14: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LT, expression2, data);
                break;
            }
            case 15: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GTE, expression2, data);
                break;
            }
            case 16: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LTE, expression2, data);
                break;
            }
            case 17: {
                jsExpression = this.binaryOperation(JsBinaryOperator.EQ, expression2, data);
                break;
            }
            case 18: {
                jsExpression = this.binaryOperation(JsBinaryOperator.NEQ, expression2, data);
                break;
            }
            case 19: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_EQ, expression2, data);
                break;
            }
            case 20: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_NEQ, expression2, data);
                break;
            }
            case 21: {
                jsExpression = this.binaryOperation(JsBinaryOperator.AND, expression2, data);
                break;
            }
            case 22: {
                jsExpression = this.binaryOperation(JsBinaryOperator.OR, expression2, data);
                break;
            }
            case 23: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG, expression2, data);
                break;
            }
            case 24: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_ADD, expression2, data);
                break;
            }
            case 25: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_SUB, expression2, data);
                break;
            }
            case 26: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MUL, expression2, data);
                break;
            }
            case 27: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_DIV, expression2, data);
                break;
            }
            case 28: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MOD, expression2, data);
                break;
            }
            case 29: {
                jsExpression = new JsArrayAccess((JsExpression)IrDynamicExpressionKt.getLeft(expression2).accept(this, data), (JsExpression)IrDynamicExpressionKt.getRight(expression2).accept(this, data));
                break;
            }
            case 30: {
                Collection<JsExpression> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = expression2.getArguments();
                JsExpression jsExpression2 = (JsExpression)expression2.getReceiver().accept(this, data);
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    JsExpression jsExpression3 = (JsExpression)it.accept(this, data);
                    collection.add(jsExpression3);
                }
                collection = (List)destination$iv$iv;
                List list2 = collection;
                JsExpression jsExpression4 = jsExpression2;
                jsExpression = new JsInvocation(jsExpression4, list2);
                break;
            }
            default: {
                String string = "Unexpected operator " + (Object)((Object)expression2.getOperator()) + ": " + RenderIrElementKt.render(expression2);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return jsExpression;
    }

    private final JsPrefixOperation prefixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPrefixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsPostfixOperation postfixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPostfixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsBinaryOperation binaryOperation(JsBinaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsBinaryOperation(operator, (JsExpression)IrDynamicExpressionKt.getLeft(expression2).accept(this, data), (JsExpression)IrDynamicExpressionKt.getRight(expression2).accept(this, data));
    }

    private final boolean isNativeInvoke(IrCall call2) {
        IrFunction irFunction = call2.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction simpleFunction = irSimpleFunction;
        IrAnnotationContainer irAnnotationContainer = simpleFunction.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            return false;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        if (simpleFunction.isSuspend()) {
            return false;
        }
        return Intrinsics.areEqual(simpleFunction.getName(), OperatorNameConventions.INVOKE) && IrTypeUtilsKt.isFunctionTypeOrSubtype((IrType)receiverType);
    }

    @Override
    @NotNull
    public JsExpression visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsExpression visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlockBody(@NotNull IrBlockBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlockBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitBody(@NotNull IrBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitCallableReference(@NotNull IrCallableReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsExpression visitClass(@NotNull IrClass declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstructor(@NotNull IrConstructor declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclaration(@NotNull IrDeclaration declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitField(@NotNull IrField declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFile(@NotNull IrFile declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunction(@NotNull IrFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitProperty(@NotNull IrProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(spread, "spread");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(aTry, "aTry");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitVariable(@NotNull IrVariable declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

