#ifndef _EFL_UI_FACTORY_EO_H_
#define _EFL_UI_FACTORY_EO_H_

#ifndef _EFL_UI_FACTORY_EO_CLASS_TYPE
#define _EFL_UI_FACTORY_EO_CLASS_TYPE

typedef Eo Efl_Ui_Factory;

#endif

#ifndef _EFL_UI_FACTORY_EO_TYPES
#define _EFL_UI_FACTORY_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** EFL Ui Factory event structure provided when an item was just created.
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Factory_Item_Created_Event
{
  Efl_Model *model; /**< The model already set on the new item. */
  Efl_Gfx_Entity *item; /**< The item that was just created. */
} Efl_Ui_Factory_Item_Created_Event;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl UI factory interface
 *
 * @ingroup Efl_Ui_Factory
 */
#define EFL_UI_FACTORY_INTERFACE efl_ui_factory_interface_get()

EWAPI const Efl_Class *efl_ui_factory_interface_get(void);

/**
 * @brief Create a UI object from the necessary properties in the specified
 * model.
 *
 * @param[in] obj The object.
 * @param[in] model Efl model
 * @param[in] parent Efl canvas
 *
 * @return Created UI object
 *
 * @ingroup Efl_Ui_Factory
 */
EOAPI Eina_Future *efl_ui_factory_create(Eo *obj, Efl_Model *model, Efl_Gfx_Entity *parent);

/**
 * @brief Release a UI object and disconnect from models.
 *
 * @param[in] obj The object.
 * @param[in] ui_view Efl canvas
 *
 * @ingroup Efl_Ui_Factory
 */
EOAPI void efl_ui_factory_release(Eo *obj, Efl_Gfx_Entity *ui_view);

EWAPI extern const Efl_Event_Description _EFL_UI_FACTORY_EVENT_CREATED;

/** Event triggered when an item has been successfully created.
 * @return Efl_Ui_Factory_Item_Created_Event
 *
 * @ingroup Efl_Ui_Factory
 */
#define EFL_UI_FACTORY_EVENT_CREATED (&(_EFL_UI_FACTORY_EVENT_CREATED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
