gap> START_TEST("cvec: builtin/addmul.tst");

#
gap> CVEC.TEST.LIMIT_ALLFFE:=32;;
gap> CVEC.TEST.LIMIT_SLICE:=32;;
gap> inf := InfoLevel(InfoWarning);;
gap> SetInfoLevel(InfoWarning,0);;  # Get rid of messages for Conway polynomials

#
gap> CVEC.TEST.ALLCHEAP("ADD2",CVEC.TEST.ADD2);
Testing ADD2 p=2, d=1 ...
Testing ADD2 p=3, d=1 ...
Testing ADD2 p=5, d=1 ...
Testing ADD2 p=7, d=1 ...
Testing ADD2 p=11, d=1 ...
Testing ADD2 p=13, d=1 ...
Testing ADD2 p=17, d=1 ...
Testing ADD2 p=19, d=1 ...
Testing ADD2 p=23, d=1 ...
Testing ADD2 p=29, d=1 ...
Testing ADD2 p=31, d=1 ...
Testing ADD2 p=2, d=2 ...
Testing ADD2 p=3, d=2 ...
Testing ADD2 p=5, d=2 ...
Testing ADD2 p=2, d=3 ...
Testing ADD2 p=3, d=3 ...
Testing ADD2 p=2, d=4 ...

#
gap> CVEC.TEST.COMPRESSED_ALL("ADD2", CVEC.TEST.ADD2_COMPRESSED);
Testing ADD2 COMPRESSED p=2, d=1 ...
Testing ADD2 COMPRESSED p=2, d=2 ...
Testing ADD2 COMPRESSED p=2, d=3 ...
Testing ADD2 COMPRESSED p=2, d=4 ...
Testing ADD2 COMPRESSED p=2, d=5 ...
Testing ADD2 COMPRESSED p=2, d=6 ...
Testing ADD2 COMPRESSED p=2, d=7 ...
Testing ADD2 COMPRESSED p=2, d=8 ...
Testing ADD2 COMPRESSED p=3, d=1 ...
Testing ADD2 COMPRESSED p=3, d=2 ...
Testing ADD2 COMPRESSED p=3, d=3 ...
Testing ADD2 COMPRESSED p=3, d=4 ...
Testing ADD2 COMPRESSED p=3, d=5 ...
Testing ADD2 COMPRESSED p=5, d=1 ...
Testing ADD2 COMPRESSED p=5, d=2 ...
Testing ADD2 COMPRESSED p=5, d=3 ...
Testing ADD2 COMPRESSED p=7, d=1 ...
Testing ADD2 COMPRESSED p=7, d=2 ...
Testing ADD2 COMPRESSED p=11, d=1 ...
Testing ADD2 COMPRESSED p=11, d=2 ...
Testing ADD2 COMPRESSED p=13, d=1 ...
Testing ADD2 COMPRESSED p=13, d=2 ...
Testing ADD2 COMPRESSED p=17, d=1 ...
Testing ADD2 COMPRESSED p=19, d=1 ...
Testing ADD2 COMPRESSED p=23, d=1 ...
Testing ADD2 COMPRESSED p=29, d=1 ...
Testing ADD2 COMPRESSED p=31, d=1 ...
Testing ADD2 COMPRESSED p=37, d=1 ...
Testing ADD2 COMPRESSED p=41, d=1 ...
Testing ADD2 COMPRESSED p=43, d=1 ...
Testing ADD2 COMPRESSED p=47, d=1 ...
Testing ADD2 COMPRESSED p=53, d=1 ...
Testing ADD2 COMPRESSED p=59, d=1 ...
Testing ADD2 COMPRESSED p=61, d=1 ...
Testing ADD2 COMPRESSED p=67, d=1 ...
Testing ADD2 COMPRESSED p=71, d=1 ...
Testing ADD2 COMPRESSED p=73, d=1 ...
Testing ADD2 COMPRESSED p=79, d=1 ...
Testing ADD2 COMPRESSED p=83, d=1 ...
Testing ADD2 COMPRESSED p=89, d=1 ...
Testing ADD2 COMPRESSED p=97, d=1 ...
Testing ADD2 COMPRESSED p=101, d=1 ...
Testing ADD2 COMPRESSED p=103, d=1 ...
Testing ADD2 COMPRESSED p=107, d=1 ...
Testing ADD2 COMPRESSED p=109, d=1 ...
Testing ADD2 COMPRESSED p=113, d=1 ...
Testing ADD2 COMPRESSED p=127, d=1 ...
Testing ADD2 COMPRESSED p=131, d=1 ...
Testing ADD2 COMPRESSED p=137, d=1 ...
Testing ADD2 COMPRESSED p=139, d=1 ...
Testing ADD2 COMPRESSED p=149, d=1 ...
Testing ADD2 COMPRESSED p=151, d=1 ...
Testing ADD2 COMPRESSED p=157, d=1 ...
Testing ADD2 COMPRESSED p=163, d=1 ...
Testing ADD2 COMPRESSED p=167, d=1 ...
Testing ADD2 COMPRESSED p=173, d=1 ...
Testing ADD2 COMPRESSED p=179, d=1 ...
Testing ADD2 COMPRESSED p=181, d=1 ...
Testing ADD2 COMPRESSED p=191, d=1 ...
Testing ADD2 COMPRESSED p=193, d=1 ...
Testing ADD2 COMPRESSED p=197, d=1 ...
Testing ADD2 COMPRESSED p=199, d=1 ...
Testing ADD2 COMPRESSED p=211, d=1 ...
Testing ADD2 COMPRESSED p=223, d=1 ...
Testing ADD2 COMPRESSED p=227, d=1 ...
Testing ADD2 COMPRESSED p=229, d=1 ...
Testing ADD2 COMPRESSED p=233, d=1 ...
Testing ADD2 COMPRESSED p=239, d=1 ...
Testing ADD2 COMPRESSED p=241, d=1 ...
Testing ADD2 COMPRESSED p=251, d=1 ...

#
gap> CVEC.TEST.ALLCHEAP("ADD3",CVEC.TEST.ADD3);
Testing ADD3 p=2, d=1 ...
Testing ADD3 p=3, d=1 ...
Testing ADD3 p=5, d=1 ...
Testing ADD3 p=7, d=1 ...
Testing ADD3 p=11, d=1 ...
Testing ADD3 p=13, d=1 ...
Testing ADD3 p=17, d=1 ...
Testing ADD3 p=19, d=1 ...
Testing ADD3 p=23, d=1 ...
Testing ADD3 p=29, d=1 ...
Testing ADD3 p=31, d=1 ...
Testing ADD3 p=2, d=2 ...
Testing ADD3 p=3, d=2 ...
Testing ADD3 p=5, d=2 ...
Testing ADD3 p=2, d=3 ...
Testing ADD3 p=3, d=3 ...
Testing ADD3 p=2, d=4 ...

#
gap> CVEC.TEST.COMPRESSED_ALL("ADD3", CVEC.TEST.ADD3_COMPRESSED);
Testing ADD3 COMPRESSED p=2, d=1 ...
Testing ADD3 COMPRESSED p=2, d=2 ...
Testing ADD3 COMPRESSED p=2, d=3 ...
Testing ADD3 COMPRESSED p=2, d=4 ...
Testing ADD3 COMPRESSED p=2, d=5 ...
Testing ADD3 COMPRESSED p=2, d=6 ...
Testing ADD3 COMPRESSED p=2, d=7 ...
Testing ADD3 COMPRESSED p=2, d=8 ...
Testing ADD3 COMPRESSED p=3, d=1 ...
Testing ADD3 COMPRESSED p=3, d=2 ...
Testing ADD3 COMPRESSED p=3, d=3 ...
Testing ADD3 COMPRESSED p=3, d=4 ...
Testing ADD3 COMPRESSED p=3, d=5 ...
Testing ADD3 COMPRESSED p=5, d=1 ...
Testing ADD3 COMPRESSED p=5, d=2 ...
Testing ADD3 COMPRESSED p=5, d=3 ...
Testing ADD3 COMPRESSED p=7, d=1 ...
Testing ADD3 COMPRESSED p=7, d=2 ...
Testing ADD3 COMPRESSED p=11, d=1 ...
Testing ADD3 COMPRESSED p=11, d=2 ...
Testing ADD3 COMPRESSED p=13, d=1 ...
Testing ADD3 COMPRESSED p=13, d=2 ...
Testing ADD3 COMPRESSED p=17, d=1 ...
Testing ADD3 COMPRESSED p=19, d=1 ...
Testing ADD3 COMPRESSED p=23, d=1 ...
Testing ADD3 COMPRESSED p=29, d=1 ...
Testing ADD3 COMPRESSED p=31, d=1 ...
Testing ADD3 COMPRESSED p=37, d=1 ...
Testing ADD3 COMPRESSED p=41, d=1 ...
Testing ADD3 COMPRESSED p=43, d=1 ...
Testing ADD3 COMPRESSED p=47, d=1 ...
Testing ADD3 COMPRESSED p=53, d=1 ...
Testing ADD3 COMPRESSED p=59, d=1 ...
Testing ADD3 COMPRESSED p=61, d=1 ...
Testing ADD3 COMPRESSED p=67, d=1 ...
Testing ADD3 COMPRESSED p=71, d=1 ...
Testing ADD3 COMPRESSED p=73, d=1 ...
Testing ADD3 COMPRESSED p=79, d=1 ...
Testing ADD3 COMPRESSED p=83, d=1 ...
Testing ADD3 COMPRESSED p=89, d=1 ...
Testing ADD3 COMPRESSED p=97, d=1 ...
Testing ADD3 COMPRESSED p=101, d=1 ...
Testing ADD3 COMPRESSED p=103, d=1 ...
Testing ADD3 COMPRESSED p=107, d=1 ...
Testing ADD3 COMPRESSED p=109, d=1 ...
Testing ADD3 COMPRESSED p=113, d=1 ...
Testing ADD3 COMPRESSED p=127, d=1 ...
Testing ADD3 COMPRESSED p=131, d=1 ...
Testing ADD3 COMPRESSED p=137, d=1 ...
Testing ADD3 COMPRESSED p=139, d=1 ...
Testing ADD3 COMPRESSED p=149, d=1 ...
Testing ADD3 COMPRESSED p=151, d=1 ...
Testing ADD3 COMPRESSED p=157, d=1 ...
Testing ADD3 COMPRESSED p=163, d=1 ...
Testing ADD3 COMPRESSED p=167, d=1 ...
Testing ADD3 COMPRESSED p=173, d=1 ...
Testing ADD3 COMPRESSED p=179, d=1 ...
Testing ADD3 COMPRESSED p=181, d=1 ...
Testing ADD3 COMPRESSED p=191, d=1 ...
Testing ADD3 COMPRESSED p=193, d=1 ...
Testing ADD3 COMPRESSED p=197, d=1 ...
Testing ADD3 COMPRESSED p=199, d=1 ...
Testing ADD3 COMPRESSED p=211, d=1 ...
Testing ADD3 COMPRESSED p=223, d=1 ...
Testing ADD3 COMPRESSED p=227, d=1 ...
Testing ADD3 COMPRESSED p=229, d=1 ...
Testing ADD3 COMPRESSED p=233, d=1 ...
Testing ADD3 COMPRESSED p=239, d=1 ...
Testing ADD3 COMPRESSED p=241, d=1 ...
Testing ADD3 COMPRESSED p=251, d=1 ...

#
gap> CVEC.TEST.ALLCHEAP("MUL1",CVEC.TEST.MUL1);
Testing MUL1 p=2, d=1 ...
Testing MUL1 p=3, d=1 ...
Testing MUL1 p=5, d=1 ...
Testing MUL1 p=7, d=1 ...
Testing MUL1 p=11, d=1 ...
Testing MUL1 p=13, d=1 ...
Testing MUL1 p=17, d=1 ...
Testing MUL1 p=19, d=1 ...
Testing MUL1 p=23, d=1 ...
Testing MUL1 p=29, d=1 ...
Testing MUL1 p=31, d=1 ...
Testing MUL1 p=2, d=2 ...
Testing MUL1 p=3, d=2 ...
Testing MUL1 p=5, d=2 ...
Testing MUL1 p=2, d=3 ...
Testing MUL1 p=3, d=3 ...
Testing MUL1 p=2, d=4 ...

#
gap> CVEC.TEST.COMPRESSED_ALL("MUL1", CVEC.TEST.MUL1_COMPRESSED);
Testing MUL1 COMPRESSED p=2, d=1 ...
Testing MUL1 COMPRESSED p=2, d=2 ...
Testing MUL1 COMPRESSED p=2, d=3 ...
Testing MUL1 COMPRESSED p=2, d=4 ...
Testing MUL1 COMPRESSED p=2, d=5 ...
Testing MUL1 COMPRESSED p=2, d=6 ...
Testing MUL1 COMPRESSED p=2, d=7 ...
Testing MUL1 COMPRESSED p=2, d=8 ...
Testing MUL1 COMPRESSED p=3, d=1 ...
Testing MUL1 COMPRESSED p=3, d=2 ...
Testing MUL1 COMPRESSED p=3, d=3 ...
Testing MUL1 COMPRESSED p=3, d=4 ...
Testing MUL1 COMPRESSED p=3, d=5 ...
Testing MUL1 COMPRESSED p=5, d=1 ...
Testing MUL1 COMPRESSED p=5, d=2 ...
Testing MUL1 COMPRESSED p=5, d=3 ...
Testing MUL1 COMPRESSED p=7, d=1 ...
Testing MUL1 COMPRESSED p=7, d=2 ...
Testing MUL1 COMPRESSED p=11, d=1 ...
Testing MUL1 COMPRESSED p=11, d=2 ...
Testing MUL1 COMPRESSED p=13, d=1 ...
Testing MUL1 COMPRESSED p=13, d=2 ...
Testing MUL1 COMPRESSED p=17, d=1 ...
Testing MUL1 COMPRESSED p=19, d=1 ...
Testing MUL1 COMPRESSED p=23, d=1 ...
Testing MUL1 COMPRESSED p=29, d=1 ...
Testing MUL1 COMPRESSED p=31, d=1 ...
Testing MUL1 COMPRESSED p=37, d=1 ...
Testing MUL1 COMPRESSED p=41, d=1 ...
Testing MUL1 COMPRESSED p=43, d=1 ...
Testing MUL1 COMPRESSED p=47, d=1 ...
Testing MUL1 COMPRESSED p=53, d=1 ...
Testing MUL1 COMPRESSED p=59, d=1 ...
Testing MUL1 COMPRESSED p=61, d=1 ...
Testing MUL1 COMPRESSED p=67, d=1 ...
Testing MUL1 COMPRESSED p=71, d=1 ...
Testing MUL1 COMPRESSED p=73, d=1 ...
Testing MUL1 COMPRESSED p=79, d=1 ...
Testing MUL1 COMPRESSED p=83, d=1 ...
Testing MUL1 COMPRESSED p=89, d=1 ...
Testing MUL1 COMPRESSED p=97, d=1 ...
Testing MUL1 COMPRESSED p=101, d=1 ...
Testing MUL1 COMPRESSED p=103, d=1 ...
Testing MUL1 COMPRESSED p=107, d=1 ...
Testing MUL1 COMPRESSED p=109, d=1 ...
Testing MUL1 COMPRESSED p=113, d=1 ...
Testing MUL1 COMPRESSED p=127, d=1 ...
Testing MUL1 COMPRESSED p=131, d=1 ...
Testing MUL1 COMPRESSED p=137, d=1 ...
Testing MUL1 COMPRESSED p=139, d=1 ...
Testing MUL1 COMPRESSED p=149, d=1 ...
Testing MUL1 COMPRESSED p=151, d=1 ...
Testing MUL1 COMPRESSED p=157, d=1 ...
Testing MUL1 COMPRESSED p=163, d=1 ...
Testing MUL1 COMPRESSED p=167, d=1 ...
Testing MUL1 COMPRESSED p=173, d=1 ...
Testing MUL1 COMPRESSED p=179, d=1 ...
Testing MUL1 COMPRESSED p=181, d=1 ...
Testing MUL1 COMPRESSED p=191, d=1 ...
Testing MUL1 COMPRESSED p=193, d=1 ...
Testing MUL1 COMPRESSED p=197, d=1 ...
Testing MUL1 COMPRESSED p=199, d=1 ...
Testing MUL1 COMPRESSED p=211, d=1 ...
Testing MUL1 COMPRESSED p=223, d=1 ...
Testing MUL1 COMPRESSED p=227, d=1 ...
Testing MUL1 COMPRESSED p=229, d=1 ...
Testing MUL1 COMPRESSED p=233, d=1 ...
Testing MUL1 COMPRESSED p=239, d=1 ...
Testing MUL1 COMPRESSED p=241, d=1 ...
Testing MUL1 COMPRESSED p=251, d=1 ...

#
gap> CVEC.TEST.ALLCHEAP("MUL2",CVEC.TEST.MUL2);
Testing MUL2 p=2, d=1 ...
Testing MUL2 p=3, d=1 ...
Testing MUL2 p=5, d=1 ...
Testing MUL2 p=7, d=1 ...
Testing MUL2 p=11, d=1 ...
Testing MUL2 p=13, d=1 ...
Testing MUL2 p=17, d=1 ...
Testing MUL2 p=19, d=1 ...
Testing MUL2 p=23, d=1 ...
Testing MUL2 p=29, d=1 ...
Testing MUL2 p=31, d=1 ...
Testing MUL2 p=2, d=2 ...
Testing MUL2 p=3, d=2 ...
Testing MUL2 p=5, d=2 ...
Testing MUL2 p=2, d=3 ...
Testing MUL2 p=3, d=3 ...
Testing MUL2 p=2, d=4 ...

#
gap> CVEC.TEST.COMPRESSED_ALL("MUL2", CVEC.TEST.MUL2_COMPRESSED);
Testing MUL2 COMPRESSED p=2, d=1 ...
Testing MUL2 COMPRESSED p=2, d=2 ...
Testing MUL2 COMPRESSED p=2, d=3 ...
Testing MUL2 COMPRESSED p=2, d=4 ...
Testing MUL2 COMPRESSED p=2, d=5 ...
Testing MUL2 COMPRESSED p=2, d=6 ...
Testing MUL2 COMPRESSED p=2, d=7 ...
Testing MUL2 COMPRESSED p=2, d=8 ...
Testing MUL2 COMPRESSED p=3, d=1 ...
Testing MUL2 COMPRESSED p=3, d=2 ...
Testing MUL2 COMPRESSED p=3, d=3 ...
Testing MUL2 COMPRESSED p=3, d=4 ...
Testing MUL2 COMPRESSED p=3, d=5 ...
Testing MUL2 COMPRESSED p=5, d=1 ...
Testing MUL2 COMPRESSED p=5, d=2 ...
Testing MUL2 COMPRESSED p=5, d=3 ...
Testing MUL2 COMPRESSED p=7, d=1 ...
Testing MUL2 COMPRESSED p=7, d=2 ...
Testing MUL2 COMPRESSED p=11, d=1 ...
Testing MUL2 COMPRESSED p=11, d=2 ...
Testing MUL2 COMPRESSED p=13, d=1 ...
Testing MUL2 COMPRESSED p=13, d=2 ...
Testing MUL2 COMPRESSED p=17, d=1 ...
Testing MUL2 COMPRESSED p=19, d=1 ...
Testing MUL2 COMPRESSED p=23, d=1 ...
Testing MUL2 COMPRESSED p=29, d=1 ...
Testing MUL2 COMPRESSED p=31, d=1 ...
Testing MUL2 COMPRESSED p=37, d=1 ...
Testing MUL2 COMPRESSED p=41, d=1 ...
Testing MUL2 COMPRESSED p=43, d=1 ...
Testing MUL2 COMPRESSED p=47, d=1 ...
Testing MUL2 COMPRESSED p=53, d=1 ...
Testing MUL2 COMPRESSED p=59, d=1 ...
Testing MUL2 COMPRESSED p=61, d=1 ...
Testing MUL2 COMPRESSED p=67, d=1 ...
Testing MUL2 COMPRESSED p=71, d=1 ...
Testing MUL2 COMPRESSED p=73, d=1 ...
Testing MUL2 COMPRESSED p=79, d=1 ...
Testing MUL2 COMPRESSED p=83, d=1 ...
Testing MUL2 COMPRESSED p=89, d=1 ...
Testing MUL2 COMPRESSED p=97, d=1 ...
Testing MUL2 COMPRESSED p=101, d=1 ...
Testing MUL2 COMPRESSED p=103, d=1 ...
Testing MUL2 COMPRESSED p=107, d=1 ...
Testing MUL2 COMPRESSED p=109, d=1 ...
Testing MUL2 COMPRESSED p=113, d=1 ...
Testing MUL2 COMPRESSED p=127, d=1 ...
Testing MUL2 COMPRESSED p=131, d=1 ...
Testing MUL2 COMPRESSED p=137, d=1 ...
Testing MUL2 COMPRESSED p=139, d=1 ...
Testing MUL2 COMPRESSED p=149, d=1 ...
Testing MUL2 COMPRESSED p=151, d=1 ...
Testing MUL2 COMPRESSED p=157, d=1 ...
Testing MUL2 COMPRESSED p=163, d=1 ...
Testing MUL2 COMPRESSED p=167, d=1 ...
Testing MUL2 COMPRESSED p=173, d=1 ...
Testing MUL2 COMPRESSED p=179, d=1 ...
Testing MUL2 COMPRESSED p=181, d=1 ...
Testing MUL2 COMPRESSED p=191, d=1 ...
Testing MUL2 COMPRESSED p=193, d=1 ...
Testing MUL2 COMPRESSED p=197, d=1 ...
Testing MUL2 COMPRESSED p=199, d=1 ...
Testing MUL2 COMPRESSED p=211, d=1 ...
Testing MUL2 COMPRESSED p=223, d=1 ...
Testing MUL2 COMPRESSED p=227, d=1 ...
Testing MUL2 COMPRESSED p=229, d=1 ...
Testing MUL2 COMPRESSED p=233, d=1 ...
Testing MUL2 COMPRESSED p=239, d=1 ...
Testing MUL2 COMPRESSED p=241, d=1 ...
Testing MUL2 COMPRESSED p=251, d=1 ...

#
gap> CVEC.TEST.ALLCHEAP("ADDMUL",CVEC.TEST.ADDMUL);
Testing ADDMUL p=2, d=1 ...
Testing ADDMUL p=3, d=1 ...
Testing ADDMUL p=5, d=1 ...
Testing ADDMUL p=7, d=1 ...
Testing ADDMUL p=11, d=1 ...
Testing ADDMUL p=13, d=1 ...
Testing ADDMUL p=17, d=1 ...
Testing ADDMUL p=19, d=1 ...
Testing ADDMUL p=23, d=1 ...
Testing ADDMUL p=29, d=1 ...
Testing ADDMUL p=31, d=1 ...
Testing ADDMUL p=2, d=2 ...
Testing ADDMUL p=3, d=2 ...
Testing ADDMUL p=5, d=2 ...
Testing ADDMUL p=2, d=3 ...
Testing ADDMUL p=3, d=3 ...
Testing ADDMUL p=2, d=4 ...

#
gap> SetInfoLevel(InfoWarning,inf);
gap> STOP_TEST("cvec: builtin/addmul.tst", 1);
