/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"matrix.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: kron_mat.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ matrix_TYP *kron_mat(A,B)
@ matrix_TYP *A, *B;
@
@ calculates the Kronecker product of the matrices A and B.
@---------------------------------------------------------------------------
@
\**************************************************************************/

matrix_TYP *kron_mat(A,B)
matrix_TYP *A, *B;
{

  int i,j,k,l,r,c;
  int rows, cols;
  matrix_TYP *C;

  rows = A->rows *B->rows;
  cols = A->cols *B->cols;
  C = init_mat(rows,cols, "");
  for(i=0; i<A->rows;i++)
    for(j=0;j<A->cols;j++)
    {
       /* changed 15/4/97 tilman
       r = i*A->rows; */
       r = i*B->rows;
       for(k=0;k<B->rows;k++)
       {
        /* changed 15/4/97 tilman
        c = j*A->cols; */
        c = j*B->cols;
        for(l=0;l<B->cols;l++)
        {
          C->array.SZ[r][c] = A->array.SZ[i][j] * B->array.SZ[k][l];
          c++;
        }
        r++;
       }
    }
  return(C);
}
