PK    -NaT9      	  ChangeLogUT	 ;\;\ux     M
0@9ŀ;!qZ\h)E{h1fJ~xz^[<J,PEc8XoRG`!V
*3<Q\6Q	Q"%$=ێt=3x'r SC{Cq7?PK
     -N᥀g@ @   Seaside-Development-Core.stUT	 ;\;\ux     WADispatcher extend [

    configurationComponent [
	<category: '*seaside-development-core'>
	^WADispatcherEditor on: self
    ]

]



WAEntryPoint extend [

    configurationComponent [
	<category: '*seaside-development-core'>
	^WAConfigurationEditor on: self
    ]

]



WALabelledFormDialog subclass: WAViewer [
    | presenter |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WAViewer class >> on: aPresenter [
	<category: 'instance creation'>
	^self new presenter: aPresenter
    ]

    buttons [
	<category: 'accessing'>
	^#(#save)
    ]

    compile: aString [
	<category: 'actions'>
	SeasidePlatformSupport 
	    compile: aString
	    into: presenter class
	    classified: #rendering
    ]

    model [
	<category: 'accessing'>
	^presenter
    ]

    presenter: aPresenter [
	<category: 'accessing'>
	presenter := aPresenter
    ]

    renderContentOn: html [
	<category: 'rendering'>
	(html heading)
	    level3;
	    with: presenter seasideString.
	super renderContentOn: html
    ]

    renderCssOn: html [
	<category: 'rendering'>
	(html textArea)
	    rows: 20;
	    columns: 80;
	    value: presenter style;
	    callback: [:css | self compile: 'style ^ ' , css printString]
    ]

    rows [
	<category: 'accessing'>
	^#(#css)
    ]

    save [
	<category: 'actions'>
	
    ]

    script [
	<category: 'accessing'>
	^'self.opener.location=self.opener.location'
    ]
]



WAErrorHandler subclass: WADebugErrorHandler [
    
    <comment: 'I am like WAErrorHandler except that I open a debugger in the image for errors and warnings (not for internal errors).'>
    <category: 'Seaside-Development-Core'>

    handleError: anError [
	<category: 'actions'>
	SeasidePlatformSupport openDebuggerOn: anError
    ]
]



WADebugErrorHandler subclass: WAWalkbackErrorHandler [
    
    <comment: 'I am the default development error handler that displays the stack frames and adds the option to display a debugger.

I delegate the rendering to WAWalkback.'>
    <category: 'Seaside-Development-Core'>

    handleError: anError [
	<category: 'actions'>
	self open: anError.
	anError isResumable ifTrue: [anError resume]
    ]

    open: anException [
	<category: 'private'>
	| answer |
	answer := WARenderLoop new call: (WAWalkback exception: anException).
	answer ifTrue: [SeasidePlatformSupport openDebuggerOn: anException]
    ]
]



WADecoration subclass: WAToolDecoration [
    | plugins showHalos processTime renderTime deprecated |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    clearDeprecated [
	<category: 'plugin-deprecation'>
	deprecated := Set new
    ]

    deprecated [
	<category: 'plugin-deprecation'>
	^deprecated
    ]

    initialize [
	<category: 'initialization'>
	super initialize.
	self clearDeprecated.
	showHalos := WAValueHolder with: false
    ]

    isGlobal [
	<category: 'testing'>
	^true
    ]

    plugins [
	<category: 'accessing'>
	^plugins 
	    ifNil: [plugins := WAToolPlugin allSubclassesOn: self owner for: self]
    ]

    processCallbackStream: aCallbackStream [
	<category: 'processing'>
	processTime := Time millisecondClockValue.
	self 
	    withDeprecatedHandlerDo: [super processCallbackStream: aCallbackStream]
    ]

    processTime [
	<category: 'plugin-timeing'>
	^processTime
    ]

    renderChildOn: html [
	<category: 'rendering'>
	self showHalos ifTrue: [html context debugMode].
	processTime := processTime isNil 
		    ifTrue: [0]
		    ifFalse: [Time millisecondClockValue - processTime].
	renderTime := Time 
		    millisecondsToRun: [self withDeprecatedHandlerDo: [self renderOwnerOn: html]].
	html context clearMode
    ]

    renderContentOn: html [
	<category: 'rendering'>
	self renderChildOn: html.
	self renderToolbarOn: html
    ]

    renderTime [
	<category: 'plugin-timeing'>
	^renderTime
    ]

    renderToolbarOn: html [
	<category: 'rendering'>
	(html div)
	    id: 'toolbar';
	    with: 
		    [self plugins do: [:each | html render: each] separatedBy: [html text: ' ']].
	processTime := nil
    ]

    showHalos [
	<category: 'accessing'>
	^showHalos contents
    ]

    states [
	<category: 'accessing'>
	^Array with: showHalos
    ]

    toggleHalos [
	<category: 'plugin-halos'>
	WAHalo initializeClass.
	showHalos contents: showHalos contents not
    ]

    withDeprecatedHandlerDo: aBlock [
	<category: 'plugin-deprecation'>
	^aBlock on: WADeprecatedApi
	    do: 
		[:notification | 
		deprecated add: notification messageText.
		notification resume]
    ]
]



WAHtmlDocument subclass: WAPrettyPrintedDocument [
    | html indentLevel indentCloseTags firstLine |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WAPrettyPrintedDocument class >> renderer: aRenderer [
	<category: 'instance-creation'>
	^self basicNew initializeWithRenderer: aRenderer
    ]

    attribute: aKey with: aValue [
	<category: 'writing-xhtml'>
	aValue == false ifTrue: [^self].
	html space.
	(html span)
	    class: (self cssClassForAttribute: aKey);
	    with: aKey.
	html text: '='.
	(html span)
	    class: 'attribute-value';
	    with: 
		    [html text: '"'.
		    (self knownRefs includes: aKey) 
			ifTrue: 
			    [(html anchor)
				url: aValue seasideString;
				with: aValue]
			ifFalse: 
			    [(self knownEvents includes: aKey) 
				ifTrue: 
				    [(html anchor)
					onClick: aValue;
					with: aValue]
				ifFalse: 
				    [aValue == true ifTrue: [html text: aKey] ifFalse: [html render: aValue]]].
		    html text: '"']
    ]

    attributes: anAttributes [
	<category: 'writing-xhtml'>
	anAttributes ifNil: [^self].
	anAttributes 
	    keysAndValuesDo: [:key :value | self attribute: key with: value]
    ]

    closeTag: aString [
	<category: 'writing-xhtml'>
	indentLevel := indentLevel - 1.
	indentCloseTags removeLast ifTrue: [self indent].
	html text: '</'.
	(html span)
	    class: (self cssClassFor: aString);
	    with: aString.
	html text: '>'
    ]

    cssClassFor: aString [
	<category: 'private'>
	^(self knownTags includes: aString) 
	    ifTrue: ['tag-known']
	    ifFalse: ['tag-unknown']
    ]

    cssClassForAttribute: aString [
	<category: 'private'>
	^(self knownAttributes includes: aString) 
	    ifTrue: ['attribute-known']
	    ifFalse: ['attribute-unknown']
    ]

    document [
	<category: 'accessing'>
	^html document
    ]

    htmlEncoder [
	<category: 'accessing'>
	^self document htmlEncoder
    ]

    indent [
	<category: 'private'>
	firstLine ifTrue: [firstLine := false] ifFalse: [html break].
	indentLevel timesRepeat: [html space: 2]
    ]

    initializeWithRenderer: aRenderer [
	<category: 'initialization'>
	html := aRenderer.
	indentCloseTags := OrderedCollection with: false.
	indentLevel := 0.
	firstLine := true
    ]

    knownAttributes [
	<category: 'configuration'>
	^#('abbr' 'accept' 'accept' 'accesskey' 'action' 'align' 'alink' 'alt' 'archive' 'axis' 'background' 'bgcolor' 'bgproperties' 'border' 'cellpadding' 'cellspacing' 'char' 'charoff' 'charset' 'charset' 'checked' 'cite' 'class' 'classid' 'clear' 'code' 'codebase' 'codetype' 'color' 'cols' 'colspan' 'compact' 'content' 'coords' 'data' 'datetime' 'declare' 'defer' 'dir' 'direction' 'disabled' 'encoding' 'enctype' 'equiv' 'face' 'for' 'frame' 'frameborder' 'framespacing' 'gutter' 'headers' 'height' 'href' 'hreflang' 'hspace' 'http' 'id' 'ismap' 'label' 'lang' 'leftmargin' 'link' 'longdesc' 'loop' 'lowsrc' 'marginheight' 'marginwidth' 'maxlength' 'media' 'method' 'methods' 'multiple' 'name' 'nohref' 'noresize' 'noshade' 'nowrap' 'object' 'onabort' 'onblur' 'onchange' 'onclick' 'ondblclick' 'onerror' 'onfocus' 'onkeydown' 'onkeypress' 'onkeyup' 'onload' 'onmousedown' 'onmousemove' 'onmouseout' 'onmouseover' 'onmouseup' 'onreset' 'onselect' 'onsubmit' 'onunload' 'prompt' 'readonly' 'rel' 'rev' 'rows' 'rowspan' 'rules' 'scheme' 'scope' 'scrolling' 'selected' 'shape' 'size' 'span' 'src' 'standby' 'style' 'summary' 'tabindex' 'target' 'text' 'title' 'type' 'urn' 'usemap' 'valign' 'value' 'valuetype' 'version' 'vlink' 'vspace' 'width' 'wrap' 'xml:lang' 'xmlns')
    ]

    knownEvents [
	<category: 'configuration'>
	^#('onabort' 'onblur' 'onchange' 'onclick' 'ondblclick' 'onerror' 'onfocus' 'onkeydown' 'onkeypress' 'onkeyup' 'onload' 'onmousedown' 'onmousemove' 'onmouseout' 'onmouseover' 'onmouseup' 'onreset' 'onselect' 'onsubmit' 'onunload')
    ]

    knownRefs [
	<category: 'configuration'>
	^#('action' 'cite' 'classid' 'codebase' 'data' 'href' 'longdesc' 'profile' 'src' 'usemap')
    ]

    knownTags [
	<category: 'configuration'>
	^#('a' 'abbr' 'acronym' 'address' 'area' 'b' 'base' 'bdo' 'big' 'blockquote' 'body' 'br' 'button' 'caption' 'cite' 'code' 'col' 'colgroup' 'dd' 'del' 'dfn' 'div' 'dl' 'dt' 'em' 'fieldset' 'form' 'h1' 'h2' 'h3' 'h4' 'h5' 'h6' 'head' 'hr' 'html' 'i' 'img' 'input' 'ins' 'ismap' 'kbd' 'label' 'legend' 'li' 'link' 'map' 'meta' 'noscript' 'object' 'ol' 'optgroup' 'option' 'p' 'param' 'pre' 'q' 'rb' 'rbc' 'rp' 'rt' 'rtc' 'ruby' 'samp' 'script' 'select' 'small' 'span' 'strong' 'style' 'sub' 'sup' 'table' 'tbody' 'td' 'textarea' 'tfoot' 'th' 'thead' 'title' 'tr' 'tt' 'ul' 'var')
    ]

    nextPut: aCharacter [
	<category: 'writing'>
	self htmlEncoder nextPut: aCharacter
    ]

    nextPutAll: aString [
	<category: 'writing'>
	self htmlEncoder nextPutAll: aString
    ]

    openTag: aString attributes: anAttributes closed: aBoolean [
	<category: 'writing-xhtml'>
	self indent.
	html text: '<'.
	(html span)
	    class: (self cssClassFor: aString);
	    with: aString.
	self attributes: anAttributes.
	aBoolean ifTrue: [html text: '/'].
	html text: '>'.
	aBoolean ifFalse: [indentLevel := indentLevel + 1].
	indentCloseTags
	    removeLast;
	    addLast: true;
	    addLast: aBoolean
    ]

    print: anObject [
	<category: 'writing'>
	self document print: anObject
    ]
]



WAFileLibrary extend [

    configurationComponent [
	<category: '*seaside-development-core'>
	^(WAFileLibraryEditor new)
	    library: self;
	    yourself
    ]

]



WAFileLibrary subclass: WAHandlerEditorFiles [
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    faviconIco [
	<category: 'accessing-pictures'>
	| cache |
	cache := #(nil) beMutable.
	(cache at: 1) isNil 
	    ifTrue: 
		[cache at: 1
		    put: #(0 0 1 0 1 0 16 16 0 0 1 0 32 0 104 4 0 0 22 0 0 0 40 0 0 0 16 0 0 0 32 0 0 0 1 0 32 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 252 252 252 253 247 247 247 253 254 254 254 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 103 117 237 253 42 51 220 253 229 230 239 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 72 116 250 253 0 51 246 253 73 95 225 253 247 247 247 253 255 255 255 253 255 255 255 253 255 255 255 253 253 253 253 253 249 249 249 253 254 254 254 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 83 137 252 253 0 87 254 253 0 88 252 253 126 146 226 253 251 251 251 253 242 242 247 253 164 164 233 253 70 70 222 253 30 30 216 253 226 226 237 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 95 152 252 253 0 126 255 253 0 111 255 253 3 103 251 253 63 97 231 253 17 55 231 253 0 45 236 253 0 11 226 253 32 33 220 253 242 242 245 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 252 252 252 253 79 145 249 253 0 158 255 253 0 98 255 253 0 149 255 253 0 149 254 253 0 106 250 253 0 33 233 253 2 31 232 253 185 185 233 253 254 254 254 253 255 255 255 253 255 255 255 253 254 254 254 253 232 237 245 253 148 184 243 253 58 136 245 253 0 136 254 253 0 163 255 253 0 113 255 253 0 134 255 253 0 118 255 253 0 84 250 253 0 92 250 253 107 113 225 253 253 253 253 253 255 255 255 253 255 255 255 253 254 254 254 253 107 164 246 253 7 108 252 253 0 118 255 253 0 135 255 253 0 134 255 253 0 128 255 253 0 104 255 253 0 82 255 253 0 110 255 253 0 146 255 253 4 77 240 253 231 231 237 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 80 153 251 253 1 113 254 253 0 129 255 253 0 143 255 253 0 147 255 253 0 144 255 253 0 116 255 253 0 89 255 253 0 96 255 253 0 144 255 253 0 114 250 253 143 149 220 253 253 253 253 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 227 238 251 253 158 199 250 253 88 171 251 253 9 149 254 253 0 167 255 253 0 121 255 253 0 143 255 253 0 136 255 253 0 89 255 253 0 104 253 253 7 60 235 253 187 187 226 253 254 254 254 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 138 184 251 253 0 155 255 253 0 109 255 253 0 162 255 253 0 143 255 253 0 133 255 253 0 88 251 253 0 30 233 253 25 31 219 253 223 223 236 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 161 197 252 253 0 137 255 253 0 115 255 253 4 140 253 253 154 182 242 253 163 188 251 253 89 130 247 253 19 37 230 253 0 0 222 253 151 151 227 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 169 201 252 253 0 109 255 253 0 117 255 253 113 161 240 253 253 253 253 253 255 255 255 253 254 254 254 253 250 250 252 253 212 212 245 253 249 249 251 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 177 205 252 253 0 94 255 253 38 115 246 253 241 243 247 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 227 236 253 253 61 127 250 253 197 213 243 253 254 254 254 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 254 254 254 253 254 254 254 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 255 255 255 253 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) 
			    asByteArray].
	^cache at: 1
    ]

    logoPng [
	<category: 'accessing-pictures'>
	| cache |
	cache := #(nil) beMutable.
	(cache at: 1) isNil 
	    ifTrue: 
		[cache at: 1
		    put: #(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 200 0 0 0 106 8 3 0 0 0 206 82 238 73 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 3 0 80 76 84 69 8 150 238 164 187 200 8 93 145 227 227 227 243 47 0 5 149 237 252 68 0 165 205 229 1 88 140 0 142 229 133 195 233 231 22 0 119 186 227 17 99 149 72 132 169 222 222 222 116 178 216 1 83 133 230 230 230 132 167 188 211 211 211 59 165 230 0 137 220 199 217 229 12 96 147 179 181 178 1 86 137 208 208 208 225 229 225 183 200 211 196 143 140 107 185 233 233 233 232 255 155 0 104 152 180 149 200 230 233 236 232 0 146 236 43 150 217 67 172 236 219 219 219 218 218 218 215 215 215 152 180 196 233 225 216 134 170 192 255 92 0 247 250 246 46 163 235 16 154 238 13 153 238 0 143 230 216 216 216 124 163 188 212 212 212 255 163 0 223 4 1 185 213 231 243 247 242 255 100 0 81 135 168 58 118 155 201 178 166 239 243 238 255 146 0 50 120 161 192 76 72 255 114 0 0 140 226 213 221 225 238 162 105 196 205 211 222 224 221 247 251 246 83 166 216 232 235 231 0 144 232 179 137 133 255 107 0 206 44 43 13 141 219 201 157 154 255 81 0 239 175 131 231 215 203 255 130 0 255 138 0 92 180 234 237 238 236 117 158 182 255 122 0 13 146 228 218 220 217 202 93 90 235 201 174 246 146 78 245 249 244 211 218 221 239 242 238 236 112 52 234 136 99 203 212 219 204 207 203 241 245 240 41 113 156 235 239 234 172 195 208 44 157 226 155 194 218 205 210 213 160 198 221 240 242 240 231 234 230 154 190 212 0 145 234 255 172 0 2 147 237 38 109 152 237 241 236 234 236 234 248 252 247 101 145 172 213 216 212 19 155 238 211 214 210 230 127 70 171 208 231 195 201 204 74 173 234 229 232 228 189 115 112 168 192 206 249 119 25 194 197 193 199 210 217 238 240 238 230 233 229 228 231 228 233 71 47 213 30 28 130 185 219 29 147 218 223 227 223 0 146 235 179 162 158 231 231 231 223 56 27 34 159 236 30 155 231 246 248 245 16 148 229 243 246 243 243 245 242 74 170 228 179 193 202 206 209 205 220 223 221 0 135 217 162 200 224 30 105 148 0 138 223 172 200 217 244 247 244 227 230 226 220 223 219 250 92 11 236 237 235 216 225 231 96 148 178 238 240 237 125 191 232 248 140 56 246 249 246 213 213 212 198 190 184 7 146 231 31 107 152 215 218 214 22 156 238 6 144 227 217 217 217 190 206 217 166 194 210 89 173 225 71 124 157 214 214 214 10 143 225 28 99 140 19 153 236 15 151 233 209 209 209 20 152 232 134 192 227 91 144 175 217 218 217 30 103 146 3 147 234 3 145 231 87 140 172 15 91 137 194 107 94 9 148 232 250 77 1 229 229 229 228 228 228 246 250 245 224 224 224 244 248 243 242 246 241 238 242 237 236 240 235 225 225 225 234 238 233 3 91 143 228 232 227 230 234 229 242 244 241 21 102 151 209 211 208 70 160 215 16 96 145 15 90 135 199 202 198 228 229 227 78 176 237 246 174 117 221 221 221 201 204 200 224 225 224 237 191 173 14 143 222 27 143 215 229 229 228 141 175 195 245 238 228 215 207 198 57 157 218 222 141 137 178 207 225 226 228 225 64 128 166 233 237 233 210 69 61 14 139 216 29 151 226 249 94 26 213 213 213 252 87 0 112 150 173 209 156 125 250 103 10 240 193 151 64 169 234 249 253 248 250 254 249 251 255 250 199 109 83 34 0 0 22 165 73 68 65 84 120 218 212 155 13 92 148 117 182 199 193 145 55 33 7 198 65 82 33 68 134 28 134 156 44 94 68 70 26 92 32 157 134 200 40 94 101 219 81 215 69 44 19 137 134 217 44 149 181 104 88 19 226 166 105 105 102 96 166 172 107 173 75 181 83 98 89 109 183 152 153 103 128 1 95 202 205 189 179 222 238 122 175 43 146 93 168 187 206 112 207 57 255 103 94 120 177 165 20 149 127 31 243 51 204 248 225 255 125 206 57 191 243 59 255 231 25 175 254 49 181 28 180 134 123 199 107 108 113 232 204 26 141 89 103 31 235 32 14 221 127 63 240 192 109 218 54 179 125 140 131 216 45 191 144 247 189 254 63 146 18 149 99 108 131 232 148 114 185 188 111 217 19 61 109 58 199 152 6 81 149 202 145 228 251 157 29 22 251 152 6 49 75 20 10 185 66 241 250 193 70 165 217 49 150 65 52 199 21 217 10 121 145 98 217 23 106 62 185 28 14 187 78 167 179 131 34 143 37 16 135 230 33 69 122 186 60 55 79 254 253 158 82 139 29 33 204 150 18 109 169 50 197 108 119 140 41 16 203 67 138 162 92 121 122 84 238 235 7 195 181 22 179 38 165 253 193 127 124 147 188 233 31 234 18 179 125 172 129 228 165 41 20 81 81 233 203 118 132 75 122 30 250 229 111 3 147 113 237 232 76 209 141 41 144 148 135 20 105 81 233 242 180 57 81 242 101 191 124 170 213 215 215 119 60 145 60 115 76 169 26 75 32 246 148 135 178 211 162 114 229 185 115 230 164 101 43 178 211 139 138 250 198 35 199 55 95 53 142 37 16 135 93 165 124 32 59 106 78 154 60 125 206 156 57 81 81 105 105 185 138 241 129 129 129 201 155 158 127 242 88 201 88 73 45 160 48 91 218 31 124 186 8 16 160 72 8 36 183 207 119 188 175 111 96 242 189 127 219 211 105 25 11 197 238 112 232 84 154 146 142 7 31 248 69 122 81 212 99 115 230 164 247 165 33 71 122 171 111 78 118 246 248 228 223 60 243 7 189 82 53 6 228 23 172 123 201 109 255 188 251 233 244 162 188 168 199 30 3 144 220 190 162 40 168 20 223 214 244 188 220 190 228 159 29 124 178 81 171 177 95 239 134 168 58 177 77 229 184 252 180 68 28 150 127 254 46 29 41 230 60 70 107 78 90 159 34 55 61 167 85 158 7 81 9 188 111 202 142 218 82 139 238 58 119 246 237 245 70 88 75 129 194 110 183 95 6 197 97 254 143 108 16 168 220 188 180 180 40 170 141 168 220 190 156 156 214 156 116 120 153 231 187 233 249 95 237 97 94 248 58 130 28 152 110 164 101 170 68 14 251 101 194 98 79 249 93 54 91 10 182 228 242 156 156 156 190 92 32 138 202 14 188 23 10 132 77 39 215 15 196 49 93 36 18 133 69 71 27 77 166 19 78 142 97 96 236 13 119 3 4 228 86 110 110 81 81 122 58 224 200 49 32 185 16 144 180 214 64 72 44 45 155 23 175 31 200 9 145 232 141 200 59 189 188 34 77 2 17 25 216 225 151 221 162 190 251 105 133 34 27 138 132 45 144 221 156 62 36 73 203 147 7 62 63 13 122 161 227 186 130 96 64 242 239 184 211 203 167 34 83 192 53 152 117 158 155 87 53 28 112 131 104 148 141 79 222 245 212 255 41 20 233 80 239 184 242 114 20 121 69 57 168 89 80 235 95 133 183 95 95 16 199 237 144 87 107 9 196 143 227 150 154 117 206 236 218 186 186 82 4 133 35 218 187 141 48 192 169 167 104 143 47 124 226 171 239 159 146 203 179 243 16 36 61 7 10 36 55 199 183 47 61 187 53 249 179 143 122 44 215 46 181 96 119 219 7 168 44 252 189 93 36 138 70 144 138 24 63 161 240 89 179 157 150 106 53 22 142 72 68 26 80 223 64 34 0 36 202 14 117 248 158 39 15 126 255 58 248 69 48 140 242 52 204 176 190 241 227 251 228 227 147 239 170 109 167 34 185 6 32 7 10 104 95 251 111 31 144 251 171 69 162 9 107 239 128 128 148 239 18 10 181 4 162 90 42 98 43 108 221 92 248 7 38 227 86 157 10 34 165 83 169 44 37 237 157 250 218 39 238 234 3 191 152 219 138 202 11 218 219 26 24 232 235 155 188 105 199 113 146 173 209 7 217 198 139 172 201 120 187 167 54 17 8 100 86 76 214 46 155 80 171 130 129 117 27 69 35 108 194 134 59 32 80 135 34 51 77 130 74 179 217 140 40 8 163 41 209 30 47 94 86 4 86 139 41 86 90 94 81 107 114 50 216 248 159 23 195 52 114 13 26 98 3 82 172 107 138 54 153 4 5 131 65 48 179 202 227 31 149 218 16 228 4 98 248 253 117 237 90 72 56 0 244 153 45 176 114 75 53 26 141 138 170 199 14 78 69 217 184 44 61 42 45 71 158 151 150 167 104 237 83 100 103 183 6 38 195 60 114 63 40 240 232 131 216 235 69 162 185 179 189 188 96 95 2 129 71 114 217 25 8 100 86 192 163 82 136 136 106 53 70 227 175 135 0 3 57 32 229 98 130 56 225 233 54 11 145 80 113 57 52 61 255 155 30 149 142 114 149 51 30 13 252 120 54 87 109 218 161 110 211 141 58 200 106 163 40 236 16 106 83 76 52 103 61 225 194 56 208 64 32 152 89 8 178 84 213 0 28 115 95 240 228 40 127 81 104 19 150 148 88 240 172 215 78 42 97 238 4 136 190 156 92 224 248 108 202 243 63 223 4 16 52 32 222 2 245 62 234 238 23 220 212 6 226 40 15 226 184 103 73 154 116 171 247 214 139 234 33 82 19 32 179 234 226 9 196 92 96 36 14 134 65 159 207 10 56 47 149 74 148 64 162 98 237 178 223 220 227 171 72 247 149 195 92 248 217 148 191 125 241 197 87 183 124 67 19 123 242 189 123 58 52 163 13 162 50 26 195 232 2 215 149 127 200 113 171 145 99 181 200 185 38 80 137 32 136 18 20 65 116 137 194 225 245 66 100 62 112 212 101 197 7 4 39 52 215 104 75 218 0 68 231 4 145 247 249 202 115 198 127 51 101 71 113 120 99 248 158 39 14 254 230 62 72 173 187 106 71 31 4 74 125 29 11 200 139 75 56 235 1 187 189 129 53 138 185 235 16 132 50 11 64 184 213 16 144 104 198 145 15 2 215 4 159 143 15 200 8 150 201 186 59 218 75 44 102 39 136 218 55 7 15 28 254 13 44 239 113 173 178 189 244 120 119 241 142 131 247 63 243 135 99 202 209 78 45 7 70 132 15 136 144 3 75 181 13 41 214 229 99 49 228 135 53 65 55 68 16 27 183 122 58 6 4 57 102 131 78 155 194 136 99 247 57 131 193 86 170 45 73 209 240 86 76 115 28 40 160 204 239 253 170 248 184 210 12 138 220 6 221 37 188 54 92 175 133 129 100 84 65 224 151 67 141 68 2 72 11 112 112 39 116 58 136 199 27 249 135 88 77 31 130 20 194 13 63 42 228 86 27 141 111 220 129 28 94 77 192 97 18 64 129 100 236 222 125 78 220 43 237 209 42 221 32 255 137 24 129 159 81 8 236 56 2 155 161 83 106 181 74 139 106 84 229 151 244 105 59 117 145 166 48 142 227 42 161 87 24 69 111 92 26 32 77 1 8 98 85 194 135 232 103 62 235 0 67 96 165 128 76 62 39 22 51 16 190 218 205 183 161 232 254 108 202 147 225 56 219 178 51 9 157 10 123 230 168 117 118 143 126 81 73 109 93 96 181 10 10 84 170 122 145 177 137 149 2 73 83 5 92 121 2 1 19 51 129 126 234 227 135 28 28 5 4 65 138 123 74 25 8 146 152 247 254 54 57 249 190 41 95 176 217 214 253 203 70 235 52 126 192 52 97 63 128 14 112 110 244 92 129 192 212 128 77 197 213 184 15 87 80 73 187 64 238 188 147 172 48 96 248 5 81 64 38 223 35 22 219 122 58 148 109 78 16 85 201 131 247 223 242 204 147 181 61 109 215 226 142 21 57 241 130 202 202 202 165 219 200 188 62 11 229 62 19 46 62 120 148 130 189 70 81 36 187 240 179 195 76 166 13 49 117 8 18 0 32 48 244 230 179 100 107 10 122 169 37 11 241 0 228 57 113 82 173 39 136 93 211 174 175 13 63 86 58 28 199 85 7 113 108 45 168 231 125 184 177 30 70 216 3 240 119 40 4 160 98 182 201 52 93 100 20 205 70 142 138 152 48 48 44 97 117 229 30 32 51 239 100 50 93 158 149 21 207 64 54 47 16 247 30 147 116 184 83 203 174 179 40 161 180 83 84 163 127 87 215 177 117 58 223 236 152 229 125 86 7 217 20 77 151 186 2 236 47 228 24 227 8 229 184 51 86 193 236 114 172 17 23 8 147 105 164 0 14 16 223 136 164 164 102 53 43 118 222 110 57 92 165 61 58 32 174 137 201 193 186 246 220 9 249 27 102 206 140 12 131 141 99 167 139 244 0 137 198 235 14 118 69 40 172 225 4 27 234 202 49 139 220 32 172 104 112 133 6 191 38 51 24 12 225 146 206 246 146 20 179 19 132 253 170 225 55 225 117 245 10 27 20 10 40 222 136 158 189 150 137 171 207 4 216 121 37 121 45 23 72 19 230 79 93 86 144 77 168 231 4 77 172 72 118 49 16 146 99 4 11 13 218 101 147 74 99 19 100 178 132 154 158 210 118 165 39 200 229 151 215 149 82 168 26 26 26 236 60 7 236 213 239 133 181 60 71 69 69 197 186 33 32 145 94 24 16 24 65 132 101 2 0 137 193 144 120 128 212 101 189 251 200 114 169 77 40 20 218 128 36 33 65 218 89 170 28 117 16 254 160 128 170 97 250 118 224 216 15 61 57 18 187 29 219 120 76 76 204 108 147 177 158 146 6 95 154 144 100 38 93 246 0 2 65 75 133 33 241 0 41 207 218 133 24 28 183 235 165 248 128 135 151 39 52 171 75 149 37 163 11 2 133 199 31 20 56 79 10 182 193 78 131 14 29 230 57 64 126 202 203 235 194 48 10 44 105 98 4 78 144 58 0 177 9 213 38 0 65 183 30 143 32 38 103 68 96 128 183 114 214 104 212 179 140 231 192 253 142 46 8 230 209 9 94 158 150 175 92 185 18 39 242 250 233 2 171 223 161 195 135 91 192 136 55 69 182 192 6 227 179 202 253 24 136 15 250 114 1 146 204 244 33 144 93 66 110 47 128 248 12 6 137 41 135 119 172 2 193 150 58 114 191 9 9 221 165 84 236 186 171 12 226 174 107 38 179 203 103 205 59 121 211 77 55 223 60 110 198 18 52 22 220 11 135 14 183 180 120 229 11 76 130 15 73 125 178 206 187 210 169 174 220 234 6 129 189 115 5 38 99 147 235 133 27 196 15 57 194 98 24 136 108 32 72 255 85 0 25 116 142 185 29 155 222 202 121 39 79 50 142 174 174 163 128 193 69 127 240 193 225 22 175 67 153 192 36 132 86 16 16 176 133 227 35 130 153 198 49 144 10 218 59 39 64 16 47 39 72 189 19 36 198 15 56 76 126 56 31 102 100 60 34 147 213 116 92 77 144 33 199 152 91 1 35 243 40 97 32 199 184 46 127 255 151 65 104 222 253 224 3 8 200 37 8 142 208 246 109 70 70 198 226 243 156 105 250 96 16 74 39 4 49 14 0 49 81 2 86 196 76 128 150 47 152 64 1 217 93 109 144 169 175 98 68 134 28 99 58 110 135 120 188 125 129 199 96 28 254 133 82 169 244 225 23 91 90 62 255 252 5 228 176 61 247 237 195 249 111 11 173 158 32 86 23 72 185 159 192 84 234 4 193 202 23 1 136 15 129 68 34 72 40 155 171 146 122 155 37 165 56 33 178 19 161 43 3 113 171 19 121 142 233 13 232 3 33 30 143 243 24 200 1 32 83 63 141 141 141 125 241 197 197 159 127 238 243 73 190 21 250 0 112 217 132 156 64 235 2 201 114 131 196 120 128 176 153 29 181 216 135 222 106 201 180 114 239 102 145 215 90 35 78 90 40 41 85 182 17 136 227 138 64 208 221 172 118 169 83 4 146 136 14 128 49 23 137 46 48 140 125 113 27 231 19 199 212 84 104 95 139 23 47 254 252 205 79 202 203 183 124 40 180 65 80 128 99 169 197 19 68 64 215 29 59 140 159 201 84 73 163 35 76 86 25 143 198 74 171 172 168 197 21 168 9 91 94 218 18 64 211 200 151 98 177 184 74 226 97 126 127 26 8 95 13 13 78 117 194 125 159 44 204 52 26 247 234 246 27 69 103 89 82 157 5 178 106 30 68 38 147 109 126 111 241 155 127 6 144 242 44 64 129 182 102 221 111 241 4 225 4 174 4 2 16 124 195 7 79 131 50 30 73 136 85 115 2 63 4 100 118 24 49 38 223 186 224 136 120 167 190 199 195 252 254 72 144 129 234 132 24 222 164 78 148 69 243 33 59 240 198 223 5 74 170 11 212 10 177 66 166 134 164 130 197 187 231 189 63 254 17 64 234 208 138 111 137 198 141 87 166 12 11 130 195 9 252 211 195 56 234 102 236 126 68 150 160 135 232 181 48 195 146 65 24 175 220 186 96 218 17 67 149 122 196 109 100 16 200 96 149 197 104 56 69 150 170 33 145 114 162 154 94 141 75 52 82 68 48 32 33 169 73 189 189 207 33 200 159 17 164 60 171 188 60 244 60 108 188 146 7 1 159 43 244 0 161 35 134 104 52 187 88 11 6 89 85 183 144 11 34 83 207 48 94 249 114 193 180 105 226 218 50 126 172 210 217 29 63 10 196 115 184 195 117 0 213 105 133 39 135 255 77 2 147 209 100 220 56 14 87 215 70 188 172 137 60 136 56 169 247 247 239 186 64 200 160 76 128 235 238 4 201 138 23 98 181 95 98 169 181 1 65 102 163 105 135 109 175 73 50 52 234 133 194 204 135 89 141 3 198 185 53 211 144 67 47 233 24 113 64 60 65 6 15 119 168 78 200 225 194 192 36 138 64 167 145 72 32 39 145 227 108 151 19 68 156 36 54 4 3 72 86 29 145 212 213 213 197 76 96 166 17 107 58 43 30 139 223 20 201 138 189 238 188 32 236 18 249 41 216 247 26 177 33 188 7 106 106 73 208 183 16 143 69 231 130 35 0 227 200 239 129 3 19 11 166 170 31 7 50 100 184 99 234 196 56 86 20 238 99 28 254 133 152 234 17 93 200 129 42 118 150 137 111 8 130 244 138 13 205 111 135 34 8 146 192 159 152 24 102 26 125 104 96 2 57 182 10 80 155 98 104 158 197 129 150 93 127 152 104 245 18 61 73 118 130 172 87 44 62 2 24 226 61 85 192 1 211 161 197 21 144 17 130 240 195 221 219 179 142 78 156 56 177 176 26 135 187 253 34 81 28 227 216 7 53 157 72 69 61 181 16 220 169 192 116 246 194 133 68 80 176 204 125 227 60 64 154 63 234 77 144 218 194 242 63 129 88 240 201 213 68 94 139 156 123 128 84 10 33 137 198 112 208 92 8 85 125 142 149 195 52 113 66 153 164 83 98 37 16 67 18 168 110 111 113 163 94 13 121 165 108 67 231 59 162 128 56 65 28 56 220 101 198 205 103 222 105 28 9 235 116 12 8 190 158 143 199 152 213 196 49 53 85 42 252 59 25 114 172 243 249 227 60 65 18 206 72 1 132 227 194 242 25 72 86 86 249 6 248 168 233 18 59 201 109 142 5 18 180 131 248 2 181 233 203 215 0 227 149 139 239 28 17 47 84 119 118 180 183 247 156 22 54 195 88 248 209 206 238 42 125 89 79 41 112 164 120 36 214 200 64 28 123 81 102 87 184 60 96 87 215 70 108 126 153 236 117 34 29 99 18 71 72 106 172 237 116 37 227 216 120 18 43 229 38 143 212 194 136 8 173 86 65 216 6 228 136 143 143 15 197 38 120 9 125 72 70 134 44 33 22 122 203 108 146 88 214 40 196 193 23 47 222 19 49 77 108 192 44 106 111 87 42 181 29 61 18 137 90 34 233 233 233 236 208 194 32 98 97 28 35 7 161 188 154 193 186 5 187 198 93 243 113 171 43 177 127 143 27 183 145 142 49 137 35 36 181 217 118 90 211 134 15 95 76 186 153 42 62 194 223 9 2 197 158 240 40 12 23 232 150 242 179 40 125 66 33 155 4 151 216 145 180 65 150 96 149 10 163 227 93 28 80 11 88 213 226 164 90 9 4 68 137 171 189 163 163 20 86 7 98 180 17 135 106 132 28 12 4 221 108 34 207 193 106 218 191 11 203 100 18 11 208 70 58 198 68 109 130 13 199 10 69 22 60 6 221 71 41 120 50 194 68 162 197 64 130 191 93 188 248 18 4 65 32 200 164 214 150 17 4 217 100 13 101 71 210 189 6 153 30 12 88 16 182 188 201 155 131 9 226 8 20 132 44 28 56 148 176 241 182 146 18 64 33 32 23 134 139 99 68 32 152 88 222 140 227 241 196 25 167 8 196 127 35 93 116 138 208 70 192 240 46 164 128 132 124 42 21 74 240 118 243 12 122 11 56 76 238 136 4 127 253 53 184 173 243 24 17 43 107 209 207 97 93 132 102 209 222 147 122 13 234 110 240 146 111 7 7 7 175 17 31 129 181 179 57 169 87 122 70 45 41 5 142 182 20 90 72 3 72 41 160 86 80 230 238 188 250 151 28 8 130 15 33 136 86 16 199 62 72 162 89 176 227 169 208 48 160 16 62 189 153 66 148 152 56 241 20 38 22 130 76 178 113 251 221 136 192 225 1 178 153 64 104 162 8 35 142 175 171 19 128 36 148 250 220 173 226 164 230 50 137 149 206 121 72 154 154 107 107 160 168 213 146 206 210 118 22 0 141 198 98 177 164 192 31 141 134 40 40 28 35 229 32 144 19 164 179 0 114 50 211 36 224 132 184 229 169 111 65 11 55 78 116 78 27 84 232 8 242 241 42 33 142 68 43 89 143 36 21 240 119 54 196 5 139 22 125 13 62 62 210 10 3 201 75 84 7 247 244 202 164 177 210 80 10 72 176 56 105 39 104 145 222 38 5 105 50 244 22 119 19 69 15 85 7 150 53 219 186 202 204 51 176 104 140 156 131 64 10 68 162 163 20 144 11 144 221 66 219 171 176 229 83 17 78 16 214 185 249 149 186 222 198 213 67 199 252 148 64 230 155 6 130 92 92 244 245 123 111 190 217 18 157 25 29 138 173 110 242 162 5 73 134 133 205 210 32 12 206 230 5 73 189 80 12 80 199 101 53 221 221 141 101 101 106 160 40 237 208 18 6 95 15 78 2 92 236 145 142 145 115 0 136 3 159 211 153 79 133 254 56 6 196 54 233 213 21 51 22 112 38 2 161 128 56 41 10 95 6 117 21 44 53 26 151 51 215 66 1 89 226 74 173 85 23 23 189 135 22 37 139 181 108 244 30 226 230 198 132 216 229 15 103 236 190 167 186 183 183 89 221 3 42 171 108 215 130 52 117 34 146 147 130 199 176 15 89 142 145 115 16 8 148 8 27 190 187 142 2 8 140 68 100 139 166 123 130 164 22 122 219 240 231 66 206 4 153 117 150 101 214 70 4 137 115 169 150 120 243 162 221 25 241 172 219 1 198 197 96 208 164 218 50 41 140 142 175 65 50 25 100 53 18 80 85 166 178 237 90 130 192 10 199 39 2 134 195 184 220 131 104 63 4 98 68 16 150 69 111 205 2 18 156 137 68 75 25 8 102 214 167 103 87 209 49 38 190 33 48 213 187 213 12 65 142 242 32 176 235 224 201 187 51 50 120 140 87 254 235 157 105 56 25 169 171 164 82 118 250 169 199 38 167 108 195 85 130 171 141 98 193 231 212 208 237 255 56 12 6 2 91 123 203 217 9 17 133 3 195 189 63 133 7 129 31 121 179 99 76 239 137 254 254 43 150 152 220 106 22 7 242 180 128 113 132 132 192 182 167 221 58 121 247 110 74 42 8 7 12 70 226 226 42 16 37 201 105 64 17 214 64 42 181 99 34 165 88 152 208 186 235 155 47 235 225 159 161 235 255 49 32 123 113 107 78 159 14 40 113 86 126 36 226 35 226 77 199 152 113 244 230 44 87 237 116 249 31 229 184 37 43 120 14 4 57 178 32 120 209 100 228 248 18 48 224 245 194 170 50 9 214 115 123 167 86 75 5 209 70 219 103 203 85 217 87 131 130 7 57 1 89 239 1 226 239 127 33 130 141 68 46 16 60 254 123 139 222 74 68 199 120 129 143 222 209 25 167 166 242 28 33 211 196 73 208 168 123 215 172 89 243 14 121 15 177 172 91 47 161 234 118 46 192 112 5 193 51 18 195 96 252 132 99 92 4 49 163 227 240 4 193 11 143 94 203 9 130 28 213 236 141 66 28 88 231 177 143 146 150 125 156 74 28 239 131 247 131 54 151 148 4 255 67 231 97 168 213 151 97 175 107 199 98 160 194 160 96 12 138 195 16 140 159 126 143 3 65 28 207 226 200 74 166 215 9 210 117 22 73 38 178 43 239 141 199 152 27 89 91 164 232 240 179 9 197 34 241 215 4 50 9 42 226 88 173 180 23 64 146 196 178 133 225 122 117 143 179 184 161 93 167 56 219 245 64 130 171 5 225 2 161 155 225 213 23 6 144 84 3 9 159 66 179 208 116 204 98 123 95 5 230 137 139 112 115 204 19 175 79 13 249 203 188 151 33 171 186 245 106 181 186 177 38 188 241 56 115 30 88 220 109 72 160 225 139 194 163 209 13 77 167 43 189 255 231 197 238 134 211 99 135 213 251 60 72 176 219 241 104 51 16 228 2 27 71 18 154 81 132 93 37 62 15 205 31 22 182 184 119 167 30 231 136 82 248 175 167 147 40 88 203 118 166 147 171 95 95 113 89 255 32 200 54 246 128 66 245 81 23 201 68 72 167 68 6 118 106 137 149 59 202 182 30 103 144 117 119 219 132 47 191 74 175 222 159 116 4 172 56 122 241 36 217 25 48 82 61 218 14 104 117 160 80 46 231 97 118 67 92 150 226 234 220 80 102 32 5 70 231 19 148 213 243 120 139 152 10 205 47 145 135 122 117 226 171 44 147 254 36 238 53 232 203 164 54 219 170 73 191 158 247 157 55 154 113 67 113 66 146 65 122 166 140 134 83 40 138 18 156 38 208 205 186 40 46 171 77 87 9 193 3 164 0 207 78 240 198 147 209 217 170 105 56 231 188 253 61 157 111 72 200 227 235 197 226 133 101 18 214 172 153 25 47 110 108 212 131 62 73 58 123 104 170 67 117 98 198 195 60 16 99 52 25 92 32 248 60 225 44 232 237 19 97 76 71 23 72 219 46 196 249 251 20 143 193 90 197 227 235 65 99 171 192 250 169 207 72 165 205 120 31 188 184 91 207 155 113 156 185 75 104 168 0 4 141 230 135 40 70 231 89 36 234 236 192 65 174 49 2 67 34 96 213 144 40 131 161 168 112 170 27 35 228 79 235 167 29 73 194 99 51 216 117 103 213 233 51 221 53 3 204 56 223 41 204 174 178 24 142 98 244 30 170 2 16 59 152 198 183 200 152 159 69 142 5 180 243 127 95 223 11 36 171 86 184 56 82 227 126 133 199 152 85 252 65 1 152 113 240 226 30 102 156 207 38 157 78 55 64 101 175 13 5 3 105 48 138 86 50 27 95 8 28 220 68 190 63 136 155 99 129 164 240 99 164 74 253 238 101 60 43 128 118 77 28 120 74 64 94 124 160 25 119 53 60 157 238 218 66 184 64 156 163 235 77 113 75 226 82 137 227 47 235 193 243 117 55 55 199 198 54 39 24 60 143 49 241 192 3 15 7 82 152 23 31 96 198 221 161 112 56 28 215 148 130 129 168 96 228 187 217 121 16 196 103 82 28 92 254 99 101 53 54 105 108 243 128 99 204 82 118 224 132 167 4 188 25 119 249 39 251 229 154 118 127 255 53 2 193 121 100 197 56 231 112 78 241 40 132 114 88 136 195 68 89 183 205 125 140 41 225 93 7 138 210 176 102 220 225 252 218 215 181 166 224 65 10 240 46 135 71 56 222 247 6 142 98 24 38 58 59 240 228 15 143 49 213 76 99 149 120 28 107 30 224 197 135 54 60 254 126 81 255 181 93 8 178 21 196 106 190 59 28 223 173 7 142 143 104 40 106 135 165 29 116 140 57 216 117 12 206 167 254 235 179 200 253 238 133 54 88 120 138 153 144 194 245 172 174 203 220 67 17 226 180 43 221 24 67 188 184 253 58 164 210 176 32 183 27 241 24 200 59 46 206 27 167 162 35 98 89 173 158 142 110 120 203 49 240 24 83 165 187 108 89 95 71 14 6 226 216 246 119 78 8 246 9 133 86 140 24 52 220 161 204 90 156 2 53 216 60 57 70 207 199 94 201 96 101 55 107 107 200 7 246 54 47 108 44 99 195 29 100 18 141 68 67 143 49 111 60 10 30 4 191 89 166 105 83 74 212 250 42 9 201 147 83 102 7 232 147 78 119 195 165 211 224 179 95 250 46 86 74 27 20 53 234 147 211 60 185 173 211 232 12 217 163 2 98 215 105 128 164 132 4 74 201 159 63 13 174 235 27 24 194 19 68 133 119 39 64 159 218 152 121 26 44 79 55 100 54 13 185 99 197 190 249 132 243 144 101 240 109 150 97 11 187 191 255 6 5 113 176 45 235 216 141 150 127 113 146 217 127 131 46 118 87 151 161 232 92 235 58 186 216 43 2 233 119 125 219 99 140 84 246 15 60 249 224 24 200 50 182 32 6 60 139 226 184 17 219 245 79 0 25 22 165 191 127 44 130 12 65 233 31 83 235 255 5 24 0 173 15 202 119 74 152 115 199 0 0 0 0 73 69 78 68 174 66 96 130) 
			    asByteArray].
	^cache at: 1
    ]

    mainCss [
	<category: 'accessing-styles'>
	^'/* html */
body {
	color: #002842;
	font-size: 12px;
	font-family: Helvetica, Verdana, Arial, sans-serif;
	background-color: #fbfffa;
}
input, textarea, select {
	color: #002842;
	margin-right: 0.5em;
	font-family: Helvetica, Verdana, Arial, sans-serif;
}
input.text, textarea {
	width: 200px;
}
a, a:link, a:active, a:visited, a:focus, a:hover {
	color: #008aff;
}

/* headings */
h1, h2, h3, h4, h5, h6 {
	color: #01598d;
	margin-bottom: 1ex;
	font-weight: normal;
}
th {
	text-align: right;
	padding-right: 1em;
}

/* special */
h1.logo a {
	width: 200px;
	height: 106px;
	outline: none;
	display: block;
	text-indent: -100em;
	background: url(logo.png) no-repeat;
}
span.unspecified {
	color: #ff7000;
}
a.download {
	background: url(save.png) no-repeat;
	background-position: 0 50%;
	padding-left: 18px;
}

/* walkback */
.walkback th {
	width: 150px;
	text-align: left;
	vertical-align: top;
}'
    ]

    savePng [
	<category: 'accessing-pictures'>
	| cache |
	cache := #(nil) beMutable.
	(cache at: 1) isNil 
	    ifTrue: 
		[cache at: 1
		    put: #(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 6 0 0 0 31 243 255 97 0 0 0 6 98 75 71 68 0 0 0 0 0 0 249 67 187 127 0 0 0 9 112 72 89 115 0 0 11 19 0 0 11 19 1 0 154 156 24 0 0 0 7 116 73 77 69 7 213 11 10 13 55 15 158 42 216 191 0 0 0 140 116 69 88 116 67 111 109 109 101 110 116 0 77 101 110 117 45 115 105 122 101 100 32 105 99 111 110 10 61 61 61 61 61 61 61 61 61 61 10 10 40 99 41 32 50 48 48 51 32 74 97 107 117 98 32 39 106 105 109 109 97 99 39 32 83 116 101 105 110 101 114 44 32 10 104 116 116 112 58 47 47 106 105 109 109 97 99 46 109 117 115 105 99 104 97 108 108 46 99 122 10 10 99 114 101 97 116 101 100 32 119 105 116 104 32 116 104 101 32 71 73 77 80 44 10 104 116 116 112 58 47 47 119 119 119 46 103 105 109 112 46 111 114 103 103 138 199 71 0 0 2 132 73 68 65 84 56 203 157 146 77 72 84 97 20 134 159 185 221 241 230 207 228 76 224 181 49 205 145 178 81 108 81 81 52 38 20 184 200 22 69 20 46 66 40 44 130 138 169 193 86 45 42 202 69 17 84 16 6 82 180 40 10 34 176 40 40 106 91 208 34 137 68 138 166 69 153 84 106 134 164 232 220 155 206 253 249 78 11 97 108 178 54 189 155 243 193 225 60 156 247 61 95 224 200 217 227 39 63 91 21 218 216 184 51 9 84 1 91 129 134 160 38 217 208 194 159 63 22 25 206 205 187 231 207 157 224 31 10 52 119 116 237 141 173 172 143 85 151 155 131 171 107 202 58 170 35 133 107 109 207 39 253 45 195 235 222 231 234 195 215 81 226 145 55 203 186 59 239 12 255 21 144 60 125 190 219 157 26 59 236 137 198 168 31 102 218 40 99 129 30 164 173 101 35 203 43 22 115 249 254 11 252 161 62 98 5 227 127 155 239 36 121 44 37 95 70 6 68 68 100 224 115 90 122 211 3 146 186 246 68 18 7 47 72 207 171 47 210 245 244 173 180 158 186 46 239 6 135 229 119 89 150 37 169 142 164 232 134 238 179 180 60 198 196 196 4 225 146 114 180 192 36 133 226 0 208 247 113 20 179 68 231 251 120 134 247 3 159 88 178 168 16 2 0 66 65 65 1 0 186 231 130 40 193 87 138 237 39 110 204 219 177 119 112 2 215 243 185 216 243 146 139 61 47 1 120 124 118 31 200 108 95 3 80 162 80 190 162 235 80 35 0 237 187 119 210 152 88 199 204 140 77 52 164 209 148 88 207 222 214 237 0 236 105 94 129 242 21 34 50 7 16 17 34 145 48 21 101 49 46 29 88 199 205 187 15 136 199 170 208 8 160 17 32 81 95 205 173 123 143 104 219 92 195 142 166 245 20 21 23 229 3 0 44 203 194 52 77 170 163 181 57 72 227 170 229 212 198 42 185 124 251 33 109 155 107 216 181 41 129 105 154 56 142 147 179 168 3 40 165 176 109 27 0 211 52 49 77 147 238 163 133 28 187 218 67 214 245 217 223 82 79 251 182 45 104 154 198 212 212 20 182 109 19 10 133 230 0 134 97 80 89 89 153 23 222 154 134 13 60 187 178 1 0 219 182 113 28 135 233 233 233 121 33 235 0 253 253 253 184 174 155 215 240 60 15 93 215 115 239 63 21 137 68 242 51 240 60 143 116 58 205 200 200 8 153 76 6 17 65 68 48 12 131 161 161 33 66 161 80 174 90 150 133 101 89 249 87 80 74 81 92 92 68 48 24 204 125 18 0 215 117 17 53 11 19 53 123 62 229 251 249 22 194 225 48 165 165 165 68 163 81 0 178 217 44 64 46 237 120 93 28 165 20 241 186 58 148 82 44 137 70 115 150 3 169 142 228 25 224 52 255 167 206 95 147 59 51 76 213 34 98 109 0 0 0 0 73 69 78 68 174 66 96 130) 
			    asByteArray].
	^cache at: 1
    ]

    selectorsToInclude [
	<category: 'accessing'>
	^#(#faviconIco #mainCss)
    ]
]



WAFileHandler extend [

    configurationComponent [
	<category: '*seaside-development-core'>
	^WAFileHandlerEditor on: self
    ]

]



WAComponent subclass: WAHalo [
    | root mode plugins |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    Halos := nil.

    WAHalo class >> for: aComponent [
	<category: 'instance-creation'>
	^Halos at: aComponent ifAbsentPut: [self new initializeOn: aComponent]
    ]

    WAHalo class >> initializeClass [
	<category: 'class initialization'>
	Halos := SeasidePlatformSupport weakDictionaryOfSize: 20
    ]

    initializeOn: aComponent [
	<category: 'initialization'>
	root := aComponent.
	mode := WAValueHolder with: self modes first.
	plugins := WAHaloPlugin allSubclassesOn: self root for: self
    ]

    mode [
	<category: 'accessing'>
	^mode contents
    ]

    mode: aSymbol [
	<category: 'accessing'>
	mode contents: aSymbol
    ]

    modes [
	<category: 'accessing'>
	^#(#render: #source:)
    ]

    plugins [
	<category: 'accessing'>
	^plugins
    ]

    render: html [
	<category: 'rendering-modes'>
	self root renderContentOn: html
    ]

    renderContentOn: html [
	<category: 'rendering'>
	| haloHtml |
	haloHtml := self rendererClass context: html context
		    callbacks: html callbacks.
	(haloHtml div)
	    class: 'halo';
	    with: 
		    [(haloHtml div)
			class: 'halo-header';
			with: 
				[self plugins do: [:each | html render: each] separatedBy: [html text: ' ']].
		    (haloHtml div)
			class: 'halo-body';
			with: [self perform: self mode with: html]].
	haloHtml flush.
	html flush
    ]

    root [
	<category: 'accessing'>
	^root
    ]

    source: html [
	<category: 'rendering-modes'>
	| context haloHtml |
	haloHtml := self rendererClass context: html context
		    callbacks: html callbacks.
	context := haloHtml context copy.
	context clearMode.
	context document: (WAPrettyPrintedDocument renderer: haloHtml).
	(haloHtml div)
	    class: 'halo-source';
	    with: [self root renderWithContext: context].
	haloHtml flush.
	html context count: context count
    ]

    states [
	<category: 'accessing'>
	^Array with: mode
    ]
]



WAComponent subclass: WAHandlerEditor [
    | handler |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WAHandlerEditor class >> on: anEntryPoint [
	<category: 'instance-creation'>
	^self new initializeOn: anEntryPoint
    ]

    handler [
	<category: 'accessing'>
	^handler
    ]

    initializeOn: aHandler [
	<category: 'initialization'>
	handler := aHandler
    ]

    renderContentOn: html [
	<category: 'rendering'>
	self renderHeadingOn: html
    ]

    renderHeadingOn: html [
	<category: 'rendering'>
	(html heading)
	    class: 'logo';
	    with: 
		    [(html anchor)
			url: ((WAUrl new)
				    hostname: 'www.seaside.st';
				    addParameter: 'version' value: SeasidePlatformSupport versionString;
				    addParameter: 'platform' value: SeasidePlatformSupport platformString;
				    yourself);
			with: 'Seaside'].
	html heading: self title , ' on ' , self handler basePath
    ]

    title [
	<category: 'accessing'>
	^self handler description
    ]

    updateRoot: aHtmlRoot [
	<category: 'updating'>
	super updateRoot: aHtmlRoot.
	WAHandlerEditorFiles default updateRoot: aHtmlRoot.
	aHtmlRoot title: self title
    ]
]



WAHandlerEditor subclass: WAConfigurationEditor [
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    close [
	<category: 'actions'>
	self answer
    ]

    configuration [
	<category: 'accessing'>
	^handler configuration
    ]

    renderAncestryListFor: aConfiguration seen: aSet on: html [
	<category: 'rendering-ancestry'>
	aConfiguration ancestors isEmpty ifTrue: [^self].
	html unorderedList: 
		[aConfiguration ancestors do: 
			[:each | 
			html listItem: 
				[self renderParent: each on: html.
				(aSet includes: each) 
				    ifFalse: 
					[aSet add: each.
					self 
					    renderAncestryListFor: each
					    seen: aSet
					    on: html]]]]
    ]

    renderAncestryOn: html [
	<category: 'rendering-ancestry'>
	(html heading)
	    level: 2;
	    with: 'Ancestry'.
	self configuration potentialAncestors isEmpty 
	    ifFalse: 
		[html text: 'Add ancestor: '.
		self renderParentSelectorOn: html].
	self 
	    renderAncestryListFor: self configuration
	    seen: Set new
	    on: html
    ]

    renderAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	html tableRow: 
		[html tableHeading: 
			[(html label)
			    title: anAttribute comment;
			    with: (self labelForSelector: anAttribute key)].
		html tableData: 
			[(self configuration valueForAttribute: anAttribute) 
			    ifNil: [self renderUnspecifiedAttribute: anAttribute on: html]
			    ifNotNil: 
				[:foo | 
				(self configuration hasLocalValueForAttribute: anAttribute) 
				    ifTrue: [self renderOverridenAttribute: anAttribute on: html]
				    ifFalse: [self renderInheritedAttribute: anAttribute on: html]]].
		self renderInheritanceForAttribute: anAttribute on: html]
    ]

    renderAttributesOn: html [
	<category: 'rendering-attributes'>
	(html heading)
	    level: 2;
	    with: 'Configuration'.
	html table: 
		[self configuration groupedAttributes do: 
			[:associaction | 
			html tableRow: 
				[(html tableData)
				    colSpan: 3;
				    with: 
					    [(html heading)
						level3;
						with: (self labelForSelector: associaction key)]].
			associaction value 
			    do: [:attribute | self renderAttribute: attribute on: html]]]
    ]

    renderButtonsOn: html [
	<category: 'rendering'>
	html break.
	html submitButton on: #save of: self.
	html submitButton on: #close of: self
    ]

    renderContentOn: html [
	<category: 'rendering'>
	super renderContentOn: html.
	html form: 
		[self renderFormOn: html.
		self renderButtonsOn: html]
    ]

    renderFormButtonsOn: html [
	<category: 'rendering'>
	html submitButton on: #save of: self.
	html submitButton on: #done of: self
    ]

    renderFormOn: html [
	<category: 'rendering'>
	self renderAncestryOn: html.
	self renderAttributesOn: html
    ]

    renderInheritanceForAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	self configuration inheritedValueAndSourceAt: anAttribute key
	    do: 
		[:value :source | 
		(self configuration hasLocalValueForAttribute: anAttribute) 
		    ifTrue: 
			[html tableData: 
				[(html anchor)
				    title: 'revert to ' , value printString , ', overriden from ' , source name;
				    callback: [self configuration clearValueForAttribute: anAttribute];
				    with: 'revert']]
		    ifFalse: 
			[html tableData: 
				[(html anchor)
				    title: 'inherited from ' , source name;
				    callback: [self configuration overrideAttribute: anAttribute];
				    with: 'override']].
		^self].
	(self configuration hasLocalValueForAttribute: anAttribute) 
	    ifTrue: 
		[html tableData: 
			[(html anchor)
			    callback: [self configuration clearValueForAttribute: anAttribute];
			    with: 'clear']]
	    ifFalse: 
		[html tableData: 
			[(html span)
			    class: 'unspecified';
			    with: '(unspecified)']]
    ]

    renderInheritedAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	html text: (self configuration valueForAttribute: anAttribute) printString
    ]

    renderInheritedValueForAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	| inheritedValue |
	inheritedValue := self configuration lookupValueAt: anAttribute key.
	inheritedValue isNil 
	    ifTrue: 
		[(html span)
		    class: 'unspecified';
		    with: '(unspecified)']
	    ifFalse: [html text: inheritedValue printString]
    ]

    renderOverrideForAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	(html anchor)
	    callback: [self configuration overrideAttribute: anAttribute];
	    with: 'edit'
    ]

    renderOverridenAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	anAttribute accept: self with: html
    ]

    renderParent: aConfiguration on: html [
	<category: 'rendering-ancestry'>
	html
	    text: aConfiguration name;
	    space.
	(self configuration hasMutableAncestry 
	    and: [self configuration ancestors includes: aConfiguration]) 
		ifTrue: 
		    [(html anchor)
			callback: [self configuration removeAncestor: aConfiguration];
			with: '(remove)']
    ]

    renderParentSelectorOn: html [
	<category: 'rendering-ancestry'>
	| selectedAncestor |
	selectedAncestor := WAValueHolder new.
	(html select)
	    selected: nil;
	    labels: [:each | each name];
	    list: self configuration potentialAncestors;
	    callback: [:value | selectedAncestor contents: value].
	html space.
	(html submitButton)
	    callback: [self configuration addAncestor: selectedAncestor contents];
	    text: 'Add'
    ]

    renderRevertForAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	(html anchor)
	    callback: [self configuration clearValueForAttribute: anAttribute];
	    with: 'clear'
    ]

    renderUnspecifiedAttribute: anAttribute on: html [
	<category: 'rendering-attributes'>
	anAttribute accept: self with: html
    ]

    save [
	<category: 'actions'>
	
    ]

    visitBooleanAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	(html select)
	    list: (Array with: true with: false);
	    selected: (self configuration valueForAttribute: anAttribute);
	    callback: [:value | self configuration takeValue: value forAttribute: anAttribute];
	    labels: [:bool | bool ifTrue: ['true'] ifFalse: ['false']]
    ]

    visitCollectionAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	| selected current |
	selected := WAValueHolder new.
	current := self configuration valueForAttribute: anAttribute.
	current do: [:each | html render: (anAttribute stringForValue: each)]
	    separatedBy: [html text: ', '].
	html break.
	(html select)
	    list: anAttribute options;
	    callback: [:value | selected contents: value].
	(html submitButton)
	    callback: 
		    [self configuration takeValue: (current copyWith: selected contents)
			forAttribute: anAttribute];
	    text: 'add'.
	(html submitButton)
	    callback: 
		    [self configuration takeValue: (current copyWithout: selected contents)
			forAttribute: anAttribute];
	    text: 'remove'
    ]

    visitListAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	(html select)
	    beOptional;
	    optionalLabel: '(none)';
	    list: anAttribute options asArray;
	    selected: (self configuration valueForAttribute: anAttribute);
	    callback: [:value | self configuration takeValue: value forAttribute: anAttribute]
    ]

    visitNumberAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	(html textInput)
	    size: 5;
	    callback: 
		    [:value | 
		    self configuration takeValue: value asNumber forAttribute: anAttribute];
	    value: (self configuration valueForAttribute: anAttribute)
    ]

    visitPasswordAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	html passwordInput callback: 
		[:value | 
		self configuration takeValue: (anAttribute valueFromString: value)
		    forAttribute: anAttribute]
    ]

    visitStringAttribute: anAttribute with: html [
	<category: 'rendering-visitors'>
	(html textInput)
	    callback: 
		    [:value | 
		    self configuration takeValue: (anAttribute valueFromString: value)
			forAttribute: anAttribute];
	    value: (self configuration valueForAttribute: anAttribute)
    ]
]



WAHandlerEditor subclass: WADispatcherComponent [
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    dispatcher: aHandler [
	<category: 'accessing'>
	handler := aHandler
    ]

    entryPoints [
	"Answer a dictionary of the visible entry points."

	<category: 'accessing'>
	^self handler entryPoints select: [:each | each isEntryPoint]
    ]

    initialize [
	<category: 'initialization'>
	super initialize.
	self initializeOn: self application parent
    ]

    renderContentOn: html [
	<category: 'rendering'>
	super renderContentOn: html.
	self renderDispatcherOn: html
    ]

    renderDispatcherOn: html [
	<category: 'rendering'>
	html table: 
		[self handler isRoot 
		    ifFalse: 
			[self 
			    renderRow: self handler parent
			    named: '..'
			    on: html].
		self entryPoints keysSortedSafely do: 
			[:each | 
			self 
			    renderRow: (self handler entryPoints at: each)
			    named: each
			    on: html]]
    ]

    renderRow: anEntryPoint named: aString on: html [
	<category: 'rendering-rows'>
	html tableRow: 
		[html tableData: 
			[self 
			    renderRowName: anEntryPoint
			    named: aString
			    on: html].
		html tableData: 
			[self 
			    renderRowDescription: anEntryPoint
			    named: aString
			    on: html].
		html tableData: 
			[self 
			    renderRowActions: anEntryPoint
			    named: aString
			    on: html]]
    ]

    renderRowActions: anEntryPoint named: aString on: html [
	<category: 'rendering-rows'>
	
    ]

    renderRowDescription: anEntryPoint named: aString on: html [
	<category: 'rendering-rows'>
	aString = self upDirectory 
	    ifFalse: [html render: anEntryPoint description]
	    ifTrue: [html render: 'Parent Directory']
    ]

    renderRowName: anEntryPoint named: aString on: html [
	<category: 'rendering-rows'>
	anEntryPoint isDispatcher 
	    ifTrue: 
		[(html anchor)
		    callback: [self dispatcher: anEntryPoint];
		    with: aString]
	    ifFalse: 
		[(html anchor)
		    url: anEntryPoint basePath , '/';
		    with: aString]
    ]

    states [
	<category: 'accessing'>
	^Array with: self
    ]

    upDirectory [
	<category: 'accessing'>
	^'..'
    ]
]



WADispatcherComponent subclass: WADispatcherEditor [
    | name type |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WADispatcherEditor class >> canBeRoot [
	<category: 'accessing'>
	^true
    ]

    WADispatcherEditor class >> description [
	<category: 'accessing'>
	^'Dispatcher Editor'
    ]

    WADispatcherEditor class >> initialize [
	<category: 'initialization'>
	self registerAsApplication: 'config'
    ]

    addEntryPoint [
	<category: 'actions'>
	| newHandler editorCommand |
	(name isNil or: [name isEmpty]) 
	    ifTrue: [^self inform: 'You must enter a path-name.'].
	newHandler := type register: name.
	editorCommand := WAConfigureDispatcherPlugin on: newHandler for: self.
	editorCommand isActive ifTrue: [editorCommand execute]
    ]

    clearCaches [
	<category: 'actions'>
	WARegistry clearAllHandlers.
	Smalltalk garbageCollect
    ]

    entryPointClasses [
	<category: 'accessing'>
	^WAEntryPoint concreteSubclasses 
	    asSortedCollection: [:a :b | a name < b name]
    ]

    initialize [
	<category: 'initialization'>
	super initialize.
	type := WAApplication.
	name := String new
    ]

    renderAddEntryPointOn: html [
	<category: 'rendering-parts'>
	(html heading)
	    level: 3;
	    with: 'Add entry point'.
	html form: 
		[html table: 
			[html tableRow: 
				[(html tableData)
				    class: 'label';
				    with: 'Name: '.
				html tableData: [html textInput callback: [:value | name := value]]].
			html tableRow: 
				[(html tableData)
				    class: 'label';
				    with: 'Type: '.
				html tableData: 
					[(html select)
					    selected: type;
					    list: self entryPointClasses;
					    callback: [:value | type := value];
					    labels: [:each | each description].
					html space.
					(html submitButton)
					    callback: [self addEntryPoint];
					    text: 'Add']]]]
    ]

    renderContentOn: html [
	<category: 'rendering'>
	super renderContentOn: html.
	self renderSettingsOn: html.
	self renderStatisticsOn: html
    ]

    renderDefaultEntryPointOn: html [
	<category: 'rendering-parts'>
	(html heading)
	    level: 3;
	    with: 'Default entry point'.
	html form: 
		[(html select)
		    beOptional;
		    optionalLabel: '(none)';
		    list: self handler entryPoints keysSortedSafely;
		    on: #defaultName of: self handler.
		html space.
		html submitButton]
    ]

    renderRowActions: anEntryPoint named: aString on: html [
	<category: 'rendering-rows'>
	aString = self upDirectory ifTrue: [^nil].
	(WADispatcherPlugin allSubclassesOn: anEntryPoint for: self) 
	    do: [:each | html render: each]
	    separatedBy: [html text: ' ']
    ]

    renderSettingsOn: html [
	<category: 'rendering'>
	(html heading)
	    level: 2;
	    with: 'Settings'.
	self renderDefaultEntryPointOn: html.
	self renderAddEntryPointOn: html
    ]

    renderStatisticsOn: html [
	<category: 'rendering'>
	(html heading)
	    level: 2;
	    with: 'Statistics'.
	html preformatted: SeasidePlatformSupport vmStatisticsReportString.
	(html anchor)
	    callback: [self clearCaches];
	    with: 'Clear Caches'
    ]
]



WADispatcherComponent subclass: WADispatcherViewer [
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WADispatcherViewer class >> canBeRoot [
	<category: 'accessing'>
	^true
    ]

    WADispatcherViewer class >> description [
	<category: 'accessing'>
	^'Dispatcher Viewer'
    ]

    WADispatcherViewer class >> initialize [
	<category: 'initialization'>
	self registerAsApplication: 'browse'.
	WADispatcher default defaultName: 'browse'
    ]

    entryPoints [
	<category: 'accessing'>
	^super entryPoints 
	    select: [:each | each isDispatcher or: [each isApplication]]
    ]
]



WAHandlerEditor subclass: WAFileDirectoryEditor [
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    renderConfigurationOn: html [
	<category: 'rendering'>
	html form: 
		[html textInput on: #directory of: self handler.
		html submitButton]
    ]

    renderContentOn: html [
	<category: 'rendering'>
	super renderContentOn: html.
	self renderConfigurationOn: html
    ]
]



WAHandlerEditor subclass: WAFileHandlerEditor [
    | fileHandler |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    basePath [
	<category: 'accessing'>
	^self handler basePath
    ]

    configureLibrary: aLibrary [
	<category: 'actions'>
	self call: aLibrary configurationComponent
    ]

    libraries [
	<category: 'accessing'>
	^self handler libraries asSortedCollection: [:a :b | a name < b name]
    ]

    renderContentOn: html [
	<category: 'rendering'>
	super renderContentOn: html.
	html table: 
		[self libraries do: 
			[:each | 
			html tableRow: 
				[html tableData: each name.
				html tableData: 
					[(html anchor)
					    callback: [self configureLibrary: each default];
					    with: 'configure']]]].
	html form: 
		[(html submitButton)
		    callback: [self answer];
		    text: 'close']
    ]
]



WAComponent subclass: WAInspector [
    | path selected input |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    WAInspector class >> on: anObject [
	<category: 'instance creation'>
	^self new object: anObject
    ]

    children [
	<category: 'accessing'>
	^Array with: path
    ]

    chooseObject: anObject named: aString [
	<category: 'actions'>
	path pushSegment: anObject name: aString.
	selected := nil
    ]

    doIt [
	<category: 'actions'>
	| result |
	result := self evaluate.
	selected ifNil: [^self].
	selected isNumber 
	    ifTrue: [self object at: selected put: result]
	    ifFalse: [self object instVarNamed: selected put: result]
    ]

    evaluate [
	<category: 'actions'>
	^self object class evaluatorClass new 
	    evaluate: input
	    in: thisContext
	    to: self object
    ]

    initialize [
	<category: 'initialize-release'>
	super initialize.
	path := WAPath new
    ]

    inspectIt [
	<category: 'actions'>
	| result |
	result := self evaluate.
	self chooseObject: result named: result printString
    ]

    isPrimitiveType: anObject [
	<category: 'testing'>
	^anObject isNumber 
	    or: [anObject isNil or: [anObject == true or: [anObject == false]]]
    ]

    object [
	<category: 'accessing'>
	^path currentSegment
    ]

    object: anObject [
	<category: 'accessing'>
	self chooseObject: anObject named: anObject printString
    ]

    renderContentOn: html [
	<category: 'rendering'>
	(html heading)
	    level: 1;
	    with: (self object printStringLimitedTo: 50).
	html render: path.
	html form: 
		[self renderMembersOn: html.
		self renderEditAreaOn: html]
    ]

    renderEditAreaOn: html [
	<category: 'rendering'>
	(html textArea)
	    value: input;
	    callback: [:value | input := value].
	html break.
	(html submitButton)
	    callback: [self doIt];
	    text: 'do it'.
	(html submitButton)
	    callback: [self inspectIt];
	    text: 'inspect it'
    ]

    renderMembersOn: html [
	<category: 'rendering'>
	| members radioGroup |
	selected := nil.
	members := self object inspectorFields.
	members isEmpty ifTrue: [^self].
	radioGroup := html radioGroup.
	html table: 
		[members associationsDo: 
			[:association | 
			self 
			    renderRow: association value
			    named: association key
			    group: radioGroup
			    on: html]]
    ]

    renderRow: anObject named: aString group: aRadioGroup on: html [
	<category: 'rendering'>
	| radioButton |
	html tableRow: 
		[html tableHeading: 
			[radioButton := (aRadioGroup radioButton)
				    ensureId;
				    callback: [selected := aString];
				    yourself.
			(html label)
			    for: radioButton id;
			    with: 
				    [(self isPrimitiveType: anObject) 
					ifTrue: [html text: aString]
					ifFalse: 
					    [(html anchor)
						callback: [self chooseObject: anObject named: aString];
						with: aString]]].
		html tableData: (anObject printStringLimitedTo: 100)]
    ]

    style [
	<category: 'accessing'>
	^'form {
	padding: 2px;
	margin: 0;
}
form th {
	text-align: left;
	padding-right: 2em;
}
form textarea {
	width: 100%;
	height: 100px;
	border: 1px solid #aaa;
}'
    ]
]



WAComponent subclass: WAStringLibraryEditor [
    | library |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    library [
	<category: 'accessing'>
	^library
    ]

    library: aLibrary [
	<category: 'accessing'>
	library := aLibrary
    ]

    renderContentOn: html [
	<category: 'rendering'>
	self renderHeadingsOn: html.
	self renderFilesOn: html.
	self renderWriteToDiskOn: html.
	self renderDoneOn: html
    ]

    renderDoneOn: html [
	<category: 'rendering'>
	html form: 
		[(html submitButton)
		    callback: [self answer];
		    text: 'close']
    ]

    renderFilesOn: html [
	<category: 'rendering'>
	html unorderedList: 
		[self library filenames do: 
			[:each | 
			html listItem: 
				[(html anchor)
				    class: 'download';
				    url: (self urlFor: each);
				    with: each]]]
    ]

    renderHeadingsOn: html [
	<category: 'rendering'>
	html heading: self library name
    ]

    renderWriteToDiskOn: html [
	<category: 'rendering'>
	html form: 
		[(html submitButton)
		    callback: [self library deployFiles];
		    title: 'write all the files to disk';
		    text: 'write to disk']
    ]

    urlFor: aFilename [
	<category: 'private'>
	^self library urlForFile: aFilename
    ]
]



WAStringLibraryEditor subclass: WAFileLibraryEditor [
    | renamingFile newName |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    renderAddFileOn: html [
	<category: 'rendering'>
	(html form)
	    multipart;
	    with: 
		    [html text: 'Add File: '.
		    html fileUpload on: #addFile of: self library.
		    html space.
		    html submitButton text: 'Add']
    ]

    renderContentOn: html [
	<category: 'rendering'>
	self renderHeadingsOn: html.
	self renderAddFileOn: html.
	self renderFilesOn: html.
	self renderWriteToDiskOn: html.
	self renderDoneOn: html
    ]

    renderFile: fileName on: html [
	<category: 'rendering'>
	html tableData: 
		[(html anchor)
		    class: 'download';
		    url: (self urlFor: fileName);
		    with: fileName].
	html tableData: 
		[(html anchor)
		    callback: [self library removeFile: fileName];
		    with: 'remove'.
		html space.
		(html anchor)
		    callback: [renamingFile := fileName];
		    with: 'rename']
    ]

    renderFilesOn: html [
	<category: 'rendering'>
	html table: 
		[self library filenames asSortedCollection do: 
			[:each | 
			html tableRow: 
				[renamingFile = each 
				    ifTrue: [self renderRenameFormForFile: each on: html]
				    ifFalse: [self renderFile: each on: html]]]]
    ]

    renderRenameFormForFile: fileName on: html [
	<category: 'rendering'>
	(html tableData)
	    colSpan: 2;
	    with: 
		    [html form: 
			    [(html textInput)
				value: fileName;
				callback: [:value | newName := value].
			    (html submitButton)
				callback: 
					[self library renameFile: fileName to: newName.
					renamingFile := nil];
				text: 'rename'.
			    (html cancelButton)
				callback: [renamingFile := nil];
				text: 'cancel']]
    ]

    updateRoot: anHtmlRoot [
	<category: 'path'>
	super updateRoot: anHtmlRoot.
	anHtmlRoot title: self library name
    ]
]



WAComponent subclass: WATool [
    | root |
    
    <comment: nil>
    <category: 'Seaside-Development-Core'>

    root [
	"Answer the root component of the application."

	<category: 'accessing'>
	^root
    ]

    root: aComponent [
	<category: 'accessing'>
	root := aComponent
    ]
]



WAComponent subclass: WAWalkback [
    | exception frames limit |
    
    <comment: 'I am a component that renders an exeception stack with temporary variables. Per default I renders the top stack frames only, but I offers the option to render all. I also offers the option to open a debugger in the image or to proceed with the execution.'>
    <category: 'Seaside-Development-Core'>

    WAWalkback class >> exception: anException [
	<category: 'instance-creation'>
	^self new initializeWithException: anException
    ]

    exception [
	<category: 'accessing'>
	^exception
    ]

    frames [
	<category: 'accessing'>
	^frames first: limit
    ]

    initializeWithException: anException [
	<category: 'initialization'>
	| context |
	exception := anException.
	context := anException signalerContext.
	frames := OrderedCollection new.
	[context isNil] whileFalse: 
		[frames add: context.
		context := context sender].
	limit := 5 min: frames size
    ]

    renderContentOn: html [
	<category: 'rendering'>
	self renderHeadingOn: html.
	self renderToolsOn: html.
	self renderExceptionOn: html.
	self renderStackOn: html
    ]

    renderExceptionOn: html [
	<category: 'rendering'>
	| problems |
	problems := self exception possibleCauses.
	problems isEmpty ifTrue: [^self].
	(html heading)
	    level: 3;
	    with: 'Possible Causes'.
	html unorderedList list: problems
    ]

    renderHeadingOn: html [
	<category: 'rendering'>
	(html heading)
	    level: 1;
	    with: 'Seaside Walkback'.
	(html heading)
	    level: 2;
	    with: self exception description
    ]

    renderObject: anObject labelled: aString on: html [
	<category: 'rendering-stack'>
	html definitionTerm: 
		[(html anchor)
		    callback: [(WAInspectorPlugin on: anObject for: self) execute];
		    with: aString].
	html definitionData: (self safePrintString: anObject)
    ]

    renderStackFrame: aContext on: html [
	<category: 'rendering-stack'>
	html definitionList: 
		[self 
		    renderObject: aContext
		    labelled: 'thisContext'
		    on: html.
		self 
		    renderObject: aContext receiver
		    labelled: 'self'
		    on: html.
		aContext tempNames keysAndValuesDo: 
			[:index :name | 
			self 
			    renderObject: (aContext tempAt: index)
			    labelled: name
			    on: html]]
    ]

    renderStackOn: html [
	<category: 'rendering'>
	(html heading)
	    level: 3;
	    with: 'Stack Trace'.
	html orderedList: 
		[self frames 
		    do: [:each | html listItem: [self renderStackFrame: each on: html]]]
    ]

    renderToolsOn: html [
	<category: 'rendering'>
	html paragraph: 
		[(html anchor)
		    callback: [self answer: true];
		    title: 'Open a debugger in your IDE and block until you hit "Proceed"';
		    with: 'Debug'.
		self exception isResumable 
		    ifTrue: 
			[html space.
			(html anchor)
			    callback: [self answer: false];
			    with: 'Proceed'].
		limit < frames size 
		    ifTrue: 
			[html space.
			(html anchor)
			    callback: [limit := frames size];
			    with: 'Full Stack']]
    ]

    safePrintString: anObject [
	<category: 'private'>
	^[anObject printStringLimitedTo: 100] on: Error
	    do: [:err | 'unprintable ' , anObject class name]
    ]

    updateRoot: aHtmlRoot [
	<category: 'updating'>
	super updateRoot: aHtmlRoot.
	aHtmlRoot title: self exception description.
	aHtmlRoot bodyAttributes addClass: 'walkback'.
	WAHandlerEditorFiles default updateRoot: aHtmlRoot
    ]
]



WALibrary extend [

    configurationComponent [
	<category: '*seaside-development-core'>
	self subclassResponsibility
    ]

]



Object subclass: WAPlugin [
    | target requestor |
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I am an abstract root class for all plugins. Plugins are an easy way to add or remove additional tools without changing the codebase. To add a new plugin make sure you choose the right superclass so that the tool can detect your code.

The appearance of all plugins, such as icons, has to be configured using CSS.'>

    WAPlugin class >> allSubclassesOn: aTargetObject for: aRequestorObject [
	<category: 'instance-creation'>
	| plugins |
	plugins := self allSubclasses 
		    collect: [:each | each on: aTargetObject for: aRequestorObject].
	^plugins asSortedCollection
    ]

    WAPlugin class >> on: aTargetObject for: aRequestorObject [
	<category: 'instance-creation'>
	^self basicNew initializeTarget: aTargetObject requestor: aRequestorObject
    ]

    <= aPlugin [
	<category: 'comparing'>
	^self priority <= aPlugin priority
    ]

    cssClass [
	"Answer a CSS class that will be applied to an automatically rendered link. nil means no class"

	<category: 'accessing'>
	^nil
    ]

    execute [
	"Execute the receiving plugin."

	<category: 'actions'>
	
    ]

    initializeTarget: aTargetObject requestor: aRequestorObject [
	<category: 'initialization'>
	target := aTargetObject.
	requestor := aRequestorObject
    ]

    isActive [
	"Answer wheter the plugin is usable with the current target."

	<category: 'testing'>
	^true
    ]

    label [
	"Answer the menu label of the plugin."

	<category: 'accessing'>
	^self printString
    ]

    open: aComponent [
	"Replace the current page with aComponent."

	<category: 'actions'>
	WARenderLoop new call: (aComponent
		    addDecoration: ((WAWindowDecoration new)
				cssClass: self cssClass;
				title: self label;
				yourself);
		    yourself)
    ]

    priority [
	"Answer a number used to sort the receiver. A lower number means it appears earlier on."

	<category: 'accessing'>
	^0
    ]

    renderOn: html [
	"A default render method to display the interface of the receiving plugin. Might be overriden with specific behavior in subclasses."

	<category: 'rendering'>
	self isActive ifFalse: [^self].
	(html anchor)
	    title: self tooltip;
	    class: self cssClass;
	    callback: [self execute];
	    with: self label
    ]

    requestor [
	"Answer the requestor component the plugin is working on."

	<category: 'accessing'>
	^requestor
    ]

    target [
	"Answer the target object the plugin is working on."

	<category: 'accessing'>
	^target
    ]

    tooltip [
	"Answer a tooltip string that is displayed on the plugin link or button."

	<category: 'accessing'>
	^nil
    ]
]



WAPlugin subclass: WADispatcherPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'Abstract root class for all plugins that add an action for an application to the dispatcher editor.'>
]



WADispatcherPlugin subclass: WAConfigureDispatcherPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I display the configuration dialog of an application. See WAApplication >> #configurationComponent'>

    execute [
	<category: 'actions'>
	self requestor call: self target configurationComponent
    ]

    isActive [
	<category: 'testing'>
	^self target configurationComponent notNil
    ]

    label [
	<category: 'accessing'>
	^'Configure'
    ]

    priority [
	<category: 'accessing'>
	^100
    ]
]



WADispatcherPlugin subclass: WACopyDispatcherPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I make a copy of an application.'>

    execute [
	<category: 'actions'>
	| name |
	name := self requestor 
		    request: 'Name'
		    label: 'add'
		    default: self target name.
	name ifNil: [^self].
	self requestor handler register: (self target copy setName: name)
    ]

    label [
	<category: 'accessing'>
	^'Copy'
    ]

    priority [
	<category: 'accessing'>
	^200
    ]
]



WADispatcherPlugin subclass: WARemoveDispatcherPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I remove an application.'>

    execute [
	<category: 'actions'>
	self requestor handler unregister: self target
    ]

    label [
	<category: 'accessing'>
	^'Remove'
    ]

    priority [
	<category: 'accessing'>
	^300
    ]
]



WAPlugin subclass: WAHaloPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'Abstract root class for all halo tools. They add functionality to the halo toolbar.'>

    EnableSeasideTools := nil.

    WAHaloPlugin class >> initialize [
	<category: 'initialization'>
	EnableSeasideTools := true
    ]

    cssClass [
	<category: 'accessing'>
	^(self class name allButFirst: 2) asLowercase
    ]

    renderOn: html [
	<category: 'rendering'>
	(html div)
	    class: self cssClass;
	    with: [super renderOn: html]
    ]
]



WAHaloPlugin subclass: WAClassnameHaloPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I display the class name of the component class.'>

    priority [
	<category: 'accessing'>
	^100
    ]

    renderOn: html [
	<category: 'rendering'>
	(html div)
	    class: self cssClass;
	    with: self target className
    ]
]



WAHaloPlugin subclass: WAInspectorPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I open an inspector on the component class.'>

    execute [
	<category: 'actions'>
	EnableSeasideTools 
	    ifTrue: [self open: (WAInspector on: self target)]
	    ifFalse: [self target inspect]
    ]

    label [
	<category: 'accessing'>
	^'Inspector'
    ]

    priority [
	<category: 'accessing'>
	^600
    ]

    tooltip [
	<category: 'accessing'>
	^'Object Inspector'
    ]
]



WAHaloPlugin subclass: WAModeHaloPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I control the rendering modes of the halo.'>

    priority [
	<category: 'accessing'>
	^900
    ]

    renderOn: html [
	<category: 'rendering'>
	(html div)
	    class: self cssClass;
	    with: 
		    [html text: '['.
		    self requestor modes do: 
			    [:each | 
			    (html anchor)
				class: 'active' if: self requestor mode = each;
				title: (self labelForSelector: each allButLast);
				callback: [self requestor mode: each];
				with: each first asUppercase]
			separatedBy: [html text: '|'].
		    html text: ']']
    ]
]



WAHaloPlugin subclass: WAStylesHaloPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I open the style editor on the component class.'>

    execute [
	<category: 'actions'>
	EnableSeasideTools 
	    ifTrue: [self open: (WAViewer on: self target)]
	    ifFalse: [Browser fullOnClass: self target class selector: #style]
    ]

    label [
	<category: 'accessing'>
	^'Styles'
    ]

    priority [
	<category: 'accessing'>
	^700
    ]

    tooltip [
	<category: 'accessing'>
	^'CSS Style Editor'
    ]
]



WAPlugin subclass: WAToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'Abstract root class for all development tool bar tools.'>

    cssClass [
	<category: 'accessing'>
	^(self class name allButFirst: 2) asLowercase
    ]
]



WAToolPlugin subclass: WAConfigureToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I display the configuration dialog for the currently active application'>

    execute [
	<category: 'actions'>
	self open: self target session application configurationComponent
    ]

    label [
	<category: 'accessing'>
	^'Configure'
    ]

    priority [
	<category: 'accessing'>
	^200
    ]
]



WAToolPlugin subclass: WADeprecationToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I display deprecation warnings.'>

    cssClass [
	<category: 'accessing'>
	^'deprecated'
    ]

    execute [
	<category: 'actions'>
	| result |
	result := self requestor confirm: 
			[:html | 
			html heading: 'Reset deprecated warnings?'.
			html unorderedList list: self requestor deprecated].
	result ifTrue: [self requestor clearDeprecated]
    ]

    isActive [
	<category: 'testing'>
	^self requestor deprecated notEmpty
    ]

    label [
	<category: 'accessing'>
	^'Deprecated'
    ]

    priority [
	<category: 'accessing'>
	^700
    ]
]



WAToolPlugin subclass: WANewSessionToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I create a new session.'>

    WANewSessionToolPlugin class >> title [
	<category: 'accessing'>
	^'New Session'
    ]

    execute [
	<category: 'actions'>
	| session |
	session := self requestor session.
	session
	    expire;
	    redirectTo: session newSessionUrl
    ]

    label [
	<category: 'accessing'>
	^'New Session'
    ]

    priority [
	<category: 'accessing'>
	^100
    ]
]



WAToolPlugin subclass: WATerminateToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I try to terminate the process handling this session. This can work of you''re at 100% CPU.'>

    label [
	<category: 'accessing'>
	^'Terminate'
    ]

    priority [
	<category: 'accessing'>
	^600
    ]

    renderOn: html [
	<category: 'rendering'>
	(html anchor)
	    url: (html context actionUrl withParameter: 'terminate');
	    with: self label
    ]
]



WAToolPlugin subclass: WATimeingToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I display render and callback times.'>

    priority [
	<category: 'accessing'>
	^900
    ]

    renderOn: html [
	<category: 'rendering'>
	(html span)
	    title: 'Render Time';
	    with: self requestor renderTime.
	html text: '/'.
	(html span)
	    title: 'Callback Time';
	    with: self requestor processTime.
	html text: ' ms'
    ]
]



WAToolPlugin subclass: WAToggleHalosToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I toggle halos on and off.'>

    execute [
	<category: 'actions'>
	self requestor toggleHalos
    ]

    label [
	<category: 'accessing'>
	^'Toggle Halos'
    ]

    priority [
	<category: 'accessing'>
	^300
    ]
]



WAToolPlugin subclass: WAValidateToolPlugin [
    
    <category: 'Seaside-Development-Core-Plugins'>
    <comment: 'I validate and XHTML page by sending it to the W3C validator. I only work if the website is publically available.'>

    label [
	<category: 'accessing'>
	^'XHTML'
    ]

    priority [
	<category: 'accessing'>
	^800
    ]

    renderOn: html [
	<category: 'rendering'>
	(html anchor)
	    title: 'Validate XHTML';
	    url: 'http://validator.w3.org/check/referer';
	    with: self label
    ]
]



Eval [
    WADispatcherEditor initialize.
    WADispatcherViewer initialize.
    WAHaloPlugin initialize
]

PK
     Պ-N        package.xmlUT	 R;\R;\ux     <package>
  <name>Seaside-Development</name>
  <namespace>Seaside</namespace>
  <prereq>Seaside-Core</prereq>

  <filein>Seaside-Development-Core.st</filein>
  <file>ChangeLog</file>
</package>PK    -NaT9      	             ChangeLogUT ;\ux     PK
     -N᥀g@ @              Seaside-Development-Core.stUT ;\ux     PK
     Պ-N                A package.xmlUT R;\ux     PK        B   