/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;
import sun.misc.FpUtils;

public final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    private StrictMath() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static strictfp double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static strictfp double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double sqrt(double var0);

    public static native double cbrt(double var0);

    public static native double IEEEremainder(double var0, double var2);

    public static double ceil(double a) {
        return StrictMath.floorOrCeil(a, -0.0, 1.0, 1.0);
    }

    public static double floor(double a) {
        return StrictMath.floorOrCeil(a, -1.0, 0.0, -1.0);
    }

    private static double floorOrCeil(double a, double negativeBoundary, double positiveBoundary, double sign) {
        int exponent = Math.getExponent(a);
        if (exponent < 0) {
            return a == 0.0 ? a : (a < 0.0 ? negativeBoundary : positiveBoundary);
        }
        if (exponent >= 52) {
            return a;
        }
        assert (exponent >= 0 && exponent <= 51);
        long mask = 0xFFFFFFFFFFFFFL >> exponent;
        long doppel = Double.doubleToRawLongBits(a);
        if ((mask & doppel) == 0L) {
            return a;
        }
        double result = Double.longBitsToDouble(doppel & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        if (sign * a > 0.0) {
            result += sign;
        }
        return result;
    }

    public static double rint(double a) {
        double twoToThe52 = 4.503599627370496E15;
        double sign = FpUtils.rawCopySign(1.0, a);
        if ((a = Math.abs(a)) < twoToThe52) {
            a = twoToThe52 + a - twoToThe52;
        }
        return sign * a;
    }

    public static native double atan2(double var0, double var2);

    public static native double pow(double var0, double var2);

    public static int round(float a) {
        return Math.round(a);
    }

    public static long round(double a) {
        return Math.round(a);
    }

    private static synchronized Random initRNG() {
        Random rnd = randomNumberGenerator;
        return rnd == null ? (randomNumberGenerator = new Random()) : rnd;
    }

    public static double random() {
        Random rnd = randomNumberGenerator;
        if (rnd == null) {
            rnd = StrictMath.initRNG();
        }
        return rnd.nextDouble();
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    public static double abs(double a) {
        return a <= 0.0 ? 0.0 - a : a;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(a) == negativeZeroFloatBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(a) == negativeZeroDoubleBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(b) == negativeZeroFloatBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(b) == negativeZeroDoubleBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    public static double ulp(double d) {
        return FpUtils.ulp(d);
    }

    public static float ulp(float f) {
        return FpUtils.ulp(f);
    }

    public static double signum(double d) {
        return FpUtils.signum(d);
    }

    public static float signum(float f) {
        return FpUtils.signum(f);
    }

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double tanh(double var0);

    public static native double hypot(double var0, double var2);

    public static native double expm1(double var0);

    public static native double log1p(double var0);

    public static double copySign(double magnitude, double sign) {
        return FpUtils.copySign(magnitude, sign);
    }

    public static float copySign(float magnitude, float sign) {
        return FpUtils.copySign(magnitude, sign);
    }

    public static int getExponent(float f) {
        return FpUtils.getExponent(f);
    }

    public static int getExponent(double d) {
        return FpUtils.getExponent(d);
    }

    public static double nextAfter(double start, double direction) {
        return FpUtils.nextAfter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        return FpUtils.nextAfter(start, direction);
    }

    public static double nextUp(double d) {
        return FpUtils.nextUp(d);
    }

    public static float nextUp(float f) {
        return FpUtils.nextUp(f);
    }

    public static double scalb(double d, int scaleFactor) {
        return FpUtils.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return FpUtils.scalb(f, scaleFactor);
    }

    static {
        negativeZeroFloatBits = Float.floatToRawIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToRawLongBits(-0.0);
    }
}

