/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.SpanIterator;

class XorCopyArgbToAny
extends Blit {
    XorCopyArgbToAny() {
        super(SurfaceType.IntArgb, CompositeType.Xor, SurfaceType.Any);
    }

    @Override
    public void Blit(SurfaceData src, SurfaceData dst, Composite comp, Region clip, int srcx, int srcy, int dstx, int dsty, int w, int h) {
        Raster srcRast = src.getRaster(srcx, srcy, w, h);
        IntegerComponentRaster icr = (IntegerComponentRaster)srcRast;
        int[] srcPix = icr.getDataStorage();
        WritableRaster dstRast = (WritableRaster)dst.getRaster(dstx, dsty, w, h);
        ColorModel dstCM = dst.getColorModel();
        Region roi = CustomComponent.getRegionOfInterest(src, dst, clip, srcx, srcy, dstx, dsty, w, h);
        SpanIterator si = roi.getSpanIterator();
        int xorrgb = ((XORComposite)comp).getXorColor().getRGB();
        Object xorPixel = dstCM.getDataElements(xorrgb, null);
        Object srcPixel = null;
        Object dstPixel = null;
        int srcScan = icr.getScanlineStride();
        srcx -= dstx;
        srcy -= dsty;
        int[] span = new int[4];
        while (si.nextSpan(span)) {
            int rowoff = icr.getDataOffset(0) + (srcy + span[1]) * srcScan + (srcx + span[0]);
            for (int y = span[1]; y < span[3]; ++y) {
                int off = rowoff;
                for (int x = span[0]; x < span[2]; ++x) {
                    srcPixel = dstCM.getDataElements(srcPix[off++], srcPixel);
                    dstPixel = dstRast.getDataElements(x, y, dstPixel);
                    switch (dstCM.getTransferType()) {
                        case 0: {
                            byte[] bytesrcarr = (byte[])srcPixel;
                            byte[] bytedstarr = (byte[])dstPixel;
                            byte[] bytexorarr = (byte[])xorPixel;
                            for (int i = 0; i < bytedstarr.length; ++i) {
                                int n = i;
                                bytedstarr[n] = (byte)(bytedstarr[n] ^ (bytesrcarr[i] ^ bytexorarr[i]));
                            }
                            break;
                        }
                        case 1: 
                        case 2: {
                            short[] shortsrcarr = (short[])srcPixel;
                            short[] shortdstarr = (short[])dstPixel;
                            short[] shortxorarr = (short[])xorPixel;
                            for (int i = 0; i < shortdstarr.length; ++i) {
                                int n = i;
                                shortdstarr[n] = (short)(shortdstarr[n] ^ (shortsrcarr[i] ^ shortxorarr[i]));
                            }
                            break;
                        }
                        case 3: {
                            int[] intsrcarr = (int[])srcPixel;
                            int[] intdstarr = (int[])dstPixel;
                            int[] intxorarr = (int[])xorPixel;
                            for (int i = 0; i < intdstarr.length; ++i) {
                                int n = i;
                                intdstarr[n] = intdstarr[n] ^ (intsrcarr[i] ^ intxorarr[i]);
                            }
                            break;
                        }
                        case 4: {
                            float[] floatsrcarr = (float[])srcPixel;
                            float[] floatdstarr = (float[])dstPixel;
                            float[] floatxorarr = (float[])xorPixel;
                            for (int i = 0; i < floatdstarr.length; ++i) {
                                int v = Float.floatToIntBits(floatdstarr[i]) ^ Float.floatToIntBits(floatsrcarr[i]) ^ Float.floatToIntBits(floatxorarr[i]);
                                floatdstarr[i] = Float.intBitsToFloat(v);
                            }
                            break;
                        }
                        case 5: {
                            double[] doublesrcarr = (double[])srcPixel;
                            double[] doubledstarr = (double[])dstPixel;
                            double[] doublexorarr = (double[])xorPixel;
                            for (int i = 0; i < doubledstarr.length; ++i) {
                                long v = Double.doubleToLongBits(doubledstarr[i]) ^ Double.doubleToLongBits(doublesrcarr[i]) ^ Double.doubleToLongBits(doublexorarr[i]);
                                doubledstarr[i] = Double.longBitsToDouble(v);
                            }
                            break;
                        }
                        default: {
                            throw new InternalError("Unsupported XOR pixel type");
                        }
                    }
                    dstRast.setDataElements(x, y, dstPixel);
                }
                rowoff += srcScan;
            }
        }
    }
}

