/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient ReentrantLock lock = new ReentrantLock();
    private volatile transient Object[] array;
    private static final Unsafe UNSAFE;
    private static final long lockOffset;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] objectArray) {
        this.array = objectArray;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        Object[] objectArray;
        if (collection.getClass() == CopyOnWriteArrayList.class) {
            objectArray = ((CopyOnWriteArrayList)collection).getArray();
        } else {
            objectArray = collection.toArray();
            if (objectArray.getClass() != Object[].class) {
                objectArray = Arrays.copyOf(objectArray, objectArray.length, Object[].class);
            }
        }
        this.setArray(objectArray);
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.setArray(Arrays.copyOf(EArray, EArray.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int indexOf(Object object, Object[] objectArray, int n, int n2) {
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length);
    }

    public int indexOf(E e, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, objectArray, n, objectArray.length);
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, objectArray.length - 1);
    }

    public int lastIndexOf(E e, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(e, objectArray, n);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.resetLock();
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = this.getArray();
        return Arrays.copyOf(objectArray, objectArray.length);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        if (TArray.length < n) {
            return Arrays.copyOf(objectArray, n, TArray.getClass());
        }
        System.arraycopy(objectArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    private E get(Object[] objectArray, int n) {
        return (E)objectArray[n];
    }

    @Override
    public E get(int n) {
        return this.get(this.getArray(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            E e2 = this.get(objectArray, n);
            if (e2 != e) {
                int n2 = objectArray.length;
                Object[] objectArray2 = Arrays.copyOf(objectArray, n2);
                objectArray2[n] = e;
                this.setArray(objectArray2);
            } else {
                this.setArray(objectArray);
            }
            E e3 = e2;
            return e3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n = objectArray.length;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n + 1);
            objectArray2[n] = e;
            this.setArray(objectArray2);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            if (n > n2 || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                objectArray = Arrays.copyOf(objectArray2, n2 + 1);
            } else {
                objectArray = new Object[n2 + 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n, objectArray, n + 1, n3);
            }
            objectArray[n] = e;
            this.setArray(objectArray);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            E e = this.get(objectArray2, n);
            int n3 = n2 - n - 1;
            if (n3 == 0) {
                this.setArray(Arrays.copyOf(objectArray2, n2 - 1));
            } else {
                objectArray = new Object[n2 - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n + 1, objectArray, n, n3);
                this.setArray(objectArray);
            }
            objectArray = e;
            return (E)objectArray;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        Object[] objectArray = this.getArray();
        int n = CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length);
        return n < 0 ? false : this.remove(object, objectArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object object, Object[] objectArray, int n) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3;
            Object[] objectArray2;
            block9: {
                objectArray2 = this.getArray();
                n3 = objectArray2.length;
                if (objectArray != objectArray2) {
                    int n4 = Math.min(n, n3);
                    for (n2 = 0; n2 < n4; n2 += 1) {
                        if (objectArray2[n2] == objectArray[n2] || !CopyOnWriteArrayList.eq(object, objectArray2[n2])) continue;
                        n = n2;
                        break block9;
                    }
                    if (n >= n3) {
                        n2 = 0;
                        return n2 != 0;
                    }
                    if (objectArray2[n] != object && (n = CopyOnWriteArrayList.indexOf(object, objectArray2, n, n3)) < 0) {
                        n2 = 0;
                        return n2 != 0;
                    }
                }
            }
            Object[] objectArray3 = new Object[n3 - 1];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            System.arraycopy(objectArray2, n + 1, objectArray3, n, n3 - n - 1);
            this.setArray(objectArray3);
            n2 = 1;
            return n2 != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRange(int n, int n2) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = objectArray.length;
            if (n < 0 || n2 > n3 || n2 < n) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = n3 - (n2 - n);
            int n5 = n3 - n2;
            if (n5 == 0) {
                this.setArray(Arrays.copyOf(objectArray, n4));
            } else {
                Object[] objectArray2 = new Object[n4];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                System.arraycopy(objectArray, n2, objectArray2, n, n5);
                this.setArray(objectArray2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean addIfAbsent(E e) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, objectArray, 0, objectArray.length) >= 0 ? false : this.addIfAbsent(e, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfAbsent(E e, Object[] objectArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            if (objectArray != objectArray2) {
                int n3 = Math.min(objectArray.length, n2);
                for (n = 0; n < n3; n += 1) {
                    if (objectArray2[n] == objectArray[n] || !CopyOnWriteArrayList.eq(e, objectArray2[n])) continue;
                    boolean bl = false;
                    return bl;
                }
                if (CopyOnWriteArrayList.indexOf(e, objectArray2, n3, n2) >= 0) {
                    n = 0;
                    return n != 0;
                }
            }
            Object[] objectArray3 = Arrays.copyOf(objectArray2, n2 + 1);
            objectArray3[n2] = e;
            this.setArray(objectArray3);
            n = 1;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (Object obj : collection) {
            if (CopyOnWriteArrayList.indexOf(obj, objectArray, 0, n) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            if (n2) {
                int n3;
                n = 0;
                Object[] objectArray2 = new Object[n2];
                for (n3 = 0; n3 < n2; n3 += 1) {
                    Object object = objectArray[n3];
                    if (collection.contains(object)) continue;
                    objectArray2[n++] = object;
                }
                if (n != n2) {
                    this.setArray(Arrays.copyOf(objectArray2, n));
                    n3 = 1;
                    return n3 != 0;
                }
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            if (n2) {
                int n3;
                n = 0;
                Object[] objectArray2 = new Object[n2];
                for (n3 = 0; n3 < n2; n3 += 1) {
                    Object object = objectArray[n3];
                    if (!collection.contains(object)) continue;
                    objectArray2[n++] = object;
                }
                if (n != n2) {
                    this.setArray(Arrays.copyOf(objectArray2, n));
                    n3 = 1;
                    return n3 != 0;
                }
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (objectArray.length == 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray2 = this.getArray();
            int n2 = objectArray2.length;
            int n3 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                Object object = objectArray[n];
                if (CopyOnWriteArrayList.indexOf(object, objectArray2, 0, n2) >= 0 || CopyOnWriteArrayList.indexOf(object, objectArray, 0, n3) >= 0) continue;
                objectArray[n3++] = object;
            }
            if (n3 > 0) {
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n2 + n3);
                System.arraycopy(objectArray, 0, objectArray3, n2, n3);
                this.setArray(objectArray3);
            }
            n = n3;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.setArray(new Object[0]);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = collection.getClass() == CopyOnWriteArrayList.class ? ((CopyOnWriteArrayList)collection).getArray() : collection.toArray();
        if (objectArray.length == 0) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray3 = this.getArray();
            int n = objectArray3.length;
            if (n == 0 && objectArray.getClass() == Object[].class) {
                this.setArray(objectArray);
            } else {
                Object[] objectArray4 = Arrays.copyOf(objectArray3, n + objectArray.length);
                System.arraycopy(objectArray, 0, objectArray4, n, objectArray.length);
                this.setArray(objectArray4);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2;
            Object[] objectArray3 = this.getArray();
            int n2 = objectArray3.length;
            if (n > n2 || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
            }
            if (objectArray.length == 0) {
                boolean bl = false;
                return bl;
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                objectArray2 = Arrays.copyOf(objectArray3, n2 + objectArray.length);
            } else {
                objectArray2 = new Object[n2 + objectArray.length];
                System.arraycopy(objectArray3, 0, objectArray2, 0, n);
                System.arraycopy(objectArray3, n, objectArray2, n + objectArray.length, n3);
            }
            System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
            this.setArray(objectArray2);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        for (Object object : this.getArray()) {
            consumer.accept(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            if (n2) {
                int n3;
                n = 0;
                Object[] objectArray2 = new Object[n2];
                for (n3 = 0; n3 < n2; n3 += 1) {
                    Object object = objectArray[n3];
                    if (predicate.test(object)) continue;
                    objectArray2[n++] = object;
                }
                if (n != n2) {
                    this.setArray(Arrays.copyOf(objectArray2, n));
                    n3 = 1;
                    return n3 != 0;
                }
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        if (unaryOperator == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n = objectArray.length;
            Object[] objectArray2 = Arrays.copyOf(objectArray, n);
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                objectArray2[i] = unaryOperator.apply(object);
            }
            this.setArray(objectArray2);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> comparator) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            Object[] objectArray3 = objectArray = Arrays.copyOf(objectArray2, objectArray2.length);
            Arrays.sort(objectArray3, comparator);
            this.setArray(objectArray);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.getArray();
        objectOutputStream.writeInt(objectArray.length);
        for (Object object : objectArray) {
            objectOutputStream.writeObject(object);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resetLock();
        int n = objectInputStream.readInt();
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Object[].class, n);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.setArray(objectArray);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        Iterator iterator = list.iterator();
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (iterator.hasNext() && CopyOnWriteArrayList.eq(objectArray[i], iterator.next())) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object object : this.getArray()) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        Object[] objectArray = this.getArray();
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(objectArray, n);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.getArray(), 1040);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int n, int n2) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = objectArray.length;
            if (n < 0 || n2 > n3 || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            COWSubList cOWSubList = new COWSubList(this, n, n2);
            return cOWSubList;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void resetLock() {
        UNSAFE.putObjectVolatile(this, lockOffset, new ReentrantLock());
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<CopyOnWriteArrayList> clazz = CopyOnWriteArrayList.class;
            lockOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("lock"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> it;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> list, int n, int n2, int n3) {
            this.offset = n2;
            this.size = n3;
            this.it = list.listIterator(n + n2);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.it.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            int n = this.size;
            ListIterator<E> listIterator = this.it;
            while (this.nextIndex() < n) {
                consumer.accept(listIterator.next());
            }
        }
    }

    private static class COWSubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.getArray();
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                E e2 = this.l.set(n + this.offset, e);
                this.expectedArray = this.l.getArray();
                E e3 = e2;
                return e3;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                E e = this.l.get(n + this.offset);
                return e;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public int size() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                int n = this.size;
                return n;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, e);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public void clear() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                E e = this.l.remove(n + this.offset);
                this.expectedArray = this.l.getArray();
                --this.size;
                E e2 = e;
                return e2;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean remove(Object object) {
            int n = this.indexOf(object);
            if (n == -1) {
                return false;
            }
            this.remove(n);
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, 0, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                COWSubListIterator<E> cOWSubListIterator = new COWSubListIterator<E>(this.l, n, this.offset, this.size);
                return cOWSubListIterator;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n2 > this.size || n > n2) {
                    throw new IndexOutOfBoundsException();
                }
                COWSubList<E> cOWSubList = new COWSubList<E>(this.l, n + this.offset, n2 + this.offset);
                return cOWSubList;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = this.offset;
            int n2 = this.offset + this.size;
            Object[] objectArray = this.expectedArray;
            if (this.l.getArray() != objectArray) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n2 > objectArray.length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = n; i < n2; ++i) {
                Object object = objectArray[i];
                consumer.accept(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            if (unaryOperator == null) {
                throw new NullPointerException();
            }
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                int n = this.offset;
                int n2 = this.offset + this.size;
                Object[] objectArray = this.expectedArray;
                if (this.l.getArray() != objectArray) {
                    throw new ConcurrentModificationException();
                }
                int n3 = objectArray.length;
                if (n < 0 || n2 > n3) {
                    throw new IndexOutOfBoundsException();
                }
                Object[] objectArray2 = Arrays.copyOf(objectArray, n3);
                for (int i = n; i < n2; ++i) {
                    Object object = objectArray[i];
                    objectArray2[i] = unaryOperator.apply(object);
                }
                this.expectedArray = objectArray2;
                this.l.setArray(objectArray2);
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> comparator) {
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                Object[] objectArray;
                int n = this.offset;
                int n2 = this.offset + this.size;
                Object[] objectArray2 = this.expectedArray;
                if (this.l.getArray() != objectArray2) {
                    throw new ConcurrentModificationException();
                }
                int n3 = objectArray2.length;
                if (n < 0 || n2 > n3) {
                    throw new IndexOutOfBoundsException();
                }
                Object[] objectArray3 = objectArray = Arrays.copyOf(objectArray2, n3);
                Arrays.sort(objectArray3, n, n2, comparator);
                this.expectedArray = objectArray;
                this.l.setArray(objectArray);
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            boolean bl = false;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int n2 = this.offset;
                    int n3 = this.offset + n;
                    Object[] objectArray = this.expectedArray;
                    if (this.l.getArray() != objectArray) {
                        throw new ConcurrentModificationException();
                    }
                    int n4 = objectArray.length;
                    if (n2 < 0 || n3 > n4) {
                        throw new IndexOutOfBoundsException();
                    }
                    int n5 = 0;
                    Object[] objectArray2 = new Object[n];
                    for (int i = n2; i < n3; ++i) {
                        Object object = objectArray[i];
                        if (collection.contains(object)) continue;
                        objectArray2[n5++] = object;
                    }
                    if (n5 != n) {
                        Object[] objectArray3 = new Object[n4 - n + n5];
                        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                        System.arraycopy(objectArray2, 0, objectArray3, n2, n5);
                        System.arraycopy(objectArray, n3, objectArray3, n2 + n5, n4 - n3);
                        this.size = n5;
                        bl = true;
                        this.expectedArray = objectArray3;
                        this.l.setArray(objectArray3);
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            boolean bl = false;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int n2 = this.offset;
                    int n3 = this.offset + n;
                    Object[] objectArray = this.expectedArray;
                    if (this.l.getArray() != objectArray) {
                        throw new ConcurrentModificationException();
                    }
                    int n4 = objectArray.length;
                    if (n2 < 0 || n3 > n4) {
                        throw new IndexOutOfBoundsException();
                    }
                    int n5 = 0;
                    Object[] objectArray2 = new Object[n];
                    for (int i = n2; i < n3; ++i) {
                        Object object = objectArray[i];
                        if (!collection.contains(object)) continue;
                        objectArray2[n5++] = object;
                    }
                    if (n5 != n) {
                        Object[] objectArray3 = new Object[n4 - n + n5];
                        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                        System.arraycopy(objectArray2, 0, objectArray3, n2, n5);
                        System.arraycopy(objectArray, n3, objectArray3, n2 + n5, n4 - n3);
                        this.size = n5;
                        bl = true;
                        this.expectedArray = objectArray3;
                        this.l.setArray(objectArray3);
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            boolean bl = false;
            ReentrantLock reentrantLock = this.l.lock;
            reentrantLock.lock();
            try {
                int n = this.size;
                if (n > 0) {
                    int n2 = this.offset;
                    int n3 = this.offset + n;
                    Object[] objectArray = this.expectedArray;
                    if (this.l.getArray() != objectArray) {
                        throw new ConcurrentModificationException();
                    }
                    int n4 = objectArray.length;
                    if (n2 < 0 || n3 > n4) {
                        throw new IndexOutOfBoundsException();
                    }
                    int n5 = 0;
                    Object[] objectArray2 = new Object[n];
                    for (int i = n2; i < n3; ++i) {
                        Object object = objectArray[i];
                        if (predicate.test(object)) continue;
                        objectArray2[n5++] = object;
                    }
                    if (n5 != n) {
                        Object[] objectArray3 = new Object[n4 - n + n5];
                        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                        System.arraycopy(objectArray2, 0, objectArray3, n2, n5);
                        System.arraycopy(objectArray, n3, objectArray3, n2 + n5, n4 - n3);
                        this.size = n5;
                        bl = true;
                        this.expectedArray = objectArray3;
                        this.l.setArray(objectArray3);
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return bl;
        }

        @Override
        public Spliterator<E> spliterator() {
            int n = this.offset;
            int n2 = this.offset + this.size;
            Object[] objectArray = this.expectedArray;
            if (this.l.getArray() != objectArray) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n2 > objectArray.length) {
                throw new IndexOutOfBoundsException();
            }
            return Spliterators.spliterator(objectArray, n, n2, 1040);
        }
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] objectArray, int n) {
            this.cursor = n;
            this.snapshot = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            Object[] objectArray = this.snapshot;
            int n = objectArray.length;
            for (int i = this.cursor; i < n; ++i) {
                Object object = objectArray[i];
                consumer.accept(object);
            }
            this.cursor = n;
        }
    }
}

