#ifndef _EFL_UI_RELATIVE_LAYOUT_EO_H_
#define _EFL_UI_RELATIVE_LAYOUT_EO_H_

#ifndef _EFL_UI_RELATIVE_LAYOUT_EO_CLASS_TYPE
#define _EFL_UI_RELATIVE_LAYOUT_EO_CLASS_TYPE

typedef Eo Efl_Ui_Relative_Layout;

#endif

#ifndef _EFL_UI_RELATIVE_LAYOUT_EO_TYPES
#define _EFL_UI_RELATIVE_LAYOUT_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief The relative layout class.
 *
 * A relative layout calculates the size and position of all the children based
 * on their relationship to each other.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
#define EFL_UI_RELATIVE_LAYOUT_CLASS efl_ui_relative_layout_class_get()

EWAPI const Efl_Class *efl_ui_relative_layout_class_get(void);

/**
 * @brief Specifies the left side edge of the child relative to the target. By
 * default, target is parent and relative is 0.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[in] target The relative target.
 * @param[in] relative The ratio between left and right of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_left_set(Eo *obj, Efl_Object *child, Efl_Object *target, double relative);

/**
 * @brief Specifies the left side edge of the child relative to the target. By
 * default, target is parent and relative is 0.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[out] target The relative target.
 * @param[out] relative The ratio between left and right of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_left_get(const Eo *obj, Efl_Object *child, Efl_Object **target, double *relative);

/**
 * @brief Specifies the right side edge of the child relative to the target. By
 * default, target is parent and relative is 1.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[in] target The relative target.
 * @param[in] relative The ratio between left and right of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_right_set(Eo *obj, Efl_Object *child, Efl_Object *target, double relative);

/**
 * @brief Specifies the right side edge of the child relative to the target. By
 * default, target is parent and relative is 1.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[out] target The relative target.
 * @param[out] relative The ratio between left and right of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_right_get(const Eo *obj, Efl_Object *child, Efl_Object **target, double *relative);

/**
 * @brief Specifies the top side edge of the child relative to the target. By
 * default, target is parent and relative is 0.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[in] target The relative target.
 * @param[in] relative The ratio between top and bottom of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_top_set(Eo *obj, Efl_Object *child, Efl_Object *target, double relative);

/**
 * @brief Specifies the top side edge of the child relative to the target. By
 * default, target is parent and relative is 0.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[out] target The relative target.
 * @param[out] relative The ratio between top and bottom of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_top_get(const Eo *obj, Efl_Object *child, Efl_Object **target, double *relative);

/**
 * @brief Specifies the bottom side edge of the child relative to the target.
 * By default, target is parent and relative is 1.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[in] target The relative target.
 * @param[in] relative The ratio between top and bottom of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_bottom_set(Eo *obj, Efl_Object *child, Efl_Object *target, double relative);

/**
 * @brief Specifies the bottom side edge of the child relative to the target.
 * By default, target is parent and relative is 1.0.
 *
 * @param[in] obj The object.
 * @param[in] child The child to specify relation.
 * @param[out] target The relative target.
 * @param[out] relative The ratio between top and bottom of the target, ranging
 * from 0.0 to 1.0.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_relation_bottom_get(const Eo *obj, Efl_Object *child, Efl_Object **target, double *relative);

/**
 * @brief Remove all relations of the child.
 *
 * @param[in] obj The object.
 * @param[in] child The child to unregister
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_unregister(Eo *obj, Efl_Object *child);

/** Remove all relations from the registered children.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI void efl_ui_relative_layout_unregister_all(Eo *obj);

/**
 * @brief Begin iterating over this object's children.
 *
 * @param[in] obj The object.
 *
 * @return Iterator to object children.
 *
 * @ingroup Efl_Ui_Relative_Layout
 */
EOAPI Eina_Iterator *efl_ui_relative_layout_children_iterate(Eo *obj) EINA_WARN_UNUSED_RESULT;
#endif /* EFL_BETA_API_SUPPORT */

#endif
