#!/bin/sh

# kanji-config-updmap-sys: 
# copy of fmtutil-sys by Thomas Esser, public domain.

# wrapper script for updmap-setup-kanji with TEXMFVAR and TEXMFCONFIG set to
#   TEXMFSYSVAR / TEXMFSYSCONFIG

test -f /bin/ksh && test -z "$RUNNING_KSH" \
  && { UNAMES=`uname -s`; test "x$UNAMES" = xULTRIX; } 2>/dev/null \
  && { RUNNING_KSH=true; export RUNNING_KSH; exec /bin/ksh $0 ${1+"$@"}; }
unset RUNNING_KSH

test -f /bin/bsh && test -z "$RUNNING_BSH" \
  && { UNAMES=`uname -s`; test "x$UNAMES" = xAIX; } 2>/dev/null \
  && { RUNNING_BSH=true; export RUNNING_BSH; exec /bin/bsh $0 ${1+"$@"}; }
unset RUNNING_BSH

# hack around a bug in zsh:
test -n "${ZSH_VERSION+set}" && alias -g '${1+"$@"}'='"$@"'
export PATH

exec kanji-config-updmap --sys ${1+"$@"}

