/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

final class LazyLoader {
    private static final boolean NO_LAZY_LOADING = Boolean.getBoolean("nb.core.windows.no.lazy.loading");
    private boolean isActive = false;
    private boolean isLoading = false;
    private final Map<ModeImpl, LazyMode> lazyModes = new HashMap<ModeImpl, LazyMode>(15);

    public LazyLoader() {
        WindowManagerImpl.getInstance().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent windowSystemEvent) {
                LazyLoader.this.isLoading = false;
            }

            public void afterLoad(WindowSystemEvent windowSystemEvent) {
                LazyLoader.this.isActive = true;
                WindowManagerImpl.getInstance().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        LazyLoader.this.startLoading();
                    }
                });
            }

            public void beforeSave(WindowSystemEvent windowSystemEvent) {
                LazyLoader.this.isActive = false;
                LazyLoader.this.loadAllNow();
            }

            public void afterSave(WindowSystemEvent windowSystemEvent) {
            }
        });
    }

    void loadAllNow() {
        this.isActive = false;
        this.isLoading = true;
        PersistenceHandler persistenceHandler = PersistenceHandler.getDefault();
        for (LazyMode lazyMode : this.lazyModes.values()) {
            for (String string : lazyMode.getTopComponents()) {
                TopComponent topComponent = persistenceHandler.getTopComponentForID(string, true);
                if (null == topComponent || topComponent.isOpened()) continue;
                lazyMode.mode.addOpenedTopComponent(topComponent, lazyMode.getPosition(string));
            }
        }
        this.lazyModes.clear();
    }

    private void startLoading() {
        this.isLoading = true;
        ArrayList<LazyMode> arrayList = new ArrayList<LazyMode>(this.lazyModes.values());
        Collections.sort(arrayList);
        for (LazyMode lazyMode : arrayList) {
            Iterator<String> iterator = lazyMode.getTopComponents().iterator();
            while (iterator.hasNext()) {
                String string;
                final String string2 = string = iterator.next();
                final ModeImpl modeImpl = lazyMode.mode;
                final int n = lazyMode.getPosition(string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LazyLoader.this.loadNow(modeImpl, string2, n);
                    }
                });
            }
        }
    }

    void lazyLoad(ModeImpl modeImpl, String string, TCRefConfig tCRefConfig, int n) {
        if (NO_LAZY_LOADING || tCRefConfig.tc_id.equals(string) || this.isLoading) {
            TopComponent topComponent = PersistenceHandler.getDefault().getTopComponentForID(tCRefConfig.tc_id, true);
            if (topComponent != null) {
                modeImpl.addOpenedTopComponent(topComponent);
            }
            if (!NO_LAZY_LOADING) {
                LazyMode lazyMode = this.getLazyMode(modeImpl);
                lazyMode.selectedTCposition = n;
            }
        } else {
            modeImpl.addUnloadedTopComponent(tCRefConfig.tc_id);
            LazyMode lazyMode = this.getLazyMode(modeImpl);
            lazyMode.add(tCRefConfig.tc_id, n);
        }
    }

    private void loadNow(ModeImpl modeImpl, String string, int n) {
        if (!this.isActive) {
            return;
        }
        TopComponent topComponent = PersistenceHandler.getDefault().getTopComponentForID(string, true);
        if (null != topComponent && !topComponent.isOpened()) {
            if (n < 0) {
                n = modeImpl.getOpenedTopComponentsIDs().size();
            }
            modeImpl.addOpenedTopComponent(topComponent, n);
        }
        this.remove(modeImpl, string);
    }

    private void remove(ModeImpl modeImpl, String string) {
        LazyMode lazyMode = this.getLazyMode(modeImpl);
        lazyMode.id2position.remove(string);
    }

    private LazyMode getLazyMode(ModeImpl modeImpl) {
        LazyMode lazyMode = this.lazyModes.get(modeImpl);
        if (null == lazyMode) {
            lazyMode = new LazyMode(modeImpl);
            this.lazyModes.put(modeImpl, lazyMode);
        }
        return lazyMode;
    }

    private static class LazyMode
    implements Comparable<LazyMode> {
        private int selectedTCposition;
        private final ModeImpl mode;
        private final Map<String, Integer> id2position = new HashMap<String, Integer>(30);

        public LazyMode(ModeImpl modeImpl) {
            this.mode = modeImpl;
        }

        private void add(String string, int n) {
            this.id2position.put(string, n);
        }

        @Override
        public int compareTo(LazyMode lazyMode) {
            if (this.mode.getKind() != lazyMode.mode.getKind()) {
                if (this.mode.getKind() == 1) {
                    return 1;
                }
                if (lazyMode.mode.getKind() == 1) {
                    return -1;
                }
            }
            return 0;
        }

        Collection<String> getTopComponents() {
            ArrayList<String> arrayList = new ArrayList<String>(this.id2position.keySet());
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    int n = (Integer)LazyMode.this.id2position.get(string);
                    int n2 = (Integer)LazyMode.this.id2position.get(string2);
                    int n3 = n - n2;
                    if (n < LazyMode.this.selectedTCposition && n2 < LazyMode.this.selectedTCposition) {
                        n3 *= -1;
                    }
                    return n3;
                }
            });
            return arrayList;
        }

        int getPosition(String string) {
            if (!this.id2position.containsKey(string)) {
                return -1;
            }
            int n = this.id2position.get(string);
            if (n <= this.selectedTCposition) {
                return 0;
            }
            return -1;
        }
    }
}

