/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.ParseResult;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryCurrentScopeVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalReplacementVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.AddCallProtocolInstructions;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.UnboxingPass;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.CFGInliner;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.ir.util.IGVDumper;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class IRScope
implements ParseResult {
    public static final Logger LOG = LoggerFactory.getLogger(IRScope.class);
    private static final Collection<IRClosure> NO_CLOSURES = Collections.EMPTY_LIST;
    private static final AtomicInteger globalScopeCount = new AtomicInteger();
    private int scopeId;
    private ByteList name;
    private final int lineNumber;
    private IRScope lexicalParent;
    private List<IRClosure> nestedClosures;
    private int nextClosureIndex;
    private List<IRScope> lexicalChildren;
    private final StaticScope staticScope;
    protected InterpreterContext interpreterContext;
    protected FullInterpreterContext fullInterpreterContext;
    protected FullInterpreterContext optimizedInterpreterContext;
    protected int temporaryVariableIndex;
    private int nextLabelIndex = 0;
    Map<RubySymbol, LocalVariable> localVars;
    EnumSet<IRFlags> flags;
    private IRManager manager;
    private boolean alreadyHasInline;
    private String inlineFailed;
    public Compilable compilable;
    private static final EnumSet<IRFlags> DEFAULT_SCOPE_FLAGS = EnumSet.of(IRFlags.CAN_CAPTURE_CALLERS_BINDING, new IRFlags[]{IRFlags.BINDING_HAS_ESCAPED, IRFlags.USES_EVAL, IRFlags.REQUIRES_BACKREF, IRFlags.REQUIRES_LASTLINE, IRFlags.REQUIRES_DYNSCOPE, IRFlags.USES_ZSUPER});
    private static final EnumSet<IRFlags> NEEDS_DYNAMIC_SCOPE_FLAGS = EnumSet.of(IRFlags.CAN_RECEIVE_BREAKS, IRFlags.HAS_NONLOCAL_RETURNS, IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS, IRFlags.BINDING_HAS_ESCAPED);

    protected IRScope(IRScope s2, IRScope lexicalParent) {
        this.lexicalParent = lexicalParent;
        this.manager = s2.manager;
        this.lineNumber = s2.lineNumber;
        this.staticScope = s2.staticScope;
        this.nextClosureIndex = s2.nextClosureIndex;
        this.temporaryVariableIndex = s2.temporaryVariableIndex;
        this.interpreterContext = null;
        this.flags = s2.flags.clone();
        this.localVars = new HashMap<RubySymbol, LocalVariable>(s2.localVars);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    public IRScope(IRManager manager, IRScope lexicalParent, ByteList name2, int lineNumber, StaticScope staticScope) {
        this.manager = manager;
        this.lexicalParent = lexicalParent;
        this.name = name2;
        this.lineNumber = lineNumber;
        this.staticScope = staticScope;
        this.nextClosureIndex = 0;
        this.temporaryVariableIndex = -1;
        this.interpreterContext = null;
        this.flags = DEFAULT_SCOPE_FLAGS.clone();
        if (this.parentMaybeUsingRefinements()) {
            this.flags.add(IRFlags.MAYBE_USING_REFINEMENTS);
        }
        this.localVars = new HashMap<RubySymbol, LocalVariable>(1);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    private void setupLexicalContainment() {
        if (this.manager.isDryRun() || RubyInstanceConfig.IR_WRITING || RubyInstanceConfig.RECORD_LEXICAL_HIERARCHY) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
            if (this.lexicalParent != null) {
                this.lexicalParent.addChildScope(this);
            }
        }
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int hashCode() {
        return this.scopeId;
    }

    public void setInterpreterContext(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.scopeId == ((IRScope)other).scopeId;
    }

    protected void addChildScope(IRScope scope) {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        this.lexicalChildren.add(scope);
    }

    public List<IRScope> getLexicalScopes() {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        return this.lexicalChildren;
    }

    public void addClosure(IRClosure closure) {
        if (this.nestedClosures == null) {
            this.nestedClosures = new ArrayList<IRClosure>(1);
        }
        this.nestedClosures.add(closure);
    }

    public void removeClosure(IRClosure closure) {
        if (this.nestedClosures != null) {
            this.nestedClosures.remove(closure);
        }
    }

    public Label getNewLabel(String prefix) {
        return new Label(prefix, this.nextLabelIndex++);
    }

    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    public Collection<IRClosure> getClosures() {
        return this.nestedClosures == null ? NO_CLOSURES : this.nestedClosures;
    }

    public IRManager getManager() {
        return this.manager;
    }

    public void setIsMaybeUsingRefinements() {
        this.flags.add(IRFlags.MAYBE_USING_REFINEMENTS);
    }

    public boolean parentMaybeUsingRefinements() {
        for (IRScope s2 = this; s2 != null; s2 = s2.getLexicalParent()) {
            if (s2.getFlags().contains((Object)IRFlags.MAYBE_USING_REFINEMENTS)) {
                return true;
            }
            if (!(s2 instanceof IREvalScript)) continue;
            return false;
        }
        return false;
    }

    public boolean maybeUsingRefinements() {
        return this.getFlags().contains((Object)IRFlags.MAYBE_USING_REFINEMENTS);
    }

    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public boolean isWithinEND() {
        for (IRScope current2 = this; current2 != null && current2 instanceof IRClosure; current2 = current2.getLexicalParent()) {
            if (!((IRClosure)current2).isEND()) continue;
            return true;
        }
        return false;
    }

    public IRMethod getNearestMethod() {
        IRScope current2;
        for (current2 = this; current2 != null && !(current2 instanceof IRMethod); current2 = current2.getLexicalParent()) {
        }
        return (IRMethod)current2;
    }

    public IRScope getNearestTopLocalVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isTopLocalVariableScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isScopeContainedBy(IRScope parentScope) {
        for (IRScope current2 = this; current2 != null; current2 = current2.getLexicalParent()) {
            if (parentScope != current2) continue;
            return true;
        }
        return false;
    }

    public int getNearestModuleReferencingScopeDepth() {
        int n = 0;
        IRScope current2 = this;
        while (!(current2 instanceof IRModuleBody)) {
            if (current2 == null || current2 instanceof IREvalScript) {
                return -1;
            }
            if ((current2 = current2.getLexicalParent()) instanceof IRFor) continue;
            ++n;
        }
        return n;
    }

    public String getId() {
        return this.getName().idString();
    }

    public RubySymbol getName() {
        return this.getManager().getRuntime().newSymbol(this.name);
    }

    public ByteList getByteName() {
        return this.name;
    }

    public void setByteName(ByteList name2) {
        this.name = name2;
    }

    public void setFileName(String filename2) {
        this.getRootLexicalScope().setFileName(filename2);
    }

    @Deprecated
    public String getFileName() {
        return this.getFile();
    }

    @Override
    public String getFile() {
        return this.getRootLexicalScope().getFile();
    }

    @Deprecated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    public IRScope getRootLexicalScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isScriptScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isNestedInClosure(IRClosure closure) {
        for (IRScope s2 = this; s2 != null && !s2.isTopLocalVariableScope(); s2 = s2.getLexicalParent()) {
            if (s2 != closure) continue;
            return true;
        }
        return false;
    }

    public void setHasLoopsFlag() {
        this.flags.add(IRFlags.HAS_LOOPS);
    }

    public boolean hasLoops() {
        return this.flags.contains((Object)IRFlags.HAS_LOOPS);
    }

    public boolean hasExplicitCallProtocol() {
        return this.flags.contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public void setExplicitCallProtocolFlag() {
        this.flags.add(IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public boolean receivesKeywordArgs() {
        return this.flags.contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
    }

    public boolean bindingHasEscaped() {
        return this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    public boolean usesEval() {
        return this.flags.contains((Object)IRFlags.USES_EVAL);
    }

    public boolean usesZSuper() {
        return this.flags.contains((Object)IRFlags.USES_ZSUPER);
    }

    public boolean canReceiveNonlocalReturns() {
        this.computeScopeFlags();
        return this.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
    }

    public void putLiveVariablesProblem(LiveVariablesProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("LVP being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("Live Variables Analysis", problem);
    }

    public LiveVariablesProblem getLiveVariablesProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (LiveVariablesProblem)this.fullInterpreterContext.getDataFlowProblems().get("Live Variables Analysis");
    }

    public void putStoreLocalVarPlacementProblem(StoreLocalVarPlacementProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("StoreLocalVarPlacementProblem being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("Placement of local-var stores", problem);
    }

    public StoreLocalVarPlacementProblem getStoreLocalVarPlacementProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (StoreLocalVarPlacementProblem)this.fullInterpreterContext.getDataFlowProblems().get("Placement of local-var stores");
    }

    public void putUnboxableOpsAnalysisProblem(UnboxableOpsAnalysisProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("UboxableOpsAnalysisProblem being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("UnboxableOpsAnalysis", problem);
    }

    public UnboxableOpsAnalysisProblem getUnboxableOpsAnalysisProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (UnboxableOpsAnalysisProblem)this.fullInterpreterContext.getDataFlowProblems().get("UnboxableOpsAnalysis");
    }

    public CFG getCFG() {
        if (this.getOptimizedInterpreterContext() != null) {
            return this.getOptimizedInterpreterContext().getCFG();
        }
        if (this.getFullInterpreterContext() == null) {
            this.prepareFullBuildCommon();
        }
        return this.fullInterpreterContext.getCFG();
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.fullInterpreterContext == null ? new ArrayList(1) : this.fullInterpreterContext.getExecutedPasses();
    }

    private void runCompilerPasses(List<CompilerPass> passes, IGVDumper dumper) {
        if (dumper != null) {
            dumper.dump(this.getCFG(), "Start");
        }
        CompilerPassScheduler scheduler = IRManager.schedulePasses(passes);
        for (CompilerPass pass2 : scheduler) {
            pass2.run(this);
            if (dumper == null) continue;
            dumper.dump(this.getCFG(), pass2.getShortLabel());
        }
        if (RubyInstanceConfig.IR_UNBOXING) {
            UnboxingPass pass3 = new UnboxingPass();
            pass3.run(this);
            if (dumper != null) {
                dumper.dump(this.getCFG(), pass3.getShortLabel());
            }
        }
        if (dumper != null) {
            dumper.close();
        }
    }

    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new InterpreterContext(this, instructions);
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    public InterpreterContext allocateInterpreterContext(Callable<List<Instr>> instructions) {
        try {
            this.interpreterContext = new InterpreterContext(this, instructions);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    private Instr[] cloneInstrs() {
        SimpleCloneInfo cloneInfo = new SimpleCloneInfo(this, false);
        Instr[] instructions = this.interpreterContext.getInstructions();
        int length2 = instructions.length;
        Instr[] newInstructions = new Instr[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            newInstructions[i2] = instructions[i2].clone(cloneInfo);
        }
        return newInstructions;
    }

    private void prepareFullBuildCommon() {
        if (this.fullInterpreterContext != null) {
            return;
        }
        this.fullInterpreterContext = new FullInterpreterContext(this, this.cloneInstrs());
    }

    public synchronized FullInterpreterContext prepareFullBuild() {
        if (this.optimizedInterpreterContext != null) {
            return this.optimizedInterpreterContext;
        }
        if (this.fullInterpreterContext != null && this.fullInterpreterContext.buildComplete()) {
            return this.fullInterpreterContext;
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareFullBuild();
        }
        this.prepareFullBuildCommon();
        this.runCompilerPasses(this.getManager().getCompilerPasses(this), this.dumpToIGV());
        this.getManager().optimizeIfSimpleScope(this);
        new AddCallProtocolInstructions().run(this);
        this.fullInterpreterContext.generateInstructionsForInterpretation();
        return this.fullInterpreterContext;
    }

    public String getFullyQualifiedName() {
        if (this.getLexicalParent() == null) {
            return this.getId();
        }
        return this.getLexicalParent().getFullyQualifiedName() + "::" + this.getId();
    }

    public IGVDumper dumpToIGV() {
        String spec;
        if (RubyInstanceConfig.IR_DEBUG_IGV != null && ((spec = RubyInstanceConfig.IR_DEBUG_IGV).contains(":") && spec.equals(this.getFileName() + ":" + this.getLineNumber()) || spec.equals(this.getFileName()))) {
            return new IGVDumper(this.getFullyQualifiedName() + "; line " + this.getLineNumber());
        }
        return null;
    }

    public synchronized BasicBlock[] prepareForCompilation() {
        if (this.optimizedInterpreterContext != null && this.optimizedInterpreterContext.buildComplete()) {
            return this.optimizedInterpreterContext.getLinearizedBBList();
        }
        if (this.fullInterpreterContext != null && this.fullInterpreterContext.buildComplete()) {
            return this.fullInterpreterContext.getLinearizedBBList();
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareForCompilation();
        }
        this.prepareFullBuildCommon();
        this.runCompilerPasses(this.getManager().getJITPasses(this), this.dumpToIGV());
        BasicBlock[] bbs = this.fullInterpreterContext.linearizeBasicBlocks();
        return bbs;
    }

    public Map<BasicBlock, Label> buildJVMExceptionTable() {
        HashMap<BasicBlock, Label> map2 = new HashMap<BasicBlock, Label>(1);
        for (BasicBlock bb : this.fullInterpreterContext.getLinearizedBBList()) {
            BasicBlock rescueBB = this.getCFG().getRescuerBBFor(bb);
            if (rescueBB == null) continue;
            map2.put(bb, rescueBB.getLabel());
        }
        return map2;
    }

    public EnumSet<IRFlags> getFlags() {
        return this.flags;
    }

    private void initScopeFlags() {
        this.flags.remove((Object)IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.USES_EVAL);
        this.flags.remove((Object)IRFlags.REQUIRES_DYNSCOPE);
        this.flags.remove((Object)IRFlags.REQUIRES_LASTLINE);
        this.flags.remove((Object)IRFlags.REQUIRES_BACKREF);
        this.flags.remove((Object)IRFlags.REQUIRES_VISIBILITY);
        this.flags.remove((Object)IRFlags.REQUIRES_BLOCK);
        this.flags.remove((Object)IRFlags.REQUIRES_SELF);
        this.flags.remove((Object)IRFlags.REQUIRES_METHODNAME);
        this.flags.remove((Object)IRFlags.REQUIRES_LINE);
        this.flags.remove((Object)IRFlags.REQUIRES_CLASS);
        this.flags.remove((Object)IRFlags.REQUIRES_FILENAME);
        this.flags.remove((Object)IRFlags.REQUIRES_SCOPE);
    }

    private void bindingEscapedScopeFlagsCheck() {
        if (this instanceof IREvalScript || this instanceof IRScriptBody) {
            this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        } else {
            this.flags.remove((Object)IRFlags.BINDING_HAS_ESCAPED);
        }
    }

    private void calculateClosureScopeFlags() {
        for (IRClosure cl : this.getClosures()) {
            cl.computeScopeFlags();
            if (cl.usesEval()) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
                this.flags.add(IRFlags.USES_ZSUPER);
                continue;
            }
            if (cl.flags.contains((Object)IRFlags.HAS_BREAK_INSTRS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_BREAKS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
            }
            if (cl.flags.contains((Object)IRFlags.HAS_NONLOCAL_RETURNS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
            }
            if (!cl.usesZSuper()) continue;
            this.flags.add(IRFlags.USES_ZSUPER);
        }
    }

    private void computeNeedsDynamicScopeFlag() {
        for (IRFlags f : NEEDS_DYNAMIC_SCOPE_FLAGS) {
            if (!this.flags.contains((Object)f)) continue;
            this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
            return;
        }
    }

    public void computeScopeFlagsEarly(List<Instr> instructions) {
        this.initScopeFlags();
        this.bindingEscapedScopeFlagsCheck();
        for (Instr i2 : instructions) {
            i2.computeScopeFlags(this);
        }
        this.calculateClosureScopeFlags();
        this.computeNeedsDynamicScopeFlag();
        this.flags.add(IRFlags.FLAGS_COMPUTED);
    }

    public void computeScopeFlags() {
        if (this.flags.contains((Object)IRFlags.FLAGS_COMPUTED)) {
            return;
        }
        this.initScopeFlags();
        this.bindingEscapedScopeFlagsCheck();
        if (this.fullInterpreterContext != null) {
            this.fullInterpreterContext.computeScopeFlagsFromInstructions();
        } else {
            this.interpreterContext.computeScopeFlagsFromInstructions();
        }
        this.calculateClosureScopeFlags();
        this.computeNeedsDynamicScopeFlag();
        this.flags.add(IRFlags.FLAGS_COMPUTED);
    }

    public abstract IRScopeType getScopeType();

    public String toString() {
        return String.valueOf((Object)this.getScopeType()) + ' ' + this.getId() + '[' + this.getFile() + ':' + this.getLine() + "]<" + this.toStringCompileForm() + ">";
    }

    public String toStringCompileForm() {
        return this.optimizedInterpreterContext != null ? "optimized" : (this.fullInterpreterContext != null ? "full" : "startup");
    }

    public String debugOutput() {
        return this.toStringInstrs();
    }

    public String toStringInstrs() {
        if (this.fullInterpreterContext != null) {
            return "Instructions:\n" + this.fullInterpreterContext.toStringInstrs();
        }
        return this.interpreterContext.toStringInstrs();
    }

    public Variable getSelf() {
        return Self.SELF;
    }

    public Variable createCurrentModuleVariable() {
        ++this.temporaryVariableIndex;
        return TemporaryCurrentModuleVariable.ModuleVariableFor(this.temporaryVariableIndex);
    }

    public Variable createCurrentScopeVariable() {
        ++this.temporaryVariableIndex;
        return TemporaryCurrentScopeVariable.ScopeVariableFor(this.temporaryVariableIndex);
    }

    public Map<RubySymbol, LocalVariable> getLocalVariables() {
        return this.localVars;
    }

    public Set<LocalVariable> getUsedLocalVariables() {
        return this.getFullInterpreterContext().getUsedLocalVariables();
    }

    public void setLocalVariables(Map<RubySymbol, LocalVariable> variables) {
        this.localVars = variables;
    }

    public void setNextLabelIndex(int index2) {
        this.nextLabelIndex = index2;
    }

    public int getNextLabelIndex() {
        return this.nextLabelIndex;
    }

    public LocalVariable lookupExistingLVar(RubySymbol name2) {
        return this.localVars.get(name2);
    }

    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int depth) {
        return this.localVars.get(name2);
    }

    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        } else if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    public LocalVariable getNewLocalVariable(RubySymbol name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Scope depth is non-zero for new-var request " + name2 + " in " + this;
        LocalVariable lvar = new LocalVariable(name2, scopeDepth, this.getStaticScope().addVariable(name2.idString()));
        this.localVars.put(name2, lvar);
        return lvar;
    }

    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.LOCAL);
    }

    public TemporaryLocalVariable getNewTemporaryVariableFor(LocalVariable var) {
        ++this.temporaryVariableIndex;
        return new TemporaryLocalReplacementVariable(var.getId(), this.temporaryVariableIndex);
    }

    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        switch (type2) {
            case FLOAT: {
                ++this.getFullInterpreterContext().floatVariableIndex;
                return new TemporaryFloatVariable(this.getFullInterpreterContext().floatVariableIndex);
            }
            case FIXNUM: {
                ++this.getFullInterpreterContext().fixnumVariableIndex;
                return new TemporaryFixnumVariable(this.getFullInterpreterContext().fixnumVariableIndex);
            }
            case BOOLEAN: {
                ++this.getFullInterpreterContext().booleanVariableIndex;
                return new TemporaryBooleanVariable(this.getFullInterpreterContext().booleanVariableIndex);
            }
            case LOCAL: {
                ++this.temporaryVariableIndex;
                return this.manager.newTemporaryLocalVariable(this.temporaryVariableIndex);
            }
        }
        throw new RuntimeException("Invalid temporary variable being alloced in this scope: " + (Object)((Object)type2));
    }

    public void setTemporaryVariableCount(int count2) {
        this.temporaryVariableIndex = count2 + 1;
    }

    public TemporaryLocalVariable getNewUnboxedVariable(Class type2) {
        TemporaryVariableType varType = type2 == Float.class ? TemporaryVariableType.FLOAT : (type2 == Fixnum.class ? TemporaryVariableType.FIXNUM : (type2 == Boolean.class ? TemporaryVariableType.BOOLEAN : TemporaryVariableType.LOCAL));
        return this.getNewTemporaryVariable(varType);
    }

    public int getTemporaryVariablesCount() {
        return this.temporaryVariableIndex + 1;
    }

    public Variable getNewInlineVariable(ByteList inlinePrefix, Variable v) {
        return this.createTemporaryVariable();
    }

    public int getLocalVariablesCount() {
        return this.localVars.size();
    }

    public boolean usesLocalVariable(Variable v) {
        return this.getFullInterpreterContext().usesLocalVariable(v);
    }

    public boolean definesLocalVariable(Variable v) {
        return this.getFullInterpreterContext().definesLocalVariable(v);
    }

    public boolean hasBeenBuilt() {
        return true;
    }

    public FullInterpreterContext getExecutionContext() {
        return this.fullInterpreterContext;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public FullInterpreterContext getFullInterpreterContext() {
        return this.fullInterpreterContext;
    }

    public FullInterpreterContext getOptimizedInterpreterContext() {
        return this.optimizedInterpreterContext;
    }

    protected void depends(Object obj) {
        assert (obj != null) : "Unsatisfied dependency and this depends() was set up wrong.  Use depends(build()) not depends(build).";
    }

    public void resetState() {
        this.interpreterContext = null;
        this.fullInterpreterContext = null;
        this.flags.remove((Object)IRFlags.FLAGS_COMPUTED);
        this.flags.add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        this.flags.add(IRFlags.USES_EVAL);
        this.flags.add(IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        FullInterpreterContext fic = this.getFullInterpreterContext();
        if (fic != null) {
            int i2 = 0;
            while (i2 < fic.getExecutedPasses().size()) {
                if (fic.getExecutedPasses().get(i2).invalidate(this)) continue;
                ++i2;
            }
        }
    }

    private FullInterpreterContext inlineFailed(String reason2) {
        this.inlineFailed = reason2;
        return null;
    }

    private FullInterpreterContext inlineMethodCommon(IRMethod methodToInline, long callsiteId, int classToken, boolean cloneHost) {
        this.alreadyHasInline = true;
        if (this.getFullInterpreterContext() == null) {
            return this.inlineFailed("inline into startup interpreter scope");
        }
        if (!methodToInline.getClosures().isEmpty()) {
            return this.inlineFailed("inline a method which contains nested closures");
        }
        FullInterpreterContext newContext = this.getFullInterpreterContext().duplicate();
        BasicBlock basicBlock = newContext.findBasicBlockOf(callsiteId);
        CallBase call2 = (CallBase)basicBlock.siteOf(callsiteId);
        RubyModule implClass = this.compilable.getImplementationClass();
        String error2 = new CFGInliner(newContext).inlineMethod(methodToInline, implClass, classToken, basicBlock, call2, cloneHost);
        return error2 == null ? newContext : this.inlineFailed(error2);
    }

    public void inlineMethod(IRMethod methodToInline, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, callsiteId, classToken, cloneHost);
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        newContext.generateInstructionsForInterpretation();
        this.optimizedInterpreterContext = newContext;
        this.manager.getRuntime().getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public void inlineMethodJIT(IRMethod methodToInline, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, callsiteId, classToken, cloneHost);
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        newContext.linearizeBasicBlocks();
        this.optimizedInterpreterContext = newContext;
        this.manager.getRuntime().getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public void inlineMethodCompiled(IRMethod methodToInline, long callsiteId, int classToken, boolean cloneHost) {
        if (this.alreadyHasInline) {
            return;
        }
        FullInterpreterContext newContext = this.inlineMethodCommon(methodToInline, callsiteId, classToken, cloneHost);
        if (newContext == null) {
            if (IRManager.IR_INLINER_VERBOSE) {
                LOG.info("Inline of " + methodToInline + " into " + this + " failed: " + this.inlineFailed + ".", new Object[0]);
            }
            return;
        }
        if (IRManager.IR_INLINER_VERBOSE) {
            LOG.info("Inline of " + methodToInline + " into " + this + " succeeded.", new Object[0]);
        }
        newContext.linearizeBasicBlocks();
        this.optimizedInterpreterContext = newContext;
        this.manager.getRuntime().getJITCompiler().getTaskFor(this.manager.getRuntime().getCurrentContext(), this.compilable).run();
    }

    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public boolean isModuleBody() {
        return false;
    }

    public boolean isNonSingletonClassBody() {
        return false;
    }

    public boolean isTopLocalVariableScope() {
        return true;
    }

    public boolean isScriptScope() {
        return false;
    }

    public boolean needsFrame() {
        boolean bindingHasEscaped = this.bindingHasEscaped();
        boolean requireFrame = bindingHasEscaped || this.usesEval();
        for (IRFlags flag : this.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case CAN_CAPTURE_CALLERS_BINDING: 
                case REQUIRES_LASTLINE: 
                case REQUIRES_BACKREF: 
                case REQUIRES_VISIBILITY: 
                case REQUIRES_BLOCK: 
                case REQUIRES_SELF: 
                case REQUIRES_METHODNAME: 
                case REQUIRES_CLASS: 
                case USES_EVAL: 
                case USES_ZSUPER: {
                    requireFrame = true;
                }
            }
        }
        return requireFrame;
    }

    public boolean needsOnlyBackref() {
        boolean backrefSeen = false;
        for (IRFlags flag : this.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case CAN_CAPTURE_CALLERS_BINDING: 
                case REQUIRES_LASTLINE: 
                case REQUIRES_VISIBILITY: 
                case REQUIRES_BLOCK: 
                case REQUIRES_SELF: 
                case REQUIRES_METHODNAME: 
                case REQUIRES_CLASS: 
                case USES_EVAL: 
                case USES_ZSUPER: {
                    return false;
                }
                case REQUIRES_BACKREF: {
                    backrefSeen = true;
                }
            }
        }
        return backrefSeen;
    }

    public boolean reuseParentScope() {
        return this.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
    }

    public boolean needsBinding() {
        return this.reuseParentScope() || !this.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED);
    }

    public boolean inliningAllowed() {
        return !this.alreadyHasInline;
    }

    public void captureParentRefinements(ThreadContext context) {
        if (this.maybeUsingRefinements()) {
            for (IRScope cur = this.getLexicalParent(); cur != null; cur = cur.getLexicalParent()) {
                RubyModule overlay = cur.staticScope.getOverlayModuleForRead();
                if (overlay == null || overlay.getRefinements().isEmpty()) continue;
                RubyModule myOverlay = this.staticScope.getOverlayModuleForWrite(context);
                myOverlay.getRefinementsForWrite().putAll(overlay.getRefinements());
                break;
            }
        }
    }

    public void cleanupAfterExecution() {
    }

    public boolean executesOnce() {
        return false;
    }

    public void persistScopeHeader(IRWriterEncoder file2) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("IRScopeType = " + (Object)((Object)this.getScopeType()));
        }
        file2.encode(this.getScopeType());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Line # = " + this.getLine());
        }
        file2.encode(this.getLine());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("# of temp vars = " + this.getTemporaryVariablesCount());
        }
        file2.encode(this.getTemporaryVariablesCount());
        file2.encode(this.getNextLabelIndex());
    }
}

