/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class PKeyDH
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = -1893518804744046740L;
    private static final BigInteger TWO = BN.TWO;
    private static final int OPENSSL_DH_MAX_MODULUS_BITS = 10000;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public PKeyDH allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDH(runtime, klass);
        }
    };
    private volatile transient BigInteger dh_p;
    private volatile transient BigInteger dh_g;
    private volatile transient BigInteger dh_y;
    private volatile transient BigInteger dh_x;

    static void createPKeyDH(Ruby runtime, RubyModule PKey2, RubyClass PKeyPKey, RubyClass PKeyError) {
        RubyClass DH = PKey2.defineClassUnder("DH", PKeyPKey, ALLOCATOR);
        PKey2.defineClassUnder("DHError", PKeyError, PKeyError.getAllocator());
        DH.defineAnnotatedMethods(PKeyDH.class);
    }

    public static RaiseException newDHError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyDH._PKey(runtime).getClass("DHError"), message);
    }

    public PKeyDH(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        PKeyDH that = (PKeyDH)original;
        this.dh_p = that.dh_p;
        this.dh_g = that.dh_g;
        this.dh_y = that.dh_y;
        this.dh_x = that.dh_x;
        return this;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public synchronized IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        if (this.dh_p != null || this.dh_g != null || this.dh_y != null || this.dh_x != null) {
            throw PKeyDH.newDHError(runtime, "illegal initialization");
        }
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2);
        if (argc > 0) {
            BigInteger p;
            IRubyObject arg0 = args[0];
            if (argc == 1 && arg0 instanceof RubyString) {
                try {
                    DHParameterSpec spec = PEMInputOutput.readDHParameters(new StringReader(arg0.toString()));
                    if (spec == null) {
                        spec = PKey.readDHParameter(arg0.asString().getByteList().bytes());
                    }
                    if (spec == null) {
                        throw runtime.newArgumentError("invalid DH PARAMETERS");
                    }
                    this.dh_p = spec.getP();
                    this.dh_g = spec.getG();
                }
                catch (NoClassDefFoundError e) {
                    throw PKeyDH.newDHError(runtime, OpenSSL.bcExceptionMessage(e));
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
            }
            int bits = RubyNumeric.fix2int((IRubyObject)arg0);
            int gval = argc == 2 ? RubyNumeric.fix2int((IRubyObject)args[1]) : 2;
            try {
                p = PKeyDH.generateP(bits, gval);
            }
            catch (IllegalArgumentException e) {
                throw runtime.newArgumentError(e.getMessage());
            }
            BigInteger g = BigInteger.valueOf(gval);
            BigInteger x = PKeyDH.generateX(p);
            BigInteger y = PKeyDH.generateY(p, g, x);
            this.dh_p = p;
            this.dh_g = g;
            this.dh_x = x;
            this.dh_y = y;
        }
        return this;
    }

    public static BigInteger generateP(int bits, int g) {
        if (bits < 2) {
            throw new IllegalArgumentException("invalid bit length");
        }
        if (g < 2) {
            throw new IllegalArgumentException("invalid generator");
        }
        switch (g) {
            case 2: {
                return BN.generatePrime(bits, true, BigInteger.valueOf(24L), BigInteger.valueOf(11L));
            }
            case 5: {
                return BN.generatePrime(bits, true, BigInteger.valueOf(10L), BigInteger.valueOf(3L));
            }
        }
        return BN.generatePrime(bits, true, TWO, BigInteger.ONE);
    }

    public static BigInteger generateX(BigInteger p, int limit) {
        BigInteger x;
        if (limit < 0) {
            throw new IllegalArgumentException("invalid limit");
        }
        SecureRandom secureRandom = new SecureRandom();
        if (limit == 0) {
            BigInteger pSub2 = p.subtract(TWO);
            while ((x = BN.randomIntegerInRange(pSub2, secureRandom)).equals(BigInteger.ZERO)) {
            }
        } else {
            while ((x = new BigInteger(limit, 0, secureRandom)).equals(BigInteger.ZERO)) {
            }
        }
        return x;
    }

    public static BigInteger generateX(BigInteger p) {
        return PKeyDH.generateX(p, p.bitLength() - 1);
    }

    public static BigInteger generateY(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }

    public static BigInteger generateY(BigInteger p, int g, BigInteger x) {
        return PKeyDH.generateY(p, BigInteger.valueOf(g), x);
    }

    @JRubyMethod(name={"generate_key!"})
    public synchronized IRubyObject generate_key() {
        BigInteger g;
        BigInteger p = this.dh_p;
        if (p == null || (g = this.dh_g) == null) {
            throw PKeyDH.newDHError(this.getRuntime(), "can't generate key");
        }
        BigInteger x = this.dh_x;
        if (x == null) {
            x = PKeyDH.generateX(p);
        }
        BigInteger y = PKeyDH.generateY(p, g, x);
        this.dh_x = x;
        this.dh_y = y;
        return this;
    }

    @JRubyMethod(name={"compute_key"})
    public synchronized IRubyObject compute_key(IRubyObject other_pub_key) {
        BigInteger p;
        BigInteger y = BN.asBigInteger(other_pub_key);
        if (y == null) {
            throw this.getRuntime().newArgumentError("invalid public key");
        }
        BigInteger x = this.dh_x;
        if (x == null || (p = this.dh_p) == null) {
            throw PKeyDH.newDHError(this.getRuntime(), "incomplete DH");
        }
        int plen = p.bitLength();
        if (plen == 0 || plen > 10000) {
            throw PKeyDH.newDHError(this.getRuntime(), "can't compute key");
        }
        return this.getRuntime().newString(new ByteList(PKeyDH.computeKey(y, x, p), false));
    }

    public static byte[] computeKey(BigInteger y, BigInteger x, BigInteger p) {
        return y.modPow(x, p).toByteArray();
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(this.dh_y != null);
    }

    @Override
    public boolean isPrivateKey() {
        return this.dh_x != null;
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(this.isPrivateKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"to_pem", "to_s"}, alias={"export"}, rest=true)
    public RubyString to_pem(IRubyObject[] args) {
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
        }
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writeDHParameters(writer, new DHParameterSpec(p, g));
        }
        catch (NoClassDefFoundError e) {
            throw PKeyDH.newDHError(this.getRuntime(), OpenSSL.bcExceptionMessage(e));
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return RubyString.newString((Ruby)this.getRuntime(), (CharSequence)writer.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"to_der"})
    public RubyString to_der() {
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
        }
        try {
            byte[] bytes = PKey.toDerDHKey(p, g);
            return StringHelper.newString(this.getRuntime(), bytes);
        }
        catch (NoClassDefFoundError e) {
            throw PKeyDH.newDHError(this.getRuntime(), OpenSSL.bcExceptionMessage(e));
        }
        catch (IOException ioe) {
            throw PKeyDH.newDHError(this.getRuntime(), ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"params"})
    public IRubyObject params() {
        BigInteger y;
        BigInteger x;
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
            x = this.dh_x;
            y = this.dh_y;
        }
        Ruby runtime = this.getRuntime();
        HashMap<RubyString, BN> params2 = new HashMap<RubyString, BN>();
        params2.put(runtime.newString("p"), BN.newBN(runtime, p));
        params2.put(runtime.newString("g"), BN.newBN(runtime, g));
        params2.put(runtime.newString("pub_key"), BN.newBN(runtime, x));
        params2.put(runtime.newString("priv_key"), BN.newBN(runtime, y));
        return RubyHash.newHash((Ruby)runtime, params2, (IRubyObject)runtime.getNil());
    }

    @JRubyMethod(name={"p"})
    public IRubyObject get_p() {
        return this.newBN(this.dh_p);
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject arg) {
        this.dh_p = BN.asBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"g"})
    public IRubyObject get_g() {
        return this.newBN(this.dh_g);
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject set_g(IRubyObject arg) {
        this.dh_g = BN.asBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"pub_key"})
    public IRubyObject pub_key() {
        return this.newBN(this.dh_y);
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return PKeyDH.getKeyFactory().generatePublic(new DHPublicKeySpec(this.dh_y, this.dh_p, this.dh_g));
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject set_pub_key(IRubyObject arg) {
        this.dh_y = BN.asBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"priv_key"})
    public IRubyObject priv_key() {
        return this.newBN(this.dh_x);
    }

    @Override
    public PrivateKey getPrivateKey() {
        try {
            return PKeyDH.getKeyFactory().generatePrivate(new DHPrivateKeySpec(this.dh_x, this.dh_p, this.dh_g));
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JRubyMethod(name={"priv_key="})
    public synchronized IRubyObject set_priv_key(IRubyObject arg) {
        this.dh_x = BN.asBigInteger(arg);
        return arg;
    }

    private IRubyObject newBN(BigInteger value2) {
        if (value2 == null) {
            return this.getRuntime().getNil();
        }
        return BN.newBN(this.getRuntime(), value2);
    }

    private static KeyFactory getKeyFactory() {
        try {
            return SecurityHelper.getKeyFactory("DiffieHellman");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

