/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ListenerManager<L> {
    private final Map<L, StackTraceElement[]> listenerMap = new HashMap<L, StackTraceElement[]>();
    private static final int TRACE_START = 3;

    public void recordListenerAdded(L listener) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.listenerMap.put(listener, stackTrace);
    }

    public void recordListenerRemoved(L listener) {
        this.listenerMap.remove(listener);
    }

    public void dumpWarningForListener(L listener, Logger log, String cleanupMessage) {
        if (this.listenerMap.containsKey(listener)) {
            log.error("*** WARNING BADLY BEHAVING LISTENER: " + listener.getClass().getName() + " ***");
            StackTraceElement[] trace = this.listenerMap.get(listener);
            if (trace != null) {
                log.error("    Possible culprit (trace from when listener was added): ");
                for (int i = 3; i < trace.length; ++i) {
                    String s = trace[i].toString();
                    if (i == 0) {
                        log.error("        ->" + s);
                        continue;
                    }
                    log.error("          " + s);
                }
            }
            log.error("    " + cleanupMessage);
        }
    }

    public void dumpWarningForAllListeners(Logger log, String cleanupMessage) {
        for (L listener : this.listenerMap.keySet()) {
            this.dumpWarningForListener(listener, log, cleanupMessage);
        }
    }
}

