/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.collection.IStack;
import net.sf.sdedit.util.collection.StackImpl;
import net.sf.sdedit.util.tree.TraversalControl;
import net.sf.sdedit.util.tree.Tree;

public class Traversal<T> {
    private IStack<Pair<T, Integer>> stack;
    private Map<T, T> lastChildren;
    private TraversalControl<T> control;
    private Tree<T> tree;
    private int maxDepth;

    public Traversal(TraversalControl<T> control) {
        this.control = control;
        this.stack = new StackImpl<Pair<T, Integer>>();
        this.lastChildren = new IdentityHashMap<T, T>();
    }

    public void DESTROY() {
        this.stack.clear();
        this.lastChildren.clear();
    }

    public void traverse(Tree<T> tree) {
        List<Object> roots = Arrays.asList(tree.getChildren(null));
        this.traverse(tree, roots, Integer.MAX_VALUE);
    }

    public void traverse(Tree<T> tree, T root) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(root);
        this.traverse(tree, list, Integer.MAX_VALUE);
    }

    public void traverse(Tree<T> tree, Collection<T> roots) {
        this.traverse(tree, roots, Integer.MAX_VALUE);
    }

    public void traverse(Tree<T> tree, Collection<T> roots, int depth) {
        this.tree = tree;
        this.maxDepth = depth;
        this.stack.clear();
        Object[] initial = roots.toArray();
        for (int i = initial.length - 1; i >= 0; --i) {
            this.stack.push(new Pair<Object, Integer>(initial[i], 0));
        }
        while (!this.stack.isEmpty()) {
            this.step();
        }
    }

    private void propagateTraversalEnd(T leaf) {
        T node = leaf;
        do {
            if ((node = this.lastChildren.remove(node)) == null) continue;
            this.control.endTraversal(node, false);
        } while (node != null);
    }

    private void step() {
        Pair<T, Integer> pair = this.stack.pop();
        T node = pair.getFirst();
        int depth = pair.getSecond();
        this.control.beginTraversal(node, depth);
        Object lastChild = null;
        if (depth < this.maxDepth) {
            T[] children = this.tree.getChildren(node);
            for (int i = children.length - 1; i >= 0; --i) {
                T child = children[i];
                if (!this.control.doTraverse(child, depth + 1)) continue;
                if (lastChild == null) {
                    lastChild = child;
                }
                this.stack.push(new Pair<T, Integer>(children[i], depth + 1));
            }
        }
        if (lastChild == null) {
            this.control.endTraversal(node, true);
            this.propagateTraversalEnd(node);
        } else {
            this.lastChildren.put(lastChild, node);
        }
    }
}

