#A  BOUNDS FOR q = 4
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the
##  second upperbounds) for a code with wordlength n and
##  dimension k. Each entry contains one of the following
##  items:
##
##  FOR LOWER- AND UPPERBOUNDSTABLE
##  [ 0, <d>, <ref> ]  from Brouwers table
##
##  FOR LOWERBOUNDSTABLE
##  empty           k= 0, 1, n or d= 2 or (k= 2 and q= 2)
##  1               shortening a [ n + 1, k + 1 ] code
##  2               puncturing a [ n + 1, k ] code
##  3               extending a [ n - 1, k ] code
##  [ 4, <dd> ]     constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]     an UUV-construction with a [ n / 2, k1 ]
##                  and a [ n / 2, k - k1 ] code
##  [ 6, <n1> ]     concatenation of a [ n1, k ] and a
##                  [ n - n1, k ] code
##  [ 7, <n1> ]     taking the residue of a [ n1, k + 1 ] code
##  20              taking the subcode of a [ n, k + 1 ] code
##  [21,<s>,<j>]    constr. B2 of a [ n+s, k+s-2j-1, d+2j] code
##  [22,<k1>,<k2>]  an UUAVUVW-construction with a [ n/3, k1 ],
##                  a [ n/3, k2 ] and a [ n/3, k-(k1+k2) ] code
##
##  FOR UPPERBOUNDSTABLE
##  empty        trivial and Singleton bound
##  11           shortening a [ n + 1, k + 1 ] code
##  12           puncturing a [ n + 1, k ] code
##  13           extending a [ n - 1, k ] code
##  [ 14, <dd> ] constr. B, with dd = dual distance
##  [ 15, <d> ]  Griesmer bound
##  [ 16, <d> ]  One-step Griesmer bound


GUAVA_BOUNDS_TABLE[1][4] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ , 1],
#V   n = 5
[ , 1, 2],
#V   n = 6
[ , 20, [0, 4, "QR"], 20],
#V   n = 7
[ , 1, 1, 1, 20],
#V   n = 8
[ , 1, 1, 1, 1, 20],
#V   n = 9
[ , 2, 1, 1, 1, 1, 20],
#V   n = 10
[ , [6, 5], 20, 1, 1, 1, 1, 20],
#V   n = 11
[ , 1, 1, 20, 1, 2, 1, 1, 20],
#V   n = 12
[ , 1, 1, 1, 20, [0, 6, "QR"], 20, 1, 1, 20],
#V   n = 13
[ , 1, 1, 1, 1, 1, 1, 20, 1, 1, 20],
#V   n = 14
[ , 1, 1, 2, 1, 1, 1, 1, 20, 1, 1, 20],
#V   n = 15
[ , 1, 1, 2, 20, 1, 1, 1, 1, 20, 1, 1, 20],
#V   n = 16
[ , 20, 1, 2, 1, 20, 1, 1, 1, 1, 20, 1, 1, 20],
#V   n = 17
[ , 1, 20, [0, 12, "BCH"], 1, 2, 20, 1, 2, 1, 1, 20, [0, 4, "ovo"], 1, 20],
#V   n = 18
[ , 1, 2, 3, 20, [0, 10, "Gu"], 20, 20, [0, 8, "MOS"], 20, 1, 1, 1, 20, 1, 20],
#V   n = 19
[ , 1, 2, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 1, 20, 1, 20],
#V   n = 20
[ , 1, 2, 1, 1, 1, 1, 1, 20, [0, 8, "QR"], 1, 20, [0, 6, "EB3"], 1, 1, 20, 1, 20],
#V   n = 21
[ , 20, [7, 82], 1, 2, 1, 1, 1, 1, 1, 20, [0, 7, "KPm"], 1, 20, [0, 5, "KPm"], 1, 20, [4, 60], 20],
#V   n = 22
[ , 2, 1, 1, 2, 20, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 23
[ , 2, 20, 1, 2, 1, 20, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 24
[ , 2, 1, 20, [0, 16, "Li1"], 2, [0, 13, "GB4"], 20, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 25
[ , [6, 5], 1, 2, 1, 2, 1, 20, 20, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 26
[ , 1, 1, 2, 20, [0, 16, "Gu"], 1, 1, 20, 20, 1, 1, 1, 1, 2, [0, 7, "EB3"], 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 27
[ , 2, 1, 2, 1, 1, 2, [0, 14, "GB4"], [0, 13, "GuB"], 20, 20, 1, 1, 1, 2, 1, 20, 20, [0, 6, "EB3"], 1, 20, 1, 1, 20, 20],
#V   n = 28
[ , 2, 20, [0, 20, "GH"], 2, [0, 17, "GB4"], [0, 16, "GuB"], 1, 1, 20, 20, 20, 1, 1, 2, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 29
[ , 2, 1, 1, 2, 1, 1, 1, 1, 1, 20, 20, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 30
[ , [6, 5], 1, 2, [0, 20, "KPq"], 1, 2, [0, 16, "DaH"], [0, 15, "GB4"], [0, 14, "Da4"], [0, 13, "DG5"], 20, 20, 20, [0, 12, "QR"], 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 31
[ , 1, 2, [0, 22, "GH"], 1, 1, 2, 1, 1, 1, 1, 20, 20, 20, 3, 2, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 32
[ , 2, [6, 16], 1, 2, [0, 20, "Gu"], [0, 19, "GB4"], 1, 1, 1, 1, 1, 20, 20, 3, [0, 11, "Du3"], 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 33
[ , 2, 1, 2, [0, 22, "Bo1"], 2, 3, 1, 2, [0, 16, "DaH"], [0, 15, "DG"], 1, 2, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 34
[ , 2, 2, [6, 17], 1, 2, 1, 20, [0, 18, "DaH"], 1, 1, 20, [0, 14, "DaH"], 20, 20, 1, 1, 2, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 35
[ , [6, 5], 2, 1, 2, [0, 22, "GB4"], 1, 1, 2, 20, 1, 2, 1, 1, 20, 20, 1, 2, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 36
[ , 1, 2, 1, 2, 1, 2, [0, 20, "GB4"], [0, 19, "Gu"], 1, 20, [0, 16, "DG"], 20, 1, 1, 20, 20, [0, 12, "GaO"], 1, 20, 1, 20, 20, [0, 8, "Zi"], 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 37
[ , 2, [6, 16], 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 1, 20, 1, 20, 3, 20, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 38
[ , 2, 1, 1, 2, 1, 2, 2, [0, 20, "Bou"], [0, 19, "DaH"], 1, 1, 1, 1, 20, 1, 1, 20, [0, 12, "QR"], 1, 2, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 39
[ , 2, 2, 1, 2, 2, [0, 24, "Gu"], 2, 1, 1, 20, [0, 18, "KPm"], [0, 17, "BMP"], 1, 1, 20, 1, 1, 1, 20, [0, 11, "KPm"], 20, 20, [0, 9, "KPm"], 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 40
[ , [6, 5], 2, 20, [0, 28, "KPq"], 2, 1, 2, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 1, 1, 2, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20],
#V   n = 41
[ , 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 20, 1, 2, 20, 1, 1, 1, 2, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, [0, 4, "IN"], 1, 20, 20],
#V   n = 42
[ , 2, [6, 21], 1, 2, [0, 28, "GB4"], 1, 2, [0, 23, "Ayd"], [0, 22, "DaH"], 20, [0, 20, "DaH"], 20, [0, 18, "DaH"], [0, 17, "DaH"], 20, [0, 16, "DaH"], 20, 20, 1, 1, 2, 1, 20, 20, 1, 20, 1, 20, 20, [0, 7, "Zi"], 20, 1, 20, 1, 1, 20, 1, 20, 20],
#V   n = 43
[ , 2, 1, 2, [0, 30, "Liz"], 3, 1, 2, 1, 1, 2, 3, 20, 3, 3, 20, 3, 20, 20, 20, 1, 2, 2, 1, 20, 20, 1, 20, 1, 20, 3, 20, 20, 1, 20, [0, 5, "KPc"], 1, 20, 1, 20, 20],
#V   n = 44
[ , 2, 20, [7, 169], 2, 1, 20, [0, 27, "Zi"], 1, 1, 2, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, [0, 14, "QR"], 2, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 45
[ , [6, 5], 1, 1, 2, 2, [0, 28, "Gu"], 3, 2, 1, 2, 2, 1, 2, [0, 18, "DG5"], [0, 17, "GW1"], 20, 1, 1, 20, 20, 1, 2, 1, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 46
[ , 2, 1, 2, [0, 32, "Liz"], 2, 1, 1, 2, 20, [0, 24, "DaH"], [0, 22, "DaH"], 20, [0, 20, "GW2"], 1, 1, 20, 20, 1, 1, 20, 20, [0, 14, "GaO"], 1, 1, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 47
[ , 2, 1, 2, 1, 2, 1, 1, 2, 20, 3, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 1, 2, 1, 1, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 48
[ , 2, 1, 2, 2, [0, 32, "Gu"], 1, 1, 2, 2, 3, [0, 23, "DG"], 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, [0, 14, "GaO"], 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 49
[ , 2, 20, [0, 36, "GH"], 2, 1, 1, 1, 2, 2, 1, 1, 20, 1, 1, 1, 2, 1, 1, 20, 20, 1, 1, 1, 1, 20, 1, 2, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 50
[ , [6, 5], 2, 1, 2, 2, 1, 1, 2, [0, 27, "Da4"], 20, 1, 2, 20, 1, 1, 2, 20, 1, 1, 20, 20, 1, 1, 1, 1, 20, [0, 12, "D1"], 20, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20],
#V   n = 51
[ , 2, 2, 20, [0, 36, "Bou"], 2, 20, 1, 2, 2, 1, 20, [0, 24, "DaH"], 20, 20, 1, 2, [0, 19, "DaH"], 20, 1, 1, 20, 20, 1, 1, 1, 2, 1, 1, 20, 20, 1, 20, 20, [0, 9, "DaH"], 20, [0, 8, "LX"], 1, 20, 20, 20, [0, 6, "DaH"], 1, 20, 1, 20, 1, 20, 20],
#V   n = 52
[ , 2, 2, 1, 1, 2, [0, 33, "Gu"], 20, [0, 32, "DaH"], 2, 2, [0, 25, "DG5"], 1, 1, 20, 20, [0, 22, "DaH"], 1, 20, 20, 1, 1, 20, 20, 1, 1, 2, 20, 1, 1, 20, 20, 1, 20, 3, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 53
[ , 2, [6, 16], 1, 2, [0, 36, "XX"], 1, 20, 3, 2, 2, 1, 20, 1, 1, 20, 3, 1, 1, 20, 20, 1, 1, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 54
[ , 2, 1, 1, 2, 3, 1, 2, 3, 2, 2, 1, 1, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, [0, 16, "GaO"], 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, [0, 8, "BZ"], 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 55
[ , [6, 5], 2, 1, 2, 1, 1, 2, 2, [0, 31, "DaH"], [0, 29, "DG"], 1, 1, 1, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 3, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 56
[ , 2, 2, 20, [0, 40, "BKW"], 1, 1, 2, 2, 3, 3, 1, 1, 1, 1, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 57
[ , 2, 2, 2, 3, 1, 1, 2, [0, 34, "YC"], 2, 1, 20, 1, 1, 1, 2, 20, [0, 24, "DaH"], 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 1, 2, 20, 20, [0, 12, "D1"], 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 58
[ , 2, [6, 16], 2, 1, 1, 1, 2, 2, [0, 32, "DaH"], 1, 1, 20, 1, 1, 2, 20, 3, 20, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 2, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 59
[ , 2, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2, 20, 1, 2, 1, 1, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 2, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 60
[ , [6, 5], 1, 2, 1, 1, 1, 2, [0, 36, "BZ"], 1, 1, 2, [0, 30, "BZ"], 20, 20, [0, 28, "GW2"], 1, 1, 1, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 1, 2, 1, 1, 20, 20, [5, 21], 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 61
[ , 2, 1, 2, 1, 1, 1, 2, 3, 1, 1, 2, 1, 1, 20, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 2, 20, 20, 1, 2, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 62
[ , 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 20, 1, 1, 1, 2, 1, 20, 20, 1, 1, 1, 2, 20, 20, 20, [0, 18, "GaO"], [0, 15, "Vx"], 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 63
[ , 2, 1, 2, 20, 1, 1, 2, 2, 1, 1, 2, [0, 32, "DaH"], [0, 31, "DaH"], 1, 2, 20, [0, 28, "DaH"], 1, 2, 20, 1, 20, 20, 1, 1, 2, 20, 20, 20, 3, 1, 20, 20, 1, 2, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 64
[ , 2, 20, [7, 253], 2, 20, 1, 2, 2, 20, 1, 2, 1, 1, 20, [0, 30, "DaH"], 20, 3, 20, [0, 27, "XBC"], 20, 20, 1, 20, 20, 1, 2, 20, 20, 20, 3, 1, 1, 20, 20, [0, 14, "XBC"], 20, 20, 1, 20, 20, 1, 20, 20, 1, 2, 20, 1, 20, 20, 1, 20, 20, [0, 6, "XBC"], 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 65
[ , [6, 5], 20, 3, 2, 20, 20, [0, 44, "BCH"], 2, 20, 20, [0, 36, "DaH"], 2, 1, 2, 1, 1, 1, 20, 3, 1, 20, 20, 1, 20, 20, [0, 23, "BCH"], [0, 19, "Vx"], 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 1, 20, 20, 1, 20, 20, [0, 10, "BCH"], 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 5, "Ed"], 20, 1, 20, 1, 20, 20],
#V   n = 66
[ , 2, 1, 1, 2, 1, 20, 3, 2, 1, 20, 3, 2, 20, [0, 32, "DaH"], 20, 1, 2, 1, 1, 1, 1, 20, 20, 1, 20, 3, 1, 20, 20, 20, 1, 1, 2, 1, 20, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 67
[ , 2, 1, 2, [0, 48, "Bou"], 1, 2, 3, 2, 1, 2, 3, [0, 35, "MTS"], 1, 2, 20, 20, [0, 30, "DaH"], 20, [0, 28, "XX"], 1, 1, 1, 20, 20, [0, 24, "XX"], 3, 2, [0, 19, "Vx"], 20, 20, 20, 1, 2, 20, [0, 15, "XX"], 20, 1, 1, 20, 20, 1, 20, 20, [0, 11, "XX"], 20, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 68
[ , 2, 1, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 20, [0, 33, "BZ"], 1, 20, 3, 20, 3, 20, 1, 2, 1, 20, 1, 2, [0, 21, "Vx"], 1, 20, 20, 20, 20, [0, 18, "GaO"], 2, 1, 20, 20, [0, 14, "XX"], 1, 20, 20, 1, 20, 1, 20, 20, [0, 10, "XX"], 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 69
[ , 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, [0, 36, "DaH"], 1, 1, 2, 1, 2, [0, 29, "XX"], 1, 20, 20, [0, 27, "XX"], 20, [0, 25, "XX"], 20, [0, 24, "XX"], 1, 1, 1, 20, 20, 20, 1, 2, 20, 1, 20, 1, 20, [0, 13, "XX"], 20, 20, [0, 12, "XX"], 20, 1, 20, 1, 20, [0, 9, "XX"], 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 70
[ , [6, 5], 20, [0, 52, "Bel"], [0, 50, "BKW"], 20, [0, 48, "XX"], 2, [0, 44, "DaH"], 20, [0, 40, "BZ"], [0, 38, "DaH"], 3, [0, 35, "DaH"], [0, 34, "DaH"], [0, 33, "DaH"], 20, [0, 31, "DaH"], 1, 20, 1, 20, 1, 1, 1, 20, 3, 2, [0, 21, "Vx"], [0, 20, "BZ"], [0, 19, "Ed"], 20, 20, 20, [0, 18, "GaO"], 2, 20, [0, 15, "XX"], 20, 1, 1, 20, 20, 1, 20, 20, [0, 11, "XX"], 20, 1, 1, 20, 20, 20, 1, 20, 20, [0, 7, "Ed"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 71
[ , 2, 1, 2, 1, 2, 1, 2, 3, 1, 2, 3, 1, 2, 3, 3, 20, 3, 1, 2, 20, [0, 28, "XX"], 20, [0, 27, "BET"], 1, 1, 2, [0, 23, "Vx"], 1, 1, 1, 20, 20, 20, 1, 2, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 72
[ , 2, 1, 2, 1, 2, 20, [0, 48, "BET"], 3, 1, 2, 1, 2, [0, 36, "BZ"], 1, 2, 20, 1, 20, [0, 30, "Tol"], 20, 1, 20, 1, 20, [0, 26, "Tol"], [0, 25, "X"], 1, 1, 2, 1, 1, 20, 20, 20, [0, 18, "GaO"], 1, 20, 1, 20, 20, [0, 14, "Tol"], 1, 20, 20, [0, 12, "X"], 20, 1, 20, 20, [0, 10, "Tol"], 1, 20, 20, 20, [0, 8, "BZ"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 73
[ , 2, 1, 2, 1, 2, 20, 3, 1, 1, 2, 1, 2, 1, 1, 2, 1, 20, 1, 2, 20, 20, [0, 28, "XX"], 20, 1, 2, 3, 20, [0, 23, "Ed"], [0, 22, "XX"], 20, 1, 1, 20, 20, 3, 20, 1, 20, 1, 20, 1, 20, [0, 13, "XX"], 20, 1, 20, 20, 1, 20, 1, 20, [0, 9, "XX"], 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 74
[ , 2, 1, 2, 1, 2, 2, 3, 20, 1, 2, 1, 2, 2, 1, 2, 1, 1, 20, [0, 31, "XX"], 1, 20, 1, 20, 20, [0, 27, "XX"], 2, [0, 24, "Ed"], 3, 1, 1, 20, 1, 2, 20, 1, 1, 20, 1, 20, [0, 15, "BET"], 20, 1, 1, 20, 20, 1, 20, 20, [0, 11, "BET"], 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 75
[ , [6, 5], 20, [0, 56, "Bel"], 1, 2, 2, 2, 1, 20, [0, 44, "BZ"], 2, [0, 40, "BZ"], 2, 20, [0, 36, "BZ"], 1, 1, 2, 3, 1, 2, 20, 1, 20, 1, 2, 1, 1, 20, [0, 22, "Ed"], 1, 20, [0, 20, "BZ"], 20, 20, [0, 18, "Vx"], 1, 20, 1, 1, 20, 20, [0, 14, "BET"], 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 76
[ , 2, 1, 1, 1, 2, 2, 2, 1, 1, 2, 2, 1, 2, 20, 1, 1, 1, 2, 1, 20, [0, 30, "BET"], 20, 20, [0, 28, "XX"], 20, [0, 27, "Ed"], 20, [0, 24, "Ed"], [0, 23, "XX"], 1, 20, [0, 21, "XX"], 1, 1, 20, 1, 20, [0, 17, "VE"], 20, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 77
[ , 2, 1, 2, 1, 2, [0, 52, "BET"], [0, 50, "X"], 1, 1, 2, 2, 1, 2, 1, 20, 1, 1, 2, 20, 1, 2, [0, 29, "Ed"], 20, 1, 20, 3, [0, 25, "Ed"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, [0, 11, "VE"], 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 78
[ , 2, 1, 2, 20, [0, 56, "Hi"], 3, 2, 1, 1, 2, [0, 44, "Ayd"], 1, 2, 1, 1, 20, 1, 2, 1, 20, [0, 31, "XX"], 1, 20, 20, [0, 28, "XX"], 3, 1, 20, 1, 1, 20, [0, 22, "XX"], [0, 21, "Ed"], 20, 1, 1, 20, [0, 18, "VE"], 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 79
[ , 2, 1, 2, 20, 3, 1, 2, 20, 1, 2, 1, 1, 2, 1, 1, 1, 20, [0, 36, "GW2"], 20, 1, 1, 1, 1, 20, 1, 1, 2, [0, 25, "Ed"], 20, 1, 1, 1, 1, 20, 20, 1, 2, 1, 20, 1, 20, 20, 1, 2, 20, [0, 14, "Ed"], 20, [0, 13, "Ed"], 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 80
[ , [6, 5], 20, [7, 317], 20, 3, 20, [0, 52, "BZ"], 20, 20, [0, 48, "BZ"], 1, 1, 2, 1, 1, 1, 2, 3, 1, 20, [0, 32, "BZ"], [0, 31, "Ed"], 1, 2, 20, [0, 28, "Ed"], [0, 27, "Ed"], 1, 20, 20, [0, 24, "BZ"], [0, 23, "Ed"], 1, 1, 20, 20, [0, 20, "BZ"], 20, 1, 20, 1, 20, 20, [0, 16, "BZ"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 81
[ , 2, 1, 2, 1, 2, 1, 2, 1, 20, 3, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, 1, 20, [0, 30, "X6u"], 20, 3, 3, [0, 26, "Ed"], 1, 20, 1, 1, 20, 1, 2, 20, 1, 1, 20, 1, 20, [0, 17, "VE"], 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, [0, 6, "Ed"], 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 82
[ , 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, 20, 1, 2, [0, 29, "Ed"], 1, 1, 1, 20, [0, 25, "Ed"], 20, 1, 1, 20, [0, 22, "Ed"], 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 83
[ , 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, [0, 32, "Ed"], 20, [0, 31, "XX"], 1, 20, 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 20, 20, 1, 1, 20, [0, 18, "VE"], 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 84
[ , 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 20, 1, 2, 1, 1, 1, 2, 2, 20, 1, 2, 1, 20, 1, 2, [0, 29, "Ed"], 20, 1, 2, 1, 1, 20, 20, 1, 2, 1, 1, 20, 20, 1, 2, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20],
#V   n = 85
[ , [6, 5], 20, [7, 338], 2, [0, 60, "BCH"], 20, [0, 56, "BZ"], 2, 1, 2, 20, 20, [0, 48, "DaH"], [0, 45, "DaH"], [0, 44, "DaH"], [0, 43, "DaH"], [0, 42, "DaH"], [0, 40, "DaH"], 20, 20, [0, 36, "BZ"], [0, 33, "BZ"], [0, 32, "BZ"], 20, [0, 31, "BCH"], 1, 20, 20, [0, 28, "BZ"], 20, [0, 26, "BZ"], [0, 25, "Ed"], 20, 20, [0, 24, "BZ"], 20, [0, 22, "BZ"], 1, 20, 20, [0, 20, "BZ"], 20, 1, 20, 1, 20, 20, [0, 16, "BZ"], 1, 20, 1, 20, 1, 20, 20, 20, [0, 12, "BZ"], 1, 20, 20, 20, [0, 10, "BCH"], [0, 9, "BZ"], 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, [0, 3, "Ham"], 20, 20],
#V   n = 86
[ , 2, 20, 3, 2, 2, 20, 3, [0, 54, "Da"], 20, [0, 52, "XBZ"], 20, 20, 3, 3, 3, 3, 3, 2, 20, 20, 3, 1, 1, 20, 1, 2, [0, 29, "Ed"], 20, 3, [0, 27, "Ed"], 1, 1, 20, 20, 3, [0, 23, "Ed"], 1, 20, [0, 21, "Ed"], 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 15, "Ed"], 20, [0, 14, "XBC"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 87
[ , 2, 2, 1, 2, 2, 2, 3, 3, 20, 3, 20, 20, 3, 3, 3, 3, 3, [0, 41, "DaH"], 2, 20, 3, 2, [0, 33, "Ed"], 1, 20, [0, 31, "X"], 1, 20, 1, 1, 20, [0, 26, "Ed"], 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 20, "Ed"], 1, 20, 1, 20, [0, 17, "VE"], 20, 1, 1, 20, 1, 20, 20, [0, 13, "Var"], 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 88
[ , 2, 2, 20, [0, 64, "Bou"], 2, 2, 2, 2, 20, 3, 1, 20, 3, 1, 1, 1, 1, 2, [0, 38, "Vx"], 20, 3, [0, 35, "Ed"], 1, 20, [0, 32, "BZ"], 3, 1, 1, 20, [0, 28, "Ed"], 1, 1, 20, 1, 20, 1, 1, 20, [0, 22, "Ed"], 1, 20, 1, 20, 1, 20, [0, 18, "VE"], 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 89
[ , 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 3, 1, 2, 1, 2, [0, 42, "DaH"], 2, [0, 37, "Vx"], 1, 1, 2, [0, 33, "Ed"], 1, 1, 20, [0, 30, "VE"], [0, 29, "Var"], 1, 20, [0, 27, "Ed"], 1, 20, [0, 25, "Ed"], 20, 1, 1, 1, 20, 1, 20, 1, 20, [0, 19, "Ed"], 1, 20, 1, 20, 20, [0, 16, "Ed"], 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 11, "X"], 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 90
[ , [6, 5], [6, 6], 2, 20, [0, 64, "BZ"], 2, [0, 58, "XB"], [0, 56, "BZx"], 1, 2, 20, [0, 50, "DaH"], 1, 2, [0, 46, "DaH"], 20, [0, 44, "DaH"], 3, 2, 1, 20, [0, 36, "Ed"], [0, 35, "Ed"], 1, 20, [0, 32, "Ed"], 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 24, "Tol"], [0, 23, "Ed"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, [0, 10, "X"], 1, 20, 20, 20, 20, [0, 8, "BZ"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 91
[ , 2, 1, 2, 2, 3, [0, 61, "Gu"], 2, 3, 20, [0, 54, "XB"], 1, 2, 20, [0, 48, "DaH"], 1, 1, 2, 2, [0, 40, "Vx"], 2, [0, 37, "Vx"], 1, 1, 2, 1, 1, 20, [0, 31, "Ed"], 1, 1, 20, [0, 28, "Ed"], 1, 20, [0, 26, "Ed"], 1, 20, 1, 1, 20, 1, 20, [0, 21, "Var"], 20, [0, 20, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 92
[ , 2, 2, [6, 17], 2, 3, 3, 2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 3, [0, 39, "BZ"], 1, 20, [0, 36, "BZ"], [0, 35, "Ed"], 20, [0, 33, "Ed"], 1, 1, 20, [0, 30, "BZ"], 1, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 93
[ , 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, [0, 48, "DaH"], 20, [0, 46, "DaH"], [0, 44, "DaH"], 1, 2, [0, 38, "BZ"], [0, 37, "Vx"], 1, 1, 1, 1, 20, [0, 32, "Ed"], 1, 1, 20, [0, 29, "Var"], 1, 20, [0, 27, "Ed"], 1, 20, [0, 25, "Var"], 20, 1, 1, 20, [0, 22, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 94
[ , 2, 2, 2, [0, 68, "Bou"], 2, 1, 2, 1, 2, [0, 56, "XB"], 20, [0, 53, "DaH"], 1, 2, 3, 20, 3, 3, 1, 2, 1, 1, 20, [0, 36, "Ed"], [0, 35, "Ed"], [0, 34, "Var"], 1, 1, 20, [0, 31, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 17, "Var"], 20, 1, 20, [0, 15, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, [0, 10, "Ed"], 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 95
[ , [6, 5], [6, 16], 2, 2, 2, 2, [0, 62, "DaH"], [0, 59, "DaH"], [0, 58, "DaH"], 3, [0, 54, "DaH"], 3, [0, 52, "DaH"], [0, 51, "DaH"], 1, 2, 3, 2, 1, 2, 1, 1, 2, 1, 1, 1, 20, [0, 33, "Var"], 1, 1, 20, 1, 1, 20, [0, 28, "Var"], 1, 20, [0, 26, "Var"], 1, 20, 20, 1, 2, 1, 20, 1, 20, 1, 20, [0, 19, "Var"], 20, [0, 18, "VE"], 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 20, [0, 9, "Ed"], 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 96
[ , 2, 1, 2, 2, 2, [0, 64, "GB4"], 2, 1, 2, 2, 2, 3, 3, 3, 20, [0, 48, "BZ"], 2, [0, 45, "BZ"], 20, [0, 42, "BZ"], [0, 40, "BZ"], [0, 39, "BZ"], [0, 38, "BZ"], 20, [0, 36, "BZ"], 1, 1, 1, 20, [0, 32, "Var"], 1, 20, [0, 30, "Ed"], 1, 1, 20, 1, 1, 20, 1, 20, 20, [0, 24, "Tol"], 20, 1, 20, 1, 20, [0, 20, "Var"], 1, 20, 1, 20, 1, 20, 20, [0, 16, "BZ"], 1, 20, 20, [0, 14, "Ed"], 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 97
[ , 2, 2, [6, 17], 2, [0, 68, "Koh"], 1, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 20, [0, 35, "Ed"], [0, 34, "Var"], 1, 1, 20, 1, 1, 20, [0, 29, "Var"], 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 21, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 98
[ , 2, 2, 1, 2, 2, 2, [0, 64, "DaH"], 1, 2, 2, 2, 1, 2, [0, 52, "DaH"], 1, 2, [0, 48, "DaH"], 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 20, 1, 1, 20, [0, 31, "Ed"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 25, "Var"], 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 13, "Var"], 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 99
[ , 2, 2, 2, [0, 72, "BKW"], 2, 2, 3, 1, 2, 2, 2, 1, 2, 3, 20, [0, 50, "GW1"], 1, 2, 1, 2, 1, 2, [0, 40, "BZ"], 1, 2, 20, 1, 1, 1, 20, [0, 33, "Ed"], 1, 1, 20, 1, 1, 20, [0, 28, "Var"], 1, 20, 1, 1, 20, 20, 1, 1, 20, [0, 22, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 100
[ , [6, 5], [6, 16], 2, 3, 2, 2, 1, 1, 2, [0, 60, "BZ"], 2, 1, 2, 1, 1, 2, 20, [0, 48, "BZ"], 2, [0, 45, "BZ"], 20, [0, 42, "BZ"], 1, 20, [0, 39, "BZ"], 1, 20, [0, 36, "BZ"], [0, 35, "Var"], 1, 1, 20, [0, 32, "Var"], 1, 20, [0, 30, "Ed"], 1, 1, 20, 1, 20, [0, 26, "Var"], 1, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 101
[ , 2, 1, 2, 1, 2, 2, 20, 1, 2, 1, 2, 1, 2, 1, 2, [0, 51, "XBZ"], 2, 1, 2, 3, 2, 3, 20, [0, 40, "Ed"], 3, [0, 38, "Ed"], [0, 37, "Var"], 1, 1, 20, [0, 34, "Var"], 1, 1, 20, 1, 1, 20, [0, 29, "Var"], 1, 20, 1, 1, 20, 1, 20, 20, 1, 2, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 2, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 102
[ , 2, 2, [6, 17], 2, [0, 72, "BKW"], 2, 2, 20, [0, 64, "DaH"], 20, [0, 60, "DaH"], 1, 2, [0, 54, "DaH"], [0, 53, "DaH"], 3, [0, 50, "DaH"], 20, [0, 48, "BZ"], 2, [0, 44, "BZ"], 1, 2, 1, 1, 1, 1, 20, 1, 1, 1, 20, [0, 33, "Var"], 1, 20, [0, 31, "Ed"], 1, 1, 20, 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 20, [0, 24, "Tol"], 20, 1, 20, 1, 20, 1, 20, [0, 19, "Var"], 20, [0, 18, "Var"], 20, [0, 17, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, [0, 12, "Tol"], 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 103
[ , 2, 2, 3, 2, 3, 2, 2, 20, 3, 1, 1, 1, 2, 2, 3, 1, 2, 20, 3, 2, 1, 2, [0, 42, "XBZ"], 20, [0, 40, "Ed"], 1, 1, 1, 20, [0, 36, "Ed"], [0, 35, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 25, "Var"], 20, 1, 1, 20, 1, 20, 1, 20, [0, 20, "Var"], 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 104
[ , 2, 2, 1, 2, 2, [0, 71, "Gu"], 2, 20, 3, 1, 1, 1, 2, 2, 3, 1, 2, 20, 1, 2, 1, 2, 1, 1, 1, 20, [0, 39, "Ed"], [0, 38, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 32, "Var"], 1, 20, [0, 30, "Ed"], 1, 20, [0, 28, "Var"], 1, 20, 1, 1, 20, 20, [0, 24, "Vx"], 1, 20, 1, 20, [0, 21, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Ed"], 20, [0, 15, "Var"], 20, 1, 20, 1, 20, 20, 20, [0, 12, "Vx"], 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 105
[ , [6, 5], [6, 21], 1, 2, 2, 3, [0, 68, "BZ"], 1, 1, 1, 1, 1, 2, [0, 56, "BZ"], 1, 20, [0, 52, "DaH"], 1, 20, [0, 48, "BZ"], 1, 2, [0, 43, "Ed"], [0, 42, "Ed"], [0, 41, "Var"], 1, 1, 1, 20, [0, 37, "Var"], 1, 1, 20, [0, 34, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 26, "Var"], 1, 20, 1, 20, 1, 20, [0, 22, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 106
[ , 2, 3, 1, 2, 2, 3, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 3, 2, 1, 1, 1, 2, 1, 1, 1, 20, [0, 40, "Ed"], 1, 1, 1, 20, [0, 36, "Var"], 1, 1, 20, [0, 33, "Var"], 1, 20, [0, 31, "Var"], 1, 20, [0, 29, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 23, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, [0, 6, "Ed"], 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 107
[ , 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 20, [0, 54, "XB"], 3, [0, 51, "XB"], 20, 1, 1, 2, 1, 1, 1, 1, 1, 20, [0, 39, "Ed"], [0, 38, "Var"], 1, 1, 20, [0, 35, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 14, "Ed"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 108
[ , 2, 2, 1, 2, [0, 76, "BKW"], 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 20, 20, 1, 2, [0, 45, "Ed"], [0, 44, "DNX"], [0, 43, "DNX"], [0, 42, "Ed"], [0, 41, "Var"], 1, 1, 1, 20, [0, 37, "Var"], 1, 1, 20, 1, 1, 20, [0, 32, "Var"], 1, 20, [0, 30, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 24, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, [0, 8, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 109
[ , 2, 2, 20, [7, 426], 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2, 20, 20, [0, 49, "GW2"], 1, 1, 1, 1, 1, 20, [0, 40, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 34, "Ed"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, [0, 25, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 110
[ , [6, 5], 2, 2, 3, 2, 2, [0, 72, "BZ"], 2, 20, 1, 1, 1, 2, [0, 60, "BZ"], 20, [0, 56, "BZ"], 1, 2, [0, 51, "BZ"], 20, 20, 3, [0, 46, "Ed"], [0, 45, "Ed"], [0, 44, "BZ"], [0, 43, "Var"], 1, 1, 1, 20, [0, 39, "Ed"], 1, 1, 20, [0, 36, "Ed"], 1, 1, 20, [0, 33, "Var"], 1, 20, [0, 31, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 20, "Var"], 20, [0, 19, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 13, "Var"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 111
[ , 2, [6, 6], 2, 2, 2, 2, 1, 2, 20, 20, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 20, 3, 1, 1, 1, 1, 20, [0, 42, "Ed"], [0, 41, "Var"], 1, 1, 20, [0, 38, "Ed"], 1, 1, 20, [0, 35, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, [0, 26, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 21, "Var"], 1, 20, 1, 20, 20, [0, 18, "Ed"], 20, [0, 17, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 11, "VE"], 20, 20, 1, 20, 1, 20, 20, 20, [0, 8, "Ed"], 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 112
[ , 2, 1, 2, 2, 2, [0, 76, "DG5"], 1, 2, 2, 20, 20, 1, 2, 2, 1, 2, 20, [0, 55, "GW2"], 2, [0, 51, "BZ"], 20, 3, 1, 1, 1, 1, 1, 1, 1, 20, [0, 40, "Var"], 1, 1, 20, [0, 37, "Var"], 1, 1, 20, 1, 1, 20, [0, 32, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 22, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, [0, 9, "Ed"], 20, 20, 1, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 113
[ , 2, 2, [6, 28], 2, 2, 2, 1, 2, 2, 20, 20, 20, [0, 68, "DaH"], 2, 1, 2, 1, 2, 2, 1, 2, 3, 1, 1, 2, [0, 45, "DNX"], [0, 44, "Ed"], [0, 43, "Var"], 1, 1, 1, 20, [0, 39, "Var"], 1, 1, 20, [0, 36, "Var"], 1, 20, [0, 34, "Ed"], 1, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 23, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 20, [0, 7, "DaH"], 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 114
[ , 2, 2, 1, 2, 2, 2, 2, [0, 74, "Bou"], 2, 20, 20, 20, 3, 2, 1, 2, 1, 2, 2, 1, 2, 1, 20, 1, 2, 1, 1, 1, 20, [0, 42, "Var"], [0, 41, "Var"], 1, 1, 20, [0, 38, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, 1, 20, [0, 24, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 3, 20, 1, 20, 20, 20, [0, 5, "Bou"], 20, 20, 1, 1, 20, 20, 20],
#V   n = 115
[ , [6, 5], 2, 2, [0, 84, "Gu3"], 2, 2, [0, 76, "BZ"], 3, [0, 72, "BZ"], 1, 20, 20, 3, [0, 64, "BZ"], 20, [0, 60, "BZ"], 1, 2, 2, 2, [0, 52, "BZ"], 2, 1, 20, [0, 48, "BZ"], [0, 46, "Ed"], [0, 45, "Var"], 1, 1, 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, [0, 35, "Var"], 1, 20, [0, 33, "Var"], 1, 20, [0, 31, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 25, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 15, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 116
[ , 2, [6, 16], 2, 1, 2, 2, 2, 3, 2, 1, 1, 20, 3, 2, 1, 1, 1, 2, 2, [0, 54, "BZ"], 2, [0, 51, "BZ"], 20, [0, 49, "GW2"], 3, 1, 1, 20, [0, 44, "Ed"], [0, 43, "Var"], 1, 1, 20, [0, 40, "Ed"], 1, 1, 20, [0, 37, "Ed"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 117
[ , 2, 1, 2, 2, [0, 84, "Bou"], [0, 80, "Gu"], 2, 1, 2, 1, 1, 2, 3, 2, 1, 2, 1, 2, 2, 1, 2, 2, [0, 50, "Ed"], 3, 1, 1, 1, 1, 1, 1, 20, [0, 42, "Var"], 1, 1, 20, [0, 39, "Ed"], 1, 1, 20, [0, 36, "Var"], 1, 20, [0, 34, "Var"], 1, 20, [0, 32, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 26, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 118
[ , 2, 2, [0, 88, "Bel"], 2, 2, 2, 2, 1, 2, 1, 1, 2, 3, 2, 1, 2, 20, [0, 60, "GW2"], 2, 1, 2, 2, 1, 1, 20, 1, 1, 2, [0, 45, "Var"], 1, 1, 1, 20, [0, 41, "Var"], 1, 1, 20, [0, 38, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 20, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, [0, 7, "VE"], 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 119
[ , 2, 2, 1, 2, 2, 2, 2, 1, 2, 20, 1, 2, 1, 2, 1, 2, 20, 3, [0, 59, "GW2"], 1, 2, 2, 1, 2, [0, 49, "Var"], 20, 1, 2, 1, 20, [0, 44, "Var"], [0, 43, "Var"], 1, 1, 20, [0, 40, "Var"], 1, 1, 20, 1, 1, 20, [0, 35, "Var"], 1, 20, [0, 33, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 22, "Var"], 20, [0, 21, "Ed"], 1, 20, 20, [0, 19, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 14, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, [0, 8, "Ed"], 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 120
[ , [6, 5], 2, 2, [0, 88, "GB4"], 2, 2, [0, 80, "BZ"], 20, [0, 76, "BZ"], 20, 20, [0, 72, "BZ"], 20, [0, 68, "BZ"], 20, [0, 64, "BZ"], 20, 3, 3, [0, 57, "BZ"], [0, 56, "BZ"], [0, 54, "BZ"], [0, 52, "BZ"], [0, 51, "BZ"], 1, 20, 20, [0, 48, "BZ"], 1, 1, 1, 1, 20, [0, 42, "Var"], 1, 1, 20, 1, 1, 20, [0, 37, "Ed"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 23, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 18, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, [0, 12, "BZ"], 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 121
[ , 2, [6, 16], 2, 1, 2, 2, 2, 1, 2, 1, 20, 3, 1, 2, 1, 2, 1, 2, 3, 1, 2, 2, 1, 1, 1, 1, 20, 3, [0, 47, "Ed"], [0, 46, "Ed"], [0, 45, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 39, "Ed"], 1, 1, 20, [0, 36, "Var"], 1, 20, [0, 34, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 24, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 17, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 122
[ , 2, 1, 2, 20, [0, 88, "GW2"], 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, [0, 51, "Ed"], [0, 50, "Var"], [0, 49, "Var"], 1, 1, 1, 1, 20, [0, 44, "Var"], 1, 1, 20, [0, 41, "Ed"], 1, 1, 20, [0, 38, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 25, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 123
[ , 2, 2, [0, 92, "Bel"], 2, 3, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 20, [0, 48, "Ed"], [0, 47, "Var"], 1, 1, 1, 20, [0, 43, "Var"], 1, 1, 20, [0, 40, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, [0, 26, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 124
[ , 2, 2, 2, 2, 3, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 20, 1, 2, [0, 57, "BZ"], 2, [0, 54, "BZ"], 1, 1, 1, 1, 1, 1, 20, [0, 46, "Ed"], [0, 45, "Var"], 1, 1, 20, [0, 42, "Var"], 1, 1, 20, [0, 39, "Var"], 1, 20, [0, 37, "Var"], 1, 20, [0, 35, "Ed"], 1, 20, [0, 33, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 27, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Var"], 20, 1, 20, 1, 20, 20, [0, 13, "Var"], 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 125
[ , [6, 5], 2, 2, 2, 1, 2, [0, 84, "BZ"], 2, [0, 80, "BZ"], 2, 1, 2, 20, [0, 72, "BZ"], 20, [0, 68, "BZ"], 2, [0, 64, "BZ"], 1, 20, [0, 60, "BZ"], 2, [0, 56, "BZ"], 2, [0, 53, "Ed"], [0, 52, "BZ"], [0, 51, "BZ"], [0, 50, "Ed"], [0, 49, "Var"], 1, 1, 1, 1, 20, [0, 44, "Var"], 1, 1, 20, [0, 41, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, [0, 12, "Ed"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20],
#V   n = 126
[ , 2, [6, 21], 2, [0, 92, "GB4"], 20, [0, 88, "BKW"], 2, [0, 82, "DaH"], 3, [0, 78, "DaH"], 20, [0, 76, "XBZ"], 20, 3, [0, 69, "DaH"], 3, [0, 66, "DaH"], 2, 1, 2, 3, 2, 1, 2, 1, 1, 1, 1, 1, 20, [0, 48, "Ed"], [0, 47, "Var"], 1, 1, 1, 20, [0, 43, "Var"], 1, 1, 20, 1, 1, 20, [0, 38, "Var"], 1, 20, [0, 36, "Var"], 1, 20, [0, 34, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 28, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, [0, 4, "Gl"], 1, 20, 20, 20],
#V   n = 127
[ , 2, 1, 2, 2, 2, 3, 2, 2, 3, 1, 2, 3, 2, 3, 2, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, [0, 52, "Var"], [0, 51, "Var"], 1, 1, 1, 1, 20, [0, 46, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 40, "Ed"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 15, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 128
[ , 2, 20, [6, 64], 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 20, [0, 63, "BZ"], 20, [0, 60, "BZ"], 20, [0, 57, "BZ"], 20, [0, 54, "BZ"], 1, 1, 20, [0, 50, "Ed"], [0, 49, "Var"], 1, 1, 1, 20, [0, 45, "Var"], 1, 1, 20, [0, 42, "Ed"], 1, 1, 20, [0, 39, "Var"], 1, 20, [0, 37, "Var"], 1, 20, [0, 35, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 129
[ , 2, 2, 3, 2, 2, 2, 2, 2, 2, 1, 2, [0, 77, "GW1"], 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 20, [0, 48, "Ed"], [0, 47, "Var"], 1, 1, 20, [0, 44, "Var"], 1, 1, 20, [0, 41, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 130
[ , [6, 5], 2, 1, 2, 2, 2, [6, 65], 2, 2, 20, [0, 80, "DaH"], 2, [0, 76, "DaH"], [0, 74, "DaH"], [0, 72, "GW2"], [0, 70, "XB"], 20, [0, 68, "DaH"], 1, 2, 1, 2, 1, 2, 1, 2, [0, 54, "Ed"], [0, 53, "DNX"], [0, 52, "Ed"], [0, 51, "Var"], 1, 1, 1, 1, 20, [0, 46, "Var"], 1, 1, 20, [0, 43, "Var"], 1, 1, 20, 1, 1, 20, [0, 38, "Var"], 1, 20, [0, 36, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, [0, 27, "Var"], 20, [0, 26, "BZ"], 20, [0, 25, "BZ"], 20, [0, 24, "BZ"], 20, [0, 23, "BZ"], 20, [0, 22, "BZ"], 20, [0, 21, "BZ"], 20, [0, 20, "BZ"], 20, [0, 19, "BZ"], 20, [0, 18, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 131
[ , 2, 2, 2, [0, 96, "BDK"], 2, 2, 3, 2, 2, 20, 3, 2, 3, 2, 3, 1, 2, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 20, [0, 50, "VE"], [0, 49, "Var"], 1, 1, 1, 20, [0, 45, "Var"], 1, 1, 20, [0, 42, "Var"], 1, 20, [0, 40, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 34, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 132
[ , 2, [6, 6], 2, 3, 2, [0, 92, "GW2"], 1, 2, 2, 20, 3, [0, 79, "GW1"], 1, 2, 3, [0, 71, "XB"], [0, 70, "GW2"], 3, 20, [0, 66, "BZ"], 20, [0, 63, "BZ"], 20, [0, 60, "BZ"], 20, [0, 57, "BZ"], [0, 55, "Vx"], [0, 54, "Var"], [0, 53, "Var"], 1, 1, 1, 1, 20, [0, 48, "Var"], 1, 1, 1, 20, [0, 44, "Var"], 1, 1, 20, 1, 1, 20, [0, 39, "Var"], 1, 20, [0, 37, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 17, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 133
[ , 2, 1, 2, 1, 2, 2, 20, [0, 88, "DaH"], 2, 2, 3, 3, 1, 2, 3, 3, 3, 3, 20, 3, 20, 3, 20, 3, [0, 58, "Vx"], 3, 1, 1, 1, 20, [0, 52, "VE"], [0, 51, "Var"], 1, 1, 1, 20, [0, 47, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 41, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 134
[ , 2, 2, [6, 49], 2, [0, 96, "BKW"], 2, 2, 3, 2, 2, 1, 2, 20, [0, 77, "GW1"], 1, 2, 3, 3, 20, 3, 20, 3, [0, 61, "Vx"], 3, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 50, "VE"], [0, 49, "Var"], 1, 1, 20, [0, 46, "VE"], 1, 1, 20, [0, 43, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 135
[ , [6, 5], 2, 2, 2, 3, [0, 94, "GW2"], 2, 1, 2, 2, 20, [0, 80, "BZ"], 20, 3, 20, [0, 72, "BZ"], 3, 3, 20, 3, [0, 64, "Vx"], 3, 2, 1, 2, [0, 58, "Vx"], [0, 57, "Vx"], [0, 56, "DNX"], [0, 55, "DNX"], [0, 54, "VE"], [0, 53, "Var"], 1, 1, 1, 1, 20, [0, 48, "Var"], 1, 1, 20, [0, 45, "Var"], 1, 1, 20, [0, 42, "Var"], 1, 20, [0, 40, "Var"], 1, 20, [0, 38, "VE"], 1, 20, [0, 36, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 30, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 136
[ , 2, 2, 2, 2, 2, 3, 2, 20, [0, 88, "DaH"], [0, 84, "GW2"], 1, 2, 20, 3, 1, 2, 2, 1, 1, 2, 1, 1, 2, 20, [0, 60, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 52, "VE"], [0, 51, "Var"], 1, 1, 1, 20, [0, 47, "Var"], 1, 1, 20, [0, 44, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 34, "Var"], 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 25, "VE"], 20, [0, 24, "VE"], 20, [0, 23, "VE"], 20, [0, 22, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Var"], 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 12, "VE"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 137
[ , 2, [6, 16], 2, [0, 100, "BKW"], 2, 2, [6, 65], 2, 3, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, [0, 58, "Vx"], [0, 57, "Vx"], [0, 56, "Var"], [0, 55, "Var"], 1, 1, 1, 1, 20, [0, 50, "Var"], 1, 1, 1, 20, [0, 46, "Var"], 1, 1, 20, 1, 1, 20, [0, 41, "Var"], 1, 20, [0, 39, "Var"], 1, 20, [0, 37, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 27, "Var"], 20, [0, 26, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 138
[ , 2, 1, 2, 2, 2, 2, 3, [0, 90, "MTS"], 3, 2, 1, 2, 1, 2, 1, 2, [0, 72, "BZ"], 2, 20, [0, 68, "BZ"], [0, 66, "Vx"], 20, [0, 64, "BZ"], 2, 20, [0, 60, "BZ"], 1, 1, 1, 1, 20, [0, 54, "VE"], [0, 53, "Var"], 1, 1, 1, 20, [0, 49, "VE"], [0, 48, "Var"], 1, 1, 20, 1, 1, 20, [0, 43, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 20, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 139
[ , 2, 2, [6, 64], 2, 2, [0, 96, "GW2"], 3, 2, 3, [0, 86, "GW2"], 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, [0, 63, "Vx"], 2, 1, 2, [0, 58, "Var"], 1, 1, 1, 1, 1, 20, [0, 52, "VE"], [0, 51, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 45, "VE"], 1, 1, 20, [0, 42, "Var"], 1, 20, [0, 40, "Var"], 1, 20, [0, 38, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 19, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 140
[ , [6, 5], 2, 2, 2, [0, 100, "BKW"], 2, 1, 2, 3, 3, 20, [0, 84, "BZ"], 20, [0, 80, "BZ"], 20, [0, 76, "BZ"], 20, [0, 72, "BZ"], 20, [0, 69, "BZ"], 20, [0, 66, "BZ"], 1, 2, [0, 62, "Vx"], 20, [0, 60, "BZ"], 1, 20, [0, 57, "VE"], [0, 56, "VE"], [0, 55, "Var"], 1, 1, 1, 1, 20, [0, 50, "Var"], 1, 1, 20, [0, 47, "VE"], 1, 1, 20, [0, 44, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, [0, 13, "Var"], 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 141
[ , 2, 2, 2, 2, 2, 2, 2, [0, 92, "MTS"], 2, 2, 20, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, [0, 64, "Vx"], 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 54, "VE"], [0, 53, "Var"], 1, 1, 1, 20, [0, 49, "Var"], 1, 1, 20, [0, 46, "Var"], 1, 1, 20, 1, 1, 20, [0, 41, "Var"], 1, 20, [0, 39, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 34, "Var"], 1, 20, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 18, "Var"], 20, 1, 20, 1, 20, 20, [0, 15, "Var"], 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 142
[ , 2, [6, 16], 2, [0, 104, "Bo1"], 2, 2, 2, 2, 2, [0, 87, "MTS"], 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 20, [0, 60, "Vx"], [0, 59, "VE"], [0, 58, "Var"], [0, 57, "Var"], 1, 1, 1, 1, 20, [0, 52, "Var"], [0, 51, "Var"], 1, 1, 20, [0, 48, "Var"], 1, 1, 20, [0, 45, "Var"], 1, 20, [0, 43, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 143
[ , 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 20, [0, 56, "VE"], [0, 55, "Var"], 1, 1, 1, 1, 20, [0, 50, "Var"], 1, 1, 20, [0, 47, "Var"], 1, 1, 20, 1, 1, 20, [0, 42, "Var"], 1, 20, [0, 40, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 144
[ , 2, 2, [6, 64], 2, 2, [0, 100, "GW2"], [6, 72], 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 20, [0, 72, "BZ"], 20, [0, 69, "BZ"], [0, 68, "BZ"], [0, 66, "BZ"], 20, [0, 64, "BZ"], 2, [0, 61, "Var"], [0, 60, "Var"], [0, 59, "Var"], 1, 1, 1, 1, 20, [0, 54, "VE"], [0, 53, "Var"], 1, 1, 1, 20, [0, 49, "Var"], 1, 1, 20, 1, 1, 20, [0, 44, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 32, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 27, "Var"], 20, [0, 26, "Var"], 1, 20, 20, [0, 24, "VE"], 20, [0, 23, "VE"], 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 17, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 145
[ , [6, 5], 2, 2, 2, [0, 104, "Koh"], 3, 1, 2, [0, 92, "BZ"], 1, 1, 2, 20, [0, 84, "BZ"], 20, [0, 80, "BZ"], 20, [0, 76, "BZ"], 2, 3, 1, 2, 3, 2, [0, 65, "Vx"], 3, [0, 63, "Vx"], 1, 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 1, 1, 20, [0, 52, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 46, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 28, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, [0, 5, "Ed"], 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 146
[ , 2, 2, 2, 2, 3, 2, 1, 2, 2, [0, 90, "MTS"], 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 56, "VE"], [0, 55, "Var"], 1, 1, 1, 20, [0, 51, "Var"], 1, 1, 20, [0, 48, "VE"], 1, 1, 20, [0, 45, "Var"], 1, 20, [0, 43, "Var"], 1, 20, [0, 41, "VE"], 1, 20, [0, 39, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 147
[ , 2, [6, 21], 2, [0, 108, "Bo1"], 3, 2, 1, 2, 2, 1, 20, [0, 89, "GW1"], 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 2, [0, 64, "Vx"], [0, 63, "Vx"], [0, 62, "VE"], [0, 61, "VE"], [0, 60, "Var"], [0, 59, "Var"], 1, 1, 1, 1, 20, [0, 54, "VE"], [0, 53, "Var"], 1, 1, 20, [0, 50, "Var"], 1, 1, 20, [0, 47, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, [0, 34, "Var"], 1, 20, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 20, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 148
[ , 2, 1, 2, 2, 2, 2, 20, [0, 98, "MTS"], 2, 1, 2, 3, 1, 2, 1, 2, 1, 2, [0, 76, "GW2"], 2, 20, [0, 72, "BZ"], 2, [0, 69, "BZ"], 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 1, 1, 20, [0, 52, "Var"], 1, 1, 20, [0, 49, "Var"], 1, 1, 20, 1, 1, 20, [0, 44, "Var"], 1, 20, [0, 42, "Var"], 1, 20, [0, 40, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 149
[ , 2, 20, [6, 64], 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, [0, 62, "Var"], [0, 61, "Var"], 1, 1, 1, 1, 20, [0, 56, "VE"], [0, 55, "Var"], 1, 1, 1, 20, [0, 51, "Var"], 1, 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 150
[ , [6, 5], 2, 3, 2, 2, [0, 104, "DG5"], 1, 2, [0, 96, "BZ"], 20, [0, 92, "BZ"], 2, 20, [0, 88, "BZ"], 20, [0, 84, "BZ"], 20, [0, 80, "BZ"], [0, 77, "GW2"], [0, 76, "BZ"], 1, 2, [0, 72, "BZ"], 2, 20, [0, 68, "BZ"], [0, 66, "Vx"], 20, [0, 64, "BZ"], 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 1, 1, 20, [0, 54, "Var"], 1, 1, 1, 20, [0, 50, "Var"], 1, 1, 20, 1, 1, 20, [0, 45, "Var"], 1, 20, [0, 43, "Var"], 1, 20, [0, 41, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, [0, 32, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 19, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 151
[ , 2, 2, 1, 2, 2, 3, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 1, 20, [0, 53, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 47, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 152
[ , 2, 2, 2, [0, 112, "Bo1"], 2, 2, 20, [0, 101, "Ma"], 2, 1, 2, [0, 92, "XBZ"], 1, 2, 1, 2, 1, 2, 1, 2, 20, [0, 75, "BZ"], 20, [0, 72, "BZ"], 20, [0, 69, "BZ"], 2, [0, 66, "BZ"], 20, [0, 64, "Vx"], [0, 63, "VE"], [0, 62, "Var"], [0, 61, "Var"], 1, 1, 1, 1, 20, [0, 56, "VE"], [0, 55, "Var"], 1, 1, 20, [0, 52, "Var"], 1, 1, 20, [0, 49, "Var"], 1, 1, 20, 1, 1, 20, [0, 44, "Var"], 1, 20, [0, 42, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 28, "Var"], 20, [0, 27, "Var"], 20, [0, 26, "VE"], 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 153
[ , 2, [6, 6], 2, 3, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 20, 3, 2, 3, 1, 2, [0, 68, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 1, 1, 20, [0, 54, "Var"], 1, 1, 20, [0, 51, "Var"], 1, 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 34, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 18, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 154
[ , 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 65, "Var"], [0, 64, "Var"], [0, 63, "Var"], 1, 1, 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 1, 20, [0, 53, "Var"], 1, 1, 20, [0, 50, "Var"], 1, 1, 20, 1, 1, 20, [0, 45, "Var"], 1, 20, [0, 43, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 155
[ , [6, 5], 2, [6, 70], 2, 2, 2, [0, 104, "BZ"], [0, 103, "MTS"], [0, 100, "BZ"], 20, [0, 96, "BZ"], [0, 94, "GW1"], 20, [0, 92, "BZ"], 20, [0, 88, "BZ"], 20, [0, 84, "BZ"], 20, [0, 80, "BZ"], 20, 1, 2, 20, 1, 2, [0, 69, "Vx"], 1, 2, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 1, 1, 20, [0, 56, "Var"], 1, 1, 1, 20, [0, 52, "Var"], 1, 1, 20, 1, 1, 20, [0, 47, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 156
[ , 2, 2, 2, 2, [6, 78], 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 20, [0, 76, "BZ"], [0, 73, "Vx"], 20, [0, 72, "BZ"], 1, 20, [0, 68, "BZ"], 2, 1, 1, 1, 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 1, 20, [0, 55, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 49, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 157
[ , 2, 2, 2, 2, 3, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 20, 3, 1, 2, 3, [0, 67, "Vx"], 20, [0, 65, "VE"], [0, 64, "Var"], [0, 63, "Var"], 1, 1, 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "VE"], 1, 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "VE"], 1, 20, [0, 44, "VE"], 1, 20, [0, 42, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 158
[ , 2, [6, 16], 2, 2, 2, [0, 110, "BKW"], 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 1, 1, 20, [0, 56, "Var"], 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 20, "Var"], 20, 1, 20, 1, 20, 20, [0, 17, "Var"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 159
[ , 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 20, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 2, [0, 68, "Var"], [0, 67, "Var"], [0, 66, "Var"], [0, 65, "Var"], 1, 1, 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 1, 20, [0, 55, "Var"], 1, 1, 20, [0, 52, "Var"], 1, 1, 20, 1, 1, 20, [0, 47, "Var"], 1, 20, [0, 45, "Var"], 1, 20, [0, 43, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, [0, 34, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 160
[ , [6, 5], 2, [6, 75], 2, 2, 2, 1, 2, [0, 104, "BZ"], 20, [0, 100, "BZ"], 2, 20, [0, 96, "BZ"], 20, [0, 92, "BZ"], 20, [0, 88, "BZ"], 20, [0, 84, "BZ"], 20, [0, 80, "BZ"], 2, 1, 1, 2, 20, [0, 72, "BZ"], 2, 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 1, 1, 20, [0, 58, "Var"], [0, 57, "Var"], 1, 1, 20, [0, 54, "Var"], 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 20, [0, 28, "Var"], 20, [0, 27, "Var"], 20, [0, 26, "Var"], 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 161
[ , 2, 2, 1, 2, 2, [0, 112, "BKW"], 20, [0, 108, "MTS"], 2, 1, 2, [0, 98, "GW1"], 20, 3, 1, 2, 1, 2, 1, 2, 1, 1, 2, 20, 1, 2, 20, 1, 2, 2, 1, 1, 1, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 1, 1, 20, [0, 56, "Var"], 1, 1, 20, [0, 53, "Var"], 1, 1, 20, 1, 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "Var"], 1, 20, [0, 44, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 30, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 162
[ , 2, 2, 2, [0, 120, "BKW"], [0, 116, "BKW"], 3, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, [0, 80, "BZ"], 2, 20, [0, 76, "BZ"], 2, 20, [0, 72, "BZ"], [0, 70, "Vx"], 20, [0, 68, "BZ"], [0, 67, "VE"], [0, 66, "Var"], [0, 65, "Var"], 1, 1, 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, [0, 50, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 163
[ , 2, [6, 16], 2, 3, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 20, 3, 2, 20, 3, 1, 1, 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 1, 1, 20, [0, 58, "Var"], 1, 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, [0, 47, "Var"], 1, 20, [0, 45, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 32, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 164
[ , 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, [0, 70, "Var"], [0, 69, "Var"], [0, 68, "Var"], [0, 67, "Var"], 1, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 1, 20, [0, 57, "Var"], 1, 1, 20, [0, 54, "Var"], 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 33, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 16, "Var"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 165
[ , [6, 5], 2, [6, 80], 2, [0, 118, "BKW"], 2, 1, 2, [0, 108, "BZ"], 20, [0, 104, "BZ"], 20, 1, 2, 20, [0, 96, "BZ"], 20, [0, 92, "BZ"], 20, [0, 88, "BZ"], 20, [0, 84, "BZ"], 2, [0, 80, "BZ"], 1, 2, [0, 76, "BZ"], 1, 2, [0, 72, "BZ"], 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 1, 1, 20, [0, 60, "Var"], [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 1, 20, [0, 53, "Var"], 1, 1, 20, 1, 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, [0, 34, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 166
[ , 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 20, 20, [0, 100, "XBZ"], 20, 3, 20, 3, 20, 3, 20, 3, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 1, 1, 20, [0, 58, "Var"], 1, 1, 20, [0, 55, "Var"], 1, 1, 20, 1, 1, 20, [0, 50, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 167
[ , 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 20, 3, 2, 3, 20, 3, 20, 3, 20, 1, 2, 20, 1, 2, 20, 1, 2, [0, 73, "Vx"], 1, 2, 20, [0, 69, "VE"], [0, 68, "Var"], [0, 67, "Var"], 1, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 1, 20, [0, 57, "Var"], 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 42, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 168
[ , 2, [6, 21], 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 20, 3, 2, 2, 2, 3, 20, 3, [0, 85, "Vx"], 20, [0, 84, "BZ"], [0, 81, "BZ"], 20, [0, 80, "BZ"], [0, 77, "Vx"], 20, [0, 76, "BZ"], 1, 20, [0, 72, "BZ"], 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 1, 1, 20, [0, 60, "Var"], 1, 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "VE"], 1, 20, [0, 47, "VE"], 1, 20, [0, 45, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, 1, 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 30, "Var"], 20, [0, 29, "Var"], 20, [0, 28, "Var"], 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 169
[ , 2, 1, 2, 2, 2, [0, 118, "DG5"], 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 3, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 73, "Vx"], 1, 2, [0, 70, "Var"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 1, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "VE"], 1, 1, 20, [0, 53, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "VE"], 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 170
[ , [6, 5], 20, [6, 85], 2, [0, 122, "DaH"], 3, 1, 2, [0, 112, "DaH"], 20, [0, 108, "DaH"], [0, 104, "DaH"], [0, 102, "DaH"], 20, [0, 100, "DaH"], [0, 98, "DaH"], 2, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 75, "Vx"], 1, 20, [0, 72, "Vx"], 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 20, [0, 58, "Var"], 1, 1, 20, [0, 55, "Var"], 1, 1, 20, 1, 1, 20, [0, 50, "Var"], 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 32, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 20, "Var"], 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 171
[ , 2, 2, 1, 2, 2, 2, 20, [0, 117, "MTS"], 3, 20, 3, 3, 2, 20, 3, 3, [0, 96, "DaH"], 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 1, 1, 20, [0, 60, "Var"], 1, 1, 20, [0, 57, "Var"], 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, [0, 34, "Var"], 20, [0, 33, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 172
[ , 2, 2, 20, [0, 128, "Liz"], 2, [0, 119, "Ayd"], 20, 3, 3, 20, 3, 1, 2, 2, 3, 3, 3, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 20, [0, 72, "Vx"], [0, 71, "VE"], [0, 70, "Var"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 1, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 1, 20, 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "Var"], 1, 20, [0, 47, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, [0, 17, "Var"], 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 173
[ , 2, 2, 20, 3, 2, 2, 20, 3, 2, 2, 3, 1, 2, 2, 2, 2, 3, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 1, 20, [0, 62, "Var"], 1, 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 174
[ , 2, [6, 6], 2, 3, 2, 2, 20, 3, 2, 2, 3, 1, 2, 2, 2, 2, 1, 2, 20, [0, 92, "BZ"], 20, 20, [0, 88, "BZ"], 2, 20, [0, 84, "BZ"], 20, 20, [0, 80, "BZ"], 2, 20, [0, 76, "BZ"], 2, [0, 73, "Var"], [0, 72, "Var"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 1, 20, [0, 61, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 1, 20, [0, 50, "Var"], 1, 20, [0, 48, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 175
[ , [6, 5], 2, 2, 2, [0, 126, "BKW"], [0, 121, "DG5"], 1, 2, [0, 114, "GW2"], 2, 1, 2, [0, 106, "GW2"], [0, 104, "BZ"], 2, [0, 100, "BZ"], 20, [0, 96, "BZ"], 20, 3, 1, 20, 3, 2, 20, 3, 1, 20, 3, [0, 78, "Vx"], 20, 3, [0, 75, "Vx"], 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 20, [0, 60, "VE"], 1, 1, 20, [0, 57, "VE"], 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 176
[ , 2, 2, 2, 2, 2, 2, 1, 2, 2, [0, 112, "GW2"], 20, [0, 108, "GW2"], 2, 2, [0, 103, "GW1"], 2, 1, 2, 1, 2, 1, 1, 2, [0, 87, "BZ"], 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 1, 20, [0, 62, "Var"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 1, 20, 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 20, [0, 30, "Var"], 20, [0, 29, "Var"], 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 177
[ , 2, 2, [6, 17], 2, 2, 2, 20, [0, 119, "MTS"], 2, 3, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 76, "Vx"], [0, 75, "Vx"], 20, [0, 73, "VE"], [0, 72, "Var"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 1, 20, [0, 61, "Var"], 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 32, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 178
[ , 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 20, [0, 108, "GW2"], 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "Var"], 1, 1, 1, 20, [0, 60, "Var"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 1, 20, [0, 50, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 34, "Var"], 20, [0, 33, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 179
[ , 2, [6, 16], 2, [0, 132, "Koh"], 2, 2, 20, [0, 120, "MTS"], 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 20, 1, 2, 2, 1, 2, 20, 1, 2, 20, 1, 2, [0, 77, "Vx"], 1, 2, [0, 74, "Var"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 20, [0, 63, "VE"], 1, 1, 1, 20, [0, 59, "Var"], 1, 1, 20, 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, [0, 21, "VE"], 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 180
[ , [6, 5], 2, 2, 2, [0, 130, "BKW"], 2, 1, 2, [0, 118, "GW2"], 2, 2, 2, 20, [0, 108, "BZ"], [0, 106, "GW1"], [0, 104, "BZ"], 20, [0, 100, "BZ"], 20, [0, 96, "BZ"], [0, 93, "BZ"], 20, [0, 92, "BZ"], [0, 90, "BZ"], 20, [0, 88, "BZ"], 20, 20, [0, 84, "BZ"], [0, 81, "BZ"], 20, [0, 80, "BZ"], 1, 20, [0, 76, "BZ"], 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 20, [0, 62, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 56, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 181
[ , 2, 2, 2, 2, 2, 2, 2, [0, 121, "MTS"], 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 20, 3, 3, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 77, "Var"], 1, 1, 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "Var"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 182
[ , 2, 2, [6, 17], [0, 134, "BKW"], 2, 2, 2, 2, 2, 2, [0, 114, "DaH"], [0, 112, "DaH"], 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 20, [0, 76, "Vx"], [0, 75, "VE"], [0, 74, "Var"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, [0, 60, "Var"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 183
[ , 2, 2, 2, 2, 2, [0, 128, "GW2"], 2, [0, 122, "MTS"], [0, 120, "GW2"], 2, 2, 2, 20, [0, 110, "GW1"], 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 80, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "Var"], [0, 65, "Var"], 1, 1, 20, [0, 62, "Var"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "Var"], 1, 20, [0, 50, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 20, [0, 42, "VE"], 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 184
[ , 2, [6, 16], 2, 2, 2, 2, 2, 2, 3, 2, 2, [0, 113, "GW1"], 1, 2, [0, 109, "GW1"], 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 77, "Var"], [0, 76, "Var"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 1, 20, [0, 64, "Var"], 1, 1, 20, [0, 61, "Var"], 1, 1, 20, 1, 1, 20, [0, 56, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "Var"], 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 185
[ , [6, 5], 2, 2, 2, [0, 134, "BKW"], 2, 2, 2, 1, 2, [0, 116, "BZ"], 2, 1, 2, 2, [0, 108, "BZ"], 20, [0, 104, "BZ"], 20, [0, 100, "BZ"], 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 20, [0, 51, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 34, "Var"], 20, [0, 33, "Var"], 20, [0, 32, "VE"], 1, 20, 1, 20, 20, [0, 29, "Var"], 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 186
[ , 2, 2, 2, 2, 3, 2, 2, [0, 124, "MTS"], 2, [0, 120, "DaH"], 2, 2, 20, [0, 112, "XBZ"], 2, 2, 1, 2, 1, 2, 1, 20, [0, 96, "BZ"], 20, 20, [0, 92, "BZ"], 20, 20, [0, 88, "BZ"], [0, 85, "Vx"], 20, [0, 84, "BZ"], 2, 20, [0, 80, "BZ"], 2, 1, 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "Var"], 1, 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, [0, 5, "DaH"], 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 187
[ , 2, 2, [6, 17], 2, 2, 2, [0, 128, "GW2"], 2, 2, 3, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, 20, 3, [0, 79, "Vx"], 20, [0, 77, "VE"], [0, 76, "Var"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 20, [0, 65, "Var"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, 1, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 188
[ , 2, 2, 1, 2, 2, 2, 3, 2, 2, 3, 2, [0, 116, "GW1"], 2, 20, [0, 112, "GW1"], 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 83, "Vx"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 20, [0, 64, "Var"], 1, 1, 20, [0, 61, "Var"], 1, 1, 20, 1, 1, 20, [0, 56, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 189
[ , 2, [6, 21], 2, [0, 140, "BKW"], 2, 2, 3, [22, 8, 1], 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 80, "Var"], [0, 79, "Var"], [0, 78, "Var"], [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, [0, 63, "Var"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 190
[ , [6, 5], 3, 2, 2, 2, 2, 3, 1, 2, 20, [0, 120, "BZ"], 2, [0, 116, "BZ"], 1, 2, [0, 112, "BZ"], 2, [0, 108, "BZ"], 20, [0, 104, "BZ"], 20, [0, 100, "BZ"], 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 20, [0, 65, "Var"], 1, 1, 20, [0, 62, "Var"], 1, 1, 20, 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 191
[ , 2, 1, 2, 2, [0, 138, "BKW"], 2, 1, 1, 2, 1, 2, 2, 1, 1, 2, 3, 2, 3, 20, 3, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 2, 1, 1, 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "Var"], 1, 1, 1, 20, [0, 64, "Var"], 1, 1, 20, 1, 1, 20, [0, 59, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 192
[ , 2, 2, [6, 64], 2, 2, [0, 136, "GW2"], 1, 1, 2, 1, 2, [0, 119, "GW1"], 1, 2, [0, 115, "GW1"], 1, 2, 3, 20, 3, 20, 20, [0, 100, "BZ"], 20, 20, [0, 96, "BZ"], 20, 20, [0, 92, "BZ"], 20, 20, [0, 88, "BZ"], 2, 20, [0, 84, "BZ"], [0, 82, "Vx"], 20, [0, 80, "BZ"], [0, 79, "VE"], [0, 78, "Var"], [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 20, [0, 67, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 61, "VE"], 1, 1, 20, 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 193
[ , 2, 2, 1, 2, 2, 3, 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 3, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, [0, 86, "Vx"], 20, 3, 1, 1, 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 20, [0, 34, "Var"], 20, [0, 33, "VE"], 20, [0, 32, "VE"], 20, [0, 31, "Var"], 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 194
[ , 2, 2, 20, [0, 144, "BKW"], 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, [0, 82, "Var"], [0, 81, "Var"], [0, 80, "Var"], [0, 79, "Var"], 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 1, 20, [0, 68, "Var"], 1, 1, 20, [0, 65, "Var"], 1, 1, 20, [0, 62, "Var"], 1, 1, 20, 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "Var"], 1, 20, [0, 53, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 36, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 195
[ , [6, 5], [6, 6], 2, 3, [0, 141, "BKW"], [0, 137, "GW2"], 1, 1, 2, 20, [0, 124, "DaH"], 2, 1, 2, [0, 117, "GW1"], 20, [0, 114, "DaH"], 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 84, "Vx"], 1, 1, 1, 1, 20, [0, 78, "VE"], [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 1, 20, [0, 67, "Var"], 1, 1, 20, [0, 64, "Var"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 196
[ , 2, 2, 2, 2, 3, 2, 20, 1, 2, 2, 3, [0, 122, "GW1"], 20, [0, 120, "DaH"], 2, 20, 3, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, [0, 63, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 197
[ , 2, 2, 2, 2, 2, 2, 2, 20, [0, 132, "XX"], 2, 2, 1, 2, 3, 2, 20, 3, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, [0, 85, "Vx"], 1, 2, 20, [0, 81, "VE"], [0, 80, "Var"], [0, 79, "Var"], 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 20, [0, 69, "VE"], 1, 1, 1, 20, [0, 65, "Var"], 1, 1, 20, 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 198
[ , 2, 2, [6, 28], 2, 2, 2, [0, 134, "MTS"], 20, 3, 2, 2, 1, 2, 1, 2, 20, 3, 2, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 20, 20, [0, 100, "BZ"], 20, 20, [0, 96, "BZ"], 20, 20, [0, 92, "BZ"], [0, 89, "Vx"], 20, [0, 88, "BZ"], 1, 20, [0, 84, "BZ"], 1, 1, 1, 1, 20, [0, 78, "VE"], [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 20, [0, 68, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 199
[ , 2, 2, 1, 2, 2, [0, 140, "Koh"], 1, 2, 3, [0, 128, "MTS"], [0, 126, "GW1"], 2, [0, 123, "GW1"], 1, 2, 2, 3, 2, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 85, "Vx"], 1, 2, [0, 82, "Var"], [0, 81, "Var"], 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "VE"], 1, 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 200
[ , [6, 5], [6, 16], 2, [0, 148, "Bo1"], 2, 2, 1, 2, 3, 2, 2, [0, 125, "GW1"], 1, 2, [0, 121, "GW1"], [0, 116, "BZ"], 3, [0, 112, "BZ"], 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 87, "Vx"], 1, 20, [0, 84, "Vx"], 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 1, 20, [0, 63, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, [0, 56, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 201
[ , 2, 2, 2, 2, [0, 145, "BKW"], [0, 141, "GW2"], 1, 2, 3, 2, 2, 1, 1, 2, 2, 2, 3, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 78, "VE"], [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "Var"], [0, 71, "Var"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, [0, 65, "Var"], 1, 1, 20, 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "Var"], 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 36, "Var"], 20, [0, 35, "Var"], 20, [0, 34, "Var"], 20, [0, 33, "Var"], 20, [0, 32, "Var"], 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 202
[ , 2, 2, 2, 2, 2, 2, 1, 2, 3, [0, 130, "MTS"], 2, 1, 2, [0, 124, "GW1"], 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 20, [0, 84, "Vx"], [0, 83, "VE"], [0, 82, "Var"], [0, 81, "Var"], 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 1, 20, 1, 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 203
[ , 2, 2, [6, 64], 2, 2, 2, 1, 2, 2, 2, [0, 129, "GW1"], 2, [0, 126, "GW1"], 1, 2, 2, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "VE"], 1, 20, [0, 55, "Var"], 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 204
[ , 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 2, 1, 2, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 20, 20, [0, 100, "BZ"], 20, 20, [0, 96, "BZ"], 20, 20, [0, 92, "BZ"], 2, 20, [0, 88, "BZ"], [0, 86, "Vx"], [0, 85, "Var"], [0, 84, "Var"], [0, 83, "Var"], 1, 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "Var"], 1, 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 205
[ , [6, 5], [6, 16], 2, [0, 152, "Bo1"], [0, 148, "BKW"], [0, 144, "MTS"], 1, 2, [0, 134, "X6a"], 2, 2, [0, 129, "GW1"], 1, 2, [0, 125, "GW1"], [0, 120, "BZ"], 20, [0, 116, "BZ"], 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, [0, 90, "Vx"], 20, 3, 1, 1, 1, 1, 20, [0, 82, "VE"], [0, 81, "Var"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 20, [0, 71, "Var"], 1, 1, 20, [0, 68, "VE"], 1, 1, 20, [0, 65, "Var"], 1, 1, 20, 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, [0, 56, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 206
[ , 2, 2, 2, 3, 2, 2, 1, 2, 2, [0, 133, "MTS"], 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, [0, 86, "Var"], 1, 1, 1, 1, 1, 1, 20, [0, 79, "Var"], [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 54, "VE"], 1, 20, [0, 52, "Var"], 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 207
[ , 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, [0, 132, "GW1"], 1, 2, [0, 128, "GW1"], 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 88, "Vx"], 1, 20, [0, 85, "VE"], [0, 84, "Var"], [0, 83, "Var"], 1, 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 1, 1, 20, [0, 72, "Var"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 1, 20, 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 208
[ , 2, 2, [6, 64], 2, 2, 2, 1, 2, 2, 2, 1, 2, [0, 130, "GW1"], 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 82, "VE"], [0, 81, "Var"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 20, [0, 71, "Var"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 209
[ , 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, [0, 89, "Vx"], 1, 2, [0, 86, "Var"], [0, 85, "Var"], 1, 1, 1, 1, 1, 20, [0, 79, "Var"], [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "Var"], 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 20, 1, 1, 20, [0, 65, "VE"], 1, 1, 20, 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, [0, 35, "Var"], 20, [0, 34, "Var"], 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 210
[ , [6, 5], [6, 21], 2, 2, [0, 152, "BKW"], [0, 148, "MTS"], 20, [0, 144, "DaH"], [0, 138, "MTS"], [0, 136, "MTS"], 2, [0, 133, "GW1"], 1, 2, [0, 129, "GW1"], [0, 124, "BZ"], [0, 121, "DaH"], [0, 120, "BZ"], 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 20, 20, [0, 100, "BZ"], 20, 20, [0, 96, "BZ"], [0, 93, "Vx"], 20, [0, 92, "BZ"], 1, 20, [0, 88, "BZ"], 1, 1, 20, [0, 84, "VE"], [0, 83, "Var"], [0, 82, "Var"], 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 1, 20, [0, 73, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 67, "VE"], 1, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 56, "VE"], 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 32, "Var"], 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 211
[ , 2, 3, 2, [0, 156, "Bou"], 3, 2, 20, 3, 2, 2, [0, 135, "GW1"], 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 89, "Var"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 20, [0, 72, "Var"], 1, 1, 20, [0, 69, "VE"], 1, 1, 20, [0, 66, "Var"], 1, 1, 20, 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 212
[ , 2, 1, 2, 2, 2, 2, 20, 3, 2, 2, 1, 2, 20, [0, 132, "GW1"], 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 20, [0, 88, "Vx"], [0, 87, "VE"], [0, 86, "Var"], [0, 85, "Var"], 1, 1, 1, 1, 1, 20, [0, 79, "Var"], [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "Var"], 1, 1, 20, [0, 71, "Var"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 57, "VE"], 1, 20, [0, 55, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 213
[ , 2, 2, [6, 64], 2, 2, 2, 2, 3, 2, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 92, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 84, "VE"], [0, 83, "Var"], [0, 82, "Var"], 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 1, 20, [0, 73, "Var"], 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, [0, 25, "VE"], 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 214
[ , 2, 2, 3, 2, 2, [0, 151, "MTS"], 2, 3, 2, [0, 139, "MTS"], 2, [0, 136, "GW1"], 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 89, "Var"], [0, 88, "Var"], [0, 87, "Var"], 1, 1, 1, 1, 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 1, 20, [0, 72, "Var"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "VE"], 1, 20, [0, 58, "Var"], 1, 20, [0, 56, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 215
[ , [6, 5], 2, 1, 2, 2, 2, [0, 147, "Ayd"], 2, 2, 1, 2, 1, 1, 2, [0, 133, "GW1"], [0, 128, "BZ"], 20, [0, 124, "BZ"], 20, [0, 120, "BZ"], 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 20, [0, 86, "VE"], [0, 85, "Var"], [0, 84, "Var"], 1, 1, 1, 1, 20, [0, 79, "Var"], [0, 78, "Var"], 1, 1, 20, [0, 75, "Var"], 1, 1, 1, 20, [0, 71, "Var"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 216
[ , 2, [6, 6], 2, [0, 160, "Bo1"], 2, 2, 3, [0, 145, "MTS"], [0, 143, "GW1"], 2, [0, 139, "GW1"], 1, 1, 2, 2, 2, 1, 2, 1, 2, 1, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 20, 20, [0, 100, "BZ"], 20, 20, [0, 96, "BZ"], 2, 20, [0, 92, "BZ"], 2, 1, 1, 1, 1, 1, 1, 20, [0, 83, "VE"], [0, 82, "Var"], 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 68, "VE"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 217
[ , 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, [0, 136, "GW1"], 2, 2, 1, 2, 1, 2, 1, 2, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, 20, 3, [0, 91, "Vx"], 20, [0, 89, "VE"], [0, 88, "Var"], [0, 87, "Var"], 1, 1, 1, 1, 1, 20, [0, 81, "Var"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "VE"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 218
[ , 2, 2, 2, 2, 2, 2, 2, 2, 2, [0, 142, "MTS"], 1, 2, [0, 138, "GW1"], 1, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 95, "Vx"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 86, "VE"], [0, 85, "Var"], [0, 84, "Var"], 1, 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 1, 20, [0, 75, "Var"], 1, 1, 20, [0, 72, "Var"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 34, "VE"], 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 219
[ , 2, 2, [6, 49], [0, 162, "BKW"], 2, [0, 155, "MTS"], 2, 2, 2, 1, 2, [0, 140, "GW1"], 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 92, "Vx"], [0, 91, "Var"], [0, 90, "Var"], [0, 89, "Var"], 1, 1, 1, 1, 1, 20, [0, 83, "VE"], [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "Var"], 1, 1, 20, [0, 71, "Var"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 32, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 220
[ , [6, 5], 2, 2, 2, [0, 160, "BKW"], 2, [0, 150, "MTS"], [0, 148, "MTS"], 2, 1, 2, 1, 1, 2, [0, 137, "GW1"], [0, 132, "BZ"], 20, [0, 128, "BZ"], 20, [0, 124, "BZ"], 20, [0, 120, "BZ"], 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 20, [0, 88, "VE"], [0, 87, "Var"], [0, 86, "Var"], 1, 1, 1, 1, 20, [0, 81, "Var"], [0, 80, "Var"], 1, 1, 20, [0, 77, "VE"], [0, 76, "Var"], 1, 1, 20, [0, 73, "Var"], 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "VE"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 221
[ , 2, [6, 16], 2, 2, 3, 2, 2, 2, [0, 147, "GW1"], 2, [0, 143, "GW1"], 1, 1, 2, 2, 3, 1, 2, 1, 2, 1, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 20, [0, 85, "VE"], [0, 84, "Var"], 1, 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 1, 20, 1, 1, 1, 20, [0, 72, "Var"], 1, 1, 20, 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 59, "VE"], 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 222
[ , 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 1, 1, 2, [0, 140, "GW1"], 2, 2, 1, 2, 1, 2, 1, 2, [0, 120, "BZ"], 2, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 20, 20, [0, 100, "BZ"], 2, 20, [0, 96, "BZ"], [0, 94, "Vx"], 20, [0, 92, "BZ"], [0, 91, "VE"], [0, 90, "Var"], [0, 89, "Var"], 1, 1, 1, 1, 1, 20, [0, 83, "VE"], [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 223
[ , 2, 2, 2, 2, 2, 2, 2, [0, 150, "MTS"], 2, 2, 1, 2, [0, 142, "GW1"], 1, 2, 2, 1, 2, 1, 2, 1, 2, 3, 2, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, [0, 98, "Vx"], 20, 3, 1, 1, 1, 1, 1, 1, 20, [0, 88, "VE"], [0, 87, "Var"], [0, 86, "Var"], 1, 1, 1, 1, 20, [0, 81, "Var"], 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "Var"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 60, "VE"], 1, 20, [0, 58, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 224
[ , 2, 2, [6, 64], 2, 2, 2, [0, 153, "MTS"], 1, 2, [0, 147, "MTS"], 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, [0, 94, "Vx"], [0, 93, "Var"], [0, 92, "Var"], [0, 91, "Var"], 1, 1, 1, 1, 1, 20, [0, 85, "VE"], [0, 84, "Var"], 1, 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], 1, 1, 20, [0, 76, "Var"], 1, 1, 20, [0, 73, "Var"], 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 225
[ , [6, 5], 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, [0, 145, "GW1"], 1, 1, 2, 2, 20, [0, 132, "BZ"], 20, [0, 128, "BZ"], 20, [0, 124, "BZ"], 2, [0, 120, "BZ"], 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 96, "Vx"], 1, 1, 1, 1, 20, [0, 90, "VE"], [0, 89, "Var"], [0, 88, "Var"], 1, 1, 1, 1, 20, [0, 83, "Var"], [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "Var"], 1, 1, 20, [0, 72, "Var"], 1, 1, 20, 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "VE"], 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 226
[ , 2, [6, 16], 2, [0, 168, "BKW"], [0, 163, "BKW"], [0, 161, "MTS"], 2, 1, 2, 1, 2, 1, 1, 2, [0, 142, "GW1"], [0, 136, "XBZ"], 20, 3, 20, 3, 20, 3, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 87, "VE"], [0, 86, "Var"], 1, 1, 1, 1, 20, [0, 81, "Var"], 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "Var"], 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 227
[ , 2, 2, 2, 3, 2, 2, 2, [0, 153, "MTS"], [0, 152, "GW1"], 2, [0, 148, "GW1"], 1, 1, 2, 2, 3, 20, 3, 20, 3, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, [0, 97, "Vx"], 1, 2, 20, [0, 93, "VE"], [0, 92, "Var"], [0, 91, "Var"], [0, 90, "Var"], 1, 1, 1, 1, 20, [0, 85, "VE"], [0, 84, "Var"], 1, 1, 1, 20, [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 20, 1, 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 34, "VE"], 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 228
[ , 2, 2, 2, 2, 2, 2, [0, 156, "MTS"], 1, 2, [0, 150, "MTS"], 1, 1, 2, [0, 145, "GW1"], 2, 3, 20, 3, 20, 3, 20, 20, [0, 124, "BZ"], 20, 20, [0, 120, "BZ"], 20, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], [0, 101, "Vx"], 20, [0, 100, "BZ"], 1, 20, [0, 96, "BZ"], 1, 1, 1, 1, 1, 20, [0, 89, "VE"], [0, 88, "Var"], 1, 1, 1, 1, 20, [0, 83, "Var"], [0, 82, "Var"], 1, 1, 20, [0, 79, "Var"], 1, 1, 1, 20, 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 229
[ , 2, 2, [6, 64], 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 20, 3, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 97, "Vx"], 1, 2, [0, 94, "Var"], [0, 93, "Var"], 1, 1, 1, 1, 1, 20, [0, 87, "VE"], [0, 86, "Var"], 1, 1, 1, 1, 20, [0, 81, "Var"], 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "Var"], 1, 1, 20, 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 32, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 230
[ , [6, 5], 2, 2, 2, 2, 2, [0, 157, "MTS"], 1, 2, 1, 2, 20, [0, 148, "GW1"], 1, 2, 3, 20, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 99, "Vx"], 1, 20, [0, 96, "Vx"], 1, 1, 20, [0, 92, "VE"], [0, 91, "Var"], [0, 90, "Var"], 1, 1, 1, 1, 20, [0, 85, "Var"], [0, 84, "Var"], 1, 1, 1, 20, [0, 80, "Var"], 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "Var"], 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 231
[ , 2, [6, 21], 2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 20, [0, 89, "VE"], [0, 88, "Var"], 1, 1, 1, 1, 20, [0, 83, "Var"], 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 20, [0, 76, "Var"], 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 232
[ , 2, 3, 2, 2, [0, 168, "BKW"], 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 20, [0, 96, "Vx"], [0, 95, "VE"], [0, 94, "VE"], [0, 93, "Var"], [0, 92, "Var"], 1, 1, 1, 1, 20, [0, 87, "VE"], [0, 86, "Var"], 1, 1, 1, 20, [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "Var"], 1, 1, 20, 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 233
[ , 2, 1, 2, 2, 1, 2, 1, 1, 2, 2, [0, 153, "GW1"], 1, 1, 1, 2, 2, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 91, "VE"], [0, 90, "Var"], 1, 1, 1, 1, 20, [0, 85, "Var"], [0, 84, "Var"], 1, 1, 20, [0, 81, "Var"], 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, 1, 1, 20, [0, 72, "Var"], 1, 1, 20, 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 234
[ , 2, 2, [6, 64], 2, 2, [0, 168, "DaH"], 1, 1, 2, [0, 155, "MTS"], 1, 1, 1, 1, 2, 2, 1, 2, 20, [0, 132, "BZ"], 20, 20, [0, 128, "BZ"], 20, 20, [0, 124, "BZ"], 20, 20, [0, 120, "BZ"], 20, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 20, 20, [0, 104, "BZ"], 2, 20, [0, 100, "BZ"], [0, 98, "Vx"], [0, 97, "Var"], [0, 96, "Var"], [0, 95, "Var"], 1, 1, 1, 1, 1, 20, [0, 89, "VE"], [0, 88, "Var"], 1, 1, 1, 1, 20, [0, 83, "Var"], 1, 1, 20, [0, 80, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 74, "VE"], 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 63, "VE"], 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 20, [0, 41, "Var"], 20, [0, 40, "VE"], 20, [0, 39, "VE"], 1, 20, 20, [0, 37, "VE"], 20, [0, 36, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 235
[ , [6, 5], 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, [0, 140, "BZ"], 20, [0, 136, "BZ"], 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, [0, 102, "Vx"], 20, 3, 1, 1, 1, 1, 20, [0, 94, "VE"], [0, 93, "Var"], [0, 92, "Var"], 1, 1, 1, 1, 20, 1, 1, 1, 1, 1, 20, [0, 82, "Var"], 1, 1, 20, [0, 79, "Var"], 1, 1, 20, [0, 76, "VE"], 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 236
[ , 2, 2, 20, [0, 176, "BKW"], 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, [0, 98, "Var"], 1, 1, 1, 1, 1, 1, 20, [0, 91, "VE"], [0, 90, "Var"], 1, 1, 20, 1, 1, 1, 1, 1, 1, 20, [0, 81, "Var"], 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "Var"], 1, 1, 20, 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 34, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 237
[ , 2, [6, 6], 2, 3, [0, 172, "BKW"], [0, 170, "Ma"], 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 100, "Vx"], 1, 20, [0, 97, "VE"], [0, 96, "VE"], [0, 95, "Var"], [0, 94, "Var"], 1, 1, 1, 1, 20, [0, 89, "VE"], [0, 88, "Var"], 20, 1, 1, 1, 1, 1, 1, 1, 20, [0, 80, "Var"], 1, 1, 20, [0, 77, "Var"], 1, 1, 20, 1, 1, 20, [0, 72, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 238
[ , 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 20, [0, 93, "VE"], [0, 92, "Var"], 1, 1, 1, 1, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 20, [0, 76, "Var"], 1, 20, [0, 74, "VE"], 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 239
[ , 2, 2, 2, 2, 2, 2, 20, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, [0, 101, "Vx"], 1, 2, [0, 98, "Var"], [0, 97, "Var"], 1, 1, 1, 1, 1, 20, [0, 91, "VE"], [0, 90, "Var"], 1, 1, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 32, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 240
[ , [6, 5], 2, [6, 70], 2, 2, 2, 2, 20, [0, 164, "GW1"], 1, 1, 1, 1, 1, 2, [0, 144, "BZ"], 20, [0, 140, "BZ"], 20, [0, 136, "BZ"], 20, 20, [0, 132, "BZ"], 20, 20, [0, 128, "BZ"], 20, 20, [0, 124, "BZ"], 20, 20, [0, 120, "BZ"], 20, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], [0, 105, "Vx"], 20, [0, 104, "BZ"], 1, 20, [0, 100, "BZ"], 1, 1, 20, [0, 96, "VE"], [0, 95, "Var"], [0, 94, "Var"], 1, 1, 1, 1, 20, [0, 89, "VE"], [0, 88, "Var"], 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, [0, 75, "Var"], 1, 1, 20, 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 241
[ , 2, 2, 1, 2, 2, 2, [0, 166, "MTS"], 20, 3, 1, 1, 1, 1, 1, 2, 3, 1, 2, 1, 2, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, [0, 101, "Var"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 93, "VE"], [0, 92, "Var"], 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "Var"], 1, 20, [0, 72, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 242
[ , 2, [6, 16], 2, [0, 180, "Bo1"], 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 20, [0, 100, "Vx"], [0, 99, "VE"], [0, 98, "VE"], [0, 97, "Var"], [0, 96, "Var"], 1, 1, 1, 1, 20, [0, 91, "VE"], [0, 90, "Var"], 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "VE"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, [0, 41, "Var"], 20, [0, 40, "VE"], 20, [0, 39, "VE"], 20, [0, 38, "Var"], 20, [0, 37, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 243
[ , 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 104, "Vx"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 95, "VE"], [0, 94, "Var"], 1, 1, 1, 1, 20, [0, 89, "Var"], 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 63, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 36, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 244
[ , 2, 2, 2, 2, 2, 2, 1, 2, [0, 166, "GW1"], 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 101, "Var"], [0, 100, "Var"], [0, 99, "Var"], 1, 1, 1, 1, 1, 20, [0, 93, "VE"], [0, 92, "Var"], 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 75, "VE"], 1, 1, 20, 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 245
[ , [6, 5], 2, [6, 75], 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 20, [0, 144, "BZ"], 20, [0, 140, "BZ"], 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 20, [0, 98, "VE"], [0, 97, "Var"], [0, 96, "Var"], 1, 1, 1, 1, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 74, "Var"], 1, 20, [0, 72, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 66, "VE"], 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 246
[ , 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, [0, 148, "XBZ"], 20, 3, 20, 3, 20, 20, [0, 136, "BZ"], 20, 20, [0, 132, "BZ"], 20, 20, [0, 128, "BZ"], 20, 20, [0, 124, "BZ"], 20, 20, [0, 120, "BZ"], 20, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 20, 20, [0, 108, "BZ"], 2, 20, [0, 104, "BZ"], 2, 1, 1, 1, 1, 1, 1, 20, [0, 95, "VE"], [0, 94, "Var"], 1, 1, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 20, 1, 1, 20, 1, 1, 20, [0, 69, "Var"], 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 34, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 247
[ , 2, [6, 16], 2, [0, 184, "Bo1"], 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 3, 20, 3, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 20, 3, 2, 20, 3, [0, 103, "Vx"], 20, [0, 101, "VE"], [0, 100, "VE"], [0, 99, "Var"], [0, 98, "Var"], 1, 1, 1, 1, 20, [0, 93, "VE"], [0, 92, "Var"], 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 20, 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "VE"], 1, 1, 20, 1, 20, [0, 67, "VE"], 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, [0, 29, "VE"], 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 248
[ , 2, 2, 2, 2, 2, 2, [4, 6], [4, 8], 1, 1, 1, 1, 1, 1, 2, 3, 20, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 107, "Vx"], 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 97, "VE"], [0, 96, "Var"], 1, 1, 1, 1, 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 20, [0, 75, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 63, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 249
[ , 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, [0, 104, "Vx"], [0, 103, "Var"], [0, 102, "Var"], [0, 101, "Var"], 1, 1, 1, 1, 1, 20, [0, 95, "VE"], [0, 94, "Var"], 1, 1, 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 77, "Vx"], 1, 1, 20, [0, 74, "Var"], 1, 20, [0, 72, "Var"], 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 32, "Var"], 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 250
[ , [6, 5], 2, [6, 80], 2, [0, 184, "Koh"], 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 20, [0, 100, "VE"], [0, 99, "Var"], [0, 98, "Var"], 1, 1, 1, 1, 20, [0, 93, "VE"], [0, 92, "Var"], 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 2, 1, 20, [0, 76, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, [0, 39, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 251
[ , 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 149, "Vx"], 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 20, [0, 97, "VE"], [0, 96, "Var"], 1, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 20, 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "Var"], 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, [0, 37, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 252
[ , 2, [6, 21], 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 148, "BZ"], 2, 20, [0, 144, "BZ"], [0, 141, "BZ"], 20, [0, 140, "BZ"], 20, 20, [0, 136, "BZ"], 20, 20, [0, 132, "BZ"], 20, 20, [0, 128, "BZ"], 20, 20, [0, 124, "BZ"], 20, 20, [0, 120, "BZ"], 20, 20, [0, 116, "BZ"], 20, 20, [0, 112, "BZ"], 2, 20, [0, 108, "BZ"], [0, 106, "Vx"], 20, [0, 104, "BZ"], 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 95, "VE"], [0, 94, "Var"], 1, 1, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 1, 2, [0, 79, "Vx"], [0, 78, "VE"], [0, 77, "Var"], 1, 20, [0, 75, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 31, "Var"], 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, [5, 125], 20, 1, 20, 20, 20],
#V   n = 253
[ , 2, 3, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 3, 2, 20, 3, 2, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 2, 20, 3, [0, 110, "Vx"], 20, 3, 1, 1, 1, 20, 1, 1, 1, 2, [0, 99, "VE"], [0, 98, "Var"], 1, 1, 1, 1, 20, [0, 93, "VE"], 1, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 1, 1, 2, 1, 1, 1, 20, 1, 1, 20, [0, 74, "Var"], 1, 20, [0, 72, "Var"], 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 63, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 57, "VE"], 1, 20, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 254
[ , 2, 1, 1, 2, 1, 2, 2, 1, 1, 2, 20, 1, 1, 1, 2, 2, 1, 2, 2, 3, 2, 20, 3, 1, 20, 3, 2, 20, 3, 20, 20, 3, 1, 20, 3, 2, 20, 3, 2, 20, 3, [0, 114, "Vx"], 20, 3, 2, [0, 109, "Vx"], 1, 2, [0, 106, "Vx"], [0, 105, "Var"], 1, 20, 1, 1, 2, 1, 1, 20, [0, 97, "VE"], [0, 96, "Var"], 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 2, 20, 1, 20, 20, 20, 1, 1, 1, 2, 2, [0, 79, "Vx"], 1, 1, 20, [0, 76, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 255
[ , [6, 5], 2, 1, 2, 1, 2, 2, 20, 1, 2, 20, 20, 1, 1, 2, [0, 152, "Vx"], 2, [0, 148, "BZ"], 2, 1, 2, 1, 2, 1, 2, 3, 2, 20, 3, 1, 20, 3, 1, 2, 3, 2, 20, 3, [0, 118, "Vx"], 20, 3, 2, [0, 113, "Vx"], 1, 2, 1, 20, [0, 108, "Vx"], 1, 1, 20, 1, 20, 1, 2, 2, 1, 1, 1, 1, 20, 1, 1, 1, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 20, 1, 1, 2, 2, 1, 20, [0, 78, "VE"], 1, 1, 20, 1, 1, 20, [0, 73, "Var"], 1, 20, [0, 71, "Var"], 1, 20, [0, 69, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 256
[ , 3, [6, 4], 20, [0, 192, "Bel"], 20, [0, 188, "XBC"], [0, 179, "BCH"], 20, 20, [0, 176, "XBC"], 20, 20, 20, [0, 172, "XBC"], [0, 171, "XBC"], 3, [0, 150, "BZ"], 3, [0, 147, "BZ"], 20, [0, 144, "BZ"], 20, [0, 141, "BZ"], 20, [0, 138, "BZ"], 3, [0, 135, "BZ"], 20, 3, 20, [0, 129, "BZ"], 3, 20, [0, 126, "BZ"], 3, [0, 123, "BZ"], 20, 3, 3, [0, 117, "BZ"], 3, [0, 115, "Vx"], 3, 20, [0, 112, "Vx"], [0, 110, "Var"], [0, 109, "Var"], 3, [0, 107, "XBC"], [0, 106, "Var"], [0, 105, "Vx"], 20, [0, 104, "XBC"], 20, [0, 103, "XBC"], [0, 101, "Vx"], 20, [0, 99, "VE"], [0, 98, "Var"], [0, 97, "Var"], [0, 96, "Vx"], 20, [0, 95, "XBC"], [0, 94, "BCH"], [0, 93, "Var"], 20, [0, 92, "XBC"], 20, 20, 20, [0, 91, "XBC"], 20, 20, 20, [0, 88, "XBC"], 20, 20, 20, [0, 87, "XBC"], [0, 86, "XBC"], [0, 82, "Vx"], [0, 80, "Vx"], [0, 79, "Vx"], 3, 20, [0, 77, "Var"], [0, 76, "Vx"], 20, [0, 75, "VE"], [0, 74, "Var"], 3, 20, [0, 72, "Var"], 3, 20, [0, 70, "Var"], 3, 20, [0, 68, "Var"], 20, [0, 67, "Var"], [0, 66, "Vx"], 20, [0, 65, "Var"], 3, 20, [0, 63, "Var"], 20, [0, 62, "Var"], [0, 61, "Vx"], 20, [0, 60, "Var"], 20, [0, 59, "Var"], [0, 58, "Vx"], 20, [0, 57, "Var"], 20, [0, 56, "Var"], 3, 20, [0, 54, "Vx"], 20, [0, 53, "Var"], 20, [0, 52, "Var"], 20, [0, 51, "Var"], 3, 20, [0, 49, "Vx"], 20, [0, 48, "Var"], 20, [0, 47, "Var"], 20, [0, 46, "Var"], 20, [0, 45, "Var"], 20, [0, 44, "Var"], 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, [0, 39, "Var"], 20, 20, [0, 38, "XBC"], [0, 37, "Var"], 20, 20, [0, 36, "XBC"], 20, [0, 35, "XBC"], 20, [0, 34, "VE"], 20, [0, 33, "Var"], 20, [0, 32, "Var"], 20, [0, 31, "XBC"], 20, 20, 20, [0, 30, "XBC"], [0, 29, "Var"], 20, 20, [0, 28, "XBC"], 20, 20, 20, [0, 27, "XBC"], 20, 20, 20, [0, 26, "XBC"], 20, 20, 20, [0, 24, "XBC"], 20, 20, 20, [0, 23, "XBC"], 20, 20, 20, [0, 22, "XBC"], 20, 20, 20, [0, 20, "XBC"], 20, 20, 20, [0, 19, "XBC"], 20, [0, 18, "XBC"], [0, 17, "BCH"], 20, 20, [0, 16, "XBC"], 20, 20, 20, [0, 15, "XBC"], 20, 20, 20, [0, 14, "XBC"], 20, 20, 20, [0, 12, "XBC"], 20, 20, 20, [0, 11, "XBC"], 20, 20, 20, [0, 10, "XBC"], [0, 9, "BCH"], 20, 20, [0, 8, "XBC"], 20, 20, 20, [0, 7, "XBC"], 20, 20, 20, [0, 6, "XBC"], 20, 20, [5, 125], 20, [5, 127], 20, 20, [0, 3, "Ham"], 20, 20, 20]];


GUAVA_BOUNDS_TABLE[2][4] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ ,],
#V   n = 5
[ ,,],
#V   n = 6
[ , [15, 4],, [14, 4]],
#V   n = 7
[ , [15, 5], [15, 4], 12, 11],
#V   n = 8
[ , [15, 6], [15, 5], [15, 4], 11, 11],
#V   n = 9
[ , [15, 7], [15, 6], [15, 5], [15, 4], 11, 11],
#V   n = 10
[ , [15, 8], [0, 6, "GH"], [15, 6], [15, 5], [15, 4], 11, 11],
#V   n = 11
[ , [15, 8], 12, 11, [15, 6], [15, 5], [15, 4], 11, 11],
#V   n = 12
[ , [15, 9], [15, 8], 11, 11, [15, 6], [14, 6], [15, 4], 11, 11],
#V   n = 13
[ , [15, 10], [15, 9], [15, 8], 11, 11, 12, 11, [15, 4], 11, 11],
#V   n = 14
[ , [15, 11], [15, 10], [15, 9], [15, 8], 11, 11, 11, 11, [15, 4], 11, 11],
#V   n = 15
[ , [15, 12], [15, 11], [15, 10], [16, 8], [15, 8], 11, 11, 11, 11, [15, 4], 11, 11],
#V   n = 16
[ , [15, 12], [15, 12], [15, 11], [16, 9], [16, 8], [15, 8], 11, 11, 11, 11, [15, 4], 11, 11],
#V   n = 17
[ , [15, 13], [15, 12], [15, 12], [16, 10], [16, 9], [16, 8], [15, 8], 11, 11, 11, 11, [15, 4], 11, 11],
#V   n = 18
[ , [15, 14], [15, 13], [15, 12], [0, 10, "Liz"], [16, 10], [16, 9], [16, 8], [15, 8], [14, 8], 11, 11, 11, [0, 3, "cap"], 11, 11],
#V   n = 19
[ , [15, 15], [15, 14], [14, 3], 12, 11, [16, 10], [16, 9], [16, 8], 12, 11, 11, 11, 11, 11, 11, 11],
#V   n = 20
[ , [15, 16], [15, 15], 12, [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 21
[ , [15, 16], [15, 16], 12, [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 22
[ , [15, 17], [15, 16], 12, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, [14, 16], 11],
#V   n = 23
[ , [15, 18], [15, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 24
[ , [15, 19], [15, 17], [15, 16], [15, 16], [0, 14, "Bou"], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 25
[ , [15, 20], [15, 18], [15, 17], [15, 16], 12, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 26
[ , [15, 20], [15, 19], [15, 18], [15, 17], [15, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 27
[ , [15, 21], [15, 20], [15, 19], [0, 17, "Bou"], [15, 17], [15, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 28
[ , [15, 22], [15, 20], [15, 20], 12, 11, [15, 17], [15, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 29
[ , [15, 23], [15, 21], [15, 20], 12, 11, 11, [16, 16], [15, 16], 11, 11, [16, 14], [14, 10], [16, 12], 11, 11, [16, 10], [14, 14], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 30
[ , [15, 24], [15, 22], [15, 21], [15, 20], 11, 11, [16, 17], [16, 16], [15, 16], 11, 11, 12, 11, [16, 12], [14, 12], 11, 12, 11, [16, 8], 11, 11, 11, [0, 4, "BK"], 11, 11, 11, 11],
#V   n = 31
[ , [15, 24], [15, 23], [15, 22], [0, 20, "Bou"], [15, 20], 11, [16, 18], [16, 17], [16, 16], [15, 16], 11, 11, 11, [16, 12], 12, 11, 11, 11, [16, 8], [16, 8], 11, 11, 12, 11, 11, 11, 11, 11],
#V   n = 32
[ , [15, 25], [15, 24], [0, 22, "GH"], 12, 11, [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [15, 16], 11, 11, [16, 13], [16, 12], 11, 11, 11, [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 33
[ , [15, 26], [15, 24], 12, 11, 11, 11, [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [15, 16], 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 34
[ , [15, 27], [15, 25], [15, 24], 11, 11, 11, [16, 20], [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 35
[ , [15, 28], [15, 26], [16, 24], [15, 24], 11, 11, [16, 21], [16, 20], [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 36
[ , [15, 28], [15, 27], [16, 25], [16, 24], [15, 24], 11, [16, 22], [16, 21], [16, 20], [15, 20], [16, 19], [16, 18], [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 37
[ , [15, 29], [15, 28], [16, 26], [16, 25], [16, 24], [15, 24], [16, 23], [16, 22], [16, 21], [16, 20], [15, 20], [16, 19], [14, 10], [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 38
[ , [15, 30], [15, 28], [16, 27], [16, 26], [16, 25], [16, 24], [15, 24], [16, 23], [16, 22], [16, 21], [16, 20], [15, 20], 12, 11, [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 39
[ , [15, 31], [15, 29], [15, 28], [16, 27], [16, 26], [16, 25], [16, 24], [14, 6], [0, 22, "Gur"], [16, 22], [16, 21], [16, 20], 12, 11, 11, [16, 17], [16, 16], [15, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], [16, 8], [0, 6, "LP"], 11, 11, 11, 11, 11, 11, 11],
#V   n = 40
[ , [15, 32], [15, 30], [16, 28], [15, 28], [16, 27], [16, 26], [16, 25], [16, 24], 11, 11, [16, 22], [16, 21], [16, 20], 11, 11, 11, [16, 17], [16, 16], [15, 16], [14, 16], [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 12, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 41
[ , [15, 32], [15, 31], [16, 29], [16, 28], [0, 27, "Da"], [16, 27], [16, 26], [14, 6], [16, 24], 11, 11, [16, 22], [14, 10], [16, 20], 11, 11, 11, [16, 17], [16, 16], 12, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 42
[ , [15, 33], [15, 32], [16, 30], [16, 29], [16, 28], 11, [16, 27], 12, 11, [16, 24], 11, 11, 12, 11, [16, 20], 11, 11, 11, [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, [0, 3, "EB4"], 11, 11, 11],
#V   n = 43
[ , [15, 34], [15, 32], [16, 31], [16, 30], [16, 29], [16, 28], 11, 12, 11, [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 44
[ , [15, 35], [15, 32], [15, 32], [16, 31], [16, 30], [16, 29], [16, 28], 11, 11, [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 45
[ , [15, 36], [15, 33], [15, 32], [0, 31, "Liz"], [0, 30, "Da"], [16, 30], [16, 29], [16, 28], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 46
[ , [15, 36], [15, 34], [15, 33], [15, 32], 11, 11, [16, 30], [14, 6], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 47
[ , [15, 37], [15, 35], [15, 34], [14, 3], [15, 32], 11, 11, 12, 11, [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, [16, 16], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [16, 9], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 48
[ , [15, 38], [15, 36], [15, 35], 12, [16, 32], [15, 32], 11, 11, 11, [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, [16, 10], [0, 8, "LP"], [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 49
[ , [15, 39], [15, 36], [15, 36], 12, [16, 33], [16, 32], [15, 32], 11, 11, [16, 29], [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 12, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 50
[ , [15, 40], [15, 37], [15, 36], 12, [16, 34], [16, 33], [16, 32], [15, 32], 11, [16, 30], [16, 29], [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 51
[ , [15, 40], [15, 38], [0, 36, "LMH"], [15, 36], [16, 35], [16, 34], [16, 33], [16, 32], [0, 31, "Gur"], [16, 31], [16, 30], [16, 29], [16, 28], [0, 27, "LP"], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 52
[ , [15, 41], [15, 39], 12, 11, [15, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, [16, 31], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 14], [0, 12, "LP"], [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 53
[ , [15, 42], [15, 40], 12, 11, [16, 36], [15, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, [16, 31], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 12, 11, [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 54
[ , [15, 43], [15, 40], 12, 11, [16, 37], [16, 36], [0, 35, "Gur"], [0, 34, "Gur"], [16, 34], [16, 33], [16, 32], 11, [16, 31], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 55
[ , [15, 44], [15, 41], [15, 40], 11, [16, 38], [16, 37], [16, 36], 11, 11, [16, 34], [14, 8], [16, 32], 11, [16, 31], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, 11, [16, 12], [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 56
[ , [15, 44], [15, 42], [0, 40, "HLa"], [15, 40], [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, 12, 11, [16, 32], 11, [16, 31], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, 11, [16, 13], [16, 12], [16, 12], 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 57
[ , [15, 45], [15, 43], 12, 11, [15, 40], [16, 39], [0, 37, "Gur"], [14, 6], [16, 36], 11, 11, 11, 11, [16, 32], 11, [14, 12], [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], 11, [16, 14], [16, 13], [16, 12], [16, 12], [0, 10, "LP"], 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 58
[ , [15, 46], [15, 44], 12, 11, [16, 40], [15, 40], 12, 11, 11, [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], [16, 15], [16, 14], [16, 13], [16, 12], 12, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 59
[ , [15, 47], [15, 44], 12, 11, [16, 40], [16, 40], 12, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 60
[ , [15, 48], [15, 45], [15, 44], 11, [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [0, 26, "LP"], [16, 26], [16, 25], [16, 24], [0, 23, "LP"], [16, 23], [16, 22], [16, 21], [16, 20], [16, 20], [16, 19], [16, 18], [16, 17], [16, 16], [16, 16], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, [0, 4, "LP"], 11, 11, 11, 11, 11],
#V   n = 61
[ , [15, 48], [15, 46], [15, 45], [15, 44], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, [0, 29, "LP"], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, [16, 23], [16, 22], [16, 21], [16, 20], [0, 19, "LP"], [16, 19], [16, 18], [16, 17], [16, 16], [0, 15, "LP"], [0, 14, "LP"], [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, [16, 8], [0, 6, "LP"], 11, 12, 11, 11, 11, 11, 11, 11],
#V   n = 62
[ , [15, 49], [15, 47], [15, 46], [14, 3], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, [0, 35, "LP"], 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, [16, 23], [16, 22], [16, 21], [16, 20], 11, [16, 19], [16, 18], [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 63
[ , [15, 50], [15, 48], [15, 47], 12, [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, [16, 23], [16, 22], [16, 21], [16, 20], 11, [16, 19], [16, 18], [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 64
[ , [15, 51], [15, 48], [15, 48], 12, [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [0, 39, "BK"], 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 24], [16, 24], 11, [16, 23], [16, 22], [16, 21], [16, 20], 11, [0, 18, "LP"], [16, 18], [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 65
[ , [15, 52], [15, 48], [15, 48], 12, [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, [16, 35], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 25], [16, 24], [16, 24], 11, [14, 26], [16, 22], [16, 21], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 66
[ , [15, 52], [15, 49], [15, 48], [15, 48], [16, 46], [16, 45], [16, 44], [0, 43, "Gur"], [16, 43], [16, 42], [16, 41], [16, 40], 11, [0, 38, "LP"], 11, 11, 11, 11, [0, 34, "LP"], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [0, 28, "LP"], [16, 28], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, [16, 14], [0, 12, "Jo"], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 67
[ , [15, 53], [15, 50], [15, 49], [15, 48], [16, 47], [16, 46], [16, 45], [16, 44], 11, [0, 42, "Gur"], [16, 42], [14, 8], [16, 40], 11, 11, 11, 11, [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], [0, 31, "LP"], 11, 11, 11, 11, [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, 12, 11, [16, 12], 11, 11, 11, [0, 8, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 68
[ , [15, 54], [15, 51], [15, 50], [16, 48], [15, 48], [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 12, 11, [16, 40], 11, 11, [0, 37, "LP"], [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 69
[ , [15, 55], [15, 52], [15, 51], [16, 49], [16, 48], [15, 48], [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, [16, 40], 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [0, 21, "LP"], [16, 21], [16, 20], 11, 11, [0, 17, "LP"], [16, 17], [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 70
[ , [15, 56], [15, 52], [15, 52], [16, 50], [16, 49], [16, 48], [15, 48], [0, 46, "Gur"], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, [16, 40], 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, [16, 29], [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [0, 20, "LP"], [16, 20], 11, 11, 11, [0, 16, "LP"], [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 71
[ , [15, 56], [15, 53], [15, 52], [16, 51], [16, 50], [16, 49], [16, 48], 12, 11, [0, 45, "LP"], [0, 44, "Gur"], [16, 44], 11, 11, 11, [16, 40], [16, 40], 11, 11, 11, [16, 37], [16, 36], 11, 11, [0, 33, "LP"], [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], [16, 28], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 72
[ , [15, 57], [15, 54], [15, 53], [15, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, [16, 44], 11, 11, [16, 41], [16, 40], [16, 40], 11, 11, 11, [0, 36, "LP"], [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, [0, 30, "LP"], [16, 30], [16, 29], [16, 28], [0, 27, "LP"], [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 73
[ , [15, 58], [15, 55], [15, 54], [16, 52], [15, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, [0, 43, "LP"], 11, [16, 42], [16, 41], [16, 40], [0, 39, "LP"], 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 74
[ , [15, 59], [15, 56], [15, 55], [16, 53], [16, 52], [0, 51, "BK"], [16, 51], [0, 49, "Gur"], [14, 6], [16, 48], 11, 11, 11, 11, 11, [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], [0, 23, "LP"], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], [0, 14, "LP"], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 75
[ , [15, 60], [15, 56], [15, 56], [16, 54], [16, 53], [16, 52], 11, 12, 11, 11, [0, 47, "BK"], [0, 46, "Gur"], 11, 11, 11, 11, [0, 42, "LP"], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, [0, 19, "LP"], 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 12], [0, 10, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 76
[ , [15, 60], [15, 57], [15, 56], [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, [16, 27], [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 77
[ , [15, 61], [15, 58], [15, 57], [15, 56], [16, 55], [0, 53, "Gur"], [16, 53], [16, 52], 11, 11, 11, 11, 11, 11, [0, 45, "LP"], [16, 45], [16, 44], 11, 11, [0, 41, "LP"], [16, 41], [16, 40], 11, [0, 38, "LP"], 11, 11, 11, [0, 35, "LP"], 11, 11, 11, [16, 33], [16, 32], 11, 11, [0, 29, "LP"], [16, 29], [16, 28], 11, [0, 26, "LP"], [16, 26], [16, 25], [16, 24], 11, [0, 22, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 78
[ , [15, 62], [15, 59], [15, 58], [16, 56], [15, 56], 12, 11, [0, 52, "Gur"], [0, 51, "BK"], 11, 11, 11, [16, 48], 11, 11, 11, [16, 45], [16, 44], 11, 11, 11, [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "LP"], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 17], [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 79
[ , [15, 63], [15, 60], [15, 59], [16, 57], [16, 56], 12, 11, 11, 11, 11, [0, 50, "BK"], [0, 49, "BK"], [16, 49], [16, 48], 11, 11, 11, [16, 45], [16, 44], 11, 11, 11, [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, [0, 18, "LP"], [16, 18], [16, 17], [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 80
[ , [15, 64], [15, 60], [15, 60], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, 11, 11, 11, [0, 48, "LP"], [16, 48], 11, 11, 11, [16, 45], [16, 44], 11, 11, 11, [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [0, 25, "LP"], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 81
[ , [15, 64], [15, 61], [15, 60], [16, 59], [16, 58], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [0, 44, "LP"], [16, 44], 11, 11, 11, [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, [16, 25], [16, 24], 11, 11, [0, 21, "LP"], 11, 11, 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 82
[ , [15, 65], [15, 62], [15, 61], [15, 60], [0, 58, "LP"], [16, 57], [16, 56], [0, 55, "Gur"], [0, 54, "BK"], 11, 11, 11, 11, 11, 11, 11, [0, 47, "LP"], 11, 11, 11, 11, [0, 43, "LP"], 11, 11, 11, [0, 40, "LP"], [16, 40], 11, 11, [0, 37, "LP"], 11, 11, 11, 11, 11, [16, 33], [16, 32], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, [16, 18], [16, 17], [16, 16], 11, 11, 11, [0, 12, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 83
[ , [15, 66], [15, 63], [15, 62], [16, 60], 12, [16, 58], [16, 57], [16, 56], 11, 11, [0, 53, "BK"], [0, 52, "LP"], [16, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, [0, 34, "LP"], [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, [0, 28, "LP"], [16, 28], 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, [16, 21], [16, 20], 11, 11, [0, 17, "LP"], [0, 16, "LP"], [16, 16], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 84
[ , [15, 67], [15, 64], [15, 63], [16, 61], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, [0, 51, "LP"], [0, 50, "LP"], 11, 11, 11, 11, [0, 46, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], [0, 31, "LP"], 11, 11, 11, 11, [16, 28], 11, 11, 11, [0, 24, "LP"], [16, 24], 11, 11, 11, [16, 21], [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 85
[ , [15, 68], [15, 64], [15, 64], [16, 62], [0, 60, "Gur"], [16, 60], [16, 59], [16, 58], [0, 56, "BK"], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, [16, 24], 11, 11, 11, [16, 21], [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 86
[ , [15, 68], [15, 64], [15, 64], [0, 62, "Gur"], 12, [16, 60], [0, 59, "LP"], [0, 58, "Gur"], 12, 11, [16, 56], [0, 54, "LP"], 11, 11, 11, 11, 11, [0, 49, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, [16, 24], [16, 24], 11, 11, 11, [0, 20, "LP"], [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 64], 11, 11],
#V   n = 87
[ , [15, 69], [15, 65], [15, 64], 12, 11, [16, 61], [16, 60], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [0, 27, "LP"], 11, 11, [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 88
[ , [15, 70], [15, 66], [15, 64], [15, 64], 11, [16, 62], [16, 61], [16, 60], 11, 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 45, "LP"], 11, 11, 11, [0, 42, "LP"], 11, 11, 11, [0, 39, "LP"], 11, 11, 11, [0, 36, "LP"], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, [0, 30, "LP"], 11, 11, 11, 11, 11, [16, 26], [16, 25], [16, 24], [0, 23, "LP"], 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 89
[ , [15, 71], [15, 67], [15, 65], [15, 64], [15, 64], [0, 62, "BK"], [16, 62], [16, 61], [0, 59, "BK"], 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, [0, 33, "LP"], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, [0, 26, "LP"], [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, [16, 20], 11, 11, 11, 11, [16, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 90
[ , [15, 72], [15, 68], [15, 66], [15, 65], [15, 64], 12, 11, [0, 61, "Gur"], 12, 11, 11, [0, 57, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 48, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, [16, 26], [16, 25], [16, 24], 11, [0, 22, "LP"], 11, 11, 11, [0, 19, "LP"], 11, 11, 11, 11, [16, 16], [0, 14, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 91
[ , [15, 72], [15, 68], [15, 67], [15, 66], [15, 65], [15, 64], 11, 11, 11, 11, 11, 12, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, [0, 51, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, 11, 11, [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 92
[ , [15, 73], [15, 69], [15, 68], [15, 67], [15, 66], [14, 4], [15, 64], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 41, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 93
[ , [15, 74], [15, 70], [15, 68], [15, 68], [15, 67], 12, 11, [15, 64], [0, 62, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 54, "LP"], 11, 11, 11, 11, [0, 50, "LP"], 11, 11, 11, [0, 47, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "LP"], 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 94
[ , [15, 75], [15, 71], [15, 69], [15, 68], [0, 67, "Gur"], 12, 11, [16, 64], 12, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 95
[ , [15, 76], [15, 72], [15, 70], [15, 69], [15, 68], 11, 11, [16, 65], [16, 64], 11, 11, 12, 11, 11, [0, 58, "LP"], 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 35, "LP"], 11, 11, 11, [0, 32, "LP"], [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 96
[ , [15, 76], [15, 72], [15, 71], [15, 70], [16, 68], [15, 68], 11, [16, 66], [0, 64, "Gur"], [16, 64], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "sp"], 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 97
[ , [15, 77], [15, 73], [15, 72], [0, 70, "War"], [16, 69], [16, 68], [15, 68], [16, 67], 12, 11, [16, 64], [0, 62, "LP"], 11, 11, 11, 11, 11, [0, 57, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 46, "LP"], 11, 11, 11, [0, 43, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 98
[ , [15, 78], [15, 74], [15, 72], 12, [16, 70], [16, 69], [16, 68], [0, 67, "Gur"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "LP"], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 8], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 99
[ , [15, 79], [15, 75], [15, 73], [15, 72], [16, 71], [16, 70], [16, 69], [16, 68], 11, 11, 11, 11, 11, 11, [0, 61, "LP"], [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, 11, [0, 49, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], 11, 11, [16, 30], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, 11, [16, 8], [0, 6, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 100
[ , [15, 80], [15, 76], [15, 74], [15, 73], [15, 72], [16, 71], [16, 70], [16, 69], [0, 67, "BK"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 59, "LP"], 11, 11, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, [0, 37, "LP"], 11, 11, 11, [0, 34, "LP"], 11, 11, [16, 32], [0, 31, "LP"], 11, 11, [0, 29, "LP"], [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 101
[ , [15, 80], [15, 76], [15, 75], [15, 74], [16, 72], [0, 71, "LP"], [16, 71], [16, 70], 12, 11, 11, [0, 65, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 102
[ , [15, 81], [15, 77], [15, 76], [0, 74, "Gur"], [16, 73], [16, 72], 11, [16, 71], 12, 11, 11, 12, 11, 11, [0, 63, "LP"], 11, 11, 11, 11, 11, [0, 58, "LP"], 11, 11, 11, 11, [0, 54, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 48, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 103
[ , [15, 82], [15, 78], [15, 76], 12, [16, 74], [16, 73], [16, 72], 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 51, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 45, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 104
[ , [15, 83], [15, 79], [0, 76, "HLa"], [15, 76], [16, 75], [16, 74], [16, 73], [16, 72], [0, 70, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 62, "LP"], 11, 11, 11, 11, 11, [0, 57, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 105
[ , [15, 84], [15, 80], 12, 11, [15, 76], [0, 74, "BK"], [16, 74], [16, 73], 12, 11, 11, [0, 68, "LP"], [0, 67, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "LP"], 11, 11, 11, [0, 39, "LP"], 11, 11, 11, 11, [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 106
[ , [15, 84], [15, 80], 12, 11, [16, 76], 12, 11, [16, 74], 12, 11, 11, 12, 11, 11, [0, 66, "LP"], [0, 65, "LP"], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 50, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, [16, 26], [0, 24, "sp"], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 107
[ , [15, 85], [15, 80], 12, 11, [16, 77], [16, 76], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 64, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, 12, 11, [16, 24], 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 108
[ , [15, 86], [15, 81], [15, 80], 11, [16, 78], [14, 4], [16, 76], 11, [0, 73, "LP"], [0, 72, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 56, "LP"], 11, 11, 11, [0, 53, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 109
[ , [15, 87], [15, 82], [15, 80], [15, 80], [16, 79], 12, 11, [16, 76], 12, 11, 11, [0, 71, "LP"], [0, 70, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 63, "LP"], 11, 11, 11, 11, [0, 59, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 47, "LP"], 11, 11, 11, [0, 44, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 110
[ , [15, 88], [15, 83], [15, 81], [15, 80], [15, 80], 12, 11, 11, 12, 11, 11, 11, 11, 11, [0, 69, "LP"], [0, 68, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, 11, [16, 24], [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 111
[ , [15, 88], [15, 84], [15, 82], [15, 81], [15, 80], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 67, "LP"], [0, 66, "LP"], 11, 11, 11, 11, [0, 62, "LP"], 11, 11, 11, 11, [0, 58, "LP"], 11, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [16, 29], [16, 28], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 112
[ , [15, 89], [15, 84], [15, 83], [15, 82], [16, 80], [15, 80], 11, 11, [0, 76, "LP"], [0, 75, "LP"], 11, 11, [0, 72, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, 11, [0, 49, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, [0, 28, "Jo"], [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 113
[ , [15, 90], [15, 85], [15, 84], [15, 83], [16, 81], [16, 80], [15, 80], 11, 12, 11, 11, [0, 74, "LP"], 12, 11, [0, 71, "LP"], [0, 70, "LP"], 11, 11, 11, 11, 11, [0, 65, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 114
[ , [15, 91], [15, 86], [15, 84], [15, 84], [16, 82], [16, 81], [16, 80], [0, 79, "LP"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 64, "LP"], 11, 11, 11, [0, 61, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 115
[ , [15, 92], [15, 87], [15, 85], [15, 84], [16, 83], [16, 82], [16, 81], [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 69, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 54, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [16, 28], [0, 26, "sp"], 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 116
[ , [15, 92], [15, 88], [15, 86], [0, 84, "Ma"], [15, 84], [16, 83], [16, 82], [16, 81], [0, 79, "LP"], [0, 78, "LP"], 11, [0, 76, "LP"], [0, 75, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 68, "LP"], 11, 11, 11, 11, 11, [0, 63, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 57, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 51, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 117
[ , [15, 93], [15, 88], [15, 87], 12, [16, 84], [0, 83, "LP"], [0, 82, "LP"], [16, 82], 12, 11, 11, 12, 11, 11, [0, 74, "LP"], [0, 73, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 118
[ , [15, 94], [15, 89], [15, 88], 12, [16, 85], [16, 84], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 72, "LP"], [0, 71, "LP"], 11, 11, 11, 11, [0, 67, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 119
[ , [15, 95], [15, 90], [15, 88], 12, [16, 86], [16, 85], [16, 84], 11, 11, [0, 80, "LP"], 11, 11, [0, 77, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 120
[ , [15, 96], [15, 91], [15, 89], [15, 88], [16, 87], [0, 85, "BK"], [16, 85], [16, 84], [0, 82, "BK"], 12, 11, [0, 79, "LP"], 12, 11, 11, [0, 75, "LP"], 11, 11, 11, 11, 11, [0, 70, "LP"], 11, 11, 11, 11, [0, 66, "LP"], 11, 11, 11, 11, [0, 62, "LP"], 11, 11, 11, [0, 59, "LP"], 11, 11, 11, [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 121
[ , [15, 96], [15, 92], [15, 90], [16, 88], [15, 88], 12, 11, [16, 85], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 4, "sp"], 11, 11, 11, 11, 11, 11],
#V   n = 122
[ , [15, 97], [15, 92], [15, 91], [16, 89], [16, 88], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 74, "LP"], 11, 11, 11, 11, 11, [0, 69, "LP"], 11, 11, 11, 11, [0, 65, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11],
#V   n = 123
[ , [15, 98], [15, 93], [15, 92], [16, 90], [16, 89], [16, 88], 11, 11, 11, [0, 83, "LP"], 11, 11, [0, 80, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 73, "LP"], [0, 72, "LP"], 11, 11, 11, 11, [0, 68, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 124
[ , [15, 99], [15, 94], [15, 92], [16, 91], [16, 90], [0, 88, "LP"], [16, 88], 11, [0, 85, "LP"], 12, 11, [0, 82, "LP"], 12, 11, 11, [0, 78, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 58, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 12, 11, 11, 11, 11, 11, 11, [16, 24], [0, 22, "sp"], 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 125
[ , [15, 100], [15, 95], [15, 93], [15, 92], [16, 91], 12, 11, [0, 87, "LP"], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, [0, 76, "LP"], 11, 11, 11, 11, 11, [0, 71, "LP"], 11, 11, 11, 11, [0, 67, "LP"], 11, 11, 11, [0, 64, "LP"], 11, 11, 11, [0, 61, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 126
[ , [15, 100], [15, 96], [15, 94], [16, 92], [15, 92], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 127
[ , [15, 101], [15, 96], [15, 95], [16, 93], [16, 92], 12, 11, 11, 11, [0, 86, "LP"], 11, 11, [0, 83, "LP"], 11, 11, [0, 80, "LP"], 11, 11, 11, 11, 11, [0, 75, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 128
[ , [15, 102], [15, 96], [15, 96], [16, 94], [16, 93], [0, 91, "LP"], 11, 11, [0, 88, "LP"], 12, 11, [0, 85, "LP"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 129
[ , [15, 103], [15, 97], [15, 96], [16, 95], [16, 94], 12, 11, [0, 90, "LP"], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, [0, 79, "LP"], 11, 11, 11, 11, 11, [0, 74, "LP"], 11, 11, 11, 11, [0, 70, "LP"], 11, 11, 11, 11, [0, 66, "LP"], 11, 11, 11, [0, 63, "LP"], 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 34], [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 130
[ , [15, 104], [15, 98], [15, 96], [15, 96], [16, 95], 12, 11, 11, 11, [0, 88, "LP"], 11, 11, [0, 85, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 77, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, [16, 33], [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "sp"], 11, 11, [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 131
[ , [15, 104], [15, 99], [15, 97], [15, 96], [15, 96], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 83, "LP"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [0, 73, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], 11, [16, 34], [16, 33], [16, 32], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 132
[ , [15, 105], [15, 100], [15, 98], [16, 96], [15, 96], [0, 94, "LP"], 11, 11, [0, 91, "LP"], 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 81, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 69, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], [16, 32], [0, 30, "sp"], 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 133
[ , [15, 106], [15, 100], [15, 99], [16, 97], [16, 96], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 37], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 134
[ , [15, 107], [15, 101], [15, 100], [16, 98], [16, 97], [16, 96], 11, 11, 12, [0, 91, "Da1"], 11, 11, [0, 88, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 80, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, [16, 36], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 135
[ , [15, 108], [15, 102], [15, 100], [16, 99], [16, 98], [16, 97], [16, 96], 11, 11, 12, 11, 11, 12, 11, 11, [0, 86, "Da1"], [0, 85, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, [16, 37], [16, 36], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 136
[ , [15, 108], [15, 103], [15, 101], [15, 100], [16, 99], [0, 97, "DM3"], [14, 4], [16, 96], [0, 94, "Da1"], 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 84, "Da1"], [0, 83, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 137
[ , [15, 109], [15, 104], [15, 102], [16, 100], [15, 100], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 82, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], [16, 35], [16, 34], [16, 33], [16, 32], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 138
[ , [15, 110], [15, 104], [15, 103], [16, 101], [16, 100], 12, 11, 11, [16, 96], [0, 94, "Da1"], 11, 11, [0, 91, "Da1"], [0, 90, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], [0, 34, "sp"], [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 139
[ , [15, 111], [15, 105], [15, 104], [16, 102], [16, 101], [16, 100], 11, 11, [16, 97], 12, 11, 11, 12, 11, 11, [0, 89, "Da1"], [0, 88, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 41], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 12, 11, [16, 34], [16, 33], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 140
[ , [15, 112], [15, 106], [15, 104], [16, 103], [16, 102], [0, 100, "DM3"], [0, 99, "Da1"], 11, [0, 97, "Da1"], 12, 11, 11, 12, 11, 11, 11, 11, 11, [0, 87, "Da1"], [0, 86, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 42], [16, 40], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, [16, 34], [0, 32, "Jo"], [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 141
[ , [15, 112], [15, 107], [15, 105], [15, 104], [16, 103], 12, 11, 11, 12, 11, 11, 11, [0, 93, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 85, "Da1"], [0, 84, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, 11, [16, 41], [16, 40], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, 12, 11, [16, 32], 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 142
[ , [15, 113], [15, 108], [15, 106], [16, 104], [15, 104], 12, 11, 11, 11, [0, 97, "Da1"], 11, 11, 12, 11, 11, [0, 91, "Da1"], [0, 90, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], 11, [16, 42], [16, 41], [16, 40], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 143
[ , [15, 114], [15, 108], [15, 107], [16, 105], [16, 104], 12, 11, 11, [16, 100], 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 89, "Da1"], [0, 88, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, [16, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 144
[ , [15, 115], [15, 109], [15, 108], [16, 106], [16, 105], [0, 103, "DM3"], [0, 102, "Da1"], 11, [0, 100, "Da1"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, 11, [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, [16, 39], [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, [16, 32], [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 145
[ , [15, 116], [15, 110], [15, 108], [16, 107], [16, 106], 12, 11, 11, 12, [0, 99, "Da1"], 11, 11, [0, 96, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 87, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, 11, [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, [0, 38, "sp"], [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 146
[ , [15, 116], [15, 111], [15, 109], [15, 108], [16, 107], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 94, "Da1"], [0, 93, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, 11, [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 147
[ , [15, 117], [15, 112], [15, 110], [16, 108], [15, 108], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 92, "Da1"], [0, 91, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, [16, 38], [0, 36, "sp"], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 148
[ , [15, 118], [15, 112], [15, 111], [16, 109], [16, 108], 12, [0, 105, "Da1"], 11, [0, 103, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 90, "Da1"], [0, 89, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 12, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 149
[ , [15, 119], [15, 112], [15, 112], [16, 110], [16, 109], [0, 107, "DM3"], 12, 11, 12, [0, 102, "Da1"], 11, 11, [0, 99, "Da1"], [0, 98, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, [16, 36], [0, 34, "sp"], 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 150
[ , [15, 120], [15, 113], [15, 112], [16, 111], [16, 110], [16, 108], 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 97, "Da1"], [0, 96, "Da1"], [0, 95, "Da1"], 11, [0, 93, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 151
[ , [15, 120], [15, 114], [15, 112], [15, 112], [16, 111], [16, 109], [16, 108], 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 152
[ , [15, 121], [15, 115], [15, 113], [15, 112], [15, 112], [16, 110], [0, 108, "Da1"], [16, 108], [0, 106, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 93, "Da1"], 11, [0, 92, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 153
[ , [15, 122], [15, 116], [15, 114], [16, 112], [15, 112], [16, 111], 12, 11, 12, [0, 105, "Da1"], 11, 11, [0, 102, "Da1"], [0, 101, "Da1"], 11, 11, [0, 98, "Da1"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 154
[ , [15, 123], [15, 116], [15, 115], [16, 113], [16, 112], [0, 111, "DM3"], 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 100, "Da1"], 12, 11, [0, 97, "Da1"], [0, 96, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 112], 11, 11, 11, 11],
#V   n = 155
[ , [15, 124], [15, 117], [15, 116], [16, 114], [16, 113], [16, 112], 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], [16, 40], [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 156
[ , [15, 124], [15, 118], [15, 116], [16, 115], [16, 114], [0, 112, "DM3"], [0, 111, "Da1"], 11, [0, 109, "Da1"], 12, 11, 11, 11, [0, 103, "Da1"], 11, 11, [0, 100, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 6, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 157
[ , [15, 125], [15, 119], [15, 117], [15, 116], [16, 115], 12, 11, 11, 12, [0, 108, "Da1"], 11, 11, [0, 105, "Da1"], 12, 11, [0, 102, "Da1"], 12, 11, 11, [0, 98, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 158
[ , [15, 126], [15, 120], [15, 118], [16, 116], [15, 116], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 159
[ , [15, 127], [15, 120], [15, 119], [16, 117], [16, 116], 12, [0, 113, "Da1"], 11, [16, 112], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 97, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, 11, [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 160
[ , [15, 128], [15, 121], [15, 120], [16, 118], [16, 117], [0, 115, "DM3"], 12, 11, [0, 112, "Da1"], 12, 11, 11, 11, [0, 106, "Da1"], 11, 11, [0, 103, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 161
[ , [15, 128], [15, 122], [15, 120], [16, 119], [16, 118], 12, 11, 11, 11, [0, 111, "Da1"], [0, 110, "Da1"], 11, [0, 108, "Da1"], 12, 11, 11, 12, 11, 11, [0, 101, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [16, 43], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 162
[ , [15, 129], [15, 123], [15, 121], [15, 120], [16, 119], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 99, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], [16, 44], [0, 42, "sp"], [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 163
[ , [15, 130], [15, 124], [15, 122], [16, 120], [15, 120], 12, [0, 116, "Da1"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 12, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 164
[ , [15, 131], [15, 124], [15, 123], [16, 121], [16, 120], [0, 118, "DM3"], 12, 11, [16, 116], [0, 113, "Da1"], 11, 11, [0, 110, "Da1"], [0, 109, "Da1"], [0, 108, "Da1"], 11, [0, 106, "Da1"], 11, 11, [0, 103, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, [16, 42], [0, 40, "sp"], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 165
[ , [15, 132], [15, 125], [15, 124], [16, 122], [16, 121], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 12, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 166
[ , [15, 132], [15, 126], [15, 124], [16, 123], [16, 122], [16, 120], 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, [0, 102, "Da1"], [0, 101, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, [16, 40], [0, 38, "sp"], 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 167
[ , [15, 133], [15, 127], [15, 125], [15, 124], [16, 123], [16, 121], [0, 119, "Da1"], 11, 11, 12, 11, 11, 11, [0, 111, "Da1"], 11, 11, [0, 108, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 168
[ , [15, 134], [15, 128], [15, 126], [16, 124], [15, 124], [0, 121, "DM3"], 12, 11, [0, 118, "Da1"], [0, 116, "Da1"], 11, 11, [0, 113, "Da1"], 12, 11, 11, 12, 11, 11, [0, 106, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 169
[ , [15, 135], [15, 128], [15, 127], [16, 125], [16, 124], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 104, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [0, 46, "sp"], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 170
[ , [15, 136], [15, 128], [15, 128], [16, 126], [16, 124], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 171
[ , [15, 136], [15, 129], [15, 128], [16, 127], [16, 125], [16, 124], [0, 122, "Da1"], 11, 11, 12, 11, 11, 11, [0, 114, "Da1"], 11, 11, [0, 111, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [0, 44, "sp"], [16, 44], 11, 11, 11, [16, 40], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 172
[ , [15, 137], [15, 130], [15, 128], [15, 128], [16, 126], [0, 124, "DM3"], 12, 11, 11, [0, 119, "Da1"], [0, 118, "Da1"], 11, [0, 116, "Da1"], 12, 11, [0, 113, "Da1"], 12, 11, 11, [0, 109, "Da1"], [0, 108, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 12, 11, [16, 44], [0, 42, "Jo"], 11, [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 173
[ , [15, 138], [15, 131], [15, 128], [15, 128], [16, 127], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [0, 106, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 12, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 174
[ , [15, 139], [15, 132], [15, 129], [15, 128], [15, 128], 12, 11, 11, 11, 12, 11, 11, 11, [0, 116, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, [16, 42], [16, 41], [16, 40], 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 175
[ , [15, 140], [15, 132], [15, 130], [15, 129], [15, 128], 12, [0, 125, "Da1"], 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 114, "Da1"], [0, 113, "Da1"], 11, [0, 111, "Da1"], [0, 110, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, [16, 42], [0, 40, "sp"], [16, 40], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 176
[ , [15, 140], [15, 133], [15, 131], [15, 130], [16, 128], [0, 127, "DM3"], 12, 11, [0, 124, "Da1"], [0, 122, "Da1"], [0, 121, "Da1"], 11, [0, 119, "Da1"], 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [0, 108, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, [16, 44], 11, 11, 12, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 177
[ , [15, 141], [15, 134], [15, 132], [15, 131], [16, 129], [16, 128], 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 45], [16, 44], 11, 11, 11, 11, [16, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 178
[ , [15, 142], [15, 135], [15, 132], [15, 132], [16, 130], [16, 129], [16, 128], 11, 11, 12, 11, 11, 11, [0, 119, "Da1"], 11, 11, [0, 116, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, [16, 40], [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 179
[ , [15, 143], [15, 136], [15, 133], [15, 132], [16, 131], [16, 130], [0, 128, "Da1"], [16, 128], 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 114, "Da1"], [0, 113, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 50], [16, 48], [16, 48], [16, 48], [0, 46, "sp"], [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 180
[ , [15, 144], [15, 136], [15, 134], [15, 133], [15, 132], [0, 130, "DM3"], 12, 11, [0, 127, "Da1"], [0, 125, "Da1"], [0, 124, "Da1"], 11, [0, 122, "Da1"], 12, 11, 11, 12, 11, 11, 12, 11, 11, [0, 112, "Da1"], [0, 111, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 51], [16, 49], [16, 48], [16, 48], 12, 11, [16, 46], [16, 45], [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 181
[ , [15, 144], [15, 137], [15, 135], [15, 134], [16, 132], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 54], 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [0, 44, "sp"], [16, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 182
[ , [15, 145], [15, 138], [15, 136], [15, 135], [16, 133], [16, 132], [0, 130, "Da1"], 11, 11, 12, 11, 11, 11, [0, 122, "Da1"], 11, 11, [0, 119, "Da1"], [0, 118, "Da1"], 11, 11, [0, 115, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 12, 11, [16, 44], 11, 11, 11, 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 183
[ , [15, 146], [15, 139], [15, 136], [15, 136], [16, 134], [16, 133], 12, 11, 11, 12, [0, 126, "Da1"], 11, 11, 12, 11, 11, 12, 11, 11, [0, 117, "Da1"], 12, 11, 11, [0, 113, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 53], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, [16, 44], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 184
[ , [15, 147], [15, 140], [15, 137], [15, 136], [16, 135], [0, 133, "DM3"], 12, 11, 11, [0, 128, "Da1"], 12, 11, [0, 125, "Da1"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 54], 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, [16, 44], [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 185
[ , [15, 148], [15, 140], [15, 138], [15, 137], [15, 136], 12, 11, 11, 11, 12, 11, 11, 11, [0, 124, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [14, 60], 11, 11, 11, 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 186
[ , [15, 148], [15, 141], [15, 139], [15, 138], [16, 136], 12, [0, 133, "Da1"], 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 122, "Da1"], [0, 121, "Da1"], 11, 11, [0, 118, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 187
[ , [15, 149], [15, 142], [15, 140], [0, 138, "Ma"], [16, 137], [16, 136], 12, 11, 11, 12, [0, 129, "Da1"], 11, 11, 12, 11, 11, 12, 11, 11, [0, 120, "Da1"], 12, 11, 11, [0, 116, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 188
[ , [15, 150], [15, 143], [15, 140], 12, [16, 138], [0, 136, "DM3"], 12, 11, 11, [0, 131, "Da1"], 12, 11, [0, 128, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 189
[ , [15, 151], [15, 144], [15, 141], [15, 140], [16, 139], 12, 11, 11, 11, 12, 11, 11, 11, [0, 127, "Da1"], 11, 11, [0, 124, "Da1"], [0, 123, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 60], 11, 11, 11, 11, 11, 11, 11, [14, 66], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [0, 46, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 190
[ , [15, 152], [15, 144], [15, 142], [0, 140, "LaM"], [15, 140], 12, [0, 136, "Da1"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, [0, 122, "Da1"], [0, 121, "Da1"], 11, 11, [0, 118, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 191
[ , [15, 152], [15, 144], [15, 143], 12, [16, 140], 12, 12, 11, [16, 136], 12, [0, 132, "Da1"], 11, [0, 130, "Da1"], 12, 11, 11, 12, 11, 11, 11, 11, 11, [0, 120, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 192
[ , [15, 153], [15, 145], [15, 144], 12, [16, 141], [16, 140], 12, 11, 11, [0, 134, "Da1"], 12, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 38], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 57], [16, 56], [16, 56], [16, 56], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 193
[ , [15, 154], [15, 146], [15, 144], 12, [16, 142], [16, 141], 12, 11, 11, 12, 11, 11, 11, [0, 130, "Da1"], 11, 11, [0, 127, "Da1"], 11, 11, 11, [0, 123, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], 11, [16, 58], [16, 57], [16, 56], [16, 56], [14, 82], [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 194
[ , [15, 155], [15, 147], [15, 144], [15, 144], [16, 143], [16, 142], [0, 139, "Da1"], 11, 11, 12, [0, 134, "Da1"], 11, 11, 12, 11, 11, 12, 11, [0, 126, "Da1"], [0, 125, "Da1"], 12, 11, 11, [0, 121, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 195
[ , [15, 156], [15, 148], [15, 145], [15, 144], [15, 144], [16, 143], 12, 11, 11, [0, 136, "Da1"], 12, 11, [0, 133, "Da1"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 38], 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [16, 51], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 196
[ , [15, 156], [15, 148], [15, 146], [16, 144], [15, 144], 13, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 128, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, [14, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 55], 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 68], 11, 11, [14, 74], [16, 65], [16, 64], 11, 11, 11, 11, [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], [16, 52], [0, 50, "sp"], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 197
[ , [15, 157], [15, 149], [15, 147], [16, 145], [16, 144], [0, 143, "DM3"], 12, 11, 11, 12, 11, 11, 11, [0, 133, "Da1"], [0, 132, "Da1"], 11, [0, 130, "Da1"], 12, 11, 11, [0, 126, "Da1"], 11, 11, [0, 123, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, [16, 68], 11, 11, 11, [16, 65], [16, 64], 11, 11, 11, [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 12, 11, [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 198
[ , [15, 158], [15, 150], [15, 148], [16, 146], [16, 145], [16, 144], [0, 142, "Da1"], 11, 11, 12, [0, 137, "Da1"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 50], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, [16, 68], 11, 11, 11, [16, 65], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, [16, 50], [0, 48, "sp"], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 199
[ , [15, 159], [15, 151], [15, 148], [16, 147], [16, 146], [16, 145], 12, 11, 11, [0, 139, "Da1"], 12, 11, [0, 136, "Da1"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, [14, 68], [16, 73], [16, 72], 11, 11, 11, 11, 11, [14, 74], 11, 11, 11, [16, 65], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, 12, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, [0, 40, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 200
[ , [15, 160], [15, 152], [15, 149], [15, 148], [16, 147], [16, 146], 12, 11, 11, 12, 11, 11, 11, [0, 135, "Da1"], 11, 11, 11, [0, 131, "Da1"], 11, 11, [0, 128, "Da1"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 55], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], 11, [14, 80], [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 201
[ , [15, 160], [15, 152], [15, 150], [16, 148], [15, 148], [16, 147], 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 133, "DM4"], 12, 11, [0, 130, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, 11, 11, [16, 48], [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 202
[ , [15, 161], [15, 153], [15, 151], [16, 149], [16, 148], [15, 148], [0, 145, "DM4"], 11, [16, 144], 12, [0, 140, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, 11, [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, [14, 73], 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [16, 55], [16, 54], [16, 53], [16, 52], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 203
[ , [15, 162], [15, 154], [15, 152], [16, 150], [16, 149], [16, 148], 12, 11, [0, 144, "DM4"], 12, 12, 11, [0, 139, "DM4"], 12, 11, 11, 11, [0, 133, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 55], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, [0, 54, "sp"], [16, 54], [16, 53], [16, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 204
[ , [15, 163], [15, 155], [15, 152], [16, 151], [16, 150], [16, 149], 12, 11, 11, 11, 12, 11, 11, [0, 138, "DM4"], [0, 137, "DM4"], 11, 11, 12, 11, 11, [0, 131, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, [16, 54], [0, 52, "Jo"], [16, 52], 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 205
[ , [15, 164], [15, 156], [15, 153], [15, 152], [16, 151], [16, 150], 12, 11, 11, [0, 144, "DM4"], 12, 11, 11, 12, 11, 11, [0, 136, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 12, 11, [16, 52], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 206
[ , [15, 164], [15, 156], [15, 154], [16, 152], [15, 152], [16, 151], [0, 148, "DM4"], [16, 148], 11, 12, [0, 143, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, [16, 52], [0, 50, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 207
[ , [15, 165], [15, 157], [15, 155], [16, 153], [16, 152], [15, 152], 12, 11, [0, 147, "DM4"], 12, 12, 11, [0, 142, "DM4"], 12, 11, 11, 11, [0, 136, "DM4"], 11, 11, [0, 133, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 208
[ , [15, 166], [15, 158], [15, 156], [16, 154], [16, 153], [16, 152], 12, 11, 11, [0, 146, "DM4"], 12, 11, 11, [0, 141, "DM4"], [0, 140, "DM4"], 11, [0, 138, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 209
[ , [15, 167], [15, 159], [15, 156], [16, 155], [16, 154], [16, 153], [0, 150, "DM4"], 11, 11, 12, [0, 145, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 50], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, 11, [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], [14, 89], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, [0, 48, "sp"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 210
[ , [15, 168], [15, 160], [15, 157], [15, 156], [16, 155], [16, 154], 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 211
[ , [15, 168], [15, 160], [15, 158], [16, 156], [15, 156], [16, 155], 12, 11, 11, [0, 148, "DM4"], 12, 11, 11, 12, 11, 11, 11, [0, 139, "DM4"], 11, 11, [0, 136, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 212
[ , [15, 169], [15, 160], [15, 159], [16, 157], [16, 156], [15, 156], 12, 11, 11, 12, 11, 11, 11, [0, 144, "DM4"], [0, 143, "DM4"], 11, [0, 141, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 213
[ , [15, 170], [15, 161], [15, 160], [16, 158], [16, 157], [16, 156], [0, 153, "DM4"], 11, 11, 12, [0, 148, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 38], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [0, 54, "sp"], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 214
[ , [15, 171], [15, 162], [15, 160], [16, 159], [16, 158], [16, 157], 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, [0, 141, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 215
[ , [15, 172], [15, 163], [15, 160], [15, 160], [16, 159], [16, 158], 12, 11, 11, [0, 151, "DM4"], 12, 11, 11, 12, [0, 145, "DM4"], 11, 11, 12, 11, 11, [0, 139, "DM4"], [0, 138, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], 11, [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, [0, 52, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 216
[ , [15, 172], [15, 164], [15, 161], [15, 160], [15, 160], [16, 159], 12, 11, 11, 12, 11, 11, 11, [0, 147, "DM4"], 12, 11, [0, 144, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 73], [16, 72], 11, 11, [14, 84], [16, 69], [16, 68], 11, [14, 87], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 217
[ , [15, 173], [15, 164], [15, 162], [16, 160], [15, 160], [15, 160], [0, 156, "DM4"], 11, 11, 12, [0, 151, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, 11, [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, [16, 52], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 218
[ , [15, 174], [15, 165], [15, 163], [16, 161], [16, 160], [15, 160], 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, [0, 144, "DM4"], 11, 11, [0, 141, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [14, 93], [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, [16, 52], [0, 50, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 219
[ , [15, 175], [15, 166], [15, 164], [16, 162], [16, 161], [16, 160], 12, 11, 11, [0, 154, "DM4"], 12, 11, 11, [0, 149, "DM4"], [0, 148, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], 11, [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 61], [16, 60], 11, [16, 59], [16, 58], [16, 56], [16, 56], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 220
[ , [15, 176], [15, 167], [15, 164], [16, 163], [16, 162], [16, 160], 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 147, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 61], [16, 60], 11, [0, 58, "sp"], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 221
[ , [15, 176], [15, 168], [15, 165], [15, 164], [16, 163], [16, 161], [0, 159, "DM4"], 11, 11, 12, [0, 154, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 61], [16, 60], 11, [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, [0, 48, "sp"], 11, 11, 11, 11, 11, 11, [0, 42, "Jo"], 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 222
[ , [15, 177], [15, 168], [15, 166], [16, 164], [15, 164], [16, 162], 12, 11, 11, 12, 12, 11, [0, 153, "DM4"], 12, 11, 11, 11, [0, 147, "DM4"], 11, 11, [0, 144, "DM4"], [0, 143, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, 11, [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 61], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 223
[ , [15, 178], [15, 169], [15, 167], [16, 165], [16, 164], [16, 163], 12, 11, 11, [0, 157, "DM4"], 12, 11, 11, [0, 152, "DM4"], [0, 151, "DM4"], 11, [0, 149, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, 11, [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 61], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 224
[ , [15, 179], [15, 170], [15, 168], [16, 166], [16, 165], [16, 164], 12, 11, 11, 12, [0, 156, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], 11, [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 56], [0, 54, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 225
[ , [15, 180], [15, 171], [15, 168], [16, 167], [16, 166], [16, 164], [0, 162, "DM4"], 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, [0, 149, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 226
[ , [15, 180], [15, 172], [15, 169], [15, 168], [16, 167], [16, 165], 12, 11, 11, 12, 12, 11, 11, 12, [0, 153, "DM4"], 11, 11, 12, 11, 11, [0, 147, "DM4"], [0, 146, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], [14, 97], 11, [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, [0, 52, "sp"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 227
[ , [15, 181], [15, 172], [15, 170], [16, 168], [15, 168], [16, 166], 12, 11, 11, [0, 160, "DM4"], 12, 11, 11, [0, 155, "DM4"], 12, 11, [0, 152, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 228
[ , [15, 182], [15, 173], [15, 171], [16, 169], [16, 168], [16, 167], 12, 11, 11, 12, [0, 159, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 65], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 229
[ , [15, 183], [15, 174], [15, 172], [16, 170], [16, 169], [16, 168], [0, 165, "DM4"], 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, [0, 152, "DM4"], 11, 11, [0, 149, "DM4"], [0, 148, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 46], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 66], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, 11, [0, 50, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 230
[ , [15, 184], [15, 175], [15, 172], [16, 171], [16, 170], [16, 168], 12, 11, 11, 12, 12, 11, 11, 12, [0, 156, "DM4"], 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, 11, [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [0, 58, "sp"], [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 231
[ , [15, 184], [15, 176], [15, 173], [15, 172], [16, 171], [16, 169], 12, 11, 11, [0, 163, "DM4"], 12, 11, 11, [0, 158, "DM4"], 12, 11, [0, 155, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, [14, 34], 11, 11, 11, 11, 11, 11, 11, [14, 40], 11, 11, 11, 11, [14, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], 11, [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 12, 11, [16, 58], [16, 57], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 232
[ , [15, 185], [15, 176], [15, 174], [16, 172], [15, 172], [16, 170], 12, 11, 11, 12, [0, 162, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 82], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 11, 11, [16, 58], [0, 56, "sp"], [16, 56], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 233
[ , [15, 186], [15, 176], [15, 175], [16, 173], [16, 172], [16, 171], [0, 168, "DM4"], 11, 11, 12, 12, 11, 11, 12, [0, 158, "DM4"], 11, 11, [0, 155, "DM4"], [0, 154, "DM4"], 11, [0, 152, "DM4"], [0, 151, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, 11, [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 69], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 11, 11, 12, 11, [16, 56], 11, 11, 11, 11, 11, 11, 11, [0, 48, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 234
[ , [15, 187], [15, 177], [15, 176], [16, 174], [16, 173], [16, 172], 12, 11, 11, 12, 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 44], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], 11, [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, 11, [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 11, 11, 11, 11, [16, 56], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 235
[ , [15, 188], [15, 178], [15, 176], [16, 175], [16, 174], [16, 172], 12, 11, 11, [0, 166, "DM4"], 12, 11, 11, [0, 161, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, 11, [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 11, 11, 11, 11, [16, 56], [0, 54, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 236
[ , [15, 188], [15, 179], [15, 176], [15, 176], [16, 175], [16, 173], 12, 11, 11, 12, [0, 165, "DM4"], 11, 11, 12, 11, 11, 11, [0, 157, "DM4"], 11, 11, 11, [0, 153, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, 11, [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], 11, [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [16, 63], [16, 62], [16, 61], [16, 60], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 237
[ , [15, 189], [15, 180], [15, 177], [15, 176], [15, 176], [16, 174], [0, 171, "DM4"], 11, 11, 12, 12, 11, 11, 12, [0, 161, "DM4"], 11, 11, 12, 11, 11, [0, 155, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, 11, [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, [0, 62, "sp"], [16, 62], [16, 61], [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 238
[ , [15, 190], [15, 180], [15, 178], [15, 177], [15, 176], [16, 175], 12, 11, 11, 12, 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, 11, [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, [16, 62], [0, 60, "sp"], [16, 60], 11, 11, 11, 11, 11, 11, 11, [0, 52, "sp"], 11, 11, 11, 11, 11, 11, [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 239
[ , [15, 191], [15, 181], [15, 179], [0, 177, "LaM"], [16, 176], [15, 176], 12, 11, 11, [0, 169, "DM4"], [0, 167, "DM4"], 11, 11, [0, 164, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, 11, [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 12, 11, [16, 60], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 240
[ , [15, 192], [15, 182], [15, 180], 12, [16, 177], [16, 176], 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, [0, 160, "DM4"], [0, 159, "DM4"], 11, 11, [0, 156, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 241
[ , [15, 192], [15, 183], [15, 180], 12, [16, 178], [16, 176], [0, 174, "DM4"], 11, 11, 12, 12, 11, 11, 12, [0, 164, "DM4"], 11, 11, 12, 11, 11, [0, 158, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, [16, 60], [0, 58, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 50, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 242
[ , [15, 193], [15, 184], [15, 181], [15, 180], [16, 179], [16, 177], 12, 11, 11, 12, 12, 11, 11, [0, 166, "DM4"], 12, 11, [0, 163, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 4, "sp"], 11, 11, 11, 11, 11, 11, 11],
#V   n = 243
[ , [15, 194], [15, 184], [15, 182], [0, 180, "Ha"], [15, 180], [16, 178], 12, 11, 11, [0, 172, "DM4"], [0, 170, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 158, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, 11, 11, 11, [0, 56, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 244
[ , [15, 195], [15, 185], [15, 183], 12, [16, 180], [16, 179], 12, 11, 11, 12, 12, 11, 11, 12, [0, 166, "DM4"], 11, 11, [0, 163, "DM4"], [0, 162, "DM4"], 11, [0, 160, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 245
[ , [15, 196], [15, 186], [15, 184], 12, [16, 181], [16, 180], [0, 177, "DM4"], [0, 176, "DM4"], 11, 12, 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 96], 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 246
[ , [15, 196], [15, 187], [15, 184], 12, [16, 182], [16, 180], 12, 11, 11, 12, 12, 11, 11, [0, 169, "DM4"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 89], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 54, "sp"], 11, 11, 11, 11, 11, 11, [0, 48, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 247
[ , [15, 197], [15, 188], [15, 185], [15, 184], [16, 183], [16, 181], 12, 11, 11, [0, 175, "DM4"], [0, 173, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 161, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], 11, 11, 11, [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], [16, 64], [0, 62, "sp"], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 6, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 248
[ , [15, 198], [15, 188], [15, 186], [0, 184, "Ha"], [15, 184], [16, 182], 12, 11, 11, 12, 12, 11, 11, 12, [0, 169, "DM4"], 11, 11, [0, 166, "DM4"], [0, 165, "DM4"], [0, 164, "DM4"], [0, 163, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], 11, 11, [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 249
[ , [15, 199], [15, 189], [15, 187], 12, [16, 184], [16, 183], [0, 180, "DM4"], 11, 11, 12, 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [14, 34], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], 11, [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 11, 11, 11, [0, 60, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 250
[ , [15, 200], [15, 190], [15, 188], 12, [16, 185], [16, 184], 12, 11, 11, 12, 12, 11, 11, [0, 172, "DM4"], 12, 11, 11, 12, 11, 11, 11, [0, 163, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 251
[ , [15, 200], [15, 191], [15, 188], 12, [16, 186], [16, 184], 12, 11, 11, 12, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, 11, [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 252
[ , [15, 201], [15, 192], [15, 189], [15, 188], [16, 187], [16, 185], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, 11, [16, 92], [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, [0, 58, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 46, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 253
[ , [15, 202], [15, 192], [15, 190], [15, 189], [15, 188], [16, 186], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, [16, 93], [16, 92], [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 81], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [16, 67], [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 254
[ , [15, 203], [15, 192], [15, 191], [15, 190], [16, 188], [16, 187], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, [16, 93], [16, 92], [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 82], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 68], [0, 66, "sp"], [16, 66], [16, 65], [16, 64], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 255
[ , [15, 204], [15, 193], [15, 192], [15, 191], [16, 189], [16, 188], 12, 11, [16, 184], 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, [16, 93], [16, 92], [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 83], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], 12, 11, [16, 66], [0, 64, "sp"], [16, 64], 11, 11, 11, 11, 11, 11, 11, [0, 56, "sp"], 11, 11, 11, 11, 11, 11, [0, 50, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 256
[ , [15, 204], [15, 194], [15, 192], [15, 192], [16, 190], [16, 188], 12, 11, [16, 185], [16, 184], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 97], [16, 96], 11, 11, 11, [16, 93], [16, 92], [16, 92], [16, 91], [16, 90], [16, 89], [16, 88], [16, 88], 11, [16, 87], [16, 86], [16, 85], [16, 84], [16, 84], [16, 82], [16, 81], [16, 80], [16, 80], [16, 80], [16, 79], [16, 78], [16, 77], [16, 76], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], 11, 11, 12, 11, [16, 64], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11]];
