/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: itoa.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

static void reverse(s)
char s[];
{
  int c,i,j;
  for(i=0, j=strlen(s)-1; i<j; i++, j--)
  {
     c = s[i];
     s[i] = s[j];
     s[j] = c;
  }
}



/**************************************************************************\
@---------------------------------------------------------------------------
@ void itoa(n, s)
@ int n;
@ char s[];
@
@ changes the integer 'n' to a character 's', for example:  124 --> '124'
@---------------------------------------------------------------------------
@
\**************************************************************************/
void itoa(n, s)
int n;
char s[];
{
  int i, sign;
  if((sign = n) <0)
    n = -n;
  i=0;
  do
  {
    s[i++] = n%10 + '0';
  }while(( n /= 10) > 0);
  if(sign < 0)
    s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}    
