/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"getput.h"
#include"longtools.h"
#include"bravais.h"
#include"matrix.h"
#include"gmp.h"


main (int argc, char *argv[])
{
  int i,
      anz;

  matrix_TYP **A,
              *tmp,
              *tmp2;

  char comment[100],
       version[10];

  read_header(argc, argv);

  if ((FILEANZ < 1) || (is_option('h')))
  {
    printf("usage: Rein 'file' -r -c\n");
    printf(" where file contains a matrix_TYP.\n");
    printf("\n");
    printf(" Calculates the pure lattices generated by the rows (columns)\n");
    printf(" of each matrix in file, ie. an integral basis of all integral\n");
    printf(" points in the vectorspace spanned by the rows (columns) of\n");
    printf(" each matrix in file.\n");
    printf("\n");
    printf("-r  : use the row-space (default)\n");
    printf("-c  : use the column space\n");
    printf("\n");
    if (is_option('h')){
       exit(0);
    }
    else{
       exit(31);
    }
  }

  A = mget_mat(FILENAMES[0],&anz);

  printf("#%d\n",anz);

  for (i=0;i<anz;i++){
     if (is_option('c')){
        sprintf(version,"(columns)");
        tmp2 = tr_pose(A[i]);
        tmp = long_rein_mat(tmp2);
        free_mat(tmp2);
        tmp2 = tr_pose(tmp);
        free_mat(tmp);
        tmp = tmp2;
     }
     else{
       sprintf(version,"(rows)");
       tmp = long_rein_mat(A[i]);
     }
     sprintf(comment,"pure lattice of the %d-th matrix of %s %s",
                      i+1,FILENAMES[0],version);
     put_mat(tmp,NULL,comment,2);
     free_mat(tmp);
  }

  exit(0);
}
