/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverTable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class RelationMemberConflictResolver
extends JPanel {
    private final AutoCompletingTextField tfRole = new AutoCompletingTextField(10);
    private final AutoCompletingTextField tfKey = new AutoCompletingTextField(10);
    private final AutoCompletingTextField tfValue = new AutoCompletingTextField(10);
    private JCheckBox cbTagRelations;
    private final RelationMemberConflictResolverModel model;
    private final RelationMemberConflictResolverTable tblResolver;
    private final JMultilineLabel lblHeader = new JMultilineLabel("");

    protected final void build() {
        this.setLayout(new GridBagLayout());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(this.lblHeader);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)pnl, gc);
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JScrollPane(this.tblResolver), gc);
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new BoxLayout(pnl2, 1));
        pnl2.add(this.buildRoleEditingPanel());
        pnl2.add(this.buildTagRelationsPanel());
        gc.gridy = 2;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add((Component)pnl2, gc);
    }

    protected JPanel buildRoleEditingPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        pnl.add(new JLabel(I18n.tr("Role:", new Object[0])));
        pnl.add(this.tfRole);
        this.tfRole.setToolTipText(I18n.tr("Enter a role for all relation memberships", new Object[0]));
        pnl.add(new JButton(new ApplyRoleAction()));
        this.tfRole.addActionListener(new ApplyRoleAction());
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RelationMemberConflictResolver.this.tfRole.selectAll();
            }
        });
        return pnl;
    }

    protected JPanel buildTagRelationsPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        this.cbTagRelations = new JCheckBox(I18n.tr("Tag modified relations with ", new Object[0]));
        this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
        this.cbTagRelations.setToolTipText(I18n.tr("<html>Select to enable entering a tag which will be applied<br>to all modified relations.</html>", new Object[0]));
        pnl.add(this.cbTagRelations);
        pnl.add(new JLabel(I18n.trc("tag", "Key:")));
        pnl.add(this.tfKey);
        this.tfKey.setToolTipText(I18n.tr("<html>Enter a tag key, e.g. <strong><tt>fixme</tt></strong></html>", new Object[0]));
        pnl.add(new JLabel(I18n.tr("Value:", new Object[0])));
        pnl.add(this.tfValue);
        this.tfValue.setToolTipText(I18n.tr("<html>Enter a tag value, e.g. <strong><tt>check members</tt></strong></html>", new Object[0]));
        this.cbTagRelations.setSelected(false);
        this.tfKey.setEnabled(false);
        this.tfValue.setEnabled(false);
        return pnl;
    }

    public RelationMemberConflictResolver(RelationMemberConflictResolverModel model) {
        this.model = model;
        this.tblResolver = new RelationMemberConflictResolverTable(model);
        this.build();
    }

    public void initForWayCombining() {
        this.lblHeader.setText(I18n.tr("<html>The combined ways are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the combined way or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first way and <strong>remove</strong> the other ways that are members of the same relation: the combined way will take the place of the original way in the relation.</html>", new Object[0]));
        this.invalidate();
    }

    public void initForNodeMerging() {
        this.lblHeader.setText(I18n.tr("<html>The merged nodes are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the target node or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first node and <strong>remove</strong> the other nodes that are members of the same relation: the target node will take the place of the original node in the relation.</html>", new Object[0]));
        this.invalidate();
    }

    public RelationMemberConflictResolverModel getModel() {
        return this.model;
    }

    public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> primitives) {
        if (!this.cbTagRelations.isSelected()) {
            return null;
        }
        if (this.tfKey.getText().trim().isEmpty()) {
            return null;
        }
        if (this.tfValue.getText().trim().isEmpty()) {
            return null;
        }
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(primitives, Utils.removeWhiteSpaces(this.tfKey.getText()), Utils.removeWhiteSpaces(this.tfValue.getText()));
    }

    public void prepareForEditing() {
        AutoCompletionList acList = new AutoCompletionList();
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            AutoCompletionManager.of(editLayer.data).populateWithMemberRoles(acList);
        }
        this.tfRole.setAutoCompletionList(acList);
        AutoCompletingTextField editor = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
        if (editor != null) {
            editor.setAutoCompletionList(acList);
        }
        AutoCompletionList acList2 = new AutoCompletionList();
        if (editLayer != null) {
            AutoCompletionManager.of(editLayer.data).populateWithKeys(acList2);
        }
        this.tfKey.setAutoCompletionList(acList2);
    }

    class ToggleTagRelationsAction
    implements ChangeListener {
        ToggleTagRelationsAction() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ButtonModel buttonModel = ((AbstractButton)e.getSource()).getModel();
            RelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            RelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
        }
    }

    class ApplyRoleAction
    extends AbstractAction {
        ApplyRoleAction() {
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Apply this role to all members", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationMemberConflictResolver.this.model.applyRole(RelationMemberConflictResolver.this.tfRole.getText());
        }
    }
}

