/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public final class DefaultMarkerProducers
implements MarkerProducers {
    @Override
    public Collection<Marker> createMarkers(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
        URL url;
        Iterator iterator;
        String uri = null;
        Collection links = wpt.getCollection("meta.links");
        if (links != null && (iterator = links.iterator()).hasNext()) {
            GpxLink oneLink = (GpxLink)iterator.next();
            uri = oneLink.uri;
        }
        String urlStr = (url = DefaultMarkerProducers.uriToUrl(uri, relativePath)) == null ? "" : url.toString();
        String symbolName = Optional.ofNullable(wpt.getString("symbol")).orElseGet(() -> wpt.getString("sym"));
        Marker marker = new Marker(wpt.getCoor(), wpt, symbolName, parentLayer, time, offset);
        if (url == null) {
            return Collections.singleton(marker);
        }
        if (Utils.hasExtension(urlStr, "wav", "mp3", "aac", "aif", "aiff")) {
            AudioMarker audioMarker = new AudioMarker(wpt.getCoor(), (TemplateEngineDataProvider)wpt, url, parentLayer, time, offset);
            Extensions exts = (Extensions)wpt.get("meta.extensions");
            if (exts != null && exts.containsKey("offset")) {
                try {
                    audioMarker.syncOffset = Double.parseDouble((String)exts.get("sync-offset"));
                }
                catch (NumberFormatException nfe) {
                    Logging.warn(nfe);
                }
            }
            return Arrays.asList(marker, audioMarker);
        }
        if (Utils.hasExtension(urlStr, "png", "jpg", "jpeg", "gif")) {
            return Arrays.asList(marker, new ImageMarker(wpt.getCoor(), url, parentLayer, time, offset));
        }
        return Arrays.asList(marker, new WebMarker(wpt.getCoor(), url, parentLayer, time, offset));
    }

    private static URL uriToUrl(String uri, File relativePath) {
        URL url;
        block3: {
            url = null;
            if (uri != null) {
                try {
                    url = new URL(uri);
                }
                catch (MalformedURLException e) {
                    if (relativePath == null) break block3;
                    url = Utils.fileToURL(new File(relativePath.getParentFile(), uri));
                }
            }
        }
        return url;
    }
}

