/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.FileTreeViews;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class Observers<T>
implements FileTreeViews.Observer<T>,
AutoCloseable {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<Integer, FileTreeViews.Observer<T>> observers = new LinkedHashMap<Integer, FileTreeViews.Observer<T>>();

    Observers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        ArrayList<FileTreeViews.Observer<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeViews.Observer<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((FileTreeViews.Observer)object.next()).onNext(t);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable throwable) {
        ArrayList<FileTreeViews.Observer<T>> arrayList;
        Object object = this.observers;
        synchronized (object) {
            arrayList = new ArrayList<FileTreeViews.Observer<T>>(this.observers.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((FileTreeViews.Observer)object.next()).onError(throwable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addObserver(FileTreeViews.Observer<? super T> observer) {
        int n = this.counter.getAndIncrement();
        Map<Integer, FileTreeViews.Observer<T>> map = this.observers;
        synchronized (map) {
            this.observers.put(n, observer);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObserver(int n) {
        Map<Integer, FileTreeViews.Observer<T>> map = this.observers;
        synchronized (map) {
            this.observers.remove(n);
        }
    }

    @Override
    public void close() {
        this.observers.clear();
    }
}

