/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.osgi.repo.AbstractOSGiResolver;
import org.apache.ivy.osgi.updatesite.UpdateSiteLoader;
import org.xml.sax.SAXException;

public class UpdateSiteResolver
extends AbstractOSGiResolver {
    private String url;
    private Long metadataTtl;
    private Boolean forceMetadataUpdate;

    public void setUrl(String string) {
        this.url = string;
    }

    public void setMetadataTtl(Long l) {
        this.metadataTtl = l;
    }

    public void setForceMetadataUpdate(Boolean bl) {
        this.forceMetadataUpdate = bl;
    }

    @Override
    protected void init() {
        if (this.url == null) {
            throw new RuntimeException("Missing url");
        }
        CacheResourceOptions cacheResourceOptions = new CacheResourceOptions();
        if (this.metadataTtl != null) {
            cacheResourceOptions.setTtl(this.metadataTtl);
        }
        if (this.forceMetadataUpdate != null) {
            cacheResourceOptions.setForce(this.forceMetadataUpdate);
        }
        UpdateSiteLoader updateSiteLoader = new UpdateSiteLoader(this.getRepositoryCacheManager(), this.getEventManager(), cacheResourceOptions);
        try {
            this.setRepoDescriptor(updateSiteLoader.load(new URI(this.url)));
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO issue while trying to read the update site (" + iOException.getMessage() + ")");
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Failed to parse the updatesite (" + parseException.getMessage() + ")");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Illformed updatesite (" + sAXException.getMessage() + ")");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Illformed url (" + uRISyntaxException.getMessage() + ")");
        }
    }
}

