/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.packager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.packager.BuiltFileResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class PackagerCacheEntry {
    private final ModuleRevisionId mr;
    private final File dir;
    private final File resourceCache;
    private final String resourceURL;
    private final boolean validate;
    private final boolean preserve;
    private final boolean restricted;
    private final boolean verbose;
    private final boolean quiet;
    private boolean built;

    public PackagerCacheEntry(ModuleRevisionId moduleRevisionId, File file, File file2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.mr = moduleRevisionId;
        this.dir = PackagerCacheEntry.getSubdir(file, this.mr);
        this.resourceCache = file2;
        this.resourceURL = string;
        this.validate = bl;
        this.preserve = bl2;
        this.restricted = bl3;
        this.verbose = bl4;
        this.quiet = bl5;
    }

    public synchronized void build(Resource resource, Map map) throws IOException {
        if (this.built) {
            throw new IllegalStateException("build in directory `" + this.dir + "' already completed");
        }
        if (this.dir.exists() && !this.cleanup()) {
            throw new IOException("can't remove directory `" + this.dir + "'");
        }
        if (!this.dir.mkdirs()) {
            throw new IOException("can't create directory `" + this.dir + "'");
        }
        InputStream inputStream = resource.openStream();
        this.saveFile("packager.xml", inputStream);
        this.saveFile("packager.xsl");
        this.saveFile("packager-1.0.xsd");
        this.saveFile("build.xml");
        Project project = new Project();
        project.init();
        project.setUserProperty("ant.file", new File(this.dir, "build.xml").getAbsolutePath());
        ProjectHelper.configureProject((Project)project, (File)new File(this.dir, "build.xml"));
        project.setBaseDir(this.dir);
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setMessageOutputLevel(this.verbose ? 3 : (this.quiet ? 1 : 2));
        defaultLogger.setOutputPrintStream(System.out);
        defaultLogger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)defaultLogger);
        project.setUserProperty("ivy.packager.organisation", "" + this.mr.getModuleId().getOrganisation());
        project.setUserProperty("ivy.packager.module", "" + this.mr.getModuleId().getName());
        project.setUserProperty("ivy.packager.revision", "" + this.mr.getRevision());
        project.setUserProperty("ivy.packager.branch", "" + this.mr.getBranch());
        if (this.resourceCache != null) {
            project.setUserProperty("ivy.packager.resourceCache", "" + this.resourceCache.getCanonicalPath());
        }
        if (this.resourceURL != null) {
            project.setUserProperty("ivy.packager.resourceURL", "" + this.getResourceURL());
        }
        if (this.validate) {
            project.setUserProperty("ivy.packager.validate", "true");
        }
        project.setUserProperty("ivy.packager.restricted", "" + this.restricted);
        project.setUserProperty("ivy.packager.quiet", String.valueOf(this.quiet));
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Message.verbose("performing packager resolver build in " + this.dir);
        try {
            project.executeTarget("build");
            this.built = true;
        }
        catch (BuildException buildException) {
            buildException.printStackTrace(System.out);
            Message.verbose("packager resolver build failed: " + (Object)((Object)buildException));
            throw buildException;
        }
    }

    public synchronized boolean isBuilt() {
        return this.built;
    }

    public ResolvedResource getBuiltArtifact(Artifact artifact) {
        if (!this.built) {
            throw new IllegalStateException("build in directory `" + this.dir + "' has not yet successfully completed");
        }
        return new ResolvedResource(new BuiltFileResource(this.dir, artifact), this.mr.getRevision());
    }

    public synchronized boolean cleanup() {
        this.built = false;
        return FileUtil.forceDelete(this.dir);
    }

    protected void saveFile(String string, InputStream inputStream) throws IOException {
        FileUtil.copy(inputStream, new File(this.dir, string), null);
    }

    protected void saveFile(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("can't find resource `" + string + "'");
        }
        this.saveFile(string, inputStream);
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.preserve) {
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    private String getResourceURL() {
        String string = IvyPatternHelper.substitute(this.resourceURL, this.mr.getOrganisation(), this.mr.getName(), this.mr.getRevision(), null, null, null, null, this.mr.getQualifiedExtraAttributes(), null);
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private static File getSubdir(File file, ModuleRevisionId moduleRevisionId) {
        return new File(file, moduleRevisionId.getOrganisation() + File.separatorChar + moduleRevisionId.getName() + File.separatorChar + moduleRevisionId.getRevision());
    }
}

