/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongHashSet;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class DocValuesNumbersQuery
extends Query {
    private final String field;
    private final LongHashSet numbers;

    public DocValuesNumbersQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers);
    }

    public DocValuesNumbersQuery(String field, Collection<Long> numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers.stream().mapToLong(Long::longValue).toArray());
    }

    public DocValuesNumbersQuery(String field, Long ... numbers) {
        this(field, new HashSet<Long>(Arrays.asList(numbers)));
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesNumbersQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DocValuesNumbersQuery other) {
        return this.field.equals(other.field) && this.numbers.equals(other.numbers);
    }

    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.field, this.numbers);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public String getField() {
        return this.field;
    }

    public Set<Long> getNumbers() {
        return this.numbers;
    }

    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)DocValuesNumbersQuery.this.field);
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            if (!DocValuesNumbersQuery.this.numbers.contains(values.nextValue())) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                });
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

