/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.MessageSupplier;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkPrimaryExecutionContext;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardRequest::new, BulkShardRequest::new, "write", false);
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions(Settings settings) {
        return BulkAction.INSTANCE.transportOptions(settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected void shardOperationOnPrimary(BulkShardRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, (update, shardId, type, mappingListener) -> {
            assert (update != null);
            assert (shardId != null);
            this.mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), type, update, mappingListener);
        }, mappingUpdateListener -> observer.waitForNextChange(new ClusterStateObserver.Listener((ActionListener)mappingUpdateListener){
            final /* synthetic */ ActionListener val$mappingUpdateListener;
            {
                this.val$mappingUpdateListener = actionListener;
            }

            @Override
            public void onNewClusterState(ClusterState state) {
                this.val$mappingUpdateListener.onResponse(null);
            }

            @Override
            public void onClusterServiceClose() {
                this.val$mappingUpdateListener.onFailure(new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                this.val$mappingUpdateListener.onFailure(new MapperException("timed out while waiting for a dynamic mapping update"));
            }
        }), listener, this.threadPool);
    }

    public static void performOnPrimary(final BulkShardRequest request, final IndexShard primary, final UpdateHelper updateHelper, final LongSupplier nowInMillisSupplier, final MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, final ThreadPool threadPool) {
        new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(listener){
            private final Executor executor;
            private final BulkPrimaryExecutionContext context;
            {
                super(listener);
                this.executor = threadPool.executor("write");
                this.context = new BulkPrimaryExecutionContext(request, primary);
            }

            @Override
            protected void doRun() throws Exception {
                while (this.context.hasMoreOperationsToExecute()) {
                    if (!TransportShardBulkAction.executeBulkItemRequest(this.context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, ActionListener.wrap(v -> this.executor.execute(this), this::onRejection))) {
                        return;
                    }
                    assert (this.context.isInitial());
                }
                this.finishRequest();
            }

            @Override
            public void onRejection(Exception e) {
                while (this.context.hasMoreOperationsToExecute()) {
                    this.context.setRequestToExecute(this.context.getCurrent());
                    Object docWriteRequest = this.context.getRequestToExecute();
                    TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, docWriteRequest.opType() == DocWriteRequest.OpType.DELETE, docWriteRequest.version()), this.context, null);
                }
                this.finishRequest();
            }

            private void finishRequest() {
                ActionListener.completeWith(this.listener, () -> new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(this.context.getBulkShardRequest(), this.context.buildShardResponse(), this.context.getLocationToSync(), null, this.context.getPrimary(), logger));
            }
        }.run();
    }

    static boolean executeBulkItemRequest(final BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, final ActionListener<Void> itemDoneListener) throws Exception {
        Engine.Result result;
        boolean isDelete;
        UpdateHelper.Result updateResult;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier);
            }
            catch (Exception failure) {
                Engine.IndexResult result2 = new Engine.IndexResult(failure, updateRequest.version(), -2L);
                context.setRequestToExecute(updateRequest);
                context.markOperationAsExecuted(result2);
                context.markAsCompleted(context.getExecutionResult());
                return true;
            }
            switch (updateResult.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.action();
                    IndexMetaData metaData = context.getPrimary().indexSettings().getIndexMetaData();
                    MappingMetaData mappingMd = metaData.mappingOrDefault();
                    indexRequest.process(metaData.getCreationVersion(), mappingMd, updateRequest.concreteIndex());
                    context.setRequestToExecute(indexRequest);
                    break;
                }
                case DELETED: {
                    context.setRequestToExecute((DocWriteRequest)updateResult.action());
                    break;
                }
                case NOOP: {
                    context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                    context.markAsCompleted(context.getExecutionResult());
                    return true;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + updateResult.getResponseResult());
                }
            }
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        final IndexShard primary = context.getPrimary();
        final long version = context.getRequestToExecute().version();
        boolean bl = isDelete = context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE;
        if (isDelete) {
            DeleteRequest request = (DeleteRequest)context.getRequestToExecute();
            result = primary.applyDeleteOperationOnPrimary(version, request.type(), request.id(), request.versionType(), request.ifSeqNo(), request.ifPrimaryTerm());
        } else {
            IndexRequest request = (IndexRequest)context.getRequestToExecute();
            result = primary.applyIndexOperationOnPrimary(version, request.versionType(), new SourceToParse(request.index(), request.type(), request.id(), request.source(), request.getContentType(), request.routing()), request.ifSeqNo(), request.ifPrimaryTerm(), request.getAutoGeneratedTimestamp(), request.isRetry());
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), primary.shardId(), context.getRequestToExecute().type(), new ActionListener<Void>(){

                @Override
                public void onResponse(Void v) {
                    context.markAsRequiringMappingUpdate();
                    waitForMappingUpdate.accept(ActionListener.runAfter(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void v) {
                            assert (context.requiresWaitingForMappingUpdate());
                            context.resetForExecutionForRetry();
                        }

                        @Override
                        public void onFailure(Exception e) {
                            context.failOnMappingUpdate(e);
                        }
                    }, () -> itemDoneListener.onResponse(null)));
                }

                @Override
                public void onFailure(Exception e) {
                    TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                    assert (context.isInitial());
                    itemDoneListener.onResponse(null);
                }
            });
            return false;
        }
        TransportShardBulkAction.onComplete(result, context, updateResult);
        return true;
    }

    private static Engine.Result exceptionToResult(Exception e, IndexShard primary, boolean isDelete, long version) {
        return isDelete ? primary.getFailedDeleteResult(e, version) : primary.getFailedIndexResult(e, version);
    }

    private static void onComplete(Engine.Result r, BulkPrimaryExecutionContext context, UpdateHelper.Result updateResult) {
        BulkItemResponse response;
        context.markOperationAsExecuted(r);
        DocWriteRequest<?> docWriteRequest = context.getCurrent();
        DocWriteRequest.OpType opType = docWriteRequest.opType();
        boolean isUpdate = opType == DocWriteRequest.OpType.UPDATE;
        BulkItemResponse executionResult = context.getExecutionResult();
        boolean isFailed = executionResult.isFailed();
        if (isUpdate && isFailed && TransportShardBulkAction.isConflictException(executionResult.getFailure().getCause()) && context.getRetryCounter() < ((UpdateRequest)docWriteRequest).retryOnConflict()) {
            context.resetForExecutionForRetry();
            return;
        }
        if (isUpdate) {
            response = TransportShardBulkAction.processUpdateResponse((UpdateRequest)docWriteRequest, context.getConcreteIndex(), executionResult, updateResult);
        } else {
            if (isFailed) {
                Exception failure = executionResult.getFailure().getCause();
                MessageSupplier messageSupplier = () -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{context.getPrimary().shardId(), opType.getLowercase(), docWriteRequest});
                if (TransportShardBulkAction.isConflictException(failure)) {
                    logger.trace(messageSupplier, (Throwable)failure);
                } else {
                    logger.debug(messageSupplier, (Throwable)failure);
                }
            }
            response = executionResult;
        }
        context.markAsCompleted(response);
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        if (operationResponse.isFailed()) {
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            DocWriteResponse.Result translatedResult = translate.getResponseResult();
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource()) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + translatedResult);
            }
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, updateResponse);
        }
        return response;
    }

    static ReplicaItemExecutionMode replicaItemExecutionMode(BulkItemRequest request, int index) {
        BulkItemResponse primaryResponse = request.getPrimaryResponse();
        assert (primaryResponse != null) : "expected primary response to be set for item [" + index + "] request [" + request.request() + "]";
        if (primaryResponse.isFailed()) {
            return primaryResponse.getFailure().getSeqNo() != -2L ? ReplicaItemExecutionMode.FAILURE : ReplicaItemExecutionMode.NOOP;
        }
        return ((DocWriteResponse)primaryResponse.getResponse()).getResult() != DocWriteResponse.Result.NOOP ? ReplicaItemExecutionMode.NORMAL : ReplicaItemExecutionMode.NOOP;
    }

    @Override
    public TransportWriteAction.WriteReplicaResult<BulkShardRequest> shardOperationOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger);
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        block5: for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            DocWriteRequest<?> docWriteRequest = item.request();
            switch (TransportShardBulkAction.replicaItemExecutionMode(item, i)) {
                case NORMAL: {
                    Object primaryResponse = item.getPrimaryResponse().getResponse();
                    Engine.Result operationResult = TransportShardBulkAction.performOpOnReplica(primaryResponse, docWriteRequest, replica);
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                case NOOP: {
                    continue block5;
                }
                case FAILURE: {
                    BulkItemResponse.Failure failure = item.getPrimaryResponse().getFailure();
                    assert (failure.getSeqNo() != -2L) : "seq no must be assigned";
                    Engine.Result operationResult = replica.markSeqNoAsNoop(failure.getSeqNo(), failure.getMessage());
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("illegal replica item execution mode for: " + docWriteRequest);
                }
            }
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest<?> docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result;
        switch (docWriteRequest.opType()) {
            case CREATE: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = new SourceToParse(shardId.getIndexName(), indexRequest.type(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType(), indexRequest.routing());
                result = replica.applyIndexOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                result = replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), deleteRequest.type(), deleteRequest.id());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }

    public static enum ReplicaItemExecutionMode {
        NORMAL,
        NOOP,
        FAILURE;

    }
}

