/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.flush;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.flush.SyncedFlushService;

public class ShardsSyncedFlushResult
implements Streamable {
    private String failureReason;
    private Map<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> shardResponses;
    private String syncId;
    private ShardId shardId;
    private int totalShards;

    private ShardsSyncedFlushResult() {
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardsSyncedFlushResult(ShardId shardId, int totalShards, String failureReason) {
        this.syncId = null;
        this.failureReason = failureReason;
        this.shardResponses = Collections.emptyMap();
        this.shardId = shardId;
        this.totalShards = totalShards;
    }

    public ShardsSyncedFlushResult(ShardId shardId, String syncId, int totalShards, Map<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> shardResponses) {
        this.failureReason = null;
        this.shardResponses = Collections.unmodifiableMap(new HashMap<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse>(shardResponses));
        this.syncId = syncId;
        this.totalShards = totalShards;
        this.shardId = shardId;
    }

    public boolean failed() {
        return this.failureReason != null;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String syncId() {
        return this.syncId;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        int i = 0;
        for (SyncedFlushService.ShardSyncedFlushResponse result : this.shardResponses.values()) {
            if (!result.success()) continue;
            ++i;
        }
        return i;
    }

    public Map<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> failedShards() {
        HashMap<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> failures = new HashMap<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse>();
        for (Map.Entry<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> result : this.shardResponses.entrySet()) {
            if (result.getValue().success()) continue;
            failures.put(result.getKey(), result.getValue());
        }
        return failures;
    }

    public Map<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> shardResponses() {
        return this.shardResponses;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.failureReason = in.readOptionalString();
        int numResponses = in.readInt();
        this.shardResponses = new HashMap<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse>();
        for (int i = 0; i < numResponses; ++i) {
            ShardRouting shardRouting = new ShardRouting(in);
            SyncedFlushService.ShardSyncedFlushResponse response = SyncedFlushService.ShardSyncedFlushResponse.readSyncedFlushResponse(in);
            this.shardResponses.put(shardRouting, response);
        }
        this.syncId = in.readOptionalString();
        this.shardId = new ShardId(in);
        this.totalShards = in.readInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.failureReason);
        out.writeInt(this.shardResponses.size());
        for (Map.Entry<ShardRouting, SyncedFlushService.ShardSyncedFlushResponse> entry : this.shardResponses.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
        out.writeOptionalString(this.syncId);
        this.shardId.writeTo(out);
        out.writeInt(this.totalShards);
    }

    public static ShardsSyncedFlushResult readShardsSyncedFlushResult(StreamInput in) throws IOException {
        ShardsSyncedFlushResult shardsSyncedFlushResult = new ShardsSyncedFlushResult();
        shardsSyncedFlushResult.readFrom(in);
        return shardsSyncedFlushResult;
    }
}

