/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryFinalizeRecoveryRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private long globalCheckpoint;

    public RecoveryFinalizeRecoveryRequest() {
    }

    RecoveryFinalizeRecoveryRequest(long recoveryId, ShardId shardId, long globalCheckpoint) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.globalCheckpoint = globalCheckpoint;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.globalCheckpoint = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readZLong() : -2L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeZLong(this.globalCheckpoint);
        }
    }
}

